/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.EscapeUtil;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerFeature;
import com.jetbrains.cidr.lang.workspace.compiler.GCCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.GCCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerCommandLineShortener;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCResponseFileShortener;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GCCCompiler
extends OCCompilerBase {
    @NonNls
    static final String COMMAND_PREFIX = "____CIDR_command_";
    @Language(value="C")
    @VisibleForTesting
    @NonNls
    public static final String DEFINE = "#define ";
    @Language(value="C")
    @VisibleForTesting
    @NonNls
    public static final String UNDEF = "#undef ";
    @NonNls
    public static final String QUOTES = "[\u2018\u2019`'\"]";
    private static final Pattern[] BAD_SWITCH_FILTER_RULES = new Pattern[]{Pattern.compile(".*error:.*?(-+\\S+) is not supported.*"), Pattern.compile(".*error:.*?[\u2018\u2019`'\"](-.+?)[\u2018\u2019`'\"].*"), Pattern.compile(".*error:\\s(.+):\\sNo such file or directory"), Pattern.compile(".*error: [\u2018\u2019`'\"](.+?)[\u2018\u2019`'\"].* not found"), Pattern.compile(".*\\berror\\s+parsing.*(-fpch-preprocess)\\b.*", 2), Pattern.compile(".*clang-cl: error: no such file or directory: [\u2018\u2019`'\"](.+?)[\u2018\u2019`'\"].*")};
    private static final Pattern INCLUDE_FILE_PATTERN = Pattern.compile("# 1 \"(.*)\" 1\\s*[\\r\\n]");
    private static final Pattern INCLUDE_FILE_FROM_SYSROOT_PATTERN = Pattern.compile("# 1 \"(.*)\" 1 3 4\\s*[\\r\\n]");
    private static final Pattern INCLUDE_HEADER_PATTERN = Pattern.compile("#include [<\"](.*)[>\"]");
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile(".*:(?:\\s|(?:\\\\[\\r\\n]))+((?:[\\S&&[^\\\\]]+(?:\\\\[ ]?)*)*)");
    private static final String STANDARD_CPP = "STANDARD_CPP";
    private static final String STANDARD_C = "STANDARD_C";
    @NonNls
    static final String CIDR_DEFINITIONS_END = "___CIDR_DEFINITIONS_END";
    @NonNls
    static final String CIDR_FEATURES_START = "___CIDR_FEATURES_START";
    @Language(value="C")
    @NonNls
    private static final String FUNCTION_HEAD = "void ____CIDR_command() {";
    @Language(value="C")
    @NonNls
    private static final String FUNCTION_TAIL = "} /* ____CIDR_command() */";
    @Language(value="C")
    @NlsSafe
    private static final String OBJC_YES = "__objc_yes";
    @Language(value="C")
    @NlsSafe
    private static final String OBJC_NO = "__objc_no";
    @Language(value="C")
    @NlsSafe
    private static final String OBJC_YES_VALUE = "((BOOL)1)";
    @Language(value="C")
    @NlsSafe
    private static final String OBJC_NO_VALUE = "((BOOL)0)";
    private static final Map<String, OCCompilerFeatures.Feature> featureFlags = new LinkedHashMap<String, OCCompilerFeatures.Feature>();
    private static final Set<String> skipSwitches;
    private static final Set<String> skipEnvironment;
    private static final List<String> CLANG_TEST_MACROS;
    private static final List<String> GCC_BUILT_IN_VA_FUNCTION_MACROS;
    private static final List<String> GCC_BUILT_IN_FUNCTION_MACROS;

    public GCCCompiler(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        if (executable == null) {
            GCCCompiler.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            GCCCompiler.$$$reportNull$$$0(1);
        }
        if (env == null) {
            GCCCompiler.$$$reportNull$$$0(2);
        }
        if (tempFilesPool == null) {
            GCCCompiler.$$$reportNull$$$0(3);
        }
        super(executable, workingDirectory, env, tempFilesPool);
    }

    @Nullable
    public String readVersion(@NotNull Pattern versionPattern) {
        if (versionPattern == null) {
            GCCCompiler.$$$reportNull$$$0(4);
        }
        return this.doReadVersion(Collections.singletonList("--version"), (Function<? super ProcessOutput, String>)((Function)output -> {
            List lines = output.getStdoutLines();
            for (String line : lines) {
                Matcher matcher;
                if (StringUtil.isEmptyOrSpaces((String)line) || !(matcher = versionPattern.matcher(line)).matches()) continue;
                return line;
            }
            return null;
        }));
    }

    @NotNull
    public static String getLanguageOption(@NotNull OCLanguageKind kind) {
        if (kind == null) {
            GCCCompiler.$$$reportNull$$$0(5);
        }
        if (kind instanceof CLanguageKind) {
            CLanguageKind cLanguageKind = (CLanguageKind)kind;
            return switch (cLanguageKind) {
                default -> throw new IncompatibleClassChangeError();
                case CLanguageKind.C -> "-xc";
                case CLanguageKind.OBJ_C -> "-xobjective-c";
                case CLanguageKind.CPP -> "-xc++";
                case CLanguageKind.OBJ_CPP -> "-xobjective-c++";
            };
        }
        return "";
    }

    @Nullable
    public static OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < switches.size(); ++i) {
            String currentSwitch = switches.get(i);
            if (!currentSwitch.startsWith("-x")) continue;
            OCLanguageKind kind = GCCCompiler.resolveOptionLanguage(currentSwitch = currentSwitch.substring(2));
            if (kind != null) {
                return kind;
            }
            if (StringUtil.isEmptyOrSpaces((String)currentSwitch) && i < switches.size() - 1) {
                kind = GCCCompiler.resolveOptionLanguage(switches.get(i + 1));
            }
            return kind;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind resolveOptionLanguage(@NotNull String option) {
        String langName;
        if (option == null) {
            GCCCompiler.$$$reportNull$$$0(7);
        }
        if ("objective-c".equals(langName = option.trim())) {
            return CLanguageKind.OBJ_C;
        }
        if ("objective-c++".equals(langName)) {
            return CLanguageKind.OBJ_CPP;
        }
        if ("c".equals(langName)) {
            return CLanguageKind.C;
        }
        if ("c++".equals(langName)) {
            return CLanguageKind.CPP;
        }
        if ("cu".equals(langName)) {
            return CUDALanguageKind.CUDA;
        }
        if ("cuda".equals(langName)) {
            return CUDALanguageKind.CUDA;
        }
        return null;
    }

    @NotNull
    protected CompilerSpecificSwitchBuilder getSwitchBuilder() {
        return new GCCSwitchBuilder();
    }

    @NotNull
    private static List<String> extractNonBuiltinSearchPaths(@NotNull @NotNull List<@NotNull String> rawSwitches, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory) {
        if (rawSwitches == null) {
            GCCCompiler.$$$reportNull$$$0(8);
        }
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(9);
        }
        if (workingDirectory == null) {
            GCCCompiler.$$$reportNull$$$0(10);
        }
        ArrayList<String> searchPaths = new ArrayList<String>();
        boolean includeIsNext = false;
        for (String element : rawSwitches) {
            if (includeIsNext) {
                element = environment.toLocalPath(workingDirectory, element);
                searchPaths.add(element);
                includeIsNext = false;
                continue;
            }
            if (element.equals("-I")) {
                includeIsNext = true;
                continue;
            }
            if (!element.startsWith("-I")) continue;
            element = environment.toLocalPath(workingDirectory, element.substring(2));
            searchPaths.add(element);
        }
        String[] canonicalSearchPaths = environment.getHostMachine().toCanonicalPath(searchPaths, true);
        List<String> list = Arrays.asList(canonicalSearchPaths);
        if (list == null) {
            GCCCompiler.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        if (languageKind == null) {
            GCCCompiler.$$$reportNull$$$0(12);
        }
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(13);
        }
        ArrayList<String> warnLog = new ArrayList<String>();
        try {
            switches = switches.expandResponseFiles(this.myWorkingDirectory, this.myEnvironment, CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
        }
        catch (IOException e) {
            throw new ExecutionException(CidrProjectModelBundle.message("cannot.expand.response.files.error.message", switches.getCommandLineString(CidrCompilerSwitches.Format.RAW)), (Throwable)e);
        }
        List<String> nonBuiltinSearchPaths = GCCCompiler.extractNonBuiltinSearchPaths(switches.getList(CidrCompilerSwitches.Format.RAW), this.myEnvironment, this.myWorkingDirectory);
        CompilerSpecificSwitchBuilder switchBuilder = this.getSwitchBuilder().withLanguageKind(languageKind).withSwitches(switches);
        if (Registry.is((String)"cidr.compiler.gcc.fpch.preprocess", (boolean)true)) {
            switchBuilder.withWritePchPreprocess();
        }
        switchBuilder.withSwitch("-v").withWritePreprocessorDefines().withSwitch("-E").withMacro(CIDR_DEFINITIONS_END);
        CidrCompilerSwitches requestSwitches = switchBuilder.build();
        ProcessOutput output = this.runGCC(this.myEnvironment, requestSwitches, GCCCompiler.buildFeaturesCheckText(requestSwitches), warnLog);
        OutputSections sections = GCCCompiler.splitOutput(output.getStdout(), warnLog);
        Pair<List<String>, Map<OCCompilerFeatures.Type<?>, Object>> definesAndFeatures = GCCCompiler.collectDefinitionsAndFeatures(sections, warnLog, languageKind);
        List defines = (List)definesAndFeatures.first;
        Map features = (Map)definesAndFeatures.second;
        boolean isClang = GCCCompiler.isClang(defines);
        GCCCompiler.collectDiagnostics(switches, isClang, features);
        GCCCompiler.collectFeatureFlags(switches, features);
        if (!features.containsKey(OCCompilerFeatures.Feature.CXX_ALTERNATIVE_OPERATORS)) {
            features.put(OCCompilerFeatures.Feature.CXX_ALTERNATIVE_OPERATORS, GCCCompiler.isCpp(defines));
        }
        if (isClang) {
            features.put(OCCompilerFeatures.Feature.CXX_MS_HAS_TYPE_PACK_ELEMENT, true);
            features.put(OCCompilerFeatures.Feature.CXX_MS_HAS_MAKE_INTEGER_SEQ, true);
            features.put(OCCompilerFeatures.Feature.CXX_HAS_IS_SAME, true);
            features.put(OCCompilerFeatures.Feature.CXX_HAS_IS_CONVERTIBLE, true);
        }
        boolean shouldEnableFrameworksWorkaround = this.myEnvironment.getHostMachine().getOSType() == OSType.MAC && !isClang;
        List<HeadersSearchPath> headersSearchPaths = GCCCompiler.collectHeaderSearchPaths(output, shouldEnableFrameworksWorkaround, this.myEnvironment, this.myWorkingDirectory, true, nonBuiltinSearchPaths);
        List<File> forcedHeaders = this.getForcedHeaders(switches, this.myEnvironment, sections.preprocessed, warnLog);
        GCCCompiler.addEmulatedWarning(warnLog);
        return new CompilerInfo(switches, defines, features, headersSearchPaths, forcedHeaders, Collections.emptyList(), warnLog, output.getExitCode());
    }

    @NotNull
    static OutputSections splitOutput(String output, List<String> warnLog) {
        String defines;
        String preprocessed = "";
        String featureChecks = "";
        int definesEnd = output.indexOf(CIDR_DEFINITIONS_END);
        int featuresStart = output.indexOf(CIDR_FEATURES_START);
        Function lineStart = index -> {
            while (index > 0 && !StringUtil.isLineBreak((char)output.charAt(index - 1))) {
                Integer n = index;
                index = index - 1;
            }
            return index;
        };
        if (definesEnd >= 0 && featuresStart >= 0) {
            defines = output.substring(0, (Integer)lineStart.fun((Object)definesEnd));
            preprocessed = output.substring(definesEnd + CIDR_DEFINITIONS_END.length() + 1, (Integer)lineStart.fun((Object)featuresStart));
            featureChecks = output.substring(featuresStart + CIDR_FEATURES_START.length() + 1);
        } else {
            warnLog.add(CidrProjectModelBundle.message("unexpected.compiler.output.error.message", new Object[0]) + "\n" + CidrProjectModelBundle.message("possibly.unsupported.compiler.error.message", new Object[0]));
            LOG.warn("Unexpected compiler output: CIDR_DEFINITIONS_END=" + definesEnd + " CIDR_FEATURES_START=" + featuresStart);
            defines = output;
        }
        return new OutputSections(Arrays.asList(StringUtil.splitByLines((String)defines)), preprocessed, featureChecks);
    }

    private static boolean isClang(@NotNull List<String> defines) {
        if (defines == null) {
            GCCCompiler.$$$reportNull$$$0(14);
        }
        return ContainerUtil.find(defines, define -> StringUtil.contains((CharSequence)define, (CharSequence)"__clang_version__")) != null;
    }

    private static boolean isCpp(@NotNull List<String> defines) {
        if (defines == null) {
            GCCCompiler.$$$reportNull$$$0(15);
        }
        return ContainerUtil.find(defines, define -> StringUtil.contains((CharSequence)define, (CharSequence)"__cplusplus")) != null;
    }

    @NotNull
    private List<File> getForcedHeaders(@NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment environment, @NotNull String preprocessed, @NotNull List<String> warnLog) {
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(16);
        }
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(17);
        }
        if (preprocessed == null) {
            GCCCompiler.$$$reportNull$$$0(18);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(19);
        }
        LinkedHashSet<File> result2 = new LinkedHashSet<File>(1);
        List<String> args = switches.getList(CidrCompilerSwitches.Format.RAW);
        boolean isFirst = true;
        for (int i = 0; i < args.size(); ++i) {
            List<File> headers;
            String pathPCH;
            String arg = this.adjustArgument(args.get(i));
            if (!arg.startsWith("-include") && !arg.startsWith("--include") && !arg.startsWith("-imacros") && !arg.startsWith("--imacros") && !arg.startsWith("-FI")) continue;
            if (arg.equals("-include") || arg.equals("--include") || arg.equals("-imacros") || arg.equals("--imacros") || arg.equals("-FI")) {
                if (++i >= args.size()) break;
                if (args.get(i).equals("-Xclang")) {
                    ++i;
                }
                pathPCH = this.preparePath(environment, this.adjustArgument(args.get(i)));
            } else if (arg.startsWith("--include") || arg.startsWith("--imacros")) {
                if (!arg.startsWith("--include=") && !arg.startsWith("--imacros=")) continue;
                pathPCH = arg.startsWith("--include=") ? this.preparePath(environment, this.adjustArgument(StringsKt.removePrefix((String)arg, (CharSequence)"--include="))) : this.preparePath(environment, this.adjustArgument(StringsKt.removePrefix((String)arg, (CharSequence)"--imacros=")));
            } else {
                pathPCH = arg.startsWith("-include") ? this.preparePath(environment, this.adjustArgument(StringsKt.removePrefix((String)arg, (CharSequence)"-include"))) : (arg.startsWith("-FI") ? this.preparePath(environment, this.adjustArgument(StringsKt.removePrefix((String)arg, (CharSequence)"-FI"))) : this.preparePath(environment, this.adjustArgument(StringsKt.removePrefix((String)arg, (CharSequence)"-imacros"))));
            }
            File pch = new File(pathPCH);
            if (pch.exists() && !(headers = this.tryExtractOriginalPrecompiledHeadersFromCMakeGeneratedFile(environment, pch)).isEmpty()) {
                result2.add(pch);
                result2.addAll(headers);
                continue;
            }
            if (!pch.exists() || pch.isDirectory()) {
                File file = pch = isFirst ? this.extractOriginalPrecompiledHeaderFile(preprocessed, environment, pch, warnLog) : null;
            }
            if (pch != null) {
                result2.add(pch);
            }
            isFirst = false;
        }
        return new SmartList(result2);
    }

    @NotNull
    private List<File> tryExtractOriginalPrecompiledHeadersFromCMakeGeneratedFile(@NotNull CidrToolEnvironment env, @NotNull File pch) {
        ArrayList<File> arrayList;
        String text;
        block9: {
            if (env == null) {
                GCCCompiler.$$$reportNull$$$0(20);
            }
            if (pch == null) {
                GCCCompiler.$$$reportNull$$$0(21);
            }
            text = FileUtil.loadFile((File)pch);
            if (text.contains("generated by CMake")) break block9;
            List<File> list = Collections.emptyList();
            if (list == null) {
                GCCCompiler.$$$reportNull$$$0(22);
            }
            return list;
        }
        try {
            ArrayList<File> result2 = new ArrayList<File>(1);
            Matcher matcher = GCCCompiler.matchSafely(INCLUDE_HEADER_PATTERN, text);
            while (matcher.find()) {
                String unescaped = EscapeUtil.unescapeAnsiStringCharacters((String)matcher.group(1));
                String path = this.preparePath(env, unescaped);
                result2.add(new File(path));
            }
            arrayList = result2;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            List<File> list = Collections.emptyList();
            if (list == null) {
                GCCCompiler.$$$reportNull$$$0(24);
            }
            return list;
        }
        if (arrayList == null) {
            GCCCompiler.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @Nullable
    private File extractOriginalPrecompiledHeaderFile(@NonNls @NotNull String preprocessed, @NotNull CidrToolEnvironment env, @NotNull File pch, @NotNull List<String> warnLog) {
        String path;
        boolean isGCC;
        if (preprocessed == null) {
            GCCCompiler.$$$reportNull$$$0(25);
        }
        if (env == null) {
            GCCCompiler.$$$reportNull$$$0(26);
        }
        if (pch == null) {
            GCCCompiler.$$$reportNull$$$0(27);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(28);
        }
        if (!(isGCC = preprocessed.contains("#pragma GCC pch_preprocess"))) {
            Matcher matcher = GCCCompiler.matchSafely(INCLUDE_FILE_PATTERN, preprocessed);
            if (matcher.find()) {
                String unescaped = EscapeUtil.unescapeAnsiStringCharacters((String)matcher.group(1));
                String path2 = this.preparePath(env, unescaped);
                return new File(path2);
            }
            matcher = GCCCompiler.matchSafely(INCLUDE_FILE_FROM_SYSROOT_PATTERN, preprocessed);
            if (matcher.find()) {
                String fileName = pch.getName();
                Optional<String> firstMatch2 = matcher.results().map(it -> EscapeUtil.unescapeAnsiStringCharacters((String)it.group(1))).filter(it -> it.contains(fileName)).findFirst();
                path = firstMatch2.map(s -> this.preparePath(env, (String)s)).orElse(null);
                if (path != null) {
                    return new File(path);
                }
            }
        }
        File dependencyFile = null;
        if (!pch.isDirectory()) {
            dependencyFile = new File(pch.getAbsolutePath() + ".d");
        } else {
            File[] files = pch.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().endsWith(".d")) continue;
                    dependencyFile = file;
                    break;
                }
            }
        }
        if (dependencyFile != null && dependencyFile.exists()) {
            try {
                String data = FileUtil.loadFile((File)dependencyFile);
                Matcher dependency = GCCCompiler.matchSafely(DEPENDENCY_PATTERN, data);
                if (dependency.find()) {
                    path = dependency.group(1).replaceAll("\\\\[ ]", " ");
                    File result2 = new File(this.preparePath(env, path));
                    return result2.exists() ? result2 : null;
                }
            }
            catch (IOException e) {
                String warn = CidrProjectModelBundle.message("dependency.file.corrupted.error.message", dependencyFile);
                warnLog.add(warn);
                return null;
            }
        }
        if (isGCC) {
            String warn = CidrProjectModelBundle.message("cannot.get.the.original.file.name.of.the.precompiled.header", pch);
            warnLog.add(warn);
        }
        return null;
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(@NotNull ProcessOutput output, boolean enableFrameworksWorkaround, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory) {
        if (output == null) {
            GCCCompiler.$$$reportNull$$$0(29);
        }
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(30);
        }
        if (workingDirectory == null) {
            GCCCompiler.$$$reportNull$$$0(31);
        }
        return GCCCompiler.collectHeaderSearchPaths(output, enableFrameworksWorkaround, environment, workingDirectory, false, Collections.emptyList());
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(@NotNull ProcessOutput output, boolean enableFrameworksWorkaround, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory, boolean hasBuiltInSearchPaths, @NotNull @NotNull List<@NotNull String> nonBuiltinSearchPaths) {
        if (output == null) {
            GCCCompiler.$$$reportNull$$$0(32);
        }
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(33);
        }
        if (workingDirectory == null) {
            GCCCompiler.$$$reportNull$$$0(34);
        }
        if (nonBuiltinSearchPaths == null) {
            GCCCompiler.$$$reportNull$$$0(35);
        }
        ArrayList<HeadersSearchPath> headersSearchPaths = new ArrayList<HeadersSearchPath>();
        ArrayList<HeadersSearchPath> additionalFrameworks = enableFrameworksWorkaround ? new ArrayList<HeadersSearchPath>() : null;
        HeadersSearchPath.Kind kind = null;
        for (String each : output.getStderrLines()) {
            String file;
            if ("#include \"...\" search starts here:".equals(each = each.trim())) {
                kind = HeadersSearchPath.Kind.USER;
                continue;
            }
            if ("#include <...> search starts here:".equals(each)) {
                kind = HeadersSearchPath.Kind.SYSTEM;
                continue;
            }
            if ("End of search list.".equals(each)) break;
            if (kind == null) continue;
            String trimmed = StringUtil.trimEnd((String)each, (String)" (framework directory)");
            boolean isFramework = false;
            if (!each.equals(trimmed)) {
                each = trimmed;
                isFramework = true;
                enableFrameworksWorkaround = false;
            } else {
                each = StringUtil.trimEnd((String)each, (String)" (headermap)");
            }
            if ((file = environment.toLocalPath(workingDirectory, each = StringUtil.nullize((String)each.trim(), (boolean)true))) == null) continue;
            String canonicalPath = environment.getHostMachine().toCanonicalPath(file, true);
            try {
                canonicalPath = FileUtil.resolveShortWindowsName((String)canonicalPath);
            }
            catch (IOException ignored) {
                continue;
            }
            boolean isBuiltIn = hasBuiltInSearchPaths && kind.isSystem() && !isFramework && !nonBuiltinSearchPaths.contains(canonicalPath);
            HeadersSearchPath.Kind currentKind = kind;
            if (isBuiltIn) {
                currentKind = HeadersSearchPath.Kind.BUILTIN;
            } else if (isFramework) {
                currentKind = kind == HeadersSearchPath.Kind.USER ? HeadersSearchPath.Kind.USER_FRAMEWORK : HeadersSearchPath.Kind.FRAMEWORK;
            }
            headersSearchPaths.add(new HeadersSearchPath(canonicalPath, false, currentKind));
            if (!enableFrameworksWorkaround) continue;
            currentKind = kind == HeadersSearchPath.Kind.USER ? HeadersSearchPath.Kind.USER_FRAMEWORK : HeadersSearchPath.Kind.FRAMEWORK;
            additionalFrameworks.add(new HeadersSearchPath(canonicalPath, false, currentKind));
        }
        if (enableFrameworksWorkaround) {
            headersSearchPaths.addAll(additionalFrameworks);
        }
        return headersSearchPaths;
    }

    @NotNull
    static Pair<List<String>, Map<OCCompilerFeatures.Type<?>, Object>> collectDefinitionsAndFeatures(@NotNull OutputSections output, List<String> warnLog, @NotNull OCLanguageKind languageKind) {
        if (output == null) {
            GCCCompiler.$$$reportNull$$$0(36);
        }
        if (languageKind == null) {
            GCCCompiler.$$$reportNull$$$0(37);
        }
        LinkedHashMap<Object, Object> cidrFeatures = new LinkedHashMap<Object, Object>();
        List<@NonNls String> defines = output.defines.stream().map(line -> line.trim()).filter(line -> line.startsWith(DEFINE) || line.startsWith(UNDEF)).collect(Collectors.toList());
        boolean isClang = GCCCompiler.isClang(defines);
        if (isClang) {
            defines.addAll(GCCCompiler.getClangTestMacros());
        }
        for (String eachLine : StringUtil.splitByLines((String)output.featureChecks)) {
            GCCCompilerFeature feature = GCCCompilerFeature.parse(eachLine);
            if (feature == null) continue;
            Command command = feature.getCommand();
            @NonNls String key = feature.getKey();
            @NonNls String value = feature.getValue();
            try {
                switch (command) {
                    case SET_TYPE_SIZE: {
                        try {
                            cidrFeatures.put(OCCompilerFeatures.TypeSize.valueOf(key), Short.parseShort(value));
                        }
                        catch (NumberFormatException e) {
                            warnLog.add(CidrProjectModelBundle.message("cannot.determine.type.size.for.key.value", key, value) + "\n" + CidrProjectModelBundle.message("possibly.unsupported.compiler.error.message", new Object[0]));
                        }
                        break;
                    }
                    case SET_FEATURE: {
                        cidrFeatures.put(OCCompilerFeatures.Feature.valueOf(key), value.equals("1"));
                        break;
                    }
                    case ADD_DEFINITION: {
                        if (key.startsWith("__CIDR_macro_")) {
                            @NonNls String realName = StringUtil.substringAfter((String)key, (String)"__CIDR_macro");
                            defines.add(DEFINE + realName + " " + value);
                            break;
                        }
                        if (key.startsWith("__CIDR_builtin_")) {
                            @NonNls String realName = StringUtil.substringAfter((String)key, (String)"__CIDR_builtin") + "(x)";
                            defines.add(DEFINE + realName + " " + realName);
                            break;
                        }
                        if (key.equals(OBJC_YES) || key.equals(OBJC_NO)) {
                            int valueLength = value.length();
                            if (valueLength != 0 && value.charAt(0) == '\"' && value.charAt(valueLength - 1) == '\"') {
                                defines.add(DEFINE + key + " " + value.substring(1, valueLength - 1));
                                break;
                            }
                            defines.add(DEFINE + key + " " + value);
                            break;
                        }
                        defines.add(DEFINE + key + " " + value);
                        break;
                    }
                    case SET_LANGUAGE_STANDARD: {
                        cidrFeatures.put(OCCompilerFeatures.LANGUAGE_STANDARD, (Object)(key.equals(STANDARD_CPP) ? OCLanguageStandard.getCppStandard(value) : OCLanguageStandard.getCStandard(value)));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                warnLog.add(CidrProjectModelBundle.message("invalid.query.message", eachLine));
            }
            if (cidrFeatures.containsKey(OCCompilerFeatures.LANGUAGE_STANDARD)) continue;
            cidrFeatures.put(OCCompilerFeatures.LANGUAGE_STANDARD, (Object)(languageKind.isCpp() ? OCLanguageStandard.CPP98 : OCLanguageStandard.C89));
        }
        defines.add("#define __extension__");
        defines.addAll(GCCCompiler.getGCCBuiltInFunctionMacros());
        return new Pair(defines, cidrFeatures);
    }

    @NonNls
    public static String buildFeaturesCheckText(@NotNull CidrCompilerSwitches requestSwitches) {
        if (requestSwitches == null) {
            GCCCompiler.$$$reportNull$$$0(38);
        }
        @NonNls StringBuilder result2 = new StringBuilder();
        result2.append("void ____CIDR_command() {\n");
        result2.append("#define ___CIDR_FEATURES_START\n");
        class QueryBuilder {
            private int nextHelperDefineId = 0;
            final /* synthetic */ StringBuilder val$result;

            QueryBuilder(StringBuilder stringBuilder) {
                this.val$result = stringBuilder;
            }

            void appendLanguageStandardQuery(@Language(value="C") @NotNull String macro, boolean isCPP) {
                if (macro == null) {
                    QueryBuilder.$$$reportNull$$$0(0);
                }
                this.val$result.append("#if defined(").append(macro).append(")\n");
                this.val$result.append(QueryBuilder.buildCommand(Command.SET_LANGUAGE_STANDARD, isCPP ? GCCCompiler.STANDARD_CPP : GCCCompiler.STANDARD_C, macro));
                this.val$result.append("#endif\n");
            }

            void appendTypeSizeQuery(@NotNull String macro, @NotNull OCCompilerFeatures.TypeSize type) {
                if (macro == null) {
                    QueryBuilder.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    QueryBuilder.$$$reportNull$$$0(2);
                }
                this.val$result.append("#if defined(").append(macro).append(")\n");
                this.val$result.append(QueryBuilder.buildCommand(Command.SET_TYPE_SIZE, type.name(), macro));
                this.val$result.append("#endif\n");
            }

            void appendHasBuiltinQuery(@NotNull String builtin, @NotNull OCCompilerFeatures.Feature feature) {
                if (builtin == null) {
                    QueryBuilder.$$$reportNull$$$0(3);
                }
                if (feature == null) {
                    QueryBuilder.$$$reportNull$$$0(4);
                }
                this.val$result.append("#if defined(__has_builtin)\n");
                this.appendSetFeatureCommand(PreprocessorCondition.hasBuiltin(builtin), feature);
                this.val$result.append("#endif\n");
            }

            void appendBuiltinQuery(@NotNull PreprocessorCondition condition, @NonNls @NotNull String emulationMacroName, boolean supported) {
                if (condition == null) {
                    QueryBuilder.$$$reportNull$$$0(5);
                }
                if (emulationMacroName == null) {
                    QueryBuilder.$$$reportNull$$$0(6);
                }
                String trueText = QueryBuilder.buildEmulationMacroCommand(emulationMacroName, "1");
                String falseText = QueryBuilder.buildEmulationMacroCommand(emulationMacroName, "0");
                if (supported) {
                    this.doAppendBranch(condition, trueText, falseText);
                } else {
                    this.val$result.append(falseText);
                }
            }

            void appendSetFeatureCommand(@NotNull PreprocessorCondition condition, @NotNull OCCompilerFeatures.Feature cidrFeature) {
                if (condition == null) {
                    QueryBuilder.$$$reportNull$$$0(7);
                }
                if (cidrFeature == null) {
                    QueryBuilder.$$$reportNull$$$0(8);
                }
                Object trueText = QueryBuilder.buildCommand(Command.SET_FEATURE, cidrFeature.name(), "1");
                if (cidrFeature == OCCompilerFeatures.Feature.OBJC_BOOL) {
                    trueText = (String)trueText + QueryBuilder.buildCommand(Command.ADD_DEFINITION, GCCCompiler.OBJC_NO, "\"((BOOL)0)\"") + QueryBuilder.buildCommand(Command.ADD_DEFINITION, GCCCompiler.OBJC_YES, "\"((BOOL)1)\"");
                }
                String falseText = QueryBuilder.buildCommand(Command.SET_FEATURE, cidrFeature.name(), "0");
                this.doAppendBranch(condition, (String)trueText, falseText);
            }

            void doAppendBranch(@NotNull PreprocessorCondition condition, @NotNull String trueText, @NotNull String falseText) {
                if (condition == null) {
                    QueryBuilder.$$$reportNull$$$0(9);
                }
                if (trueText == null) {
                    QueryBuilder.$$$reportNull$$$0(10);
                }
                if (falseText == null) {
                    QueryBuilder.$$$reportNull$$$0(11);
                }
                String HELPER_DEFINE_PREFIX = "__CIDR_HELPER_DEFINE_";
                String helperDefine = HELPER_DEFINE_PREFIX + this.nextHelperDefineId;
                ++this.nextHelperDefineId;
                condition.appendPotentialDefinesIfs(this.val$result);
                this.val$result.append("#if ").append(condition.getText()).append("\n");
                this.val$result.append(GCCCompiler.DEFINE).append(helperDefine).append('\n');
                this.val$result.append("#endif\n");
                condition.appendPotentialDefinesEndifs(this.val$result);
                this.val$result.append("#if defined(").append(helperDefine).append(")\n");
                this.val$result.append(trueText);
                this.val$result.append("#else\n");
                this.val$result.append(falseText);
                this.val$result.append("#endif\n");
            }

            private static String buildCommand(Command type, @NonNls String key, @NonNls String value) {
                @NonNls String command = "{ int __attribute__ ((unused)) %s%s, %s%s = ((void) %s, 0); }%n";
                return String.format("{ int __attribute__ ((unused)) %s%s, %s%s = ((void) %s, 0); }%n", new Object[]{GCCCompiler.COMMAND_PREFIX, type, GCCCompiler.COMMAND_PREFIX, key, value});
            }

            private static String buildEmulationMacroCommand(@NonNls @Nullable String emulationMacroName, @NonNls String value) {
                if (emulationMacroName != null) {
                    return QueryBuilder.buildCommand(Command.ADD_DEFINITION, emulationMacroName, value);
                }
                return "\n";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "macro";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builtin";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "feature";
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "condition";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "emulationMacroName";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cidrFeature";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "trueText";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "falseText";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$1QueryBuilder";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendLanguageStandardQuery";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendTypeSizeQuery";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendHasBuiltinQuery";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendBuiltinQuery";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendSetFeatureCommand";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doAppendBranch";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        QueryBuilder queryBuilder = new QueryBuilder(result2);
        queryBuilder.appendLanguageStandardQuery("__STDC_VERSION__", false);
        queryBuilder.appendLanguageStandardQuery("__cplusplus", true);
        List<String> switchesList = requestSwitches.getList(CidrCompilerSwitches.Format.RAW);
        boolean hasFileName = ContainerUtil.exists(switchesList, it -> it.startsWith("-D__FILE_NAME__="));
        if (!hasFileName) {
            result2.append("#ifdef __FILE_NAME__\n");
            result2.append(QueryBuilder.buildCommand(Command.ADD_DEFINITION, "__CIDR_macro__FILE_NAME__", "\"_file_name_short_\""));
            result2.append("#endif\n");
        }
        queryBuilder.appendBuiltinQuery(PreprocessorCondition.defined("__has_include"), "__CIDR_builtin__has_include", true);
        queryBuilder.appendBuiltinQuery(PreprocessorCondition.defined("__has_include_next"), "__CIDR_builtin__has_include_next", true);
        queryBuilder.appendBuiltinQuery(PreprocessorCondition.defined("__has_cpp_attribute"), "__CIDR_builtin__has_cpp_attribute", true);
        queryBuilder.appendSetFeatureCommand(PreprocessorCondition.safe("!defined(__cplusplus) && __STDC_VERSION__ <= 199409L"), OCCompilerFeatures.Feature.C_VARIABLE_DECLARATION_RULES_ARE_C89_COMPATIBLE);
        result2.append("#if __clang__\n");
        result2.append("#if !(defined (__has_extension)) && defined(__has_feature)\n  #define __has_extension __has_feature\n#endif\n#if !defined(__has_attribute)\n  #define __has_attribute(x) 0\n#endif\n#if !defined(__has_builtin)\n  #define __has_builtin(x) 0\n#endif\n#if !defined(__is_identifier)\n  #define __is_identifier(x) 1\n#endif\n#if !__has_builtin(__is_target_arch)\n  #define __is_target_arch(x) 0\n#endif\n#if !__has_builtin(__is_target_vendor)\n  #define __is_target_vendor(x) 0\n#endif\n#if !__has_builtin(__is_target_os)\n  #define __is_target_os(x) 0\n#endif\n#if !__has_builtin(__is_target_variant_os)\n  #define __is_target_variant_os(x) 0\n#endif\n#if !__has_builtin(__is_target_environment)\n  #define __is_target_environment(x) 0\n#endif\n#if !__has_builtin(__is_target_variant_environment)\n  #define __is_target_variant_environment(x) 0\n#endif\n");
        ClangFeatures.getAllFeatures().forEach(each -> {
            boolean supported = !ClangFeatures.getUnsupportedClangFeatures().contains(each);
            PreprocessorCondition featureCondition = PreprocessorCondition.hasFeature(each);
            PreprocessorCondition extensionCondition = PreprocessorCondition.hasExtension(each);
            queryBuilder.appendBuiltinQuery(featureCondition, GCCCompiler.clangFeatureMacro(each), supported);
            queryBuilder.appendBuiltinQuery(extensionCondition, GCCCompiler.clangExtensionMacro(each), supported);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(each);
            if (cidrFeature != null) {
                queryBuilder.appendSetFeatureCommand(PreprocessorCondition.or(featureCondition, extensionCondition), cidrFeature);
            }
        });
        ClangFeatures.getAllBuiltins().forEach(each -> {
            PreprocessorCondition condition = PreprocessorCondition.hasBuiltin(each);
            queryBuilder.appendBuiltinQuery(condition, GCCCompiler.clangBuiltinMacro(each), true);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(each);
            if (cidrFeature != null) {
                queryBuilder.appendSetFeatureCommand(condition, cidrFeature);
            }
        });
        ClangFeatures.getAllAttributes().forEach(each -> queryBuilder.appendBuiltinQuery(PreprocessorCondition.hasAttribute(each), GCCCompiler.clangAttributeMacro(each), true));
        ClangFeatures.getAllTargetArchs().forEach(arch -> queryBuilder.appendBuiltinQuery(PreprocessorCondition.function("__is_target_arch", arch), GCCCompiler.clangTargetArchMacro(arch), true));
        ClangFeatures.getAllTargetVendors().forEach(vendor -> queryBuilder.appendBuiltinQuery(PreprocessorCondition.function("__is_target_vendor", vendor), GCCCompiler.clangTargetVendorMacro(vendor), true));
        ClangFeatures.getAllTargetOss().forEach(os -> {
            queryBuilder.appendBuiltinQuery(PreprocessorCondition.function("__is_target_os", os), GCCCompiler.clangTargetOsMacro(os), true);
            queryBuilder.appendBuiltinQuery(PreprocessorCondition.function("__is_target_variant_os", os), GCCCompiler.clangTargetVariantOsMacro(os), true);
        });
        ClangFeatures.getAllTargetEnvironemts().forEach(environment -> {
            queryBuilder.appendBuiltinQuery(PreprocessorCondition.function("__is_target_environment", environment), GCCCompiler.clangTargetEnvironmentMacro(environment), true);
            queryBuilder.appendBuiltinQuery(PreprocessorCondition.function("__is_target_variant_environment", environment), GCCCompiler.clangTargetVariantEnvironmentMacro(environment), true);
        });
        queryBuilder.appendSetFeatureCommand(PreprocessorCondition.safe("!__is_identifier(__auto_type)"), OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
        queryBuilder.appendSetFeatureCommand(PreprocessorCondition.defined("__cpp_concepts"), OCCompilerFeatures.Feature.CXX_CONCEPTS);
        result2.append("#else\n");
        result2.append("#define __CIDR_GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)\n");
        LinkedHashMap<OCCompilerFeatures.Feature, @NonNls String> checks = new LinkedHashMap<OCCompilerFeatures.Feature, String>();
        checks.put(OCCompilerFeatures.Feature.GCC_AUTO_TYPE, "!defined(__cplusplus) && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.C_STATIC_ASSERT, "!defined(__cplusplus) && __STDC_VERSION__ >= 201112L && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_AUTO_TYPE, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_NULLPTR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_EXCEPTIONS, "defined(__cplusplus) && __EXCEPTIONS");
        checks.put(OCCompilerFeatures.Feature.CXX_CONSTEXPR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40500");
        checks.put(OCCompilerFeatures.Feature.CXX_USER_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_ATTRIBUTES, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_GNU_INTEGER_PACK, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 80100");
        checks.put(OCCompilerFeatures.Feature.CXX_HAS_IS_SAME, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 100100");
        checks.put(OCCompilerFeatures.Feature.CXX_HAS_IS_CONVERTIBLE, "defined(__cplusplus) && __CIDR_GCC_VERSION >= 130100");
        checks.put(OCCompilerFeatures.Feature.CXX_HAS_IS_NOTHROW_CONVERTIBLE, "defined(__cplusplus) && __CIDR_GCC_VERSION >= 130100");
        checks.put(OCCompilerFeatures.Feature.C_NULLPTR, "!defined(__cplusplus) && __STDC_VERSION__ > 201710L && __CIDR_GCC_VERSION >= 130100");
        checks.put(OCCompilerFeatures.Feature.C_AUTO_TYPE, "!defined(__cplusplus) && __STDC_VERSION__ > 201710L && __CIDR_GCC_VERSION >= 130100");
        checks.put(OCCompilerFeatures.Feature.C_CONSTEXPR, "!defined(__cplusplus) && __STDC_VERSION__ > 201710L && __CIDR_GCC_VERSION >= 130100");
        checks.forEach((feature, check) -> queryBuilder.appendSetFeatureCommand(PreprocessorCondition.safe(check), (OCCompilerFeatures.Feature)feature));
        result2.append("#endif\n");
        queryBuilder.appendHasBuiltinQuery("__builtin_bit_cast", OCCompilerFeatures.Feature.BUILTIN_BIT_CAST);
        queryBuilder.appendHasBuiltinQuery("__builtin_source_location", OCCompilerFeatures.Feature.BUILTIN_SOURCE_LOCATION);
        GCCCompiler.getTypeSizesMacros().forEach((type, macro) -> queryBuilder.appendTypeSizeQuery((String)macro, (OCCompilerFeatures.TypeSize)type));
        result2.append("} /* ____CIDR_command() */\n");
        return result2.toString();
    }

    @NotNull
    public static LinkedHashMap<OCCompilerFeatures.TypeSize, String> getTypeSizesMacros() {
        LinkedHashMap<OCCompilerFeatures.TypeSize, @NonNls String> sizes = new LinkedHashMap<OCCompilerFeatures.TypeSize, String>();
        sizes.put(OCCompilerFeatures.TypeSize.WCHAR_T, "__SIZEOF_WCHAR_T__");
        sizes.put(OCCompilerFeatures.TypeSize.SHORT, "__SIZEOF_SHORT__");
        sizes.put(OCCompilerFeatures.TypeSize.INT, "__SIZEOF_INT__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG, "__SIZEOF_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.POINTER, "__SIZEOF_POINTER__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_LONG, "__SIZEOF_LONG_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.INT128_T, "__SIZEOF_INT128__");
        sizes.put(OCCompilerFeatures.TypeSize.FLOAT, "__SIZEOF_FLOAT__");
        sizes.put(OCCompilerFeatures.TypeSize.DOUBLE, "__SIZEOF_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, "__SIZEOF_LONG_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.SIZE_T, "__SIZEOF_SIZE_T__");
        sizes.put(OCCompilerFeatures.TypeSize.PTRDIFF_T, "__SIZEOF_PTRDIFF_T__");
        LinkedHashMap<OCCompilerFeatures.TypeSize, String> linkedHashMap = sizes;
        if (linkedHashMap == null) {
            GCCCompiler.$$$reportNull$$$0(39);
        }
        return linkedHashMap;
    }

    private static void collectDiagnostics(@NotNull CidrCompilerSwitches switches, boolean isClang, final Map<OCCompilerFeatures.Type<?>, Object> result2) {
        HashSet<String> set;
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(40);
        }
        if ((set = new HashSet<String>(switches.getList(CidrCompilerSwitches.Format.RAW))).contains("-w")) {
            return;
        }
        boolean everythingEnabled = set.contains("-Weverything");
        boolean allWarningsEnabled = everythingEnabled || set.contains("-Wall");
        boolean pedanticAsErrors = set.contains("-pedantic-errors");
        boolean pedanticEnabled = everythingEnabled || pedanticAsErrors || set.contains("-pedantic") || set.contains("-Wpedantic");
        boolean warningsAsErrors = set.contains("-Werror");
        class Checker {
            Checker() {
            }

            void add(OCCompilerFeatures.Diagnostic diagnostic, boolean globallyEnabled, boolean globallyEnabledAsError, @NonNls String id) {
                OCCompilerFeatures.DiagnosticLevel level = this.getLevel(globallyEnabled, globallyEnabledAsError, id);
                result2.put(diagnostic, level != null ? level : OCCompilerFeatures.DiagnosticLevel.DISABLED);
            }

            @Nullable
            private OCCompilerFeatures.DiagnosticLevel getLevel(boolean globallyEnabled, boolean globallyEnabledAsError, @NonNls String id) {
                if (globallyEnabled && globallyEnabledAsError || set.contains("-Werror=" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.ERROR;
                }
                if (globallyEnabled || set.contains("-W" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.WARNING;
                }
                return null;
            }
        }
        Checker checker = new Checker();
        checker.add(OCCompilerFeatures.Diagnostic.MISSING_RETURN_FROM_NON_VOID, isClang || allWarningsEnabled, warningsAsErrors, "return-type");
        if (isClang) {
            checker.add(OCCompilerFeatures.Diagnostic.FOLDING_CONSTANT, pedanticEnabled, pedanticAsErrors, "gnu-folding-constant");
        }
    }

    private static void collectFeatureFlags(@NotNull CidrCompilerSwitches switches, Map<OCCompilerFeatures.Type<?>, Object> result2) {
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(41);
        }
        HashSet<String> set = new HashSet<String>(switches.getList(CidrCompilerSwitches.Format.RAW));
        featureFlags.forEach((flag, feature) -> {
            String positive = "-f" + flag;
            String negative = "-fno-" + flag;
            if (set.contains(positive)) {
                result2.put((OCCompilerFeatures.Type<?>)feature, true);
            } else if (set.contains(negative)) {
                result2.put((OCCompilerFeatures.Type<?>)feature, false);
            }
        });
    }

    @NotNull
    ProcessOutput runGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull String fileText, @NotNull List<? super String> warnLog) throws ExecutionException {
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(42);
        }
        if (options == null) {
            GCCCompiler.$$$reportNull$$$0(43);
        }
        if (fileText == null) {
            GCCCompiler.$$$reportNull$$$0(44);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(45);
        }
        HashSet skipOptions = ContainerUtil.newHashSet((Object[])new String[]{"-fdiagnostics-format", "-imacros", "-"});
        return this.tryRunGCC(environment, options, skipOptions, 0, 0, false, fileText, warnLog);
    }

    @NotNull
    protected OCCompilerCommandLineShortener getCommandLineShortener() {
        return new GCCResponseFileShortener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ProcessOutput tryRunGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull Set<String> skipOptions, int optionsRetriesNumber, int timeoutsNumber, boolean skipResponseFile, @NotNull String fileText, @NotNull List<? super String> warnLog) throws ExecutionException {
        ProcessOutput output;
        String clCommandLineString;
        String userFriendlySwitches;
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(46);
        }
        if (options == null) {
            GCCCompiler.$$$reportNull$$$0(47);
        }
        if (skipOptions == null) {
            GCCCompiler.$$$reportNull$$$0(48);
        }
        if (fileText == null) {
            GCCCompiler.$$$reportNull$$$0(49);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(50);
        }
        CidrCompilerSwitches filteredOptions = this.filterOptions(options, skipOptions);
        Path responseFile = null;
        OCCompilerCommandLineShortener shortener = this.getCommandLineShortener();
        Path bodyFile = null;
        String gccPath = this.myExecutable.getPath();
        HostMachine host = environment.getHostMachine();
        Path tmpDir = host.getTempDirectory();
        try {
            try {
                bodyFile = this.myTempFilesPool.writeToTempFile(host, fileText, tmpDir, "compiler-file", "");
            }
            catch (IOException e) {
                throw new ExecutionException(CidrProjectModelBundle.message("unable.to.create.temporary.file", new Object[0]), (Throwable)e);
            }
            GeneralCommandLine cl = new GeneralCommandLine(new String[]{gccPath});
            environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            cl.withWorkDirectory(this.myWorkingDirectory);
            Map clEnvironment = cl.getEnvironment();
            clEnvironment.put("LC_ALL", "C");
            for (String skipVariables : skipEnvironment) {
                clEnvironment.remove(skipVariables);
            }
            cl.addParameters(filteredOptions.getList(CidrCompilerSwitches.Format.RAW));
            userFriendlySwitches = cl.getParametersList().getParametersString().replaceFirst(Matcher.quoteReplacement(" -D___CIDR_DEFINITIONS_END"), "");
            if (!skipResponseFile) {
                cl = shortener.shorten(cl, environment, this.myTempFilesPool);
                responseFile = OCResponseFileShortener.getResponseFile((UserDataHolder)cl);
            }
            cl.addParameters(new String[]{environment.toEnvPath(bodyFile.toAbsolutePath().toString())});
            clCommandLineString = cl.getCommandLineString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running compiler: " + clCommandLineString + "\nArguments file contents: " + filteredOptions);
            }
            output = outCompilerRunner.run(cl, environment);
            if (bodyFile != null) {
                this.myTempFilesPool.delete(bodyFile);
            }
            if (responseFile != null) {
                this.myTempFilesPool.delete(responseFile);
            }
        }
        catch (Throwable throwable) {
            if (bodyFile != null) {
                this.myTempFilesPool.delete(bodyFile);
            }
            if (responseFile != null) {
                this.myTempFilesPool.delete(responseFile);
            }
            throw throwable;
        }
        this.logCompilerOutput(clCommandLineString, output);
        @NonNls String userFriendlyCommandLine = gccPath + " " + userFriendlySwitches;
        if (output.isTimeout()) {
            if (timeoutsNumber < 1) {
                LOG.debug("Trying to run compiler after timeout");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber + 1, skipResponseFile, fileText, warnLog);
            }
            throw GCCCompiler.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            if (!skipResponseFile && responseFile != null && output.getStderr().contains("@" + environment.toEnvPath(responseFile.toString()))) {
                LOG.debug("Trying to run compiler without a @response file");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber, true, fileText, warnLog);
            }
            if (optionsRetriesNumber < 2 && GCCCompiler.collectSkipOptionsGcc(output.getStderrLines(), skipOptions, warnLog)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Trying to run compiler with skipped options: " + StringUtil.join(skipOptions, (String)" "));
                }
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber + 1, timeoutsNumber, skipResponseFile, fileText, warnLog);
            }
            if (!GCCCompiler.allowResultsWithError(output)) {
                throw GCCCompiler.throwCompilerError(output, userFriendlyCommandLine);
            }
        }
        ProcessOutput processOutput2 = output;
        if (processOutput2 == null) {
            GCCCompiler.$$$reportNull$$$0(51);
        }
        return processOutput2;
    }

    private static boolean allowResultsWithError(@NotNull ProcessOutput output) {
        if (output == null) {
            GCCCompiler.$$$reportNull$$$0(52);
        }
        return PluginUtils.hasAppCode() && output.getExitCode() == 1;
    }

    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, final @NotNull Set<String> skipOptions) {
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(53);
        }
        if (skipOptions == null) {
            GCCCompiler.$$$reportNull$$$0(54);
        }
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(){
            boolean archAdded = false;
            boolean skipOptionValue = false;
            boolean skipRest = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipRest) {
                    return false;
                }
                parameter = GCCCompiler.this.adjustArgument(parameter.trim());
                boolean tokenIsSwitch = GCCCompiler.isOptionSwitch(parameter);
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (!skipOptions.contains(parameter)) {
                    if (skipSwitches.contains(parameter)) {
                        this.skipOptionValue = true;
                        return false;
                    }
                    String finalParameter = parameter;
                    if (ContainerUtil.exists(skipSwitches, s -> finalParameter.startsWith((String)s))) {
                        return false;
                    }
                    if (parameter.startsWith("-Werror") || parameter.startsWith("-Wno-error")) {
                        return false;
                    }
                    if ("-arch".equals(parameter)) {
                        if (this.archAdded) {
                            this.skipOptionValue = true;
                            return false;
                        }
                        this.archAdded = true;
                    }
                    if (parameter.startsWith("-include") || parameter.startsWith("--include")) {
                        String includeArg;
                        if (("-include".equals(parameter) || "--include".equals(parameter)) && skipOptions.contains(GCCCompiler.this.adjustArgument(nextParameter))) {
                            return false;
                        }
                        if (parameter.startsWith("--include=") ? skipOptions.contains(includeArg = parameter.substring("--include=".length())) : skipOptions.contains(includeArg = parameter.substring("-include".length()))) {
                            return false;
                        }
                    }
                    if (parameter.equals("--")) {
                        this.skipRest = true;
                        return false;
                    }
                    return true;
                }
                this.skipOptionValue = tokenIsSwitch;
                return false;
            }
        };
        CidrCompilerSwitches cidrCompilerSwitches = switches.filterOptions((BiFunction<? super String, ? super String, Boolean>)argumentsFilter2);
        if (cidrCompilerSwitches == null) {
            GCCCompiler.$$$reportNull$$$0(55);
        }
        return cidrCompilerSwitches;
    }

    private static boolean isOptionSwitch(@NotNull String option) {
        if (option == null) {
            GCCCompiler.$$$reportNull$$$0(56);
        }
        return option.startsWith("-");
    }

    static boolean collectSkipOptionsGcc(List<String> lines, Set<? super String> skipOptions, List<? super String> warnLog) {
        return GCCCompiler.collectOptionsToSkip(lines, skipOptions, warnLog, BAD_SWITCH_FILTER_RULES);
    }

    @NonNls
    @NotNull
    protected String adjustArgument(@NotNull String arg) {
        if (arg == null) {
            GCCCompiler.$$$reportNull$$$0(57);
        }
        String string = arg;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NonNls
    @NotNull
    protected String preparePath(@NotNull CidrToolEnvironment env, @NotNull String path) {
        if (env == null) {
            GCCCompiler.$$$reportNull$$$0(59);
        }
        if (path == null) {
            GCCCompiler.$$$reportNull$$$0(60);
        }
        String string = FileUtil.toCanonicalPath((String)env.toLocalPath(this.myWorkingDirectory, path));
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(61);
        }
        return string;
    }

    @NonNls
    public static List<String> getClangTestMacros() {
        return CLANG_TEST_MACROS;
    }

    @NonNls
    @NotNull
    public static List<String> getGCCBuiltInFunctionMacros() {
        List<String> list = GCC_BUILT_IN_FUNCTION_MACROS;
        if (list == null) {
            GCCCompiler.$$$reportNull$$$0(62);
        }
        return list;
    }

    @NonNls
    @NotNull
    public static List<String> getGCCBuiltInVAFunctionMacros() {
        List<String> list = GCC_BUILT_IN_VA_FUNCTION_MACROS;
        if (list == null) {
            GCCCompiler.$$$reportNull$$$0(63);
        }
        return list;
    }

    @NonNls
    @NotNull
    public static String clangFeatureMacro(@NotNull String feature) {
        if (feature == null) {
            GCCCompiler.$$$reportNull$$$0(64);
        }
        String string = "__CIDR_clang__has_feature_" + feature;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(65);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangExtensionMacro(@NotNull String extension) {
        if (extension == null) {
            GCCCompiler.$$$reportNull$$$0(66);
        }
        String string = "__CIDR_clang__has_extension_" + extension;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(67);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangAttributeMacro(@NotNull String attribute) {
        if (attribute == null) {
            GCCCompiler.$$$reportNull$$$0(68);
        }
        String string = "__CIDR_clang__has_attribute_" + attribute;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(69);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangBuiltinMacro(@NotNull String extension) {
        if (extension == null) {
            GCCCompiler.$$$reportNull$$$0(70);
        }
        String string = "__CIDR_clang__has_builtin_" + extension;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(71);
        }
        return string;
    }

    @NonNls
    @NotNull
    @VisibleForTesting
    public static String clangTargetArchMacro(@NotNull String arch) {
        if (arch == null) {
            GCCCompiler.$$$reportNull$$$0(72);
        }
        String string = "__CIDR_clang__is_target_arch_" + arch;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetVendorMacro(@NotNull String vendor) {
        if (vendor == null) {
            GCCCompiler.$$$reportNull$$$0(74);
        }
        String string = "__CIDR_clang__is_target_vendor_" + vendor;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(75);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetOsMacro(@NotNull String os) {
        if (os == null) {
            GCCCompiler.$$$reportNull$$$0(76);
        }
        String string = "__CIDR_clang__is_target_os_" + os;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(77);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetEnvironmentMacro(@NotNull String environment) {
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(78);
        }
        String string = "__CIDR_clang__is_target_environment_" + environment;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(79);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetVariantOsMacro(@NotNull String os) {
        if (os == null) {
            GCCCompiler.$$$reportNull$$$0(80);
        }
        String string = "__CIDR_clang__is_target_variant_os_" + os;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(81);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetVariantEnvironmentMacro(@NotNull String environment) {
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(82);
        }
        String string = "__CIDR_clang__is_target_variant_environment_" + environment;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(83);
        }
        return string;
    }

    static {
        featureFlags.put("ms-extensions", OCCompilerFeatures.Feature.MS_EXTENSIONS);
        featureFlags.put("ms-compatibility", OCCompilerFeatures.Feature.MS_EXTENSIONS);
        featureFlags.put("operator-names", OCCompilerFeatures.Feature.CXX_ALTERNATIVE_OPERATORS);
        skipSwitches = ContainerUtil.newHashSet((Object[])new String[]{"-o", "--output", "--output=", "-M", "-MM", "-MF", "-MG", "-MP", "-MT", "-MQ", "-MD", "-MMD", "-fdiagnostics-color", "-fcolor-diagnostics"});
        skipEnvironment = ContainerUtil.newHashSet((Object[])new String[]{"DEPENDENCIES_OUTPUT", "SUNPRO_DEPENDENCIES"});
        CLANG_TEST_MACROS = List.of("#define __has_feature(X) " + GCCCompiler.clangFeatureMacro("##X"), "#define __has_extension(X) " + GCCCompiler.clangExtensionMacro("##X"), "#define __has_attribute(X) " + GCCCompiler.clangAttributeMacro("##X"), "#define __has_builtin(X) " + GCCCompiler.clangBuiltinMacro("##X"), "#define __is_target_arch(X) " + GCCCompiler.clangTargetArchMacro("##X"), "#define __is_target_vendor(X) " + GCCCompiler.clangTargetVendorMacro("##X"), "#define __is_target_os(X) " + GCCCompiler.clangTargetOsMacro("##X"), "#define __is_target_environment(X) " + GCCCompiler.clangTargetEnvironmentMacro("##X"), "#define __is_target_variant_os(X) " + GCCCompiler.clangTargetVariantOsMacro("##X"), "#define __is_target_variant_environment(X) " + GCCCompiler.clangTargetVariantEnvironmentMacro("##X"));
        GCC_BUILT_IN_VA_FUNCTION_MACROS = List.of("#define __builtin_va_start(list, paramN) ((void)(list = sizeof(paramN)))", "#define __builtin_va_arg(list, type) ((type)list)", "#define __builtin_va_end(list) ((void)list)", "#define __builtin_va_copy(dest, src) ((void)(dest = src))");
        GCC_BUILT_IN_FUNCTION_MACROS = ContainerUtil.concat(GCC_BUILT_IN_VA_FUNCTION_MACROS, List.of("#define __builtin_offsetof(type, member) ((size_t)(&(((type *)0)->member)))", "#define __builtin_types_compatible_p(X,Y) 1", "#define __builtin_choose_expr(C,T,E) T"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 22, 23, 24, 39, 51, 55, 58, 61, 62, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 10: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 2: 
            case 20: 
            case 26: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFilesPool";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: 
            case 13: 
            case 16: 
            case 40: 
            case 41: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 7: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawSwitches";
                break;
            }
            case 9: 
            case 17: 
            case 30: 
            case 33: 
            case 42: 
            case 46: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 39: 
            case 51: 
            case 55: 
            case 58: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler";
                break;
            }
            case 12: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessed";
                break;
            }
            case 19: 
            case 28: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnLog";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pch";
                break;
            }
            case 29: 
            case 32: 
            case 36: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonBuiltinSearchPaths";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestSwitches";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipOptions";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 66: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arch";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendor";
                break;
            }
            case 76: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNonBuiltinSearchPaths";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "tryExtractOriginalPrecompiledHeadersFromCMakeGeneratedFile";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSizesMacros";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "tryRunGCC";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOptions";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustArgument";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePath";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getGCCBuiltInFunctionMacros";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getGCCBuiltInVAFunctionMacros";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "clangFeatureMacro";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "clangExtensionMacro";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "clangAttributeMacro";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "clangBuiltinMacro";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetArchMacro";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetVendorMacro";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetOsMacro";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetEnvironmentMacro";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetVariantOsMacro";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetVariantEnvironmentMacro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptionLanguage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractNonBuiltinSearchPaths";
                break;
            }
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 39: 
            case 51: 
            case 55: 
            case 58: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isClang";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCpp";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getForcedHeaders";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryExtractOriginalPrecompiledHeadersFromCMakeGeneratedFile";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "extractOriginalPrecompiledHeaderFile";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collectHeaderSearchPaths";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "collectDefinitionsAndFeatures";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildFeaturesCheckText";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "collectDiagnostics";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collectFeatureFlags";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "runGCC";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "tryRunGCC";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "allowResultsWithError";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "filterOptions";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isOptionSwitch";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "adjustArgument";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "preparePath";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "clangFeatureMacro";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "clangExtensionMacro";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "clangAttributeMacro";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "clangBuiltinMacro";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetArchMacro";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetVendorMacro";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetOsMacro";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetEnvironmentMacro";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetVariantOsMacro";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetVariantEnvironmentMacro";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 22, 23, 24, 39, 51, 55, 58, 61, 62, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83 -> new IllegalStateException(string);
        };
    }

    static class OutputSections {
        @NotNull
        final List<String> defines;
        @NotNull
        final String preprocessed;
        @NotNull
        final String featureChecks;

        OutputSections(@NotNull List<String> defines, @NotNull String preprocessed, @NotNull String featureTests) {
            if (defines == null) {
                OutputSections.$$$reportNull$$$0(0);
            }
            if (preprocessed == null) {
                OutputSections.$$$reportNull$$$0(1);
            }
            if (featureTests == null) {
                OutputSections.$$$reportNull$$$0(2);
            }
            this.defines = defines;
            this.preprocessed = preprocessed;
            this.featureChecks = featureTests;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defines";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "preprocessed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "featureTests";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$OutputSections";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    public static enum Command {
        SET_TYPE_SIZE,
        SET_FEATURE,
        ADD_DEFINITION,
        SET_LANGUAGE_STANDARD;

    }

    private static class PreprocessorCondition {
        @NonNls
        @NotNull
        private final String myText;
        @NotNull
        private final Iterable<String> myPotentialDefines;

        private PreprocessorCondition(@NonNls @NotNull String text, @NotNull Iterable<String> potentialDefines) {
            if (text == null) {
                PreprocessorCondition.$$$reportNull$$$0(0);
            }
            if (potentialDefines == null) {
                PreprocessorCondition.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myPotentialDefines = potentialDefines;
        }

        @NonNls
        @NotNull
        String getText() {
            String string = this.myText;
            if (string == null) {
                PreprocessorCondition.$$$reportNull$$$0(2);
            }
            return string;
        }

        void appendPotentialDefinesIfs(@NonNls StringBuilder result2) {
            for (String potentialDefine : this.myPotentialDefines) {
                if (PreprocessorCondition.isSafe(potentialDefine)) continue;
                result2.append("#if !defined(").append(potentialDefine).append(")\n");
            }
        }

        void appendPotentialDefinesEndifs(@NonNls StringBuilder result2) {
            for (String potentialDefine : this.myPotentialDefines) {
                if (PreprocessorCondition.isSafe(potentialDefine)) continue;
                result2.append("#endif\n");
            }
        }

        private static boolean isSafe(@NotNull String potentialDefine) {
            if (potentialDefine == null) {
                PreprocessorCondition.$$$reportNull$$$0(3);
            }
            return potentialDefine.startsWith("__");
        }

        static PreprocessorCondition safe(@NonNls @NotNull String text) {
            if (text == null) {
                PreprocessorCondition.$$$reportNull$$$0(4);
            }
            return new PreprocessorCondition(text, Collections.emptyList());
        }

        static PreprocessorCondition defined(@NonNls @NotNull String macro) {
            if (macro == null) {
                PreprocessorCondition.$$$reportNull$$$0(5);
            }
            return PreprocessorCondition.safe("defined(" + macro + ")");
        }

        static PreprocessorCondition function(@NonNls @NotNull String funcName, @NonNls @NotNull String param) {
            if (funcName == null) {
                PreprocessorCondition.$$$reportNull$$$0(6);
            }
            if (param == null) {
                PreprocessorCondition.$$$reportNull$$$0(7);
            }
            return new PreprocessorCondition(funcName + "(" + param + ")", Collections.singletonList(param));
        }

        static PreprocessorCondition hasFeature(@NotNull @NonNls String feature) {
            if (feature == null) {
                PreprocessorCondition.$$$reportNull$$$0(8);
            }
            return PreprocessorCondition.function("__has_feature", feature);
        }

        static PreprocessorCondition hasBuiltin(@NotNull @NonNls String feature) {
            if (feature == null) {
                PreprocessorCondition.$$$reportNull$$$0(9);
            }
            return PreprocessorCondition.function("__has_builtin", feature);
        }

        static PreprocessorCondition hasExtension(@NotNull @NonNls String feature) {
            if (feature == null) {
                PreprocessorCondition.$$$reportNull$$$0(10);
            }
            return PreprocessorCondition.function("__has_extension", feature);
        }

        static PreprocessorCondition hasAttribute(@NotNull @NonNls String feature) {
            if (feature == null) {
                PreprocessorCondition.$$$reportNull$$$0(11);
            }
            return PreprocessorCondition.function("__has_attribute", feature);
        }

        static PreprocessorCondition or(@NotNull PreprocessorCondition a, @NotNull PreprocessorCondition b) {
            if (a == null) {
                PreprocessorCondition.$$$reportNull$$$0(12);
            }
            if (b == null) {
                PreprocessorCondition.$$$reportNull$$$0(13);
            }
            Iterable<String> allDefines = PreprocessorCondition.unique(a.myPotentialDefines, b.myPotentialDefines);
            return new PreprocessorCondition(a.getText() + " || " + b.getText(), allDefines);
        }

        @NotNull
        private static Iterable<String> unique(@NotNull Iterable<String> a, @NotNull Iterable<String> b) {
            if (a == null) {
                PreprocessorCondition.$$$reportNull$$$0(14);
            }
            if (b == null) {
                PreprocessorCondition.$$$reportNull$$$0(15);
            }
            HashSet hashSet = ContainerUtil.newHashSet((Iterable)ContainerUtil.concat(a, b));
            if (hashSet == null) {
                PreprocessorCondition.$$$reportNull$$$0(16);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "potentialDefines";
                    break;
                }
                case 2: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$PreprocessorCondition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "potentialDefine";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "macro";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "funcName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "feature";
                    break;
                }
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$PreprocessorCondition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unique";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 16: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSafe";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "safe";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "defined";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "function";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "hasFeature";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "hasBuiltin";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "hasExtension";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "hasAttribute";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "or";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "unique";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 16 -> new IllegalStateException(string);
            };
        }
    }
}

