/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.Map;
import java.util.function.BiConsumer;

public final class FeatureParseUtil {
    private FeatureParseUtil() {
    }

    public static long parseVersion(Map<String, String> defines, String key) throws ExecutionException {
        String s = defines.get(key);
        if (s == null) {
            return -1L;
        }
        try {
            if (s.endsWith("L")) {
                return Long.parseLong(s.substring(0, s.length() - 1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new ExecutionException(CidrProjectModelBundle.message("c.macro.has.wrong.format", key, s));
    }

    public static void collectStandardFeatures(Map<String, String> defines, BiConsumer<OCCompilerFeatures.Type<?>, Object> consumer) throws ExecutionException {
        long cVersion = FeatureParseUtil.parseVersion(defines, "__STDC_VERSION__");
        long cppVersion = FeatureParseUtil.parseVersion(defines, "__cplusplus");
        consumer.accept(OCCompilerFeatures.Feature.C_STATIC_ASSERT, cppVersion < 0L && cVersion >= 201112L);
        consumer.accept(OCCompilerFeatures.Feature.C_AUTO_TYPE, cppVersion < 0L && cVersion > 201710L);
        consumer.accept(OCCompilerFeatures.Feature.C_NULLPTR, cppVersion < 0L && cVersion > 201710L);
        consumer.accept(OCCompilerFeatures.Feature.C_CONSTEXPR, cppVersion < 0L && cVersion > 201710L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_AUTO_TYPE, cppVersion >= 201103L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL, cppVersion >= 201103L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS, cppVersion >= 201103L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_NULLPTR, cppVersion >= 201103L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT, cppVersion >= 201103L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_EXCEPTIONS, cppVersion > 0L && defines.containsKey("__EXCEPTIONS"));
        consumer.accept(OCCompilerFeatures.Feature.CXX_CONSTEXPR, cppVersion >= 201103L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS, cppVersion >= 201103L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_USER_LITERALS, cppVersion >= 201103L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS, cppVersion >= 201402L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION, cppVersion >= 201402L);
        consumer.accept(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS, cppVersion >= 201402L);
        if (cppVersion > 0L) {
            consumer.accept(OCCompilerFeatures.LANGUAGE_STANDARD, (Object)OCLanguageStandard.getCppStandard(cppVersion + "L"));
        } else if (cVersion > 0L) {
            consumer.accept(OCCompilerFeatures.LANGUAGE_STANDARD, (Object)OCLanguageStandard.getCStandard(cVersion + "L"));
        }
    }

    public static void collectGccSizes(Map<String, String> defines, BiConsumer<OCCompilerFeatures.Type<?>, Object> consumer) {
        for (OCCompilerFeatures.TypeSize typeSize : OCCompilerFeatures.TypeSize.values()) {
            try {
                String sizeStr = defines.get("__SIZEOF_" + typeSize.name() + "__");
                if (sizeStr == null) continue;
                consumer.accept(typeSize, Short.valueOf(sizeStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

