/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCAttributes {
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_UNUSED = "unused";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_USED = "used";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_CXX_MAYBE_UNUSED = "maybe_unused";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_CXX_NORETURN = "noreturn";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_CONSTRUCTOR = "constructor";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_DESTRUCTOR = "destructor";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_IBOUTLET = "iboutlet";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_IBOUTLET_COLLECTION = "iboutletcollection";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_IBACTION = "ibaction";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_RETURNS_RETAINED = "ns_returns_retained";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_OVERLOADABLE = "overloadable";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_DEPRECATED = "deprecated";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_UNAVAILABLE = "unavailable";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_TRANSPARENT_UNION = "transparent_union";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_NAME = "swift_name";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_WRAPPER = "swift_wrapper";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_ASYNC_NAME = "swift_async_name";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_ASYNC = "swift_async";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_SWIFT_ASYNC_ERROR = "swift_async_error";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_UNUSED_MACRO = "__attribute__((unused))";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_MIN_IOS_VERSION = "__min_ios_version";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_MIN_MACOS_VERSION = "__min_macos_version";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_RETURNS_RETAINED_MACRO = "NS_RETURNS_RETAINED";
    @NotNull
    @NlsSafe
    public static final String ATTRIBUTE_MODE = "mode";
    public static final @NotNull Set<@NlsSafe String> CUDA_ATTRIBUTES = Set.of("global", "device", "host");

    public static boolean hasAttribute(@NotNull Collection<String> attributes, @NotNull String attribute) {
        if (attributes == null) {
            OCAttributes.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            OCAttributes.$$$reportNull$$$0(1);
        }
        return attributes.contains(attribute) || attributes.contains(OCAttributes.wrapWithUnderscores(attribute));
    }

    public static String makeCppAttribute(String attribute) {
        return "[[" + attribute + "]]";
    }

    @Nullable
    public static String getAttributeParameter(@NotNull Collection<String> attributes, @NotNull String attribute) {
        if (attributes == null) {
            OCAttributes.$$$reportNull$$$0(2);
        }
        if (attribute == null) {
            OCAttributes.$$$reportNull$$$0(3);
        }
        String plainAttributePrefix = OCAttributes.attributeParameterPrefix(attribute);
        String underscoredAttributePrefix = OCAttributes.attributeParameterPrefix(OCAttributes.wrapWithUnderscores(attribute));
        for (String curAttribute : attributes) {
            if (curAttribute.startsWith(plainAttributePrefix)) {
                return curAttribute.substring(plainAttributePrefix.length());
            }
            if (!curAttribute.startsWith(underscoredAttributePrefix)) continue;
            return curAttribute.substring(underscoredAttributePrefix.length());
        }
        return null;
    }

    @NotNull
    public static String attributeParameterPrefix(@NotNull String attribute) {
        if (attribute == null) {
            OCAttributes.$$$reportNull$$$0(4);
        }
        String string = attribute + "#";
        if (string == null) {
            OCAttributes.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String wrapWithUnderscores(@NotNull String attribute) {
        if (attribute == null) {
            OCAttributes.$$$reportNull$$$0(6);
        }
        if (StringUtil.startsWithChar((CharSequence)attribute, (char)'_')) {
            String string = attribute;
            if (string == null) {
                OCAttributes.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = "__" + attribute + "__";
        if (string == null) {
            OCAttributes.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String trimUnderscores(@NotNull String attribute) {
        if (attribute == null) {
            OCAttributes.$$$reportNull$$$0(9);
        }
        if (attribute.length() <= 4 || !attribute.startsWith("__") || !attribute.endsWith("__")) {
            String string = attribute;
            if (string == null) {
                OCAttributes.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = attribute.substring(2, attribute.length() - 2);
        if (string == null) {
            OCAttributes.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "attributeParameterPrefix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithUnderscores";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUnderscores";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeParameter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "attributeParameterPrefix";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithUnderscores";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "trimUnderscores";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

