/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.light.OCLightFileType;
import com.jetbrains.cidr.lang.light.OCSlowLanguage;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCLanguageUtilsBase {
    public static final Key<Boolean> INSIDE_TYPING_ACTION_HINT = Key.create((String)"INSIDE_TYPING_ACTION_HINT");
    public static final Key<Boolean> INDENTATION_ONLY_HINT = Key.create((String)"INDENTATION_ONLY_HINT");
    private static final ExtensionPointName<OCLanguageUtilsBase> EP_NAME = ExtensionPointName.create((String)"cidr.lang.langUtils");

    protected static boolean isLightPsiOn() {
        return false;
    }

    protected static boolean assertLightPsiOn(@Nullable Object message) {
        return CidrLogService.LOG.assertTrue(OCLanguageUtilsBase.isLightPsiOn(), message);
    }

    @NotNull
    public static Language getConfigLanguage() {
        Language riderCppLanguage = Language.findLanguageByID((String)"C++");
        if (riderCppLanguage != null) {
            Language language = riderCppLanguage;
            if (language == null) {
                OCLanguageUtilsBase.$$$reportNull$$$0(0);
            }
            return language;
        }
        OCLanguage oCLanguage = OCLanguage.getInstance();
        if (oCLanguage == null) {
            OCLanguageUtilsBase.$$$reportNull$$$0(1);
        }
        return oCLanguage;
    }

    @NotNull
    public static Language getLightLanguage() {
        OCLanguage oCLanguage = OCLanguage.getInstance();
        if (oCLanguage == null) {
            OCLanguageUtilsBase.$$$reportNull$$$0(2);
        }
        return oCLanguage;
    }

    @NotNull
    public static Language getSlowLanguage() {
        Language language = OCLanguageUtilsBase.isLightPsiOn() ? OCSlowLanguage.getInstance() : OCLanguage.getInstance();
        if (language == null) {
            OCLanguageUtilsBase.$$$reportNull$$$0(3);
        }
        return language;
    }

    @NotNull
    public static FileType getBaseFileType() {
        LanguageFileType languageFileType = OCLanguageUtilsBase.isLightPsiOn() ? OCLightFileType.INSTANCE : OCFileType.INSTANCE;
        if (languageFileType == null) {
            OCLanguageUtilsBase.$$$reportNull$$$0(4);
        }
        return languageFileType;
    }

    public static boolean isSupported(@Nullable Language language) {
        return language == OCLanguageUtilsBase.getSlowLanguage() || language == OCLanguageUtilsBase.getLightLanguage();
    }

    public static boolean isSupported(@NotNull VirtualFile virtualFile) {
        Iterator iterator;
        if (virtualFile == null) {
            OCLanguageUtilsBase.$$$reportNull$$$0(5);
        }
        if ((iterator = EP_NAME.getExtensionList().iterator()).hasNext()) {
            OCLanguageUtilsBase utils = (OCLanguageUtilsBase)iterator.next();
            return utils.isSupportedFile(virtualFile);
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        return fileTypeManager.isFileOfType(virtualFile, (FileType)OCLightFileType.INSTANCE) && OCLanguageUtilsBase.assertLightPsiOn(virtualFile);
    }

    public static boolean isSupported(@NotNull FileType fileType) {
        Iterator iterator;
        if (fileType == null) {
            OCLanguageUtilsBase.$$$reportNull$$$0(6);
        }
        if ((iterator = EP_NAME.getExtensionList().iterator()).hasNext()) {
            OCLanguageUtilsBase utils = (OCLanguageUtilsBase)iterator.next();
            return utils.isSupportedFileType(fileType);
        }
        return fileType == OCLightFileType.INSTANCE && OCLanguageUtilsBase.assertLightPsiOn(fileType);
    }

    public static boolean isSupported(@Nullable PsiFile file) {
        Iterator iterator = EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            OCLanguageUtilsBase utils = (OCLanguageUtilsBase)iterator.next();
            return utils.isSupportedFile(file);
        }
        return false;
    }

    public abstract boolean isSupportedFile(@Nullable PsiFile var1);

    public abstract boolean isSupportedFile(@NotNull VirtualFile var1);

    public abstract boolean isSupportedFileType(@NotNull FileType var1);

    public static boolean isCppSupportDisabled(@NotNull Project project) {
        if (project == null) {
            OCLanguageUtilsBase.$$$reportNull$$$0(7);
        }
        return (Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)project, (Object)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCLanguageUtilsBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSlowLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFileType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCLanguageUtilsBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCppSupportDisabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

