/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationEditorUtil;
import com.jetbrains.cidr.execution.CidrRunConfigurationUtil;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import com.jetbrains.cidr.ui.CustomEditableComboItem;
import com.jetbrains.cidr.ui.CustomEditableComboItemPrinter;
import com.jetbrains.cidr.ui.ExecutableDataPrinter;
import com.jetbrains.cidr.ui.FileItemPrinter;
import com.jetbrains.cidr.ui.InvalidItem;
import com.jetbrains.cidr.ui.ItemPrinter;
import com.jetbrains.cidr.ui.MutableComboBoxModelEx;
import com.jetbrains.cidr.ui.SortedCollectionComboBoxModel;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRunConfigurationExecutableEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>> {
    private final BCH myConfigHelper;
    private final ComboboxWithBrowseButton myComboboxWithBrowseButton;
    private final MutableComboBoxModelEx<Object> myExecutableComboModel;
    private final CustomEditableComboItem customExecutableItem;

    public CidrRunConfigurationExecutableEditor(Project project, @NotNull BCH configHelper, boolean hasTargetsInSeveralProjects) {
        if (configHelper == null) {
            CidrRunConfigurationExecutableEditor.$$$reportNull$$$0(0);
        }
        this.customExecutableItem = new CustomEditableComboItem(CidrExecutionBundle.message("custom.executable.title", new Object[0]));
        this.myConfigHelper = configHelper;
        this.myExecutableComboModel = new SortedCollectionComboBoxModel<Object>(ComparisonsKt.compareBy((Function1[])new Function1[]{o -> {
            if (o == null) {
                return Integer.valueOf(0);
            }
            if (o instanceof CidrBuildTarget) {
                return Integer.valueOf(1);
            }
            if (o instanceof InvalidItem) {
                return Integer.valueOf(2);
            }
            if (o instanceof File) {
                return Integer.valueOf(3);
            }
            return Integer.valueOf(4);
        }}));
        this.resetExecutableModel(null, null);
        this.myComboboxWithBrowseButton = new ComboboxWithBrowseButton((JComboBox)((Object)CidrRunConfigurationEditorUtil.createCombo(item -> item instanceof File || item instanceof String)));
        final JComboBox combobox = this.myComboboxWithBrowseButton.getComboBox();
        combobox.setModel(this.myExecutableComboModel);
        combobox.setRenderer(new MyExecutablesRenderer(hasTargetsInSeveralProjects, CustomEditableComboItemPrinter.INSTANCE));
        combobox.addActionListener(evt -> {
            String content;
            Object patt2535$temp = combobox.getSelectedItem();
            if (patt2535$temp instanceof String && (content = (String)patt2535$temp).isEmpty()) {
                combobox.setSelectedItem(null);
            }
        });
        this.myComboboxWithBrowseButton.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JComboBox>(CidrExecutionBundle.message("executable.select.title", new Object[0]), null, (ComponentWithBrowseButton)this.myComboboxWithBrowseButton, null, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                combobox.getModel().setSelectedItem(VfsUtilCore.virtualToIoFile((VirtualFile)chosenFile));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/cidr/execution/CidrRunConfigurationExecutableEditor$1", "onFileChosen"));
            }
        });
        MessageBus messageBus = project.getMessageBus();
        combobox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String itemName = CidrRunConfigurationExecutableEditor.getItemName(ComboBoxModelKt.getItemValue(e));
                ((ExecutableListener)messageBus.syncPublisher(ExecutableListener.TOPIC)).onExecutableSelected(itemName);
            }
        });
    }

    protected void resetExecutableModel(@Nullable Object selection, @Nullable TARGET buildTarget) {
        ArrayList<Object> newItems = new ArrayList<Object>();
        newItems.add(this.customExecutableItem);
        newItems.addAll(this.myConfigHelper.getRunTargets(buildTarget));
        if (selection != null && !newItems.contains(selection)) {
            newItems.add(selection);
        }
        this.myExecutableComboModel.reset(newItems);
        this.myExecutableComboModel.setSelectedItem(selection);
    }

    public void createAdditionalControls(JPanel panel, GridBag g) {
        JLabel label = new JLabel(this.myConfigHelper.getExecutableTitle() + ":");
        panel.add((Component)label, g.nextLine().next());
        panel.add((Component)this.myComboboxWithBrowseButton, g.next().coverLine());
        label.setLabelFor((Component)this.myComboboxWithBrowseButton);
    }

    public void onTargetSelected(@Nullable TARGET target) {
        if (target != null && target.isExecutable()) {
            this.myComboboxWithBrowseButton.getComboBox().setSelectedItem(null);
            this.myComboboxWithBrowseButton.getComboBox().setSelectedItem(target);
        }
    }

    public void resetEditorFrom(@NotNull CONFIGURATION runConfiguration) {
        if (runConfiguration == null) {
            CidrRunConfigurationExecutableEditor.$$$reportNull$$$0(1);
        }
        ExecutableData executableData = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        Object executable = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        if (executableData != null) {
            if (executableData.target != null) {
                executable = this.myConfigHelper.findRunTarget(executableData.target);
            } else if (executableData.path != null) {
                executable = new File(executableData.path);
            }
        }
        CidrBuildTarget<?> target = CidrRunConfigurationUtil.getTarget(runConfiguration);
        this.resetExecutableModel(ComboBoxModelKt.createMaybeInvalidItem(executable, executableData), target);
    }

    public void applyEditorTo(@NotNull CONFIGURATION runConfiguration) throws ConfigurationException {
        Object object;
        if (runConfiguration == null) {
            CidrRunConfigurationExecutableEditor.$$$reportNull$$$0(2);
        }
        ExecutableData executableData = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        JComboBox combobox = this.myComboboxWithBrowseButton.getComboBox();
        Object selectedExecutable = ComboBoxModelKt.getSelectedItemValue(combobox);
        if (combobox.isEditable() && (object = combobox.getEditor().getItem()) instanceof String) {
            String content = (String)object;
            executableData = content.isBlank() ? null : new ExecutableData(content);
        } else if (selectedExecutable == null) {
            executableData = (ExecutableData)ComboBoxModelKt.getSelectedInvalidItemValue(combobox);
        } else if (selectedExecutable instanceof CidrBuildTarget) {
            executableData = new ExecutableData(new BuildTargetData((CidrBuildTarget)selectedExecutable));
        } else if (selectedExecutable instanceof File) {
            executableData = new ExecutableData(((File)selectedExecutable).getPath());
        } else if (selectedExecutable instanceof String) {
            executableData = new ExecutableData((String)selectedExecutable);
        }
        ((CidrExecutableDataHolder)runConfiguration).setExecutableData(executableData);
    }

    @Nullable
    private static String getItemName(Object item) {
        if (item instanceof File) {
            return ((File)item).getName();
        }
        if (item instanceof CidrBuildTarget) {
            return ((CidrBuildTarget)item).getName();
        }
        return null;
    }

    public ComboboxWithBrowseButton getComboboxWithBrowseButton() {
        return this.myComboboxWithBrowseButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configHelper";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunConfigurationExecutableEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyExecutablesRenderer
    extends CidrRunConfigurationEditorUtil.RunConfigurationsRenderer {
        MyExecutablesRenderer(boolean hasTargetsInSeveralProjects, ItemPrinter ... itemPrinters) {
            if (itemPrinters == null) {
                MyExecutablesRenderer.$$$reportNull$$$0(0);
            }
            super(hasTargetsInSeveralProjects, MyExecutablesRenderer.arrayOf(itemPrinters, new FileItemPrinter(true, true), ExecutableDataPrinter.INSTANCE));
        }

        protected String getSeparatorAbove(@NotNull JList list, Object value, int index) {
            if (list == null) {
                MyExecutablesRenderer.$$$reportNull$$$0(1);
            }
            if (index == 0) {
                return null;
            }
            if (value instanceof CustomEditableComboItem) {
                return "";
            }
            Object previous = list.getModel().getElementAt(index - 1);
            if (value instanceof File && !(previous instanceof File)) {
                return "";
            }
            return super.getSeparatorAbove(list, value, index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemPrinters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunConfigurationExecutableEditor$MyExecutablesRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSeparatorAbove";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ExecutableListener {
        public static final Topic<ExecutableListener> TOPIC = new Topic(ExecutableListener.class.getSimpleName(), ExecutableListener.class);

        public void onExecutableSelected(@Nullable String var1);
    }
}

