/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.jetbrains.cidr.CidrProjectApplicationVersion;
import java.nio.file.Path;
import java.util.function.Predicate;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenHelper<T> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ProjectOpenHelper.class);
    private final Key<T> myOpenDataKey;
    private final SupportedFileChecker mySupportedFileChecker;

    public ProjectOpenHelper(@NotNull Key<T> openDataKey, @NotNull SupportedFileChecker supportedFileChecker) {
        if (openDataKey == null) {
            ProjectOpenHelper.$$$reportNull$$$0(0);
        }
        if (supportedFileChecker == null) {
            ProjectOpenHelper.$$$reportNull$$$0(1);
        }
        this.myOpenDataKey = openDataKey;
        this.mySupportedFileChecker = supportedFileChecker;
    }

    public boolean isSupportedFile(@Nullable VirtualFile file) {
        return file != null && this.mySupportedFileChecker.isSupportedFile(file);
    }

    @Nullable
    public VirtualFile findSupportedSubFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenHelper.$$$reportNull$$$0(2);
        }
        if (!file.isDirectory() && this.isSupportedFile(file)) {
            return file;
        }
        for (VirtualFile child : file.getChildren()) {
            if (child == null || child.isDirectory() || !this.isSupportedFile(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getValidProjectPath(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenHelper.$$$reportNull$$$0(3);
        }
        if (!file.isDirectory()) {
            file = file.getParent();
        }
        if (ProjectUtil.isValidProjectPath((Path)file.toNioPath())) {
            return file;
        }
        return null;
    }

    @Nullable
    private static Pair<Path, OpenProjectTask> createTaskToOpenExistingProjectInDirectory(@NotNull VirtualFile file, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile projectDir;
        if (file == null) {
            ProjectOpenHelper.$$$reportNull$$$0(4);
        }
        if ((projectDir = ProjectOpenHelper.getValidProjectPath(file)) == null) {
            return null;
        }
        LOG.info("Opening existing project in directory " + projectDir + " Requested file " + file);
        Path projectPath = projectDir.toNioPath();
        OpenProjectTask openProjectTask = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists((Path)projectPath, (Project)projectToClose).withForceOpenInNewFrame(forceOpenInNewFrame);
        return new Pair((Object)projectPath, (Object)openProjectTask);
    }

    @Nullable
    public Project openExistingProjectInDirectory(@NotNull VirtualFile file, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Pair<Path, OpenProjectTask> task2;
        if (file == null) {
            ProjectOpenHelper.$$$reportNull$$$0(5);
        }
        if ((task2 = ProjectOpenHelper.createTaskToOpenExistingProjectInDirectory(file, projectToClose, forceOpenInNewFrame)) == null) {
            return null;
        }
        return ProjectManagerEx.getInstanceEx().openProject((Path)task2.first, (OpenProjectTask)task2.second);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data) {
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(6);
        }
        return this.openProject(virtualFile, projectToClose, forceOpenInNewFrame, data, project -> true);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data, Predicate<Project> callback) {
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(7);
        }
        if (!this.isSupportedFile(virtualFile)) {
            return null;
        }
        this.markFileToOpen(virtualFile, data);
        VirtualFile baseDir = virtualFile.getParent();
        OpenProjectTask options = OpenProjectTaskKt.OpenProjectTask(builder -> {
            PlatformProjectOpenProcessor.Companion.configureToOpenDotIdeaOrCreateNewIfNotExists(builder, baseDir.toNioPath(), projectToClose);
            builder.setForceOpenInNewFrame(forceOpenInNewFrame);
            builder.withBeforeOpenCallback(ProjectOpenHelper.beforeOpenCallback(callback));
            return Unit.INSTANCE;
        });
        return ProjectManagerEx.getInstanceEx().openProject(baseDir.toNioPath(), options);
    }

    public void linkToExistingProject(@NotNull Project project, @NotNull T data) {
        VirtualFile baseDir;
        if (project == null) {
            ProjectOpenHelper.$$$reportNull$$$0(8);
        }
        if (data == null) {
            ProjectOpenHelper.$$$reportNull$$$0(9);
        }
        VirtualFile userDataHolder = (baseDir = project.getBaseDir()) != null ? baseDir : project;
        userDataHolder.putUserData(this.myOpenDataKey, data);
    }

    @NotNull
    private static Predicate<Project> beforeOpenCallback(@Nullable Predicate<Project> userCallback) {
        Predicate<Project> predicate = project -> {
            CidrProjectApplicationVersion.getInstance(project).initializeApplicationInfo();
            return userCallback == null || userCallback.test((Project)project);
        };
        if (predicate == null) {
            ProjectOpenHelper.$$$reportNull$$$0(10);
        }
        return predicate;
    }

    public void markFileToOpen(@NotNull VirtualFile virtualFile, @NotNull T data) {
        if (virtualFile == null) {
            ProjectOpenHelper.$$$reportNull$$$0(11);
        }
        if (data == null) {
            ProjectOpenHelper.$$$reportNull$$$0(12);
        }
        VirtualFile baseDir = virtualFile.getParent();
        baseDir.putUserData(this.myOpenDataKey, data);
    }

    @Nullable
    public T getAndClearFileToOpenData(@NotNull Project project) {
        if (project == null) {
            ProjectOpenHelper.$$$reportNull$$$0(13);
        }
        VirtualFile baseDir = project.getBaseDir();
        Object data = null;
        if (baseDir != null) {
            data = baseDir.getUserData(this.myOpenDataKey);
            baseDir.putUserData(this.myOpenDataKey, null);
        }
        if (data == null) {
            data = project.getUserData(this.myOpenDataKey);
        }
        project.putUserData(this.myOpenDataKey, null);
        return (T)data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openDataKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedFileChecker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/ProjectOpenHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/ProjectOpenHelper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeOpenCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSupportedSubFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValidProjectPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTaskToOpenExistingProjectInDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openExistingProjectInDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "linkToExistingProject";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "markFileToOpen";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAndClearFileToOpenData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }

    public static interface SupportedFileChecker {
        public boolean isSupportedFile(@NotNull VirtualFile var1);
    }
}

