/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.translateCode;

import com.intellij.cidr.translateCode.CidrTranslateCodeActionKt;
import com.intellij.cidr.translateCode.CidrTranslatedCodeBlock;
import com.intellij.cidr.translateCode.TranslatedCodeEditor;
import com.intellij.cidr.translateCode.TranslatedResultUiInfo;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/cidr/translateCode/TranslationDividerPainter;", "Lcom/intellij/diff/tools/util/DiffSplitter$Painter;", "leftEditor", "Lcom/intellij/openapi/editor/Editor;", "rightEditor", "translationInfo", "Lcom/intellij/cidr/translateCode/TranslatedResultUiInfo;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/cidr/translateCode/TranslatedResultUiInfo;)V", "getYRange", "Lkotlin/ranges/IntRange;", "editor", "scrollOffset", "", "lineRange", "paint", "", "g", "Ljava/awt/Graphics;", "divider", "Ljavax/swing/JComponent;", "paintHighlightedBlockCurves", "Ljava/awt/Graphics2D;", "width", "intellij.cidr.translateCode"})
final class TranslationDividerPainter
implements DiffSplitter.Painter {
    @NotNull
    private final Editor leftEditor;
    @NotNull
    private final Editor rightEditor;
    @NotNull
    private final TranslatedResultUiInfo translationInfo;

    public TranslationDividerPainter(@NotNull Editor leftEditor, @NotNull Editor rightEditor, @NotNull TranslatedResultUiInfo translationInfo) {
        Intrinsics.checkNotNullParameter((Object)leftEditor, (String)"leftEditor");
        Intrinsics.checkNotNullParameter((Object)rightEditor, (String)"rightEditor");
        Intrinsics.checkNotNullParameter((Object)translationInfo, (String)"translationInfo");
        this.leftEditor = leftEditor;
        this.rightEditor = rightEditor;
        this.translationInfo = translationInfo;
    }

    public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
        TranslatedCodeEditor.CmdHeader cmdHeader;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)divider, (String)"divider");
        Graphics2D graphics2D = DiffDividerDrawUtil.getDividerGraphics((Graphics)g, (Component)divider, (Component)this.leftEditor.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"getDividerGraphics(...)");
        Graphics2D gg = graphics2D;
        Color gutterColor = CidrTranslateCodeActionKt.getGutterColor(this.rightEditor);
        gg.setColor(gutterColor);
        gg.fill(gg.getClipBounds());
        this.paintHighlightedBlockCurves(gg, divider.getWidth());
        Editor editor = this.rightEditor;
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        JComponent jComponent = editorEx != null ? editorEx.getPermanentHeaderComponent() : null;
        TranslatedCodeEditor.CmdHeader cmdHeader2 = cmdHeader = jComponent instanceof TranslatedCodeEditor.CmdHeader ? (TranslatedCodeEditor.CmdHeader)((Object)jComponent) : null;
        if (cmdHeader != null) {
            Editor editor2 = this.rightEditor;
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            gg.setColor(((EditorEx)editor2).getPermanentHeaderComponent().getBackground());
            gg.fillRect(0, 0, divider.getWidth(), cmdHeader.getHeight());
        }
        gg.dispose();
    }

    private final void paintHighlightedBlockCurves(Graphics2D g, int width) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        int leftMaxLine = this.leftEditor.getDocument().getLineCount();
        int rightMaxLine = this.rightEditor.getDocument().getLineCount();
        int blockId = this.translationInfo.getHighlightedBlockId();
        CidrTranslatedCodeBlock block = this.translationInfo.blockById(blockId);
        Pair<Color, Color> pair = this.translationInfo.colorForCurrentBlock(blockId);
        Color bgColor = (Color)pair.component1();
        Color borderColor = (Color)pair.component2();
        if (block != null && bgColor != null) {
            int leftScrollOffset = CidrTranslateCodeActionKt.verticalScrollOffsetFromHeader(this.leftEditor);
            int rightScrollOffset = CidrTranslateCodeActionKt.verticalScrollOffsetFromHeader(this.rightEditor);
            IntRange leftRange = new IntRange(block.getSrcStartLine(), RangesKt.coerceAtMost((int)block.getSrcEndLine(), (int)leftMaxLine));
            for (IntRange transRange : block.getTranslatedRanges()) {
                IntRange rightRange = new IntRange(transRange.getFirst(), RangesKt.coerceAtMost((int)transRange.getLast(), (int)rightMaxLine));
                int leftLineCount = leftRange.getLast() - leftRange.getFirst();
                int rightLineCount = rightRange.getLast() - rightRange.getFirst();
                if (leftLineCount == 0 || rightLineCount == 0) continue;
                IntRange leftYRange = this.getYRange(this.leftEditor, leftScrollOffset, leftRange);
                IntRange rightYRange = this.getYRange(this.rightEditor, rightScrollOffset, rightRange);
                g.setColor(bgColor);
                g.fillRect(0, leftYRange.getFirst(), 10, leftYRange.getLast() - leftYRange.getFirst());
                if (!this.translationInfo.shouldDrawBlockConnection()) continue;
                DiffDrawUtil.drawCurveTrapezium((Graphics2D)g, (int)10, (int)width, (int)leftYRange.getFirst(), (int)leftYRange.getLast(), (int)rightYRange.getFirst(), (int)rightYRange.getLast(), (Color)bgColor, (Color)borderColor);
                if (borderColor == null) continue;
                g.setColor(borderColor);
                g.drawLine(0, leftYRange.getFirst(), 10, leftYRange.getFirst());
                g.drawLine(0, leftYRange.getLast(), 10, leftYRange.getLast());
            }
        }
        config.restore();
    }

    private final IntRange getYRange(Editor editor, int scrollOffset, IntRange lineRange) {
        Object object = ApplicationManager.getApplication().runReadAction(() -> TranslationDividerPainter.getYRange$lambda$0(editor, lineRange, scrollOffset));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (IntRange)object;
    }

    private static final IntRange getYRange$lambda$0(Editor $editor, IntRange $lineRange, int $scrollOffset) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$lineRange, (String)"$lineRange");
        int startY = $editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)$lineRange.getFirst(), (int)0)).y;
        int endY = $editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)$lineRange.getLast(), (int)0)).y;
        return new IntRange(startY - $scrollOffset, endY - $scrollOffset);
    }
}

