/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.psi;

import com.intellij.cidr.cpp.util.CidrStringCodec;
import com.intellij.cidr.cpp.util.CidrStringLiteral;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0016J\u001d\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH&J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/intellij/cidr/cpp/psi/CidrStringLiteralExpression;", "T", "Lcom/intellij/cidr/cpp/util/CidrStringLiteral;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "changeContentAtSegment", "segmentInDocument", "Lcom/intellij/openapi/util/Segment;", "newContent", "", "unreliable", "", "detectActualContent", "parsedLiteral", "(Lcom/intellij/cidr/cpp/util/CidrStringLiteral;Ljava/lang/String;)Ljava/lang/String;", "getStringCodec", "Lcom/intellij/cidr/cpp/util/CidrStringCodec;", "handleLiteralContentChange", "astNode", "Lcom/intellij/lang/ASTNode;", "intellij.cidr.psi.base"})
@SourceDebugExtension(value={"SMAP\nCidrStringLiteralExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrStringLiteralExpression.kt\ncom/intellij/cidr/cpp/psi/CidrStringLiteralExpression\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public interface CidrStringLiteralExpression<T extends CidrStringLiteral>
extends PsiLanguageInjectionHost {
    @NotNull
    public CidrStringCodec<T> getStringCodec();

    @NotNull
    default public CidrStringLiteralExpression<T> handleLiteralContentChange(@NotNull ASTNode astNode, @NotNull String newContent, boolean unreliable) {
        Object object;
        String string;
        String newContentToHandle;
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        T t = CidrStringLiteralUtil.parseStringLiteral(this.getStringCodec(), astNode.getText());
        Intrinsics.checkNotNullExpressionValue(t, (String)"parseStringLiteral(...)");
        T parsedLiteral = t;
        String string2 = newContentToHandle = unreliable ? this.detectActualContent(parsedLiteral, newContent) : newContent;
        if (((CidrStringLiteral)parsedLiteral).prefix.isRaw) {
            string = newContentToHandle;
        } else {
            String string3 = StringUtil.escapeStringCharacters((String)(unreliable ? StringUtil.unescapeStringCharacters((String)newContentToHandle) : newContentToHandle));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"escapeStringCharacters(...)");
        }
        String newTextFragmentEscaped = string;
        String string4 = ((CidrStringLiteral)parsedLiteral).contents;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"contents");
        String contents = string4;
        if (((CharSequence)contents).length() > 0) {
            String string5 = astNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
            object = StringsKt.replace$default((String)string5, (String)contents, (String)newTextFragmentEscaped, (boolean)false, (int)4, null);
        } else if (((CidrStringLiteral)parsedLiteral).prefix.isRaw) {
            String string6 = astNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
            object = StringsKt.replace$default((String)string6, (String)"()", (String)("(" + newTextFragmentEscaped + ")"), (boolean)false, (int)4, null);
        } else {
            object = ((CidrStringLiteral)parsedLiteral).prefix.prefix + "\"" + newTextFragmentEscaped + "\"";
        }
        String newText = object;
        PsiElement psiElement = astNode.getPsi();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.LeafElement");
        ((LeafElement)psiElement).replaceWithText(newText);
        return this;
    }

    @NotNull
    default public CidrStringLiteralExpression<T> changeContentAtSegment(@NotNull Segment segmentInDocument, @NotNull String newContent, boolean unreliable) {
        ASTNode aSTNode;
        ASTNode[] nodes;
        block3: {
            ASTNode aSTNode2;
            Intrinsics.checkNotNullParameter((Object)segmentInDocument, (String)"segmentInDocument");
            Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
            ASTNode[] aSTNodeArray = this.getNode().getChildren(this.getStringCodec().getAllLiterals());
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
            ASTNode[] aSTNodeArray2 = nodes = aSTNodeArray;
            int n = aSTNodeArray2.length;
            for (int i = 0; i < n; ++i) {
                ASTNode aSTNode3;
                ASTNode node = aSTNode3 = aSTNodeArray2[i];
                boolean bl = false;
                if (!node.getTextRange().contains(segmentInDocument)) continue;
                aSTNode2 = aSTNode3;
                break block3;
            }
            aSTNode2 = aSTNode = null;
        }
        if (aSTNode != null) {
            ASTNode astNode = aSTNode;
            boolean bl = false;
            return this.handleLiteralContentChange(astNode, newContent, unreliable);
        }
        int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)this.getNode().getText(), (CharSequence)newContent);
        int commonSuffixLength = StringUtil.commonSuffixLength((CharSequence)this.getNode().getText().subSequence(commonPrefixLength, this.getNode().getText().length()), (CharSequence)newContent.subSequence(commonPrefixLength, newContent.length()));
        TextRange textRange = TextRange.create((int)(segmentInDocument.getStartOffset() + commonPrefixLength), (int)(segmentInDocument.getEndOffset() - commonSuffixLength));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange changedSegmentInDocument = textRange;
        TextRange textRange2 = TextRange.create((int)commonPrefixLength, (int)(newContent.length() - commonSuffixLength));
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"create(...)");
        TextRange changedSegmentInNewContent = textRange2;
        for (ASTNode astNode : nodes) {
            String newNodeText;
            String newContentFragment;
            TextRange intersectionInNode;
            TextRange intersection;
            if (astNode.getTextRange().intersection(changedSegmentInDocument) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)intersection.shiftLeft(astNode.getTextRange().getStartOffset()), (String)"shiftLeft(...)");
            Intrinsics.checkNotNullExpressionValue((Object)changedSegmentInNewContent.substring(newContent), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)intersectionInNode.replace(astNode.getText(), newContentFragment), (String)"replace(...)");
            Intrinsics.checkNotNull((Object)astNode);
            this.handleLiteralContentChange(astNode, newNodeText, unreliable);
        }
        return this;
    }

    public static /* synthetic */ CidrStringLiteralExpression changeContentAtSegment$default(CidrStringLiteralExpression cidrStringLiteralExpression, Segment segment, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: changeContentAtSegment");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return cidrStringLiteralExpression.changeContentAtSegment(segment, string, bl);
    }

    @NotNull
    default public String detectActualContent(@NotNull T parsedLiteral, @NotNull String newContent) {
        String string;
        boolean equalPrefixes;
        Intrinsics.checkNotNullParameter(parsedLiteral, (String)"parsedLiteral");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        T t = CidrStringLiteralUtil.parseStringLiteral(this.getStringCodec(), newContent);
        Intrinsics.checkNotNullExpressionValue(t, (String)"parseStringLiteral(...)");
        T parsedLiteralNewContent = t;
        boolean bl = equalPrefixes = ((CidrStringLiteral)parsedLiteral).prefix == ((CidrStringLiteral)parsedLiteralNewContent).prefix && (((CidrStringLiteral)parsedLiteral).prefix.isRaw || StringUtil.isQuotedString((String)newContent));
        if (equalPrefixes) {
            String string2 = ((CidrStringLiteral)parsedLiteralNewContent).contents;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contents");
        } else {
            string = newContent;
        }
        return string;
    }
}

