/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.codeInsight.actions.FileTreeIterator;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.InstallNodeLocalDependenciesAction;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JsqtProcessOutputViewer;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfigurable;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierLanguageServiceImpl;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatWithPrettierAction
extends AnAction
implements DumbAware {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ReformatWithPrettierAction.class);
    private static final long EDT_TIMEOUT_MS = 2000L;
    private final ErrorHandler myErrorHandler;
    static final ErrorHandler NOOP_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void showError(@NotNull Project project, @Nullable Editor editor, @NotNull String text, @Nullable Runnable onLinkClick) {
            if (project == null) {
                1.$$$reportNull$$$0(0);
            }
            if (text == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/prettierjs/ReformatWithPrettierAction$1";
            objectArray[2] = "showError";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public ReformatWithPrettierAction(@NotNull ErrorHandler errorHandler) {
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(0);
        }
        this.myErrorHandler = errorHandler;
    }

    public ReformatWithPrettierAction() {
        this(ErrorHandler.DEFAULT);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        NodePackage nodePackage = PrettierConfiguration.getInstance(project).getPackage((PsiElement)psiFile);
        e.getPresentation().setEnabledAndVisible(!nodePackage.isEmptyPath() && ReformatWithPrettierAction.isAcceptableFileContext(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static boolean isAcceptableFileContext(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(3);
        }
        if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
            return true;
        }
        Object[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return !ArrayUtil.isEmpty((Object[])virtualFiles);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            ReformatWithPrettierAction.processFileInEditor(project, editor, this.myErrorHandler, null);
        } else {
            Object[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (!ArrayUtil.isEmpty((Object[])virtualFiles)) {
                ReformatWithPrettierAction.processVirtualFiles(project, Arrays.asList(virtualFiles), this.myErrorHandler);
            }
        }
    }

    static boolean checkNodeAndPackage(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull ErrorHandler errorHandler) {
        NodeJsInterpreter nodeJsInterpreter;
        if (psiFile == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(5);
        }
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(6);
        }
        Project project = psiFile.getProject();
        NodeJsInterpreterRef interpreterRef = NodeJsInterpreterRef.createProjectRef();
        NodePackage nodePackage = PrettierConfiguration.getInstance(project).getPackage((PsiElement)psiFile);
        try {
            nodeJsInterpreter = NodeInterpreterUtil.getValidInterpreterOrThrow((NodeJsInterpreter)interpreterRef.resolve(project));
        }
        catch (ExecutionException e1) {
            errorHandler.showError(project, editor, PrettierBundle.message("error.invalid.interpreter", new Object[0]), () -> NodeSettingsConfigurable.showSettingsDialog((Project)project));
            return false;
        }
        if (nodePackage.isEmptyPath()) {
            errorHandler.showError(project, editor, PrettierBundle.message("error.no.valid.package", new Object[0]), () -> ReformatWithPrettierAction.editSettings(project));
            return false;
        }
        if (!nodePackage.isValid(project, nodeJsInterpreter)) {
            String message = PrettierBundle.message("error.package.is.not.installed", NpmManager.getInstance((Project)project).getNpmInstallPresentableText());
            errorHandler.showError(project, editor, message, () -> ReformatWithPrettierAction.installPackage(project));
            return false;
        }
        SemVer nodePackageVersion = nodePackage.getVersion(project);
        if (nodePackageVersion != null && nodePackageVersion.compareTo(PrettierUtil.MIN_VERSION) < 0) {
            errorHandler.showError(project, editor, PrettierBundle.message("error.unsupported.version", PrettierUtil.MIN_VERSION.getRawVersion()), null);
            return false;
        }
        return true;
    }

    public static boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull ErrorHandler errorHandler) {
        PsiFile file;
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(8);
        }
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(9);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == null) {
            return false;
        }
        return ReformatWithPrettierAction.checkNodeAndPackage(file, editor, errorHandler);
    }

    public static void processFileInEditor(@NotNull Project project, @NotNull Editor editor, @NotNull ErrorHandler errorHandler, @Nullable TextRange targetRange) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(11);
        }
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(12);
        }
        if (!ReformatWithPrettierAction.isAvailable(project, editor, errorHandler)) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return;
        }
        if (!ReformatWithPrettierAction.checkNodeAndPackage(file, editor, errorHandler)) {
            return;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(vFile)).hasReadonlyFiles()) {
            return;
        }
        TextRange range = targetRange != null ? targetRange : (editor.getSelectionModel().hasSelection() ? new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd()) : null);
        ReformatWithPrettierAction.ensureConfigsSaved(Collections.singletonList(vFile), project);
        ThrowableComputable computable = () -> ReformatWithPrettierAction.performRequestForFile(file, range);
        PrettierLanguageService.FormatResult result = (PrettierLanguageService.FormatResult)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, PrettierBundle.message("progress.title", new Object[0]), true, project);
        if (result == null) {
            return;
        }
        if (!StringUtil.isEmpty((String)result.error)) {
            errorHandler.showErrorWithDetails(project, editor, PrettierBundle.message("error.while.reformatting.message", new Object[0]), result.error);
        } else if (result.unsupported) {
            errorHandler.showError(project, editor, PrettierBundle.message("not.supported.file", file.getName()), null);
        } else if (result.ignored) {
            ReformatWithPrettierAction.showHintLater(editor, PrettierBundle.message("file.was.ignored.hint", file.getName()), false, null);
        } else {
            Document document = editor.getDocument();
            CharSequence textBefore = document.getImmutableCharSequence();
            String newContent = result.result;
            LineSeparator newLineSeparator = StringUtil.detectSeparators((CharSequence)newContent);
            String newDocumentContent = StringUtil.convertLineSeparators((String)newContent);
            Ref lineSeparatorUpdated = new Ref((Object)Boolean.FALSE);
            EditorScrollingPositionKeeper.perform((Editor)editor, (boolean)true, () -> ReformatWithPrettierAction.runWriteCommandAction(project, () -> {
                if (!StringUtil.equals((CharSequence)textBefore, (CharSequence)newContent)) {
                    document.setText((CharSequence)newDocumentContent);
                }
                lineSeparatorUpdated.set((Object)ReformatWithPrettierAction.setDetectedLineSeparator(project, vFile, newLineSeparator));
            }));
            ReformatWithPrettierAction.showHintLater(editor, ReformatWithPrettierAction.buildNotificationMessage(document, textBefore, (Boolean)lineSeparatorUpdated.get()), false, null);
        }
    }

    static TextRange processFileAsPostFormatProcessor(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(13);
        }
        if (range == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(14);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isWriteAccessAllowed());
        Project project = file.getProject();
        if (!ReformatWithPrettierAction.checkNodeAndPackage(file, null, NOOP_ERROR_HANDLER)) {
            return range;
        }
        VirtualFile vFile = file.getVirtualFile();
        ReformatWithPrettierAction.ensureConfigsSaved(Collections.singletonList(vFile), project);
        PrettierLanguageService.FormatResult result = ReformatWithPrettierAction.performRequestForFile(file, range);
        if (result != null) {
            int delta = ReformatWithPrettierAction.applyFormatResult(project, vFile, result);
            if (delta < 0 && range.getLength() < Math.abs(delta)) {
                return TextRange.from((int)range.getStartOffset(), (int)0);
            }
            return range.grown(delta);
        }
        return range;
    }

    static void ensureConfigsSaved(@NotNull List<VirtualFile> virtualFiles, @NotNull Project project) {
        if (virtualFiles == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(15);
        }
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(16);
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        for (VirtualFile config : PrettierUtil.lookupPossibleConfigFiles(virtualFiles, project)) {
            Document document = documentManager.getCachedDocument(config);
            if (document == null || !documentManager.isDocumentUnsaved(document)) continue;
            documentManager.saveDocument(document);
        }
    }

    public static void processVirtualFiles(@NotNull Project project, @NotNull List<VirtualFile> virtualFiles, @NotNull ErrorHandler errorHandler) {
        ReadonlyStatusHandler.OperationStatus readonlyStatus;
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(17);
        }
        if (virtualFiles == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(18);
        }
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(19);
        }
        if ((readonlyStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(virtualFiles)).hasReadonlyFiles()) {
            return;
        }
        ReformatWithPrettierAction.ensureConfigsSaved(virtualFiles, project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (virtualFiles.size() == 1 && virtualFiles.get(0).isDirectory()) {
            PsiDirectory psiDirectory = psiManager.findDirectory(virtualFiles.get(0));
            if (psiDirectory == null) {
                return;
            }
            ReformatWithPrettierAction.processFileIterator(project, new FileTreeIterator(psiDirectory), false, errorHandler);
        } else {
            ReformatWithPrettierAction.processFileIterator(project, new FileTreeIterator(PsiUtilCore.toPsiFiles((PsiManager)psiManager, virtualFiles)), true, errorHandler);
        }
    }

    private static void processFileIterator(@NotNull Project project, @NotNull FileTreeIterator fileIterator, boolean reportSkippedFiles, @NotNull ErrorHandler errorHandler) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(20);
        }
        if (fileIterator == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(21);
        }
        if (errorHandler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(22);
        }
        Map results = (Map)ReformatWithPrettierAction.executeUnderProgress(project, indicator -> {
            HashMap<PsiFile, PrettierLanguageService.FormatResult> reformattedResults = new HashMap<PsiFile, PrettierLanguageService.FormatResult>();
            SmartList files = new SmartList();
            ReadAction.run(() -> ReformatWithPrettierAction.lambda$processFileIterator$6(fileIterator, (List)files));
            for (PsiFile currentFile : files) {
                PrettierLanguageService.FormatResult errorResult;
                indicator.setText(PrettierBundle.message("processing.0.progress", currentFile.getName()));
                if (!ReformatWithPrettierAction.checkNodeAndPackage(currentFile, null, errorHandler)) {
                    return Collections.emptyMap();
                }
                PrettierLanguageService.FormatResult result = ReformatWithPrettierAction.performRequestForFile(currentFile, null);
                if (result == null) continue;
                if (result.unsupported && reportSkippedFiles) {
                    errorResult = PrettierLanguageService.FormatResult.error(PrettierBundle.message("not.supported.file", currentFile.getName()));
                    reformattedResults.put(currentFile, errorResult);
                }
                if (result.ignored) {
                    errorResult = PrettierLanguageService.FormatResult.error(PrettierBundle.message("file.was.ignored", currentFile.getName()));
                    reformattedResults.put(currentFile, errorResult);
                    continue;
                }
                reformattedResults.put(currentFile, result);
            }
            return reformattedResults;
        });
        ReformatWithPrettierAction.runWriteCommandAction(project, () -> {
            for (Map.Entry entry : results.entrySet()) {
                VirtualFile virtualFile = ((PsiFile)entry.getKey()).getVirtualFile();
                if (virtualFile == null) continue;
                PrettierLanguageService.FormatResult result = (PrettierLanguageService.FormatResult)entry.getValue();
                ReformatWithPrettierAction.applyFormatResult(project, virtualFile, result);
            }
        });
        List errors = ContainerUtil.mapNotNull(results.entrySet(), t -> ((PrettierLanguageService.FormatResult)t.getValue()).error);
        if (!errors.isEmpty()) {
            errorHandler.showErrorWithDetails(project, null, PrettierBundle.message("failed.to.reformat.0.files", errors.size()), StringUtil.join((Collection)errors, (String)"\n"));
        }
    }

    static int applyFormatResult(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull PrettierLanguageService.FormatResult result) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(23);
        }
        if (virtualFile == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(24);
        }
        if (result == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(25);
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        int delta = 0;
        if (document != null && StringUtil.isEmpty((String)result.error) && !result.ignored && !result.unsupported) {
            CharSequence textBefore = document.getCharsSequence();
            LineSeparator newlineSeparator = StringUtil.detectSeparators((CharSequence)result.result);
            String newContent = StringUtil.convertLineSeparators((String)result.result);
            if (!StringUtil.equals((CharSequence)textBefore, (CharSequence)newContent)) {
                int lengthBefore = textBefore.length();
                document.setText((CharSequence)newContent);
                delta = newContent.length() - lengthBefore;
            }
            ReformatWithPrettierAction.setDetectedLineSeparator(project, virtualFile, newlineSeparator);
        }
        return delta;
    }

    @Nullable
    static PrettierLanguageService.FormatResult performRequestForFile(@NotNull PsiFile currentFile, @Nullable TextRange range) {
        boolean edt;
        if (currentFile == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(26);
        }
        if (!(edt = ApplicationManager.getApplication().isDispatchThread()) && ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("JSLanguageServiceUtil.awaitFuture() under read action may cause deadlock");
        }
        Project project = currentFile.getProject();
        Ref text = Ref.create();
        Ref filePath = Ref.create();
        Ref ignoreFilePath = Ref.create();
        Ref rangeForRequest = Ref.create((Object)range);
        ReadAction.run(() -> {
            if (!currentFile.isValid()) {
                return;
            }
            VirtualFile currentVFile = currentFile.getVirtualFile();
            filePath.set((Object)LocalFilePath.asLocalFilePath((Path)currentVFile.toNioPath()));
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(currentFile);
            if (document == null) {
                return;
            }
            CharSequence content = document.getImmutableCharSequence();
            if (range != null && range.getStartOffset() == 0 && range.getLength() == content.length()) {
                rangeForRequest.set(null);
            }
            text.set((Object)JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal((Project)project, (CharSequence)content, (VirtualFile)currentVFile).toString());
            VirtualFile ignoreVFile = PrettierUtil.findIgnoreFile(currentVFile, project);
            if (ignoreVFile != null) {
                ignoreFilePath.set((Object)ignoreVFile.getPath());
            }
        });
        if (text.isNull()) {
            return PrettierLanguageService.FormatResult.UNSUPPORTED;
        }
        NodePackage nodePackage = PrettierConfiguration.getInstance(project).getPackage((PsiElement)currentFile);
        PrettierLanguageServiceImpl service = PrettierLanguageService.getInstance(project, currentFile.getVirtualFile(), nodePackage);
        CompletableFuture<PrettierLanguageService.FormatResult> formatFuture = service.format((String)filePath.get(), (String)ignoreFilePath.get(), (String)text.get(), nodePackage, (TextRange)rangeForRequest.get());
        long timeout = edt ? 2000L : JSLanguageServiceUtil.getTimeout();
        return (PrettierLanguageService.FormatResult)JSLanguageServiceUtil.awaitFuture(formatFuture, (long)timeout, (long)5L, null, (boolean)true, null, (boolean)edt);
    }

    private static <T> T executeUnderProgress(@NotNull Project project, @NotNull NullableFunction<ProgressIndicator, T> handler) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(27);
        }
        if (handler == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(28);
        }
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> handler.fun((Object)ProgressManager.getInstance().getProgressIndicator()), PrettierBundle.message("progress.title", new Object[0]), true, project);
    }

    private static void runWriteCommandAction(@NotNull Project project, @NotNull Runnable runnable) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(29);
        }
        if (runnable == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(30);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PrettierBundle.message("reformat.with.prettier.command.name", new Object[0]), null, (Runnable)runnable, (PsiFile[])new PsiFile[0]);
    }

    @NotNull
    @Nls
    private static String buildNotificationMessage(@NotNull Document document, @NotNull CharSequence textBefore, boolean lineSeparatorsUpdated) {
        int number;
        if (document == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(31);
        }
        if (textBefore == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(32);
        }
        if ((number = VcsFacade.getInstance().calculateChangedLinesNumber(document, textBefore)) == 0) {
            String string = lineSeparatorsUpdated ? PrettierBundle.message("line.endings.were.updated", new Object[0]) : PrettierBundle.message("no.lines.changed", new Object[0]);
            if (string == null) {
                ReformatWithPrettierAction.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = PrettierBundle.message("formatted.0.lines", number);
        if (string == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static void showHintLater(@NotNull Editor editor, @NotNull @Nls String text, boolean isError, @Nullable HyperlinkListener hyperlinkListener) {
        if (editor == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(35);
        }
        if (text == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            JComponent component = isError ? HintUtil.createErrorLabel((String)text, (HyperlinkListener)hyperlinkListener, null) : HintUtil.createInformationLabel((String)text, (HyperlinkListener)hyperlinkListener, null, null);
            LightweightHint hint = new LightweightHint(component);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
        }, ModalityState.nonModal(), o -> editor.isDisposed() || !editor.getComponent().isShowing());
    }

    private static void installPackage(@NotNull Project project) {
        VirtualFile packageJson;
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(37);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)project.getBaseDir())) != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole((Project)project, (VirtualFile)packageJson);
        }
    }

    private static void showErrorDetails(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(38);
        }
        if (text == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(39);
        }
        ProcessOutput output = new ProcessOutput();
        output.appendStderr(text);
        JsqtProcessOutputViewer.show((Project)project, (String)PrettierBundle.message("prettier.formatter.notification.title", new Object[0]), (Icon)PrettierUtil.ICON, null, null, (ProcessOutput)output);
    }

    private static void editSettings(@NotNull Project project) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(40);
        }
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PrettierConfigurable(project));
    }

    private static boolean setDetectedLineSeparator(@NotNull Project project, @NotNull VirtualFile vFile, @Nullable LineSeparator newSeparator) {
        if (project == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(41);
        }
        if (vFile == null) {
            ReformatWithPrettierAction.$$$reportNull$$$0(42);
        }
        if (newSeparator != null) {
            String newSeparatorString = newSeparator.getSeparatorString();
            if (!StringUtil.equals((CharSequence)vFile.getDetectedLineSeparator(), (CharSequence)newSeparatorString)) {
                AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project, (VirtualFile)vFile, (String)newSeparatorString);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void lambda$processFileIterator$6(FileTreeIterator fileIterator, List files) throws RuntimeException {
        while (fileIterator.hasNext()) {
            files.add(fileIterator.next());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/ReformatWithPrettierAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 27: 
            case 29: 
            case 37: 
            case 38: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIterator";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textBefore";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/ReformatWithPrettierAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNotificationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 33: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableFileContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkNodeAndPackage";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processFileInEditor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processFileAsPostFormatProcessor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "ensureConfigsSaved";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFiles";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processFileIterator";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applyFormatResult";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "performRequestForFile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "executeUnderProgress";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runWriteCommandAction";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "buildNotificationMessage";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showHintLater";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "installPackage";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDetails";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "editSettings";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setDetectedLineSeparator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 33, 34 -> new IllegalStateException(string);
        };
    }

    public static interface ErrorHandler {
        public static final ErrorHandler DEFAULT = new DefaultErrorHandler();

        public void showError(@NotNull Project var1, @Nullable Editor var2, @NotNull @Nls String var3, @Nullable Runnable var4);

        default public void showErrorWithDetails(@NotNull Project project, @Nullable Editor editor, @NotNull @Nls String text, @NotNull String details) {
            if (project == null) {
                ErrorHandler.$$$reportNull$$$0(0);
            }
            if (text == null) {
                ErrorHandler.$$$reportNull$$$0(1);
            }
            if (details == null) {
                ErrorHandler.$$$reportNull$$$0(2);
            }
            this.showError(project, editor, text, () -> ReformatWithPrettierAction.showErrorDetails(project, details));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "details";
                    break;
                }
            }
            objectArray[1] = "com/intellij/prettierjs/ReformatWithPrettierAction$ErrorHandler";
            objectArray[2] = "showErrorWithDetails";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void showError(@NotNull Project project, @Nullable Editor editor, @NotNull @Nls String text, final @Nullable Runnable onLinkClick) {
            if (project == null) {
                DefaultErrorHandler.$$$reportNull$$$0(0);
            }
            if (text == null) {
                DefaultErrorHandler.$$$reportNull$$$0(1);
            }
            if (editor != null) {
                HyperlinkAdapter listener = onLinkClick == null ? null : new HyperlinkAdapter(){

                    protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        onLinkClick.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/prettierjs/ReformatWithPrettierAction$DefaultErrorHandler$1", "hyperlinkActivated"));
                    }
                };
                ReformatWithPrettierAction.showHintLater(editor, PrettierBundle.message("prettier.formatter.hint.0", text), true, (HyperlinkListener)listener);
            } else {
                Notification notification = JSLinterGuesser.NOTIFICATION_GROUP.createNotification(PrettierBundle.message("prettier.formatter.notification.title", new Object[0]), text, NotificationType.ERROR);
                if (onLinkClick != null) {
                    notification.setListener((NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(@NotNull Notification notification1, @NotNull HyperlinkEvent e) {
                            if (notification1 == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (e == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            onLinkClick.run();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "e";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/prettierjs/ReformatWithPrettierAction$DefaultErrorHandler$2";
                            objectArray[2] = "hyperlinkActivated";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
                notification.notify(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/prettierjs/ReformatWithPrettierAction$DefaultErrorHandler";
            objectArray[2] = "showError";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

