/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigLangSubstitutor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public final class PrettierUtil {
    public static final Icon ICON = null;
    public static final String PACKAGE_NAME = "prettier";
    public static final String CONFIG_SECTION_NAME = "prettier";
    public static final String RC_FILE_NAME = ".prettierrc";
    public static final String CONFIG_FILE_NAME = "prettier.config";
    private static final String IGNORE_FILE_NAME = ".prettierignore";
    private static final List<String> CONFIG_FILE_NAMES = List.of(".prettierrc", ".prettierrc.json", ".prettierrc.yml", ".prettierrc.yaml", ".prettierrc.json5", ".prettierrc.js", "prettier.config.js", ".prettierrc.mjs", "prettier.config.mjs", ".prettierrc.cjs", "prettier.config.cjs", ".prettierrc.toml");
    private static final List<String> CONFIG_FILE_NAMES_WITH_PACKAGE_JSON = ContainerUtil.append(CONFIG_FILE_NAMES, (Object[])new String[]{"package.json"});
    public static final SemVer MIN_VERSION = new SemVer("1.13.0", 1, 13, 0);
    private static final Logger LOG = Logger.getInstance(PrettierUtil.class);

    private PrettierUtil() {
    }

    public static boolean isConfigFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            PrettierUtil.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = file = element instanceof PsiFile ? (PsiFile)element : null;
        if (file == null || file.isDirectory() || !file.isValid()) {
            return false;
        }
        return PrettierUtil.isConfigFile(file.getVirtualFile());
    }

    public static boolean isConfigFileOrPackageJson(@Nullable VirtualFile virtualFile) {
        return PackageJsonUtil.isPackageJsonFile((VirtualFile)virtualFile) || PrettierUtil.isConfigFile(virtualFile);
    }

    @Contract(value="null -> false")
    public static boolean isJSConfigFile(@Nullable VirtualFile virtualFile) {
        return PrettierUtil.isConfigFile(virtualFile) && ArrayUtil.contains((String)StringUtil.toLowerCase((String)virtualFile.getExtension()), (String[])new String[]{"js", "mjs", "cjs"});
    }

    @Contract(value="null -> false")
    public static boolean isNonJSConfigFile(@Nullable VirtualFile virtualFile) {
        return PrettierUtil.isConfigFile(virtualFile) && !ArrayUtil.contains((String)StringUtil.toLowerCase((String)virtualFile.getExtension()), (String[])new String[]{"js", "mjs", "cjs"});
    }

    @Contract(value="null -> false")
    public static boolean isConfigFile(@Nullable VirtualFile virtualFile) {
        return virtualFile != null && CONFIG_FILE_NAMES.contains(virtualFile.getName());
    }

    @Nullable
    public static VirtualFile findIgnoreFile(@NotNull VirtualFile source, @NotNull Project project) {
        VirtualFile packageJson;
        if (source == null) {
            PrettierUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(2);
        }
        VirtualFile rootDir = (packageJson = PackageJsonUtil.findUpPackageJson((VirtualFile)source)) != null ? packageJson.getParent() : project.getBaseDir();
        return rootDir == null ? null : rootDir.findChild(IGNORE_FILE_NAME);
    }

    @NotNull
    public static Collection<VirtualFile> lookupPossibleConfigFiles(@NotNull List<VirtualFile> from, @NotNull Project project) {
        if (from == null) {
            PrettierUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(4);
        }
        HashSet<VirtualFile> results = new HashSet<VirtualFile>();
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            HashSet<VirtualFile> hashSet = results;
            if (hashSet == null) {
                PrettierUtil.$$$reportNull$$$0(5);
            }
            return hashSet;
        }
        for (VirtualFile file : from) {
            PrettierUtil.addPossibleConfigsForFile(file, results, baseDir);
        }
        HashSet<VirtualFile> hashSet = results;
        if (hashSet == null) {
            PrettierUtil.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static void addPossibleConfigsForFile(@NotNull VirtualFile from, @NotNull Set<VirtualFile> result, @NotNull VirtualFile baseDir) {
        if (from == null) {
            PrettierUtil.$$$reportNull$$$0(7);
        }
        if (result == null) {
            PrettierUtil.$$$reportNull$$$0(8);
        }
        if (baseDir == null) {
            PrettierUtil.$$$reportNull$$$0(9);
        }
        for (VirtualFile current = from.getParent(); current != null && current.isValid() && current.isDirectory(); current = current.getParent()) {
            for (String name : CONFIG_FILE_NAMES_WITH_PACKAGE_JSON) {
                VirtualFile file = current.findChild(name);
                if (file == null || !file.isValid() || file.isDirectory()) continue;
                result.add(file);
            }
            if (!current.equals(baseDir)) continue;
            return;
        }
    }

    @Nullable
    public static VirtualFile findSingleConfigInContentRoots(@NotNull Project project) {
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(10);
        }
        return JSLinterConfigFileUtil.findDistinctConfigInContentRoots((Project)project, CONFIG_FILE_NAMES_WITH_PACKAGE_JSON, file -> {
            if (PackageJsonUtil.isPackageJsonFile((VirtualFile)file)) {
                PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)file);
                return data.getTopLevelProperties().contains("prettier");
            }
            return true;
        });
    }

    @Nullable
    public static VirtualFile findSingleConfigInDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            PrettierUtil.$$$reportNull$$$0(11);
        }
        if (!dir.isDirectory()) {
            return null;
        }
        List configs = ContainerUtil.mapNotNull(CONFIG_FILE_NAMES, name -> dir.findChild(name));
        return configs.size() == 1 ? (VirtualFile)configs.get(0) : null;
    }

    @Nullable
    public static PrettierConfig parseConfig(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(12);
        }
        if (virtualFile == null) {
            PrettierUtil.$$$reportNull$$$0(13);
        }
        return (PrettierConfig)ReadAction.compute(() -> {
            if (!PrettierUtil.isConfigFileOrPackageJson(virtualFile)) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            return (PrettierConfig)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> CachedValueProvider.Result.create((Object)PrettierUtil.parseConfigInternal(psiFile), (Object[])new Object[]{psiFile}));
        });
    }

    @Nullable
    private static PrettierConfig parseConfigInternal(@NotNull PsiFile file) {
        if (file == null) {
            PrettierUtil.$$$reportNull$$$0(14);
        }
        try {
            if (PackageJsonUtil.isPackageJsonFile((PsiFile)file)) {
                PackageJsonData packageJsonData = PackageJsonData.getOrCreate((VirtualFile)file.getVirtualFile());
                if (!packageJsonData.isDependencyOfAnyType("prettier")) {
                    return null;
                }
                Object prettierProperty = ((Map)ObjectUtils.coalesce((Object)((Map)Holder.OUR_GSON_SERIALIZER.fromJson(file.getText(), Map.class)), Collections.emptyMap())).get("prettier");
                return prettierProperty instanceof Map ? PrettierConfig.createFromMap((Map)prettierProperty) : null;
            }
            if (file instanceof JsonFile) {
                return PrettierUtil.parseConfigFromJsonText(file.getText());
            }
            if (JSLinterConfigLangSubstitutor.YamlLanguageHolder.INSTANCE.equals(file.getLanguage())) {
                return PrettierConfig.createFromMap((Map)new Yaml().load(file.getText()));
            }
        }
        catch (Exception e) {
            LOG.info(String.format("Could not read config data from file [%s]", file.getVirtualFile().getPath()), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static PrettierConfig parseConfigFromJsonText(String text) {
        try (JsonReader reader = new JsonReader((Reader)new StringReader(text));){
            if (reader.peek() == JsonToken.STRING) {
                PrettierConfig prettierConfig = null;
                return prettierConfig;
            }
            PrettierConfig prettierConfig = PrettierConfig.createFromMap((Map)Holder.OUR_GSON_SERIALIZER.fromJson(reader, Map.class));
            return prettierConfig;
        }
        catch (IOException e) {
            LOG.info("Could not parse config from text", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/PrettierUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/PrettierUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupPossibleConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConfigFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lookupPossibleConfigFiles";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleConfigsForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSingleConfigInContentRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findSingleConfigInDirectory";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseConfig";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigInternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        static final Gson OUR_GSON_SERIALIZER = new GsonBuilder().create();

        private Holder() {
        }
    }
}

