/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierConfigurationCollector;
import com.intellij.prettierjs.PrettierDetectionInfo;
import com.intellij.prettierjs.PrettierUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/prettierjs/PrettierProjectConfigurator;", "Lcom/intellij/platform/DirectoryProjectConfigurator$AsyncDirectoryProjectConfigurator;", "()V", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/module/Module;", "isProjectCreatedWithWizard", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/util/Ref;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPrettierConfigLocation", "Lcom/intellij/prettierjs/PrettierConfigurationCollector$ConfigLocation;", "detectionInfo", "Lcom/intellij/prettierjs/PrettierDetectionInfo;", "getPrettierDetectionInfo", "dir", "getRootPackageJsonData", "Lcom/intellij/javascript/nodejs/PackageJsonData;", "shouldAutoconfigurePrettierForRootDirectory", "intellij.prettierJS"})
public final class PrettierProjectConfigurator
extends DirectoryProjectConfigurator.AsyncDirectoryProjectConfigurator {
    @Nullable
    public Object configure(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.readAndWriteAction((Function1)((Function1)new Function1<ReadAndWriteScope, ReadResult<? extends Unit>>(project, this, baseDir){
            final /* synthetic */ Project $project;
            final /* synthetic */ PrettierProjectConfigurator this$0;
            final /* synthetic */ VirtualFile $baseDir;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$baseDir = $baseDir;
                super(1);
            }

            @NotNull
            public final ReadResult<Unit> invoke(@NotNull ReadAndWriteScope $this$readAndWriteAction) {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                PrettierConfiguration prettierConfiguration = PrettierConfiguration.getInstance(this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)prettierConfiguration, (String)"getInstance(...)");
                PrettierConfiguration config = prettierConfiguration;
                if (config.isDefaultConfigurationMode()) {
                    PrettierDetectionInfo detectionInfo = PrettierProjectConfigurator.access$getPrettierDetectionInfo(this.this$0, this.$baseDir);
                    if (detectionInfo.getHasDependencyOnPrettier() && !detectionInfo.getHasPrettierConfig()) {
                        PrettierConfigurationCollector.logAutoEnableInNewProject$default(PrettierConfigurationCollector.INSTANCE, PrettierConfigurationCollector.EnabledStatus.UNCHANGED, PrettierConfigurationCollector.PackageDeclarationLocation.IN_PROJECT_ROOT_PACKAGE, null, 4, null);
                    } else if (PrettierProjectConfigurator.access$shouldAutoconfigurePrettierForRootDirectory(this.this$0, detectionInfo)) {
                        return $this$readAndWriteAction.writeAction((Function0)new Function0<Unit>(config, this.this$0, detectionInfo){
                            final /* synthetic */ PrettierConfiguration $config;
                            final /* synthetic */ PrettierProjectConfigurator this$0;
                            final /* synthetic */ PrettierDetectionInfo $detectionInfo;
                            {
                                this.$config = $config;
                                this.this$0 = $receiver;
                                this.$detectionInfo = $detectionInfo;
                                super(0);
                            }

                            public final void invoke() {
                                this.$config.getState().configurationMode = PrettierConfiguration.ConfigurationMode.AUTOMATIC;
                                PrettierConfigurationCollector.INSTANCE.logAutoEnableInNewProject(PrettierConfigurationCollector.EnabledStatus.AUTOMATIC, PrettierConfigurationCollector.PackageDeclarationLocation.IN_PROJECT_ROOT_PACKAGE, PrettierProjectConfigurator.access$getPrettierConfigLocation(this.this$0, this.$detectionInfo));
                            }
                        });
                    }
                }
                return $this$readAndWriteAction.value((Object)Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final PackageJsonData getRootPackageJsonData(VirtualFile dir) {
        if (!dir.isDirectory()) {
            return null;
        }
        VirtualFile virtualFile = dir.findChild("package.json");
        if (virtualFile == null) {
            return null;
        }
        VirtualFile packageJson = virtualFile;
        return PackageJsonData.getOrCreate((VirtualFile)packageJson);
    }

    private final PrettierDetectionInfo getPrettierDetectionInfo(VirtualFile dir) {
        PackageJsonData packageJsonData = this.getRootPackageJsonData(dir);
        if (packageJsonData == null) {
            return new PrettierDetectionInfo(false, false, false, false, 15, null);
        }
        PackageJsonData packageJsonData2 = packageJsonData;
        String[] stringArray = new String[]{"prettier"};
        if (!packageJsonData2.containsOneOfDependencyOfAnyType(stringArray)) {
            return new PrettierDetectionInfo(true, false, false, false, 14, null);
        }
        return new PrettierDetectionInfo(true, true, packageJsonData2.getTopLevelProperties().contains("prettier"), PrettierUtil.findSingleConfigInDirectory(dir) != null);
    }

    private final boolean shouldAutoconfigurePrettierForRootDirectory(PrettierDetectionInfo detectionInfo) {
        return detectionInfo.getHasPackageJsonInProjectRoot() && detectionInfo.getHasDependencyOnPrettier() && detectionInfo.getHasPrettierConfig();
    }

    private final PrettierConfigurationCollector.ConfigLocation getPrettierConfigLocation(PrettierDetectionInfo detectionInfo) {
        if (detectionInfo.getHasPrettierConfigInPackageJson()) {
            return PrettierConfigurationCollector.ConfigLocation.PACKAGE_JSON;
        }
        if (detectionInfo.getHasPrettierConfigFile()) {
            return PrettierConfigurationCollector.ConfigLocation.CONFIG_FILE;
        }
        return PrettierConfigurationCollector.ConfigLocation.NONE;
    }

    public static final /* synthetic */ PrettierDetectionInfo access$getPrettierDetectionInfo(PrettierProjectConfigurator $this, VirtualFile dir) {
        return $this.getPrettierDetectionInfo(dir);
    }

    public static final /* synthetic */ boolean access$shouldAutoconfigurePrettierForRootDirectory(PrettierProjectConfigurator $this, PrettierDetectionInfo detectionInfo) {
        return $this.shouldAutoconfigurePrettierForRootDirectory(detectionInfo);
    }

    public static final /* synthetic */ PrettierConfigurationCollector.ConfigLocation access$getPrettierConfigLocation(PrettierProjectConfigurator $this, PrettierDetectionInfo detectionInfo) {
        return $this.getPrettierConfigLocation(detectionInfo);
    }
}

