/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.elevation;

import com.intellij.application.Topics;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.elevation.ElevationBundle;
import com.intellij.execution.process.elevation.ElevationDaemonProcessLauncher;
import com.intellij.execution.process.elevation.ElevationLogger;
import com.intellij.execution.process.elevation.settings.ElevationSettings;
import com.intellij.execution.process.mediator.client.MediatedProcess;
import com.intellij.execution.process.mediator.client.MediatedProcessHandler;
import com.intellij.execution.process.mediator.client.ProcessMediatorClient;
import com.intellij.execution.process.mediator.client.launcher.ProcessMediatorConnection;
import com.intellij.execution.process.mediator.client.launcher.ProcessMediatorConnectionManager;
import com.intellij.execution.process.mediator.common.QuotaExceededException;
import com.intellij.execution.process.mediator.common.QuotaOptions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J'\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00140\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/process/elevation/ElevationServiceImpl;", "Lcom/intellij/execution/process/ElevationService;", "Lcom/intellij/openapi/Disposable;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "connectionManager", "Lcom/intellij/execution/process/mediator/client/launcher/ProcessMediatorConnectionManager;", "authorizeService", "", "createProcess", "Lcom/intellij/execution/process/mediator/client/MediatedProcess;", "processBuilder", "Ljava/lang/ProcessBuilder;", "createProcessHandler", "Lcom/intellij/execution/process/mediator/client/MediatedProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "dispose", "tryRelaunchingDaemonUntilHaveQuotaPermit", "R", "block", "Lkotlin/Function1;", "Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "intellij.execution.process.elevation"})
public final class ElevationServiceImpl
implements ElevationService,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ProcessMediatorConnectionManager connectionManager;
    private static final int MAX_RELAUNCHING_DAEMON_UNTIL_HAVE_QUOTA_PERMIT_ATTEMPTS = 3;

    /*
     * WARNING - void declaration
     */
    public ElevationServiceImpl(@NotNull CoroutineScope cs) {
        void it;
        ProcessMediatorConnectionManager $this$connectionManager_u24lambda_u240;
        ProcessMediatorConnectionManager processMediatorConnectionManager;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        ProcessMediatorConnectionManager processMediatorConnectionManager2 = processMediatorConnectionManager = new ProcessMediatorConnectionManager((Function0)new Function0<ProcessMediatorConnection>(this){
            final /* synthetic */ ElevationServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProcessMediatorConnection invoke() {
                ProcessMediatorClient.Builder clientBuilder = new ProcessMediatorClient.Builder(ElevationServiceImpl.access$getCs$p(this.this$0), ElevationSettings.Companion.getInstance().getQuotaOptions());
                boolean debug = false;
                ElevationDaemonProcessLauncher elevationDaemonProcessLauncher = new ElevationDaemonProcessLauncher(clientBuilder);
                String string = ElevationBundle.message("progress.title.starting.elevation.daemon", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return (ProcessMediatorConnection)elevationDaemonProcessLauncher.launchWithProgress(string);
            }
        });
        ElevationServiceImpl elevationServiceImpl = this;
        boolean bl = false;
        Topics.subscribe(ElevationSettings.Listener.TOPIC, (Disposable)((Disposable)$this$connectionManager_u24lambda_u240), (Object)new ElevationSettings.Listener($this$connectionManager_u24lambda_u240){
            final /* synthetic */ ProcessMediatorConnectionManager $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public void onDaemonQuotaOptionsChanged(@NotNull QuotaOptions oldValue, @NotNull QuotaOptions newValue) {
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                this.$this_apply.adjustQuota(newValue);
            }
        });
        $this$connectionManager_u24lambda_u240 = processMediatorConnectionManager;
        boolean bl2 = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        elevationServiceImpl.connectionManager = processMediatorConnectionManager;
    }

    public void authorizeService() {
        this.connectionManager.launchDaemonAndConnectIfNeeded();
    }

    @NotNull
    public MediatedProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessBuilder processBuilder = commandLine.toProcessBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"toProcessBuilder(...)");
        ProcessBuilder processBuilder2 = processBuilder;
        MediatedProcess process = this.createProcess(processBuilder2);
        return new MediatedProcessHandler(process, commandLine);
    }

    @NotNull
    public MediatedProcess createProcess(@NotNull ProcessBuilder processBuilder) {
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        if (!ElevationSettings.Companion.getInstance().askEnableKeepAuthIfNeeded()) {
            throw new ProcessCanceledException();
        }
        return (MediatedProcess)this.tryRelaunchingDaemonUntilHaveQuotaPermit((Function1)new Function1<ProcessMediatorClient, MediatedProcess>(processBuilder){
            final /* synthetic */ ProcessBuilder $processBuilder;
            {
                this.$processBuilder = $processBuilder;
                super(1);
            }

            @NotNull
            public final MediatedProcess invoke(@NotNull ProcessMediatorClient client) {
                MediatedProcess mediatedProcess;
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                MediatedProcess $this$invoke_u24lambda_u240 = mediatedProcess = MediatedProcess.Companion.create(client, this.$processBuilder);
                boolean bl = false;
                ElevationLogger.INSTANCE.getLOG().info("Created process PID " + $this$invoke_u24lambda_u240.pid());
                return mediatedProcess;
            }
        });
    }

    private final <R> R tryRelaunchingDaemonUntilHaveQuotaPermit(Function1<? super ProcessMediatorClient, ? extends R> block) {
        int maxAttempts = 3;
        int attempt = 1;
        while (true) {
            ProcessMediatorConnection connection = this.connectionManager.launchDaemonAndConnectIfNeeded();
            try {
                return (R)block.invoke((Object)connection.getClient());
            }
            catch (Exception e) {
                if (!(e instanceof RejectedExecutionException) && !(e instanceof QuotaExceededException)) {
                    throw e;
                }
                if (attempt > 1) {
                    ElevationLogger.INSTANCE.getLOG().warn("Repeated launch error after " + attempt + " attempts; quota options: " + ElevationSettings.Companion.getInstance().getQuotaOptions(), (Throwable)e);
                }
                this.connectionManager.parkConnection(connection);
                if (attempt != maxAttempts) {
                    ++attempt;
                    continue;
                }
                Object[] objectArray = new Object[]{maxAttempts};
                throw new ExecutionException(ElevationBundle.message("dialog.message.unable.to.configure.elevation.daemon.after.attempts", objectArray));
            }
            break;
        }
    }

    public void dispose() {
    }

    public static final /* synthetic */ CoroutineScope access$getCs$p(ElevationServiceImpl $this) {
        return $this.cs;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/execution/process/elevation/ElevationServiceImpl$Companion;", "", "()V", "MAX_RELAUNCHING_DAEMON_UNTIL_HAVE_QUOTA_PERMIT_ATTEMPTS", "", "intellij.execution.process.elevation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

