/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.InputStream;
import org.apache.xmlrpc.AuthenticatedXmlRpcHandler;
import org.apache.xmlrpc.AuthenticationFailed;
import org.apache.xmlrpc.ContextXmlRpcHandler;
import org.apache.xmlrpc.DefaultXmlRpcContext;
import org.apache.xmlrpc.ParseFailed;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcContext;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcHandlerMapping;
import org.apache.xmlrpc.XmlRpcRequestProcessor;
import org.apache.xmlrpc.XmlRpcResponseProcessor;
import org.apache.xmlrpc.XmlRpcServerRequest;

public class XmlRpcWorker {
    protected XmlRpcRequestProcessor requestProcessor = new XmlRpcRequestProcessor();
    protected XmlRpcResponseProcessor responseProcessor = new XmlRpcResponseProcessor();
    protected XmlRpcHandlerMapping handlerMapping;

    public XmlRpcWorker(XmlRpcHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
    }

    protected static Object invokeHandler(Object handler2, XmlRpcServerRequest request, XmlRpcContext context) throws Exception {
        long now = 0L;
        try {
            if (XmlRpc.debug) {
                now = System.currentTimeMillis();
            }
            if (handler2 == null) {
                throw new NullPointerException("Null handler passed to XmlRpcWorker.invokeHandler");
            }
            if (handler2 instanceof ContextXmlRpcHandler) {
                Object object = ((ContextXmlRpcHandler)handler2).execute(request.getMethodName(), request.getParameters(), context);
                return object;
            }
            if (handler2 instanceof XmlRpcHandler) {
                Object object = ((XmlRpcHandler)handler2).execute(request.getMethodName(), request.getParameters());
                return object;
            }
            if (handler2 instanceof AuthenticatedXmlRpcHandler) {
                Object object = ((AuthenticatedXmlRpcHandler)handler2).execute(request.getMethodName(), request.getParameters(), context.getUserName(), context.getPassword());
                return object;
            }
            throw new ClassCastException("Handler class " + handler2.getClass().getName() + " is not a valid XML-RPC handler");
        }
        finally {
            if (XmlRpc.debug) {
                System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis processing request");
            }
        }
    }

    public byte[] execute(InputStream is, String user, String password) {
        return this.execute(is, this.defaultContext(user, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] execute(InputStream is, XmlRpcContext context) {
        long now = 0L;
        if (XmlRpc.debug) {
            now = System.currentTimeMillis();
        }
        try {
            XmlRpcServerRequest request = this.requestProcessor.decodeRequest(is);
            Object handler2 = this.handlerMapping.getHandler(request.getMethodName());
            Object response = XmlRpcWorker.invokeHandler(handler2, request, context);
            byte[] byArray = this.responseProcessor.encodeResponse(response, this.requestProcessor.getEncoding());
            return byArray;
        }
        catch (AuthenticationFailed alertCallerAuth) {
            throw alertCallerAuth;
        }
        catch (ParseFailed alertCallerParse) {
            throw alertCallerParse;
        }
        catch (Exception x) {
            if (XmlRpc.debug) {
                x.printStackTrace();
            }
            byte[] byArray = this.responseProcessor.encodeException(x, this.requestProcessor.getEncoding());
            return byArray;
        }
        finally {
            if (XmlRpc.debug) {
                System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis in request/process/response");
            }
        }
    }

    protected XmlRpcContext defaultContext(String user, String password) {
        return new DefaultXmlRpcContext(user, password, this.handlerMapping);
    }
}

