/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.pathValidation.PathValidatorKt;
import com.jetbrains.python.pathValidation.PlatformAndRoot;
import com.jetbrains.python.pathValidation.ValidationRequest;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkGroupPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PoetryOutdatedVersion;
import com.jetbrains.python.sdk.poetry.PyAddExistingPoetryEnvPanel;
import com.jetbrains.python.sdk.poetry.PyAddNewPoetryPanel;
import com.jetbrains.python.sdk.poetry.PyPoetrySdkAdditionalData;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.tuweni.toml.Toml;
import org.apache.tuweni.toml.TomlTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00c4\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020$0/2\b\u00109\u001a\u0004\u0018\u00010:\u001a\u0012\u0010;\u001a\u00020\u001d2\b\u00109\u001a\u0004\u0018\u00010:H\u0002\u001a:\u0010<\u001a\u00020=2\b\u00109\u001a\u0004\u0018\u00010:2\b\u0010>\u001a\u0004\u0018\u00010$2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001f0/2\b\u0010@\u001a\u0004\u0018\u00010\b2\u0006\u0010A\u001a\u00020B\u001a.\u0010C\u001a\b\u0012\u0004\u0012\u00020D0/2\b\u0010>\u001a\u0004\u0018\u00010$2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\b0F2\b\u0010G\u001a\u0004\u0018\u00010\b\u001a\b\u0010H\u001a\u0004\u0018\u00010I\u001a\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020\b0/2\u0006\u0010G\u001a\u00020\b\u001a\b\u0010K\u001a\u0004\u0018\u00010I\u001a\u001c\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00172\u0006\u00104\u001a\u00020\u0019\u001a\u000e\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020\b\u001a\u0015\u0010O\u001a\u0004\u0018\u00010\u001d2\u0006\u0010G\u001a\u00020\b\u00a2\u0006\u0002\u0010P\u001a\u001a\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020S0R2\u0006\u0010T\u001a\u00020\b\u001a4\u0010U\u001a\u00020\b2\u000b\u0010G\u001a\u00070\b\u00a2\u0006\u0002\b'2\u0006\u0010V\u001a\u00020\b2\u0012\u0010W\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0X\"\u00020\b\u00a2\u0006\u0002\u0010Y\u001a.\u0010Z\u001a\u00020\b2\r\u0010G\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b'2\u0012\u0010W\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0X\"\u00020\b\u00a2\u0006\u0002\u0010[\u001a'\u0010Z\u001a\u00020\b2\u0006\u0010\\\u001a\u00020\u001f2\u0012\u0010W\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0X\"\u00020\b\u00a2\u0006\u0002\u0010]\u001a&\u0010^\u001a\u00020_2\u0006\u0010>\u001a\u00020$2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\b0/2\b\b\u0001\u0010`\u001a\u00020\b\u001a\u001a\u0010a\u001a\b\u0012\u0004\u0012\u00020\b0F2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020\u001f0/\u001a2\u0010c\u001a\u00070\b\u00a2\u0006\u0002\b'2\u000b\u0010G\u001a\u00070\b\u00a2\u0006\u0002\b'2\b\u0010d\u001a\u0004\u0018\u00010\b2\u0006\u0010e\u001a\u00020\u001d2\u0006\u0010f\u001a\u00020\u001d\u001aR\u0010g\u001a\u0004\u0018\u00010\u001f2\b\u00109\u001a\u0004\u0018\u00010:2\b\u0010>\u001a\u0004\u0018\u00010$2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001f0/2\b\u0010@\u001a\u0004\u0018\u00010\b2\b\u0010d\u001a\u0004\u0018\u00010\b2\u0006\u0010e\u001a\u00020\u001d2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\b\u001a\u0018\u0010h\u001a\u00070\b\u00a2\u0006\u0002\bi2\u000b\u0010j\u001a\u00070\b\u00a2\u0006\u0002\bi\u001aZ\u0010k\u001a\u0002Hl\"\u0006\b\u0000\u0010l\u0018\u00012\r\u0010G\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b'2\u0012\u0010W\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0X\"\u00020\b2\u0006\u0010m\u001a\u0002Hl2\u0014\b\u0004\u0010n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002Hl0oH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010p\u001a\u0017\u0010q\u001a\u0004\u0018\u00010r2\r\u0010s\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b'\u001a\u0016\u0010t\u001a\u0004\u0018\u00010$*\u00020\u00192\u0006\u00109\u001a\u00020:H\u0002\"#\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\"\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0012\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"+\u0010\u0015\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"(\u0010\u001e\u001a\u00020\u001d*\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010 \"\u0004\b!\u0010\"\"\u0017\u0010#\u001a\u0004\u0018\u00010\u0019*\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"6\u0010(\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b'*\u00020)2\r\u0010\u001c\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\"\u001b\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0/*\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\"\u0017\u00102\u001a\u0004\u0018\u00010\u0019*\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010&\"\u001a\u00104\u001a\u0004\u0018\u00010\u0019*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006u"}, d2={"LOCK_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "getLOCK_NOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "LOCK_NOTIFICATION_GROUP$delegate", "Lkotlin/Lazy;", "POETRY_DEFAULT_SOURCE_URL", "", "POETRY_ICON", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getPOETRY_ICON", "()Ljavax/swing/Icon;", "POETRY_LOCK", "POETRY_PATH_SETTING", "PY_PROJECT_TOML", "REPLACE_PYTHON_VERSION", "poetryVersion", "getPoetryVersion", "()Ljava/lang/String;", "pyProjectTomlCache", "", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPyProjectTomlCache", "()Ljava/util/Map;", "value", "", "isPoetry", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/projectRoots/Sdk;)Z", "setPoetry", "(Lcom/intellij/openapi/projectRoots/Sdk;Z)V", "poetryLock", "Lcom/intellij/openapi/module/Module;", "getPoetryLock", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/SystemDependent;", "poetryPath", "Lcom/intellij/ide/util/PropertiesComponent;", "getPoetryPath", "(Lcom/intellij/ide/util/PropertiesComponent;)Ljava/lang/String;", "setPoetryPath", "(Lcom/intellij/ide/util/PropertiesComponent;Ljava/lang/String;)V", "poetrySources", "", "getPoetrySources", "(Lcom/intellij/openapi/projectRoots/Sdk;)Ljava/util/List;", "pyProjectToml", "getPyProjectToml", "virtualFile", "Lcom/intellij/openapi/editor/Document;", "getVirtualFile", "(Lcom/intellij/openapi/editor/Document;)Lcom/intellij/openapi/vfs/VirtualFile;", "allModules", "project", "Lcom/intellij/openapi/project/Project;", "allowCreatingNewEnvironments", "createPoetryPanel", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "module", "existingSdks", "newProjectPath", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "detectPoetryEnvs", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "existingSdkPaths", "", "projectPath", "detectPoetryExecutable", "Ljava/io/File;", "getPoetryEnvs", "getPoetryExecutable", "getPyProjectTomlForPoetry", "getPythonExecutable", "homePath", "isVirtualEnvsInProject", "(Ljava/lang/String;)Ljava/lang/Boolean;", "parsePoetryShowOutdated", "", "Lcom/jetbrains/python/sdk/poetry/PoetryOutdatedVersion;", "input", "runCommand", "command", "args", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "runPoetry", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "sdk", "(Lcom/intellij/openapi/projectRoots/Sdk;[Ljava/lang/String;)Ljava/lang/String;", "runPoetryInBackground", "", "description", "sdkHomes", "sdks", "setupPoetry", "python", "installPackages", "init", "setupPoetrySdkUnderProgress", "suggestedSdkName", "Lcom/intellij/openapi/util/NlsSafe;", "basePath", "syncRunPoetry", "T", "defaultResult", "callback", "Lkotlin/Function1;", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "validatePoetryExecutable", "Lcom/intellij/openapi/ui/ValidationInfo;", "poetryExecutable", "getModule", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\npoetry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 poetry.kt\ncom/jetbrains/python/sdk/poetry/PoetryKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,601:1\n562#1,2:636\n574#1,4:638\n562#1,2:642\n574#1,4:644\n562#1,2:648\n574#1,4:650\n372#2,7:602\n1#3:609\n1#3:626\n1#3:664\n37#4,2:610\n1747#5,3:612\n1045#5:615\n1603#5,9:616\n1855#5:625\n1856#5:627\n1612#5:628\n766#5:629\n857#5,2:630\n1549#5:632\n1620#5,3:633\n1603#5,9:654\n1855#5:663\n1856#5:665\n1612#5:666\n*S KotlinDebug\n*F\n+ 1 poetry.kt\ncom/jetbrains/python/sdk/poetry/PoetryKt\n*L\n538#1:636,2\n538#1:638,4\n545#1:642,2\n545#1:644,4\n554#1:648,2\n554#1:650,4\n104#1:602,7\n525#1:626\n590#1:664\n215#1:610,2\n510#1:612,3\n522#1:615\n525#1:616,9\n525#1:625\n525#1:627\n525#1:628\n530#1:629\n530#1:630,2\n530#1:632\n530#1:633,3\n590#1:654,9\n590#1:663\n590#1:665\n590#1:666\n*E\n"})
public final class PoetryKt {
    @NotNull
    public static final String PY_PROJECT_TOML = "pyproject.toml";
    @NotNull
    public static final String POETRY_LOCK = "poetry.lock";
    @NotNull
    public static final String POETRY_DEFAULT_SOURCE_URL = "https://pypi.org/simple";
    @NotNull
    public static final String POETRY_PATH_SETTING = "PyCharm.Poetry.Path";
    @NotNull
    public static final String REPLACE_PYTHON_VERSION = "import re,sys;f=open(\"pyproject.toml\", \"r+\");orig=f.read();f.seek(0);f.write(re.sub(r\"(python = \\\"\\^)[^\\\"]+(\\\")\", \"\\g<1>\"+'.'.join(str(v) for v in sys.version_info[:2])+\"\\g<2>\", orig))";
    @NotNull
    private static final Icon POETRY_ICON;
    @NotNull
    private static final Map<String, Pair<Long, VirtualFile>> pyProjectTomlCache;
    @NotNull
    private static final Lazy LOCK_NOTIFICATION_GROUP$delegate;

    @NotNull
    public static final Icon getPOETRY_ICON() {
        return POETRY_ICON;
    }

    @NotNull
    public static final Pair<Long, VirtualFile> getPyProjectTomlForPoetry(@NotNull VirtualFile virtualFile) {
        VirtualFile virtualFile2;
        Long l;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Long l2 = virtualFile.getModificationStamp();
        try {
            l = l2;
            virtualFile2 = (VirtualFile)ReadAction.compute(() -> PoetryKt.getPyProjectTomlForPoetry$lambda$1(virtualFile));
        }
        catch (Throwable e) {
            l = l2;
            virtualFile2 = null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Long l3 = l;
        return new Pair((Object)l3, (Object)virtualFile3);
    }

    @NotNull
    public static final Map<String, Pair<Long, VirtualFile>> getPyProjectTomlCache() {
        return pyProjectTomlCache;
    }

    @Nullable
    public static final VirtualFile getPyProjectToml(@NotNull Module $this$pyProjectToml) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$pyProjectToml, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir($this$pyProjectToml);
        if (virtualFile != null && (virtualFile = virtualFile.findChild(PY_PROJECT_TOML)) != null) {
            Pair<Long, VirtualFile> pair;
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            String key = $this$pyProjectToml.getName() + virtualFile2.getPath();
            boolean bl2 = false;
            Map<String, Pair<Long, VirtualFile>> $this$getOrPut$iv = pyProjectTomlCache;
            boolean $i$f$getOrPut = false;
            Pair<Long, VirtualFile> value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl3 = false;
                Pair<Long, VirtualFile> answer$iv = PoetryKt.getPyProjectTomlForPoetry(virtualFile2);
                $this$getOrPut$iv.put(key, answer$iv);
                pair = answer$iv;
            } else {
                pair = value$iv;
            }
            Pair<Long, VirtualFile> pair2 = pair;
            boolean bl4 = false;
            if (virtualFile2.getModificationStamp() == ((Number)pair2.getFirst()).longValue()) {
                object = (VirtualFile)pair2.getSecond();
            } else {
                Pair<Long, VirtualFile> pair3 = pyProjectTomlCache.put(key, PoetryKt.getPyProjectTomlForPoetry(virtualFile2));
                object = pair3 != null ? (VirtualFile)pair3.getSecond() : null;
            }
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final String getPoetryPath(@NotNull PropertiesComponent $this$poetryPath) {
        Intrinsics.checkNotNullParameter((Object)$this$poetryPath, (String)"<this>");
        return $this$poetryPath.getValue(POETRY_PATH_SETTING);
    }

    public static final void setPoetryPath(@NotNull PropertiesComponent $this$poetryPath, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$poetryPath, (String)"<this>");
        $this$poetryPath.setValue(POETRY_PATH_SETTING, value);
    }

    @Nullable
    public static final File detectPoetryExecutable() {
        String name2 = SystemInfo.isWindows ? "poetry.bat" : "poetry";
        File file = PathEnvironmentVariableUtil.findInPath((String)name2);
        if (file == null) {
            String string = System.getProperty("user.home");
            if (string != null) {
                File file2;
                String homePath2 = string;
                boolean bl = false;
                File it = file2 = new File(homePath2 + File.separator + ".poetry" + File.separator + "bin" + File.separator + name2);
                boolean bl2 = false;
                file = it.exists() ? file2 : null;
            } else {
                file = null;
            }
        }
        return file;
    }

    @Nullable
    public static final File getPoetryExecutable() {
        Object object;
        block3: {
            block2: {
                File file;
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
                object = PoetryKt.getPoetryPath(propertiesComponent);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                File it2 = file = new File(it);
                boolean bl2 = false;
                object = it2.exists() ? file : null;
                if (object != null) break block3;
            }
            object = PoetryKt.detectPoetryExecutable();
        }
        return object;
    }

    @Nullable
    public static final ValidationInfo validatePoetryExecutable(@Nullable String poetryExecutable) {
        String string = PyBundle.message("python.sdk.poetry.executable.not.found", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return PathValidatorKt.validateExecutableFile(new ValidationRequest(poetryExecutable, string, PlatformAndRoot.Companion.getLocal(), null, 8, null));
    }

    @NotNull
    public static final String suggestedSdkName(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return "Poetry (" + PathUtil.getFileName((String)basePath) + ")";
    }

    @Nullable
    public static final Sdk setupPoetrySdkUnderProgress(@Nullable Project project2, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @Nullable String python, boolean installPackages, @Nullable String poetryPath) {
        Sdk sdk2;
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        String string = newProjectPath;
        if (string == null) {
            Module module2 = module;
            string = module2 != null ? BasePySdkExtKt.getBasePath(module2) : null;
            if (string == null && (string = project2 != null ? project2.getBasePath() : null) == null) {
                return null;
            }
        }
        String projectPath = string;
        String string2 = PyBundle.message("python.sdk.dialog.title.setting.up.poetry.environment", new Object[0]);
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>((Project)project2, poetryPath, projectPath, python, installPackages, string2){
            final /* synthetic */ String $poetryPath;
            final /* synthetic */ String $projectPath;
            final /* synthetic */ String $python;
            final /* synthetic */ boolean $installPackages;
            {
                this.$poetryPath = $poetryPath;
                this.$projectPath = $projectPath;
                this.$python = $python;
                this.$installPackages = $installPackages;
                super($project, $super_call_param$1, true);
            }

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                String string;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                if (this.$poetryPath != null) {
                    string = this.$poetryPath;
                } else {
                    Pair<Long, VirtualFile> pair;
                    VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(this.$projectPath);
                    if (virtualFile != null && (virtualFile = virtualFile.findChild("pyproject.toml")) != null) {
                        VirtualFile it = virtualFile;
                        boolean bl = false;
                        pair = PoetryKt.getPyProjectTomlForPoetry(it);
                    } else {
                        pair = null;
                    }
                    boolean init2 = pair == null;
                    String string2 = FileUtil.toSystemDependentName((String)this.$projectPath);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
                    string = PoetryKt.setupPoetry(string2, this.$python, this.$installPackages, init2);
                }
                String poetry = string;
                return PoetryKt.getPythonExecutable(poetry);
            }
        };
        Sdk sdk3 = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), existingSdks, null, projectPath, PoetryKt.suggestedSdkName(projectPath));
        if (sdk3 != null) {
            Sdk sdk4;
            Sdk $this$setupPoetrySdkUnderProgress_u24lambda_u2410 = sdk4 = sdk3;
            boolean bl = false;
            Object object = module;
            if (object == null) {
                Object[] objectArray = project2;
                object = project2 != null && (objectArray = PyStatisticToolsKt.getModules((Project)objectArray)) != null ? (Module)ArraysKt.firstOrNull((Object[])objectArray) : null;
            }
            PySdkExtKt.associateWithModule($this$setupPoetrySdkUnderProgress_u24lambda_u2410, object, newProjectPath);
            PoetryKt.setPoetry($this$setupPoetrySdkUnderProgress_u24lambda_u2410, true);
            sdk2 = sdk4;
        } else {
            sdk2 = null;
        }
        return sdk2;
    }

    public static /* synthetic */ Sdk setupPoetrySdkUnderProgress$default(Project project2, Module module, List list, String string, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        return PoetryKt.setupPoetrySdkUnderProgress(project2, module, list, string, string2, bl, string3);
    }

    @NotNull
    public static final String setupPoetry(@NotNull String projectPath, @Nullable String python, boolean installPackages, boolean init2) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (init2) {
            Object[] objectArray = new String[]{"init", "-n"};
            Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
            PoetryKt.runPoetry(projectPath, Arrays.copyOf(stringArray, stringArray.length));
            if (python != null) {
                stringArray = new String[]{"-c", REPLACE_PYTHON_VERSION};
                PoetryKt.runCommand(projectPath, python, stringArray);
            }
        }
        if (installPackages) {
            String string = python;
            if (string != null) {
                String it = string;
                boolean bl = false;
                String[] stringArray2 = new String[]{"env", "use", it};
                PoetryKt.runPoetry(projectPath, stringArray2);
            }
            stringArray = new String[]{"install"};
            PoetryKt.runPoetry(projectPath, stringArray);
        } else if (python != null) {
            stringArray = new String[]{"env", "use", python};
            PoetryKt.runPoetry(projectPath, stringArray);
        } else {
            stringArray = new String[]{"run", "python", "-V"};
            PoetryKt.runPoetry(projectPath, stringArray);
        }
        stringArray = new String[]{"env", "info", "-p"};
        return PoetryKt.runPoetry(projectPath, stringArray);
    }

    public static final boolean isPoetry(@NotNull Sdk $this$isPoetry) {
        Intrinsics.checkNotNullParameter((Object)$this$isPoetry, (String)"<this>");
        return $this$isPoetry.getSdkAdditionalData() instanceof PyPoetrySdkAdditionalData;
    }

    public static final void setPoetry(@NotNull Sdk $this$isPoetry, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$isPoetry, (String)"<this>");
        SdkAdditionalData oldData = $this$isPoetry.getSdkAdditionalData();
        SdkAdditionalData newData = value ? (SdkAdditionalData)(oldData instanceof PythonSdkAdditionalData ? new PyPoetrySdkAdditionalData((PythonSdkAdditionalData)oldData) : new PyPoetrySdkAdditionalData()) : (oldData instanceof PyPoetrySdkAdditionalData ? (SdkAdditionalData)new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor($this$isPoetry)) : oldData);
        SdkModificator sdkModificator = $this$isPoetry.getSdkModificator();
        Intrinsics.checkNotNullExpressionValue((Object)sdkModificator, (String)"getSdkModificator(...)");
        SdkModificator modificator = sdkModificator;
        modificator.setSdkAdditionalData(newData);
        ApplicationManager.getApplication().runWriteAction(() -> PoetryKt._set_isPoetry_$lambda$12(modificator));
    }

    @NotNull
    public static final String runPoetry(@NotNull Sdk sdk2, String ... args2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        String string = PySdkExtKt.getAssociatedModulePath(sdk2);
        if (string == null) {
            throw new PyExecutionException(PyBundle.message("python.sdk.poetry.execution.exception.no.project.message", new Object[0]), "Poetry", CollectionsKt.emptyList(), new ProcessOutput());
        }
        String projectPath = string;
        String[] stringArray = new String[3];
        stringArray[0] = "env";
        stringArray[1] = "use";
        Intrinsics.checkNotNull((Object)sdk2.getHomePath());
        PoetryKt.runPoetry(projectPath, stringArray);
        return PoetryKt.runPoetry(projectPath, Arrays.copyOf(args2, args2.length));
    }

    @NotNull
    public static final String runPoetry(@Nullable String projectPath, String ... args2) {
        ProcessOutput result2;
        ProcessOutput processOutput;
        String string;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        File file = PoetryKt.getPoetryExecutable();
        String string2 = string = file != null ? file.getPath() : null;
        if (string == null) {
            throw new PyExecutionException(PyBundle.message("python.sdk.poetry.execution.exception.no.poetry.message", new Object[0]), "poetry", CollectionsKt.emptyList(), new ProcessOutput());
        }
        String executable = string;
        List command = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)executable), (Object[])args2);
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(command).withWorkDirectory(projectPath);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withWorkDirectory(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        CapturingProcessHandler handler2 = new CapturingProcessHandler(commandLine);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        CapturingProcessHandler $this$runPoetry_u24lambda_u2413 = handler2;
        boolean bl = false;
        if (indicator != null) {
            $this$runPoetry_u24lambda_u2413.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
            processOutput = $this$runPoetry_u24lambda_u2413.runProcessWithProgressIndicator(indicator);
        } else {
            processOutput = $this$runPoetry_u24lambda_u2413.runProcess();
        }
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"with(...)");
        ProcessOutput $this$runPoetry_u24lambda_u2414 = result2 = processOutput;
        boolean bl2 = false;
        if ($this$runPoetry_u24lambda_u2414.isCancelled()) {
            throw new RunCanceledByUserException();
        }
        if ($this$runPoetry_u24lambda_u2414.getExitCode() != 0) {
            throw new PyExecutionException(PyBundle.message("python.sdk.poetry.execution.exception.error.running.poetry.message", new Object[0]), executable, ArraysKt.asList((Object[])args2), $this$runPoetry_u24lambda_u2414.getStdout(), $this$runPoetry_u24lambda_u2414.getStderr(), $this$runPoetry_u24lambda_u2414.getExitCode(), CollectionsKt.emptyList());
        }
        String string3 = $this$runPoetry_u24lambda_u2414.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStdout(...)");
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @NotNull
    public static final String runCommand(@NotNull String projectPath, @NotNull String command, String ... args2) {
        ProcessOutput result2;
        CapturingProcessHandler handler2;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)command), (Object[])args2)).withWorkDirectory(projectPath);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withWorkDirectory(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        CapturingProcessHandler $this$runCommand_u24lambda_u2415 = handler2 = new CapturingProcessHandler(commandLine);
        boolean bl = false;
        ProcessOutput processOutput = $this$runCommand_u24lambda_u2415.runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"with(...)");
        ProcessOutput $this$runCommand_u24lambda_u2416 = result2 = processOutput;
        boolean bl2 = false;
        if ($this$runCommand_u24lambda_u2416.isCancelled()) {
            throw new RunCanceledByUserException();
        }
        if ($this$runCommand_u24lambda_u2416.getExitCode() != 0) {
            throw new PyExecutionException(PyBundle.message("python.sdk.poetry.execution.exception.error.running.poetry.message", new Object[0]), command, ArraysKt.asList((Object[])args2), $this$runCommand_u24lambda_u2416.getStdout(), $this$runCommand_u24lambda_u2416.getStderr(), $this$runCommand_u24lambda_u2416.getExitCode(), CollectionsKt.emptyList());
        }
        String string = $this$runCommand_u24lambda_u2416.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
        return string;
    }

    @NotNull
    public static final List<String> getPoetrySources(@NotNull Sdk $this$poetrySources) {
        Intrinsics.checkNotNullParameter((Object)$this$poetrySources, (String)"<this>");
        return CollectionsKt.listOf((Object)POETRY_DEFAULT_SOURCE_URL);
    }

    private static final VirtualFile getVirtualFile(Document $this$virtualFile) {
        return FileDocumentManager.getInstance().getFile($this$virtualFile);
    }

    private static final Module getModule(VirtualFile $this$getModule, Project project2) {
        return ModuleUtil.findModuleForFile((VirtualFile)$this$getModule, (Project)project2);
    }

    private static final NotificationGroup getLOCK_NOTIFICATION_GROUP() {
        Lazy lazy = LOCK_NOTIFICATION_GROUP$delegate;
        return (NotificationGroup)lazy.getValue();
    }

    @Nullable
    public static final VirtualFile getPoetryLock(@NotNull Module $this$poetryLock) {
        Intrinsics.checkNotNullParameter((Object)$this$poetryLock, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir($this$poetryLock);
        return virtualFile != null ? virtualFile.findChild(POETRY_LOCK) : null;
    }

    public static final void runPoetryInBackground(@NotNull Module module, @NotNull List<String> args2, @NlsSafe @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Project project2 = module.getProject();
        String string = StringUtil.toTitleCase((String)description);
        Task.Backgroundable task2 = new Task.Backgroundable(module, description, args2, project2, string){
            final /* synthetic */ Module $module;
            final /* synthetic */ String $description;
            final /* synthetic */ List<String> $args;
            {
                this.$module = $module;
                this.$description = $description;
                this.$args = $args;
                super($super_call_param$1, $super_call_param$2, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Sdk sdk2 = PySdkExtKt.getPythonSdk(this.$module);
                if (sdk2 == null) {
                    return;
                }
                Sdk sdk3 = sdk2;
                indicator.setText(this.$description + "...");
                try {
                    Collection $this$toTypedArray$iv = this.$args;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    PoetryKt.runPoetry(sdk3, Arrays.copyOf(stringArray, stringArray.length));
                }
                catch (RunCanceledByUserException runCanceledByUserException) {
                }
                catch (ExecutionException e) {
                    String string = PyBundle.message("python.sdk.poetry.execution.exception.error.running.poetry.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    PySdkExtKt.showSdkExecutionException(sdk3, e, string);
                }
                finally {
                    VirtualFile virtualFile = PythonSdkUtil.getSitePackagesDirectory(sdk3);
                    if (virtualFile != null) {
                        virtualFile.refresh(true, true);
                    }
                    VirtualFile virtualFile2 = PySdkExtKt.getAssociatedModuleDir(sdk3);
                    if (virtualFile2 != null) {
                        virtualFile2.refresh(true, false);
                    }
                    PyPackageManager.getInstance(sdk3).refreshAndGetPackages(true);
                }
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private static final boolean allowCreatingNewEnvironments(Project project2) {
        return project2 != null || !PlatformUtils.isPyCharm() || PlatformUtils.isPyCharmEducational();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PyAddSdkPanel createPoetryPanel(@Nullable Project project2, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @NotNull UserDataHolder context) {
        PyAddSdkPanel pyAddSdkPanel;
        boolean bl;
        List panels;
        PyAddExistingPoetryEnvPanel existingPoetryPanel;
        PyAddNewPoetryPanel newPoetryPanel;
        block6: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            newPoetryPanel = PoetryKt.allowCreatingNewEnvironments(project2) ? new PyAddNewPoetryPanel(project2, module, existingSdks, null, context) : null;
            existingPoetryPanel = new PyAddExistingPoetryEnvPanel(project2, module, existingSdks, null, context);
            Object[] objectArray = new PyAddSdkPanel[]{newPoetryPanel, existingPoetryPanel};
            panels = CollectionsKt.listOfNotNull((Object[])objectArray);
            Set<String> existingSdkPaths = PoetryKt.sdkHomes(existingSdks);
            Object object = project2;
            if (object == null || (object = object.getBasePath()) == null) {
                object = newProjectPath;
            }
            Iterable iterable = PoetryKt.detectPoetryEnvs(module, existingSdkPaths, (String)object);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PyDetectedSdk it = (PyDetectedSdk)((Object)element$iv);
                    boolean bl2 = false;
                    if (!PySdkExtKt.isAssociatedWithModule((Sdk)it, module)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            pyAddSdkPanel = existingPoetryPanel;
        } else {
            PyAddNewPoetryPanel pyAddNewPoetryPanel = newPoetryPanel;
            pyAddSdkPanel = pyAddNewPoetryPanel != null ? (PyAddSdkPanel)pyAddNewPoetryPanel : (PyAddSdkPanel)existingPoetryPanel;
        }
        PyAddSdkPanel defaultPanel = pyAddSdkPanel;
        return new PyAddSdkGroupPanel(PoetryKt::createPoetryPanel$lambda$18, POETRY_ICON, panels, defaultPanel);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final List<Module> allModules(@Nullable Project project2) {
        List list;
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            Collection collection = ModuleUtil.getModulesOfType((Project)it, (ModuleType)PythonModuleTypeBase.getInstance());
            if (collection != null) {
                Iterable $this$sortedBy$iv = collection;
                boolean $i$f$sortedBy = false;
                List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Module it = (Module)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (Module)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
                if (list2 != null) {
                    list = list2;
                    return list;
                }
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> sdkHomes(@NotNull List<? extends Sdk> sdks2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(sdks2, (String)"sdks");
        Iterable $this$mapNotNull$iv = sdks2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Sdk it = (Sdk)element$iv$iv;
            boolean bl2 = false;
            if (it.getHomePath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PyDetectedSdk> detectPoetryEnvs(@Nullable Module module, @NotNull Set<String> existingSdkPaths, @Nullable String projectPath) {
        List list;
        Intrinsics.checkNotNullParameter(existingSdkPaths, (String)"existingSdkPaths");
        Object object = module;
        if ((object == null || (object = BasePySdkExtKt.getBasePath(object)) == null) && (object = projectPath) == null) {
            return CollectionsKt.emptyList();
        }
        Object path2 = object;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = PoetryKt.getPoetryEnvs((String)path2);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!existingSdkPaths.contains(PoetryKt.getPythonExecutable(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PyDetectedSdk(PoetryKt.getPythonExecutable(it)));
            }
            list = (List)destination$iv$iv;
        }
        catch (Throwable e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getPoetryEnvs(@NotNull String projectPath) {
        List<Object> list;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        String[] stringArray = new String[]{"env", "list", "--full-path"};
        List defaultResult$iv = CollectionsKt.emptyList();
        boolean $i$f$syncRunPoetry = false;
        try {
            void args$iv;
            list = ApplicationManager.getApplication().executeOnPooledThread(new Callable(projectPath, (String[])args$iv, defaultResult$iv){
                final /* synthetic */ String $projectPath;
                final /* synthetic */ String[] $args;
                final /* synthetic */ Object $defaultResult;
                {
                    this.$projectPath = $projectPath;
                    this.$args = $args;
                    this.$defaultResult = $defaultResult;
                }

                public final List<? extends String> call() {
                    Object object;
                    try {
                        String result2;
                        String result3 = result2 = PoetryKt.runPoetry(this.$projectPath, Arrays.copyOf(this.$args, this.$args.length));
                        boolean bl = false;
                        object = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)result3), (Function1)getPoetryEnvs.1.1.INSTANCE), (Function1)getPoetryEnvs.1.2.INSTANCE));
                    }
                    catch (PyExecutionException e) {
                        object = this.$defaultResult;
                    }
                    catch (ProcessNotCreatedException e) {
                        object = this.$defaultResult;
                    }
                    return object;
                }
            }).get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e$iv) {
            list = defaultResult$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Boolean isVirtualEnvsInProject(@NotNull String projectPath) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (FileUtil.exists((String)projectPath)) {
            Object var4_4;
            String[] stringArray = new String[]{"config", "virtualenvs.in-project"};
            Object defaultResult$iv = null;
            boolean $i$f$syncRunPoetry = false;
            try {
                void args$iv;
                var4_4 = ApplicationManager.getApplication().executeOnPooledThread(new Callable(projectPath, (String[])args$iv, defaultResult$iv){
                    final /* synthetic */ String $projectPath;
                    final /* synthetic */ String[] $args;
                    final /* synthetic */ Object $defaultResult;
                    {
                        this.$projectPath = $projectPath;
                        this.$args = $args;
                        this.$defaultResult = $defaultResult;
                    }

                    public final Boolean call() {
                        Object object;
                        try {
                            String result2;
                            String it = result2 = PoetryKt.runPoetry(this.$projectPath, Arrays.copyOf(this.$args, this.$args.length));
                            boolean bl = false;
                            object = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it)).toString(), (Object)"true");
                        }
                        catch (PyExecutionException e) {
                            object = this.$defaultResult;
                        }
                        catch (ProcessNotCreatedException e) {
                            object = this.$defaultResult;
                        }
                        return object;
                    }
                }).get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e$iv) {
                var4_4 = defaultResult$iv;
            }
            bl = var4_4;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getPoetryVersion() {
        String string;
        Object var0 = null;
        String[] stringArray = new String[]{"--version"};
        String defaultResult$iv = "";
        boolean $i$f$syncRunPoetry = false;
        try {
            void args$iv;
            void projectPath$iv;
            string = ApplicationManager.getApplication().executeOnPooledThread(new Callable((String)projectPath$iv, (String[])args$iv, defaultResult$iv){
                final /* synthetic */ String $projectPath;
                final /* synthetic */ String[] $args;
                final /* synthetic */ Object $defaultResult;
                {
                    this.$projectPath = $projectPath;
                    this.$args = $args;
                    this.$defaultResult = $defaultResult;
                }

                public final String call() {
                    Object object;
                    try {
                        String result2;
                        String it = result2 = PoetryKt.runPoetry(this.$projectPath, Arrays.copyOf(this.$args, this.$args.length));
                        boolean bl = false;
                        char[] cArray = new char[]{' '};
                        object = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null));
                    }
                    catch (PyExecutionException e) {
                        object = this.$defaultResult;
                    }
                    catch (ProcessNotCreatedException e) {
                        object = this.$defaultResult;
                    }
                    return object;
                }
            }).get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e$iv) {
            string = defaultResult$iv;
        }
        return string;
    }

    public static final /* synthetic */ <T> T syncRunPoetry(String projectPath, String[] args2, T defaultResult, Function1<? super String, ? extends T> callback) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean $i$f$syncRunPoetry = false;
        try {
            object = ApplicationManager.getApplication().executeOnPooledThread(new Callable(projectPath, args2, callback, defaultResult){
                final /* synthetic */ String $projectPath;
                final /* synthetic */ String[] $args;
                final /* synthetic */ Function1<String, T> $callback;
                final /* synthetic */ T $defaultResult;
                {
                    this.$projectPath = $projectPath;
                    this.$args = $args;
                    this.$callback = $callback;
                    this.$defaultResult = $defaultResult;
                }

                public final T call() {
                    Object object;
                    try {
                        String result2 = PoetryKt.runPoetry(this.$projectPath, Arrays.copyOf(this.$args, this.$args.length));
                        object = this.$callback.invoke((Object)result2);
                    }
                    catch (PyExecutionException e) {
                        object = this.$defaultResult;
                    }
                    catch (ProcessNotCreatedException e) {
                        object = this.$defaultResult;
                    }
                    return object;
                }
            }).get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            object = defaultResult;
        }
        return object;
    }

    @NotNull
    public static final String getPythonExecutable(@NotNull String homePath2) {
        Intrinsics.checkNotNullParameter((Object)homePath2, (String)"homePath");
        String string = PythonSdkUtil.getPythonExecutable(homePath2);
        if (string == null) {
            String[] stringArray = new String[]{homePath2, "bin", "python"};
            String string2 = FileUtil.join((String[])stringArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, PoetryOutdatedVersion> parsePoetryShowOutdated(@NotNull String input) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Iterable $this$mapNotNull$iv = StringsKt.lines((CharSequence)input);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            List list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String line2 = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence = line2;
            Pattern pattern = Pattern.compile(" +");
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            List it = list = StringsKt.split$default((CharSequence)charSequence, (Pattern)pattern, (int)0, (int)2, null);
            boolean bl3 = false;
            List list2 = it.size() > 3 ? list : null;
            if (list2 != null) {
                it = list2;
                boolean bl4 = false;
                pair = TuplesKt.to(it.get(0), (Object)new PoetryOutdatedVersion((String)it.get(1), (String)it.get(2)));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final VirtualFile getPyProjectTomlForPoetry$lambda$1(VirtualFile $virtualFile) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        TomlTable tomlTable = Toml.parse($virtualFile.getInputStream()).getTable("tool.poetry");
        if (tomlTable != null) {
            TomlTable it = tomlTable;
            boolean bl = false;
            virtualFile = $virtualFile;
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    private static final void _set_isPoetry_$lambda$12(SdkModificator $modificator) {
        Intrinsics.checkNotNullParameter((Object)$modificator, (String)"$modificator");
        $modificator.commitChanges();
    }

    private static final String createPoetryPanel$lambda$18() {
        return "Poetry environment";
    }

    public static final /* synthetic */ VirtualFile access$getVirtualFile(Document $receiver) {
        return PoetryKt.getVirtualFile($receiver);
    }

    public static final /* synthetic */ Module access$getModule(VirtualFile $receiver, Project project2) {
        return PoetryKt.getModule($receiver, project2);
    }

    public static final /* synthetic */ NotificationGroup access$getLOCK_NOTIFICATION_GROUP() {
        return PoetryKt.getLOCK_NOTIFICATION_GROUP();
    }

    static {
        Icon icon = PythonIcons.Python.Origami;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Origami");
        POETRY_ICON = icon;
        pyProjectTomlCache = new LinkedHashMap();
        LOCK_NOTIFICATION_GROUP$delegate = LazyKt.lazy((Function0)LOCK_NOTIFICATION_GROUP.2.INSTANCE);
    }
}

