/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PyTargetsRemoteSourcesRefresher;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsIntrospectionFacade;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "pyRequest", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "targetEnvRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetEnvRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getInterpreterPaths", "", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getInterpreterVersion", "isLocalTarget", "", "synchronizeRemoteSourcesAndSetupMappings", "", "intellij.python.community.impl"})
public final class PyTargetsIntrospectionFacade {
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final Project project;
    @NotNull
    private final HelpersAwareTargetEnvironmentRequest pyRequest;

    public PyTargetsIntrospectionFacade(@NotNull Sdk sdk2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.sdk = sdk2;
        this.project = project2;
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = PythonInterpreterTargetEnvironmentFactory.Companion.findPythonTargetInterpreter(this.sdk, this.project);
        if (helpersAwareTargetEnvironmentRequest == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.pyRequest = helpersAwareTargetEnvironmentRequest;
        if (!(!(this.sdk instanceof Disposable) || !Disposer.isDisposed((Disposable)((Disposable)this.sdk)))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final TargetEnvironmentRequest getTargetEnvRequest() {
        return this.pyRequest.getTargetEnvironmentRequest();
    }

    public final boolean isLocalTarget() {
        return this.getTargetEnvRequest() instanceof LocalTargetEnvironmentRequest;
    }

    @Nullable
    public final String getInterpreterVersion(@NotNull ProgressIndicator indicator) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        TargetedCommandLineBuilder cmdBuilder = new TargetedCommandLineBuilder(this.getTargetEnvRequest());
        PySdkExtKt.configureBuilderToRunPythonOnTarget(this.sdk, cmdBuilder);
        PythonSdkFlavor<?> sdkFlavor = PySdkExtKt.getSdkFlavor(this.sdk);
        String string = sdkFlavor.getVersionOption();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionOption(...)");
        cmdBuilder.addParameter(string);
        TargetedCommandLine cmd = cmdBuilder.build();
        TargetEnvironment environment = this.getTargetEnvRequest().prepareEnvironment((TargetProgressIndicator)new TargetProgressIndicatorAdapter(indicator));
        return sdkFlavor.getVersionStringFromOutput(PythonScripts.execute(cmd, environment, indicator));
    }

    @NotNull
    public final List<String> getInterpreterPaths(@NotNull ProgressIndicator indicator) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        PythonScriptExecution execution = PythonScripts.prepareHelperScriptExecution(PythonHelper.SYSPATH, this.pyRequest);
        TargetEnvironment environment = this.getTargetEnvRequest().prepareEnvironment((TargetProgressIndicator)new TargetProgressIndicatorAdapter(indicator));
        TargetedCommandLine cmd = PythonScripts.buildTargetedCommandLine$default(execution, environment, this.sdk, CollectionsKt.emptyList(), false, 8, null);
        List list = PythonScripts.execute(cmd, environment, indicator).getStdoutLines();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
        return list;
    }

    public final void synchronizeRemoteSourcesAndSetupMappings(@NotNull ProgressIndicator indicator) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (this.isLocalTarget()) {
            return;
        }
        new PyTargetsRemoteSourcesRefresher(this.sdk, this.project).run(indicator);
    }
}

