/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.Context;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.PySdkTargetPaths;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\"\u0010\u0006\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001a4\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\"\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001aG\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\"\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a4\u0010\u0014\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\"\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001a<\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\"\u0010\u0006\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001a,\u0010\u0016\u001a\u00020\u00012\"\u0010\u0017\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u0007H\u0002\u001a`\u0010\u0018\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!\u001a`\u0010\u0018\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010$\u001a\u0004\u0018\u00010\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!\u001aF\u0010\u0018\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00192\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020!H\u0002\u001aN\u0010\u0018\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00192\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0002\u001a*\u0010'\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0(2\u0006\u0010)\u001a\u00020*\u001an\u0010+\u001a\u00020\u00012(\u0010,\u001a$\u0012\u0004\u0012\u00020\n\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0-2\u0006\u0010.\u001a\u00020!2\"\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\n`\u000b0\u00072\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020!\u001a\u000e\u00102\u001a\u0004\u0018\u000103*\u00020\u0005H\u0002\u00a8\u00064"}, d2={"addIfNeeded", "", "context", "Lcom/jetbrains/python/run/Context;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "pathList", "", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "addLibrariesFromModule", "module", "Lcom/intellij/openapi/module/Module;", "pythonPathList", "addRoots", "roots", "", "(Lcom/jetbrains/python/run/Context;Ljava/util/Collection;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "addRootsFromModule", "addToPythonPath", "appendSystemPythonPath", "pythonPath", "collectPythonPath", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "shouldAddContentRoots", "", "shouldAddSourceRoots", "isDebug", "sdkHome", "addContentRoots", "addSourceRoots", "getAddedPaths", "", "sdkAdditionalData", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "initPythonPath", "envs", "", "passParentEnvs", "targetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "checkPythonPathInEnvs", "toNioPathOrNull", "Ljava/nio/file/Path;", "intellij.python.community.impl"})
@JvmName(name="TargetedPythonPaths")
@SourceDebugExtension(value={"SMAP\nTargetedPythonPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetedPythonPaths.kt\ncom/jetbrains/python/run/TargetedPythonPaths\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,236:1\n731#2,9:237\n1549#2:246\n1620#2,3:247\n1549#2:251\n1620#2,3:252\n1549#2:255\n1620#2,3:256\n1#3:250\n1#3:269\n11383#4,9:259\n13309#4:268\n13310#4:270\n11392#4:271\n*S KotlinDebug\n*F\n+ 1 TargetedPythonPaths.kt\ncom/jetbrains/python/run/TargetedPythonPaths\n*L\n60#1:237,9\n60#1:246\n60#1:247,3\n143#1:251\n143#1:252,3\n146#1:255\n146#1:256,3\n189#1:269\n189#1:259,9\n189#1:268\n189#1:270\n189#1:271\n*E\n"})
public final class TargetedPythonPaths {
    public static final void initPythonPath(@NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs, @NotNull Collection<Function<TargetEnvironment, String>> pythonPathList, @NotNull TargetEnvironmentRequest targetEnvironmentRequest, boolean checkPythonPathInEnvs) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter(pythonPathList, (String)"pythonPathList");
        Intrinsics.checkNotNullParameter((Object)targetEnvironmentRequest, (String)"targetEnvironmentRequest");
        if (passParentEnvs && targetEnvironmentRequest instanceof LocalTargetEnvironmentRequest && (!checkPythonPathInEnvs || !envs.containsKey("PYTHONPATH"))) {
            TargetedPythonPaths.appendSystemPythonPath(pythonPathList);
        }
        PythonScripts.appendToPythonPath(envs, pythonPathList, targetEnvironmentRequest.getTargetPlatform());
    }

    public static /* synthetic */ void initPythonPath$default(Map map, boolean bl, Collection collection, TargetEnvironmentRequest targetEnvironmentRequest, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        TargetedPythonPaths.initPythonPath(map, bl, collection, targetEnvironmentRequest, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendSystemPythonPath(Collection<Function<TargetEnvironment, String>> pythonPath) {
        String syspath = System.getenv("PYTHONPATH");
        if (syspath != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list;
            ListIterator iterator$iv;
            Iterable $this$dropLastWhile$iv;
            CharSequence charSequence = syspath;
            Object object = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
            object = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
            Collection<Function<TargetEnvironment, String>> collection = pythonPath;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p0 = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)p0).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$map = false;
            iterator$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(TargetEnvironmentFunctions.constant((Object)p0));
            }
            collection.addAll((List)destination$iv$iv);
        }
    }

    @NotNull
    public static final Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull Project project2, @Nullable Module module, @Nullable String sdkHome, @Nullable PyRemotePathMapper pathMapper, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Sdk sdk2 = PythonSdkUtil.findSdkByPath(sdkHome);
        return TargetedPythonPaths.collectPythonPath(project2, module, sdk2, pathMapper, shouldAddContentRoots, shouldAddSourceRoots, isDebug);
    }

    @NotNull
    public static final Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull Project project2, @Nullable Module module, @Nullable Sdk sdk2, @Nullable PyRemotePathMapper pathMapper, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return TargetedPythonPaths.collectPythonPath(new Context(project2, sdk2, pathMapper), module, shouldAddContentRoots, shouldAddSourceRoots, isDebug);
    }

    private static final Collection<Function<TargetEnvironment, String>> collectPythonPath(Context context, Module module, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Set pythonPath = new LinkedHashSet<Function<TargetEnvironment, String>>(TargetedPythonPaths.collectPythonPath(context, module, shouldAddContentRoots, shouldAddSourceRoots));
        if (isDebug) {
            PythonSdkFlavor<?> pythonSdkFlavor;
            Sdk sdk2 = context.getSdk();
            if (sdk2 != null) {
                Sdk it = sdk2;
                boolean bl = false;
                pythonSdkFlavor = PythonSdkFlavor.getFlavor(it);
            } else {
                pythonSdkFlavor = null;
            }
            if (pythonSdkFlavor instanceof JythonSdkFlavor) {
                Object[] objectArray = new String[]{"pycharm", "pydev"};
                for (String helpersResource : CollectionsKt.listOf((Object[])objectArray)) {
                    String helperPath = PythonHelpersLocator.Companion.findPathStringInHelpers(helpersResource);
                    Path path2 = Path.of(helperPath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
                    Function targetHelperPath = TargetEnvironmentFunctions.targetPath((Path)path2);
                    pythonPath.add(targetHelperPath);
                }
            }
        }
        return pythonPath;
    }

    private static final Collection<Function<TargetEnvironment, String>> collectPythonPath(Context context, Module module, boolean addContentRoots2, boolean addSourceRoots2) {
        Collection pythonPathList = new LinkedHashSet();
        if (module != null) {
            Set dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, (Set)dependencies);
            if (addContentRoots2) {
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                TargetedPythonPaths.addRoots(context, pythonPathList, virtualFileArray);
                for (Module dependency : dependencies) {
                    VirtualFile[] virtualFileArray2 = ModuleRootManager.getInstance((Module)dependency).getContentRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getContentRoots(...)");
                    TargetedPythonPaths.addRoots(context, pythonPathList, virtualFileArray2);
                }
            }
            if (addSourceRoots2) {
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
                TargetedPythonPaths.addRoots(context, pythonPathList, virtualFileArray);
                for (Module dependency : dependencies) {
                    VirtualFile[] virtualFileArray3 = ModuleRootManager.getInstance((Module)dependency).getSourceRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray3, (String)"getSourceRoots(...)");
                    TargetedPythonPaths.addRoots(context, pythonPathList, virtualFileArray3);
                }
            }
            TargetedPythonPaths.addLibrariesFromModule(module, pythonPathList);
            TargetedPythonPaths.addRootsFromModule(module, pythonPathList);
            for (Module dependency : dependencies) {
                TargetedPythonPaths.addLibrariesFromModule(dependency, pythonPathList);
                TargetedPythonPaths.addRootsFromModule(dependency, pythonPathList);
            }
        }
        return pythonPathList;
    }

    @NotNull
    public static final List<Function<TargetEnvironment, String>> getAddedPaths(@NotNull SdkAdditionalData sdkAdditionalData) {
        Intrinsics.checkNotNullParameter((Object)sdkAdditionalData, (String)"sdkAdditionalData");
        List pathList = new ArrayList();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            List list;
            if (sdkAdditionalData instanceof RemoteSdkProperties) {
                Set<VirtualFile> set = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
                Intrinsics.checkNotNullExpressionValue(set, (String)"getAddedPathFiles(...)");
                $this$map$iv = set;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    var12_12 = destination$iv$iv;
                    boolean bl = false;
                    var12_12.add(((RemoteSdkProperties)sdkAdditionalData).getPathMappings().convertToRemote(it.getPath()));
                }
                list = (List)destination$iv$iv;
            } else {
                Set<VirtualFile> set = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
                Intrinsics.checkNotNullExpressionValue(set, (String)"getAddedPathFiles(...)");
                $this$map$iv = set;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (VirtualFile)item$iv$iv;
                    var12_12 = destination$iv$iv;
                    boolean bl = false;
                    var12_12.add(it.getPath());
                }
                list = (List)destination$iv$iv;
            }
            List addedPaths = list;
            for (String file : addedPaths) {
                Intrinsics.checkNotNull((Object)file);
                pathList.add(TargetEnvironmentFunctions.constant((Object)file));
            }
        }
        return pathList;
    }

    private static final void addToPythonPath(Context context, VirtualFile file, Collection<Function<TargetEnvironment, String>> pathList) {
        if (file.getFileSystem() instanceof JarFileSystem) {
            VirtualFile realFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (realFile != null) {
                TargetedPythonPaths.addIfNeeded(context, realFile, pathList);
            }
        } else if (file.isDirectory()) {
            TargetedPythonPaths.addIfNeeded(context, file, pathList);
        }
    }

    private static final void addIfNeeded(Context context, VirtualFile file, Collection<Function<TargetEnvironment, String>> pathList) {
        Path filePath = Path.of(FileUtil.toSystemDependentName((String)file.getPath()), new String[0]);
        Project project2 = context.getProject();
        Sdk sdk2 = context.getSdk();
        PyRemotePathMapper pyRemotePathMapper = context.getPathMapper();
        Intrinsics.checkNotNull((Object)filePath);
        pathList.add(PySdkTargetPaths.getTargetPathForPythonConsoleExecution(project2, sdk2, pyRemotePathMapper, filePath));
    }

    /*
     * WARNING - void declaration
     */
    private static final void addLibrariesFromModule(Module module, Collection<Function<TargetEnvironment, String>> pythonPathList) {
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
        for (OrderEntry entry : orderEntryArray) {
            void $this$mapNotNullTo$iv$iv;
            String name2;
            if (!(entry instanceof LibraryOrderEntry) || (name2 = ((LibraryOrderEntry)entry).getLibraryName()) != null && StringsKt.endsWith$default((String)name2, (String)" interpreter library", (boolean)false, (int)2, null)) continue;
            VirtualFile[] virtualFileArray = ((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRootFiles(...)");
            Object[] $this$mapNotNull$iv = virtualFileArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Path it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (TargetedPythonPaths.toNioPathOrNull(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (Path root : (List)destination$iv$iv) {
                PersistentLibraryKind kind;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    pythonPathList.add(TargetEnvironmentFunctions.targetPath((Path)root));
                    continue;
                }
                if (!(library instanceof LibraryEx) || (kind = ((LibraryEx)library).getKind()) != PythonLibraryType.getInstance().getKind()) continue;
                pythonPathList.add(TargetEnvironmentFunctions.targetPath((Path)root));
            }
        }
    }

    private static final Path toNioPathOrNull(VirtualFile $this$toNioPathOrNull) {
        return $this$toNioPathOrNull.getFileSystem().getNioPath($this$toNioPathOrNull);
    }

    private static final void addRootsFromModule(Module module, Collection<Function<TargetEnvironment, String>> pythonPathList) {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension != null) {
            VirtualFile pathForTests;
            VirtualFile path2 = extension.getCompilerOutputPath();
            if (path2 != null) {
                String string = path2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)string));
            }
            if ((pathForTests = extension.getCompilerOutputPathForTests()) != null) {
                String string = pathForTests.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)string));
            }
        }
    }

    private static final void addRoots(Context context, Collection<Function<TargetEnvironment, String>> pythonPathList, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            TargetedPythonPaths.addToPythonPath(context, root, pythonPathList);
        }
    }
}

