/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.ExecutionExceptionWithHyperlink;
import com.jetbrains.python.run.PyRunnerUtil;
import com.jetbrains.python.run.PythonCommandLineState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class PythonRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "PythonRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PythonRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            PythonRunner.$$$reportNull$$$0(1);
        }
        return executorId.equals("Run") && profile instanceof AbstractPythonRunConfiguration;
    }

    private static void execute(@NotNull RunProfileState profileState, @NotNull Runnable runnable) {
        if (profileState == null) {
            PythonRunner.$$$reportNull$$$0(2);
        }
        if (runnable == null) {
            PythonRunner.$$$reportNull$$$0(3);
        }
        Runnable clientIdRunnable = ClientId.decorateRunnable((Runnable)runnable);
        if (profileState instanceof PythonCommandLineState) {
            AppExecutorUtil.getAppExecutorService().execute(clientIdRunnable);
        } else {
            ApplicationManager.getApplication().invokeAndWait(clientIdRunnable);
        }
    }

    protected @NotNull Promise<@Nullable RunContentDescriptor> execute(@NotNull ExecutionEnvironment env, @NotNull RunProfileState state) {
        if (env == null) {
            PythonRunner.$$$reportNull$$$0(4);
        }
        if (state == null) {
            PythonRunner.$$$reportNull$$$0(5);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        AsyncPromise promise = new AsyncPromise();
        PythonRunner.execute(state, () -> {
            try {
                ExecutionResult executionResult;
                boolean useTargetsAPI = Registry.is((String)"python.use.targets.api");
                RunProfile profile = env.getRunProfile();
                if (useTargetsAPI && state instanceof PythonCommandLineState) {
                    executionResult = ((PythonCommandLineState)state).execute(env.getExecutor());
                } else {
                    if (!useTargetsAPI && PyRunnerUtil.isTargetBasedSdkAssigned(state)) {
                        Project project2 = env.getProject();
                        Module module = PyRunnerUtil.getModule(state);
                        throw new ExecutionExceptionWithHyperlink(PyBundle.message("runcfg.error.message.python.interpreter.is.invalid.configure", new Object[0]), () -> PyInterpreterInspection.InterpreterSettingsQuickFix.showPythonInterpreterSettings(project2, module));
                    }
                    executionResult = !useTargetsAPI && state instanceof PythonCommandLineState && profile instanceof CommandLinePatcher ? ((PythonCommandLineState)state).execute(env.getExecutor(), (CommandLinePatcher)profile) : state.execute(env.getExecutor(), (ProgramRunner)this);
                }
                ApplicationManager.getApplication().invokeLater(() -> promise.setResult((Object)DefaultProgramRunnerKt.showRunContent((ExecutionResult)executionResult, (ExecutionEnvironment)env)), ModalityState.any());
            }
            catch (ExecutionException e) {
                promise.setError((Throwable)e);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            PythonRunner.$$$reportNull$$$0(6);
        }
        return asyncPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonRunner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

