/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyMakeFunctionTopLevelDialog;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyMakeLocalFunctionTopLevelProcessor;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyMakeMethodTopLevelProcessor;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersDialog;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersHelper;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyMoveSymbolDelegate
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (targetContainer != null && !super.canMove(elements, targetContainer, reference)) {
            return false;
        }
        if (PyMoveSymbolDelegate.isMovableLocalFunctionOrMethod(elements[0])) {
            return true;
        }
        for (PsiElement element : elements) {
            if (PyMoveModuleMembersHelper.isMovableModuleMember(element)) continue;
            return false;
        }
        return true;
    }

    public void doMove(@NotNull Project project2, @NotNull List<PyElement> elements) {
        BaseRefactoringProcessor processor2;
        if (project2 == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(1);
        }
        PsiElement firstElement = (PsiElement)elements.get(0);
        String initialPath = StringUtil.notNullize((String)PyPsiUtils.getContainingFilePath(firstElement));
        if (PyMoveSymbolDelegate.isMovableLocalFunctionOrMethod(firstElement)) {
            PyFunction function = (PyFunction)firstElement;
            PyMakeFunctionTopLevelDialog dialog2 = new PyMakeFunctionTopLevelDialog(project2, function, initialPath, initialPath);
            if (!dialog2.showAndGet()) {
                return;
            }
            if (function.getContainingClass() != null) {
                PyMakeMethodTopLevelProcessor processor22 = new PyMakeMethodTopLevelProcessor(function, dialog2.getTargetPath());
            } else {
                processor2 = new PyMakeLocalFunctionTopLevelProcessor(function, dialog2.getTargetPath());
            }
            processor2.setPreviewUsages(dialog2.isPreviewUsages());
        } else {
            ArrayList<PsiNamedElement> initialElements = new ArrayList<PsiNamedElement>();
            for (PsiElement psiElement : elements) {
                PsiNamedElement e = PyMoveModuleMembersHelper.extractNamedElement(psiElement);
                if (e == null) {
                    return;
                }
                initialElements.add(e);
            }
            PyMoveModuleMembersDialog dialog2 = new PyMoveModuleMembersDialog(project2, initialElements, initialPath, initialPath);
            if (!dialog2.showAndGet()) {
                return;
            }
            PsiNamedElement[] psiNamedElementArray = (PsiNamedElement[])ContainerUtil.findAllAsArray(dialog2.getSelectedTopLevelSymbols(), PsiNamedElement.class);
            processor2 = new PyMoveModuleMembersProcessor(psiNamedElementArray, dialog2.getTargetPath());
            processor2.setPreviewUsages(dialog2.isPreviewUsages());
        }
        try {
            processor2.run();
        }
        catch (IncorrectOperationException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)project2);
        }
    }

    public boolean tryToMove(@NotNull PsiElement element, @NotNull Project project2, @Nullable DataContext dataContext, @Nullable PsiReference reference, @Nullable Editor editor2) {
        if (element == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(3);
        }
        PsiFile currentFile = element.getContainingFile();
        if (editor2 != null && currentFile instanceof PyFile && PyMoveSymbolDelegate.selectionSpansMultipleLines(editor2)) {
            List<PyElement> moduleMembers = PyMoveSymbolDelegate.collectAllMovableElementsInSelection(editor2, (PyFile)currentFile);
            if (moduleMembers.isEmpty()) {
                PyMoveSymbolDelegate.showBadSelectionErrorHint(project2, editor2);
            } else {
                this.doMove(project2, moduleMembers);
            }
            return true;
        }
        PsiNamedElement e = PyMoveModuleMembersHelper.extractNamedElement(element);
        if (e != null && PyMoveModuleMembersHelper.hasMovableElementType((PsiElement)e)) {
            if (PyMoveModuleMembersHelper.isMovableModuleMember((PsiElement)e) || PyMoveSymbolDelegate.isMovableLocalFunctionOrMethod((PsiElement)e)) {
                this.doMove(project2, Collections.singletonList((PyElement)e));
            } else {
                PyMoveSymbolDelegate.showBadSelectionErrorHint(project2, editor2);
            }
            return true;
        }
        return false;
    }

    private static void showBadSelectionErrorHint(@NotNull Project project2, @Nullable Editor editor2) {
        if (project2 == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(4);
        }
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)PyBundle.message("refactoring.move.module.members.error.selection", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), null);
    }

    private static boolean selectionSpansMultipleLines(@NotNull Editor editor2) {
        if (editor2 == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(5);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        Document document = editor2.getDocument();
        return document.getLineNumber(selectionModel.getSelectionStart()) != document.getLineNumber(selectionModel.getSelectionEnd());
    }

    @NotNull
    private static List<PyElement> collectAllMovableElementsInSelection(@NotNull Editor editor2, @NotNull PyFile pyFile) {
        if (editor2 == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(6);
        }
        if (pyFile == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(7);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        TextRange selectionRange = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        List<PyElement> members2 = PyMoveModuleMembersHelper.getTopLevelModuleMembers(pyFile);
        List list = ContainerUtil.filter(members2, member -> {
            PsiElement body = PyMoveModuleMembersHelper.expandNamedElementBody((PsiNamedElement)member);
            return body != null && selectionRange.contains(body.getTextRange());
        });
        if (list == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(8);
        }
        return list;
    }

    @VisibleForTesting
    public static boolean isMovableLocalFunctionOrMethod(@NotNull PsiElement element) {
        if (element == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(9);
        }
        return PyMoveSymbolDelegate.isLocalFunction(element) || PyMoveSymbolDelegate.isSuitableInstanceMethod(element);
    }

    private static boolean isSuitableInstanceMethod(@Nullable PsiElement element) {
        PyFunction function = PyUtil.as(element, PyFunction.class);
        if (function == null || function.getContainingClass() == null) {
            return false;
        }
        String funcName = function.getName();
        if (funcName == null || PyUtilCore.isSpecialName((String)funcName)) {
            return false;
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(function.getProject(), function.getContainingFile());
        if (PySuperMethodsSearch.search(function, typeEvalContext).findFirst() != null) {
            return false;
        }
        if (PyOverridingMethodsSearch.search(function, true).findFirst() != null) {
            return false;
        }
        if (function.getDecoratorList() != null || function.getModifier() != null) {
            return false;
        }
        return function.getContainingClass().findPropertyByCallable(function) == null;
    }

    private static boolean isLocalFunction(@Nullable PsiElement resolved) {
        return resolved instanceof PyFunction && PsiTreeUtil.getParentOfType((PsiElement)resolved, ScopeOwner.class, (boolean)true) instanceof PyFunction;
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(10);
        }
        return language.isKindOf((Language)PythonLanguage.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/PyMoveSymbolDelegate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/PyMoveSymbolDelegate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllMovableElementsInSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryToMove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showBadSelectionErrorHint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectionSpansMultipleLines";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAllMovableElementsInSelection";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMovableLocalFunctionOrMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "supportsLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

