/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralExpressionImpl
extends PyElementImpl
implements PyStringLiteralExpression,
PsiLiteralValue,
ContributedReferenceHost {
    @Nullable
    private volatile String myStringValue;
    @Nullable
    private volatile List<TextRange> myValueTextRanges;
    @Nullable
    private volatile List<Pair<TextRange, String>> myDecodedFragments;

    public PyStringLiteralExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyStringLiteralExpression(this);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myStringValue = null;
        this.myValueTextRanges = null;
        this.myDecodedFragments = null;
    }

    @NotNull
    public List<TextRange> getStringValueTextRanges() {
        List result2 = this.myValueTextRanges;
        if (result2 == null) {
            this.myValueTextRanges = result2 = PyStringLiteralExpression.super.getStringValueTextRanges();
        }
        List list = result2;
        if (list == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Pair<TextRange, String>> getDecodedFragments() {
        int elementStart = this.getTextRange().getStartOffset();
        List result2 = this.myDecodedFragments;
        if (result2 == null) {
            List combined;
            this.myDecodedFragments = result2 = (combined = StreamEx.of((Collection)this.getStringElements()).flatMap(node -> StreamEx.of((Collection)node.getDecodedFragments()).map(pair -> {
                int nodeRelativeOffset = node.getTextRange().getStartOffset() - elementStart;
                return Pair.create((Object)((TextRange)pair.getFirst()).shiftRight(nodeRelativeOffset), (Object)((String)pair.getSecond()));
            })).toList());
        }
        List list = result2;
        if (list == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean isDocString() {
        List stringNodes = this.getStringNodes();
        return stringNodes.size() == 1 && ((ASTNode)stringNodes.get(0)).getElementType() == PyTokenTypes.DOCSTRING;
    }

    @Override
    public boolean isInterpolated() {
        return StreamEx.of((Collection)this.getStringElements()).select(PyFormattedStringElement.class).anyMatch(element -> !element.getFragments().isEmpty());
    }

    @NotNull
    public String getStringValue() {
        String result2 = this.myStringValue;
        if (result2 == null) {
            StringBuilder out = new StringBuilder();
            for (Pair<TextRange, String> fragment2 : this.getDecodedFragments()) {
                out.append((String)fragment2.getSecond());
            }
            this.myStringValue = result2 = out.toString();
        }
        String string = result2;
        if (string == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Object getValue() {
        return this.getStringValue();
    }

    public TextRange getStringValueTextRange() {
        List<TextRange> allRanges = this.getStringValueTextRanges();
        if (allRanges.size() == 1) {
            return allRanges.get(0);
        }
        if (allRanges.size() > 1) {
            return allRanges.get(0).union(allRanges.get(allRanges.size() - 1));
        }
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getStringValue();
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyFile file;
        if (context == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (key == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)((file = PyUtil.as(FileContextUtil.getContextFile((PsiElement)this), PyFile.class)) == null ? this : file));
        LanguageLevel languageLevel = file == null ? LanguageLevel.forElement((PsiElement)this) : file.getLanguageLevel();
        ASTNode firstNode = (ASTNode)ContainerUtil.getFirstItem((List)this.getStringNodes());
        if (firstNode != null) {
            if (firstNode.getElementType() == PyElementTypes.FSTRING_NODE) {
                return builtinCache.getUnicodeType(languageLevel);
            }
            if (firstNode.getElementType() == PyTokenTypes.DOCSTRING) {
                return builtinCache.getStrType();
            }
            if (((PyStringElement)firstNode).isBytes()) {
                return builtinCache.getBytesType(languageLevel);
            }
            IElementType type2 = PythonHighlightingLexer.convertStringType((IElementType)firstNode.getElementType(), (String)firstNode.getText(), (LanguageLevel)languageLevel, (file != null && file.hasImportFromFuture(FutureFeature.UNICODE_LITERALS) ? 1 : 0) != 0);
            if (PyTokenTypes.UNICODE_NODES.contains(type2)) {
                return builtinCache.getUnicodeType(languageLevel);
            }
        }
        return builtinCache.getStrType();
    }

    public final PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String string = PyStringLiteralExpressionImpl.this.getStringValue();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public String getLocationString() {
                String packageForFile = PyElementPresentation.getPackageForFile(PyStringLiteralExpressionImpl.this.getContainingFile());
                return packageForFile != null ? String.format("(%s)", packageForFile) : null;
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                Icon icon = AllIcons.Nodes.Variable;
                if (icon == null) {
                    1.$$$reportNull$$$0(1);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new StringLiteralTextEscaper(this);
    }

    @Override
    public int valueOffsetToTextOffset(int valueOffset) {
        return this.createLiteralTextEscaper().getOffsetInHost(valueOffset, this.getStringValueTextRange());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValueTextRanges";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecodedFragments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class StringLiteralTextEscaper
    extends LiteralTextEscaper<PyStringLiteralExpression> {
        private final PyStringLiteralExpressionImpl myHost;

        protected StringLiteralTextEscaper(@NotNull PyStringLiteralExpressionImpl host) {
            if (host == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(0);
            }
            super((PsiLanguageInjectionHost)host);
            this.myHost = host;
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            if (rangeInsideHost == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(1);
            }
            if (outChars == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(2);
            }
            for (Pair<TextRange, String> fragment2 : this.myHost.getDecodedFragments()) {
                String intersectedValue;
                TextRange encodedTextRange = (TextRange)fragment2.getFirst();
                TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                if (intersection == null || intersection.isEmpty()) continue;
                String value = (String)fragment2.getSecond();
                if (value.codePointCount(0, value.length()) == 1 || value.length() == intersection.getLength()) {
                    intersectedValue = value;
                } else {
                    int start = Math.max(0, rangeInsideHost.getStartOffset() - encodedTextRange.getStartOffset());
                    int end = Math.min(value.length(), start + intersection.getLength());
                    intersectedValue = value.substring(start, end);
                }
                outChars.append(intersectedValue);
            }
            return true;
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            if (rangeInsideHost == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(3);
            }
            int offset = 0;
            int endOffset = -1;
            for (Pair<TextRange, String> fragment2 : this.myHost.getDecodedFragments()) {
                TextRange encodedTextRange = (TextRange)fragment2.getFirst();
                TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                if (intersection == null || intersection.isEmpty()) continue;
                String value = (String)fragment2.getSecond();
                int valueLength = value.length();
                int intersectionLength = intersection.getLength();
                if (valueLength == 0) {
                    return -1;
                }
                if (value.codePointCount(0, valueLength) == 1) {
                    if (offset == offsetInDecoded) {
                        return intersection.getStartOffset();
                    }
                    offset += valueLength;
                } else {
                    if (offset + intersectionLength >= offsetInDecoded) {
                        int delta = offsetInDecoded - offset;
                        return intersection.getStartOffset() + delta;
                    }
                    offset += intersectionLength;
                }
                endOffset = intersection.getEndOffset();
            }
            if (offset == offsetInDecoded) {
                return endOffset;
            }
            return -1;
        }

        public boolean isOneLine() {
            return true;
        }

        @NotNull
        public TextRange getRelevantTextRange() {
            TextRange textRange = this.myHost.getStringValueTextRange();
            if (textRange == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInsideHost";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outChars";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$StringLiteralTextEscaper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$StringLiteralTextEscaper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelevantTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "decode";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getOffsetInHost";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

