/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAssignmentStatementImpl
extends PyElementImpl
implements PyAssignmentStatement {
    private volatile PyExpression @Nullable [] myTargets;

    public PyAssignmentStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyAssignmentStatement(this);
    }

    @Override
    public PyExpression @NotNull [] getTargets() {
        PyExpression[] result2 = this.myTargets;
        if (result2 == null) {
            result2 = this.calcTargets(false);
            this.myTargets = result2;
        }
        if (result2 == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(0);
        }
        return result2;
    }

    @Override
    public PyExpression @NotNull [] getRawTargets() {
        return this.calcTargets(true);
    }

    private PyExpression @NotNull [] calcTargets(boolean raw) {
        ASTNode[] eqSigns = this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.EQ}));
        if (eqSigns.length == 0) {
            if (PyExpression.EMPTY_ARRAY == null) {
                PyAssignmentStatementImpl.$$$reportNull$$$0(1);
            }
            return PyExpression.EMPTY_ARRAY;
        }
        ASTNode lastEq = eqSigns[eqSigns.length - 1];
        ArrayList<PyExpression> candidates = new ArrayList<PyExpression>();
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && node != lastEq; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof PyExpression)) continue;
            if (raw) {
                candidates.add((PyExpression)psi);
                continue;
            }
            PyAssignmentStatementImpl.addCandidate(candidates, (PyExpression)psi);
        }
        ArrayList<PyExpression> targets = new ArrayList<PyExpression>();
        for (PyExpression expr : candidates) {
            if (!raw && !(expr instanceof PyTargetExpression) && !(expr instanceof PyReferenceExpression) && !(expr instanceof PySubscriptionExpression) && !(expr instanceof PySliceExpression)) continue;
            targets.add(expr);
        }
        PyExpression[] pyExpressionArray = targets.toArray(PyExpression.EMPTY_ARRAY);
        if (pyExpressionArray == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(2);
        }
        return pyExpressionArray;
    }

    private static void addCandidate(List<PyExpression> candidates, PyExpression psi) {
        if (psi instanceof PyParenthesizedExpression) {
            PyAssignmentStatementImpl.addCandidate(candidates, ((PyParenthesizedExpression)psi).getContainedExpression());
        } else if (psi instanceof PySequenceExpression) {
            PyExpression[] pyExpressions;
            for (PyExpression pyExpression : pyExpressions = ((PySequenceExpression)psi).getElements()) {
                PyAssignmentStatementImpl.addCandidate(candidates, pyExpression);
            }
        } else if (psi instanceof PyStarExpression) {
            PyExpression expression = ((PyStarExpression)psi).getExpression();
            if (expression != null) {
                PyAssignmentStatementImpl.addCandidate(candidates, expression);
            }
        } else {
            candidates.add(psi);
        }
    }

    @Override
    @NotNull
    public List<Pair<PyExpression, PyExpression>> getTargetsToValuesMapping() {
        Object[] constituents;
        SmartList ret = new SmartList();
        if (!PsiTreeUtil.hasErrorElements((PsiElement)this) && (constituents = (PyExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PyExpression.class)) != null && constituents.length > 1) {
            PyExpression rhs = constituents[constituents.length - 1];
            ArrayList lhses = Lists.newArrayList((Object[])constituents);
            if (!lhses.isEmpty()) {
                lhses.remove(lhses.size() - 1);
            }
            for (PyExpression lhs : lhses) {
                PyAssignmentStatementImpl.mapToValues(lhs, rhs, (List<Pair<PyExpression, PyExpression>>)ret);
            }
        }
        SmartList smartList = ret;
        if (smartList == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private static void mapToValues(@Nullable PyExpression lhs, @Nullable PyExpression rhs, List<Pair<PyExpression, PyExpression>> map) {
        block11: {
            PyTupleExpression rhs_tuple;
            PyTupleExpression lhs_tuple;
            block12: {
                PyExpression rhs_one;
                block10: {
                    lhs_tuple = null;
                    PyExpression lhs_one = null;
                    PyExpression pyExpression = PyPsiUtils.flattenParens(lhs);
                    if (pyExpression instanceof PyTupleExpression) {
                        PyTupleExpression tupleExpr;
                        lhs_tuple = tupleExpr = (PyTupleExpression)pyExpression;
                    } else if (lhs != null) {
                        lhs_one = lhs;
                    }
                    rhs_tuple = null;
                    rhs_one = null;
                    PyExpression pyExpression2 = PyPsiUtils.flattenParens(rhs);
                    if (pyExpression2 instanceof PyTupleExpression) {
                        PyTupleExpression tupleExpr;
                        rhs_tuple = tupleExpr = (PyTupleExpression)pyExpression2;
                    } else if (rhs != null) {
                        rhs_one = rhs;
                    }
                    if (lhs_one == null) break block10;
                    map.add((Pair<PyExpression, PyExpression>)Pair.create((Object)lhs_one, (Object)rhs));
                    break block11;
                }
                if (lhs_tuple == null || rhs_one == null) break block12;
                PyElementGenerator elementGenerator = PyElementGenerator.getInstance(rhs_one.getProject());
                LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)lhs);
                int counter = 0;
                for (PyExpression tuple_elt : lhs_tuple.getElements()) {
                    try {
                        PyExpression expression = elementGenerator.createExpressionFromText(languageLevel, "(" + rhs_one.getText() + ")[" + counter + "]");
                        PyAssignmentStatementImpl.mapToValues(tuple_elt, expression, map);
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                    ++counter;
                }
                break block11;
            }
            if (lhs_tuple == null || rhs_tuple == null) break block11;
            List<PyExpression> lhsTupleElements = Arrays.asList(lhs_tuple.getElements());
            List<PyExpression> rhsTupleElements = Arrays.asList(rhs_tuple.getElements());
            int size = Math.max(lhsTupleElements.size(), rhsTupleElements.size());
            for (int index = 0; index < size; ++index) {
                PyAssignmentStatementImpl.mapToValues((PyExpression)ContainerUtil.getOrElse(lhsTupleElements, (int)index, null), (PyExpression)ContainerUtil.getOrElse(rhsTupleElements, (int)index, null), map);
            }
        }
    }

    @Nullable
    public PsiNamedElement getNamedElement(@NotNull String the_name) {
        PyExpression pyExpression;
        PyExpression[] targets;
        if (the_name == null) {
            PyAssignmentStatementImpl.$$$reportNull$$$0(4);
        }
        if ((targets = this.getTargets()).length == 1 && (pyExpression = targets[0]) instanceof PyTargetExpression) {
            PyTargetExpression target = (PyTargetExpression)pyExpression;
            return !target.isQualified() && the_name.equals(target.getName()) ? target : null;
        }
        return PyUtil.IterHelper.findName(this.getNamedElements(), the_name);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myTargets = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyAssignmentStatementImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "the_name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsToValuesMapping";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyAssignmentStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }
}

