/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.packaging.repository.PyPackageRepositoryUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyPackageManagerImplBase
extends PyPackageManager {
    protected static final String SETUPTOOLS_VERSION = "44.1.1";
    protected static final String PIP_VERSION = "20.3.4";
    protected static final String SETUPTOOLS_WHEEL_NAME = "setuptools-44.1.1-py2.py3-none-any.whl";
    protected static final String PIP_WHEEL_NAME = "pip-20.3.4-py2.py3-none-any.whl";
    protected static final int ERROR_NO_SETUPTOOLS = 3;
    private static final Logger LOG = Logger.getInstance(PyPackageManagerImplBase.class);
    protected static final String PACKAGING_TOOL = "packaging_tool.py";
    protected static final int TIMEOUT = 600000;
    protected static final String INSTALL = "install";
    protected static final String UNINSTALL = "uninstall";
    protected String mySeparator;
    @Nullable
    protected volatile List<PyPackage> myPackagesCache;
    private final AtomicBoolean myUpdatingCache;

    @Override
    public void refresh() {
        LOG.debug("Refreshing SDK roots and packages cache");
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            Sdk sdk2 = this.getSdk();
            application.runWriteAction(() -> {
                VirtualFile[] files = sdk2.getRootProvider().getFiles(OrderRootType.CLASSES);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])files);
            });
            PythonSdkType.getInstance().setupSdkPaths(sdk2);
        });
    }

    @Override
    public void installManagement() throws ExecutionException {
        PyPackage installedPip;
        PyPackage installedSetuptools;
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(this.getSdk());
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.package.management.for.python.not.supported", languageLevel, LanguageLevel.PYTHON27));
        }
        boolean success = this.updatePackagingTools();
        if (success) {
            return;
        }
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON312) && ((installedSetuptools = this.refreshAndCheckForSetuptools()) == null || PackageVersionComparator.VERSION_COMPARATOR.compare(installedSetuptools.getVersion(), SETUPTOOLS_VERSION) < 0)) {
            this.installManagement(Objects.requireNonNull(this.getHelperPath(SETUPTOOLS_WHEEL_NAME)));
        }
        if ((installedPip = PyPsiPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip")) == null || PackageVersionComparator.VERSION_COMPARATOR.compare(installedPip.getVersion(), PIP_VERSION) < 0) {
            this.installManagement(Objects.requireNonNull(this.getHelperPath(PIP_WHEEL_NAME)));
        }
    }

    protected final boolean updatePackagingTools() {
        try {
            this.installUsingPipWheel("--upgrade", "--force-reinstall", "setuptools", "pip");
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    public boolean hasManagement() throws ExecutionException {
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(this.getSdk());
        Boolean hasSetuptools = languageLevel.isAtLeast(LanguageLevel.PYTHON312) || this.refreshAndCheckForSetuptools() != null;
        Boolean hasPip = PyPsiPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip") != null;
        return hasSetuptools != false && hasPip != false;
    }

    @Nullable
    protected final PyPackage refreshAndCheckForSetuptools() throws ExecutionException {
        try {
            List<PyPackage> packages2 = this.refreshAndGetPackages(false);
            PyPackage setuptoolsPackage = PyPsiPackageUtil.findPackage(packages2, "setuptools");
            return setuptoolsPackage != null ? setuptoolsPackage : PyPsiPackageUtil.findPackage(packages2, "distribute");
        }
        catch (PyExecutionException e) {
            if (e.getExitCode() == 3) {
                return null;
            }
            throw e;
        }
    }

    protected void installManagement(@NotNull String name2) throws ExecutionException {
        if (name2 == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(0);
        }
        this.installUsingPipWheel("--no-index", name2);
    }

    protected abstract void installUsingPipWheel(String ... var1) throws ExecutionException;

    protected PyPackageManagerImplBase(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(1);
        }
        super(sdk2);
        this.mySeparator = File.separator;
        this.myPackagesCache = null;
        this.myUpdatingCache = new AtomicBoolean(false);
    }

    @Override
    @NotNull
    public Set<PyPackage> getDependents(@NotNull PyPackage pkg) throws ExecutionException {
        if (pkg == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(2);
        }
        List<PyPackage> packages2 = this.refreshAndGetPackages(false);
        HashSet<PyPackage> dependents = new HashSet<PyPackage>();
        for (PyPackage p : packages2) {
            List<PyRequirement> requirements2 = p.getRequirements();
            for (PyRequirement requirement : requirements2) {
                if (!requirement.getName().equals(pkg.getName())) continue;
                dependents.add(p);
            }
        }
        HashSet<PyPackage> hashSet = dependents;
        if (hashSet == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    protected static LanguageLevel getOrRequestLanguageLevelForSdk(@NotNull Sdk sdk2) throws ExecutionException {
        if (sdk2 == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(4);
        }
        if (sdk2 instanceof PyDetectedSdk) {
            PythonSdkFlavor<?> flavor = PythonSdkFlavor.getFlavor(sdk2);
            if (flavor != null && sdk2.getHomePath() != null) {
                LanguageLevel languageLevel = flavor.getLanguageLevel(sdk2.getHomePath());
                if (languageLevel == null) {
                    PyPackageManagerImplBase.$$$reportNull$$$0(5);
                }
                return languageLevel;
            }
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.cannot.retrieve.version", sdk2.getHomePath()));
        }
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk2);
        if (languageLevel == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(6);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public List<PyRequirement> getRequirements(@NotNull Module module) {
        if (module == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(7);
        }
        return Optional.ofNullable(PyPackageUtil.getRequirementsFromTxt(module)).orElseGet(() -> PyPackageUtil.findSetupPyRequires(module));
    }

    @Override
    @Nullable
    public PyRequirement parseRequirement(@NotNull String line2) {
        if (line2 == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(8);
        }
        return PyRequirementParser.fromLine(line2);
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull String text) {
        if (text == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(9);
        }
        List<PyRequirement> list = PyRequirementParser.fromText(text);
        if (list == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull VirtualFile file) {
        if (file == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(11);
        }
        List<PyRequirement> list = PyRequirementParser.fromFile(file);
        if (list == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @NotNull
    public final List<PyPackage> refreshAndGetPackages(boolean alwaysRefresh) throws ExecutionException {
        List<PyPackage> currentPackages = this.myPackagesCache;
        if (alwaysRefresh || currentPackages == null) {
            List<PyPackage> list;
            this.myPackagesCache = null;
            try {
                List<PyPackage> packages2 = this.collectPackages();
                LOG.debug("Packages installed in " + this.getSdk().getName() + ": " + packages2);
                this.myPackagesCache = packages2;
                ((PyPackageManager.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PACKAGE_MANAGER_TOPIC)).packagesRefreshed(this.getSdk());
                list = Collections.unmodifiableList(packages2);
            }
            catch (ExecutionException e) {
                this.myPackagesCache = Collections.emptyList();
                throw e;
            }
            if (list == null) {
                PyPackageManagerImplBase.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<PyPackage> list = Collections.unmodifiableList(currentPackages);
        if (list == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    protected abstract List<PyPackage> collectPackages() throws ExecutionException;

    protected final void refreshPackagesSynchronously() {
        PyPackageUtil.updatePackagesSynchronouslyWithGuard(this, this.myUpdatingCache);
    }

    @Nullable
    protected static String getProxyString() {
        HttpConfigurable settings = HttpConfigurable.getInstance();
        if (settings != null && settings.USE_HTTP_PROXY) {
            String credentials = settings.PROXY_AUTHENTICATION ? String.format("%s:%s@", settings.getProxyLogin(), settings.getPlainProxyPassword()) : "";
            return "http://" + credentials + String.format("%s:%d", settings.PROXY_HOST, settings.PROXY_PORT);
        }
        return null;
    }

    @Nullable
    protected String getHelperPath(@NotNull String helper) throws ExecutionException {
        if (helper == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(15);
        }
        return PythonHelpersLocator.findPathStringInHelpers(helper);
    }

    @NotNull
    protected static List<String> makeSafeToDisplayCommand(@NotNull List<String> cmdline) {
        if (cmdline == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(16);
        }
        ArrayList<String> safeCommand = new ArrayList<String>(cmdline);
        for (int i = 0; i < safeCommand.size(); ++i) {
            if (cmdline.get(i).equals("--proxy") && i + 1 < cmdline.size()) {
                safeCommand.set(i + 1, PyPackageManagerImplBase.makeSafeUrlArgument(cmdline.get(i + 1)));
            }
            if (!cmdline.get(i).equals("--index-url") || i + 1 >= cmdline.size()) continue;
            safeCommand.set(i + 1, PyPackageManagerImplBase.makeSafeUrlArgument(cmdline.get(i + 1)));
        }
        ArrayList<String> arrayList = safeCommand;
        if (arrayList == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private static String makeSafeUrlArgument(@NotNull String urlArgument) {
        block7: {
            String string;
            String maskedCredentials;
            String password;
            String login;
            block8: {
                int colonIndex;
                if (urlArgument == null) {
                    PyPackageManagerImplBase.$$$reportNull$$$0(18);
                }
                URI proxyUri = new URI(urlArgument);
                String credentials = proxyUri.getUserInfo();
                if (credentials == null || (colonIndex = credentials.indexOf(":")) < 0) break block7;
                login = credentials.substring(0, colonIndex);
                password = credentials.substring(colonIndex + 1);
                String maskedPassword = StringUtil.repeatSymbol((char)'*', (int)password.length());
                maskedCredentials = login + ":" + maskedPassword;
                if (!urlArgument.contains(credentials)) break block8;
                String string2 = urlArgument.replaceFirst(Pattern.quote(credentials), maskedCredentials);
                if (string2 == null) {
                    PyPackageManagerImplBase.$$$reportNull$$$0(19);
                }
                return string2;
            }
            try {
                String encodedCredentials = PyPackageRepositoryUtil.encodeCredentialsForUrl(login, password);
                string = urlArgument.replaceFirst(Pattern.quote(encodedCredentials), maskedCredentials);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (string == null) {
                PyPackageManagerImplBase.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = urlArgument;
        if (string == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    protected final List<PyPackage> parsePackagingToolOutput(@NotNull String output2) throws PyExecutionException {
        if (output2 == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(22);
        }
        ArrayList<PyPackage> packages2 = new ArrayList<PyPackage>();
        for (String line2 : StringUtil.splitByLines((String)output2)) {
            PyPackage pkg = this.parsePackaging(line2, "\t", true, PySdkBundle.message("python.sdk.packaging.invalid.output.format", new Object[0]), PACKAGING_TOOL);
            if (pkg == null) continue;
            packages2.add(pkg);
        }
        ArrayList<PyPackage> arrayList = packages2;
        if (arrayList == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @Nullable
    protected final PyPackage parsePackaging(@NotNull @NonNls String line2, @NotNull @NonNls String separator, boolean useLocation, @NotNull @Nls String errorMessage, @NotNull @NonNls String command) throws PyExecutionException {
        List<PyRequirement> requirements2;
        List fields;
        if (line2 == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(24);
        }
        if (separator == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(25);
        }
        if (errorMessage == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(26);
        }
        if (command == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(27);
        }
        if ((fields = StringUtil.split((String)line2, (String)separator)).size() < 3) {
            throw new PyExecutionException(errorMessage, command, List.of());
        }
        String name2 = (String)fields.get(0);
        List<PyRequirement> list = requirements2 = fields.size() >= 4 ? this.parseRequirements(PyPackageManagerImplBase.toMultilineString((String)fields.get(3))) : List.of();
        return "Python".equals(name2) ? null : new PyPackage(name2, (String)fields.get(1), useLocation ? (String)fields.get(2) : "", requirements2);
    }

    @NotNull
    private static String toMultilineString(@NotNull String string) {
        if (string == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(28);
        }
        String string2 = StringUtil.join((Collection)StringUtil.split((String)string, (String)":"), (String)"\n");
        if (string2 == null) {
            PyPackageManagerImplBase.$$$reportNull$$$0(29);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 10, 12, 13, 14, 17, 19, 20, 21, 23, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerImplBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdline";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlArgument";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerImplBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependents";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRequirements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackages";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeToDisplayCommand";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeUrlArgument";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackagingToolOutput";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toMultilineString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installManagement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDependents";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRequirements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirement";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHelperPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeToDisplayCommand";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeUrlArgument";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parsePackagingToolOutput";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parsePackaging";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toMultilineString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 10, 12, 13, 14, 17, 19, 20, 21, 23, 29 -> new IllegalStateException(string);
        };
    }
}

