/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyPep8NamingInspection
extends PyInspection {
    private static final String INSPECTION_SHORT_NAME = "PyPep8NamingInspection";
    private static final Pattern LOWERCASE_REGEX = Pattern.compile("[_\\p{javaLowerCase}][_\\p{javaLowerCase}0-9]*");
    private static final Pattern UPPERCASE_REGEX = Pattern.compile("[_\\p{javaUpperCase}][_\\p{javaUpperCase}0-9]*");
    private static final Pattern MIXEDCASE_REGEX = Pattern.compile("_?_?[\\p{javaUpperCase}][\\p{javaLowerCase}\\p{javaUpperCase}0-9]*");
    private static final Map<String, Supplier<@InspectionMessage String>> ERROR_CODES_DESCRIPTION = Map.of("N801", PyPsiBundle.messagePointer("INSP.pep8.naming.class.names.should.use.capwords.convention", new Object[0]), "N802", PyPsiBundle.messagePointer("INSP.pep8.naming.function.name.should.be.lowercase", new Object[0]), "N803", PyPsiBundle.messagePointer("INSP.pep8.naming.argument.name.should.be.lowercase", new Object[0]), "N806", PyPsiBundle.messagePointer("INSP.pep8.naming.variable.in.function.should.be.lowercase", new Object[0]), "N811", PyPsiBundle.messagePointer("INSP.pep8.naming.constant.variable.imported.as.non.constant", new Object[0]), "N812", PyPsiBundle.messagePointer("INSP.pep8.naming.lowercase.variable.imported.as.non.lowercase", new Object[0]), "N813", PyPsiBundle.messagePointer("INSP.pep8.naming.camelcase.variable.imported.as.lowercase", new Object[0]), "N814", PyPsiBundle.messagePointer("INSP.pep8.naming.camelcase.variable.imported.as.constant", new Object[0]));
    public final List<String> ignoredErrors = new ArrayList<String>();
    public boolean ignoreOverriddenFunctions = true;
    public final List<String> ignoredBaseClasses = Lists.newArrayList((Object[])new String[]{"unittest.TestCase", "unittest.case.TestCase"});

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreOverriddenFunctions", (String)PyPsiBundle.message("ignore.overridden.functions", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.horizontalStack((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"ignoredBaseClasses", (String)PyPsiBundle.message("INSP.pep8.naming.column.name.excluded.base.classes", new Object[0])), OptPane.stringList((String)"ignoredErrors", (String)PyPsiBundle.message("INSP.pep8.naming.column.name.ignored.errors", new Object[0]))})});
        if (optPane == null) {
            PyPep8NamingInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    private static void addFunctionQuickFixes(ProblemsHolder holder, PyClass containingClass, ASTNode nameNode, List<LocalQuickFix> quickFixes, TypeEvalContext typeEvalContext) {
        LocalQuickFix qf;
        if (holder != null && holder.isOnTheFly() && (qf = PythonUiService.getInstance().createPyRenameElementQuickFix(nameNode.getPsi())) != null) {
            quickFixes.add(qf);
        }
        if (containingClass != null) {
            quickFixes.add(new IgnoreBaseClassQuickFix(containingClass, typeEvalContext));
        }
    }

    private LocalQuickFix[] createRenameAndIgnoreErrorQuickFixes(@Nullable PsiElement node, String errorCode) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (node != null) {
            LocalQuickFix qf = PythonUiService.getInstance().createPyRenameElementQuickFix(node);
            if (qf != null) {
                fixes.add(qf);
            }
            fixes.add(new IgnoreErrorFix(errorCode));
        }
        return fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPep8NamingInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyPep8NamingInspection.$$$reportNull$$$0(2);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyPep8NamingInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyPep8NamingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class IgnoreBaseClassQuickFix
    implements LocalQuickFix {
        private final List<String> myBaseClassNames;

        IgnoreBaseClassQuickFix(@NotNull PyClass baseClass, @NotNull TypeEvalContext context) {
            if (baseClass == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(0);
            }
            if (context == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(1);
            }
            this.myBaseClassNames = new ArrayList<String>();
            ContainerUtil.addIfNotNull(this.getBaseClassNames(), (Object)baseClass.getQualifiedName());
            for (PyClass ancestor : baseClass.getAncestorClasses(context)) {
                ContainerUtil.addIfNotNull(this.getBaseClassNames(), (Object)ancestor.getQualifiedName());
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.pep8.ignore.method.names.for.descendants.of.class", new Object[0]);
            if (string == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            if (project2 == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(4);
            }
            PythonUiService.getInstance().showPopup(project2, this.getBaseClassNames(), PyPsiBundle.message("INSP.pep8.ignore.base.class", new Object[0]), (Consumer<String>)((Consumer)selectedValue -> InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project2, it -> {
                PyPep8NamingInspection inspection = (PyPep8NamingInspection)it.getUnwrappedTool(PyPep8NamingInspection.class.getSimpleName(), descriptor2.getPsiElement());
                ContainerUtil.addIfNotNull(inspection.ignoredBaseClasses, (Object)selectedValue);
            })));
        }

        public List<String> getBaseClassNames() {
            return this.myBaseClassNames;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull ProblemDescriptor previewDescriptor) {
            if (project2 == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(5);
            }
            if (previewDescriptor == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(6);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                IgnoreBaseClassQuickFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 7: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 7 -> new IllegalStateException(string);
            };
        }
    }

    protected class IgnoreErrorFix
    implements LocalQuickFix {
        private final String myCode;

        IgnoreErrorFix(String code) {
            this.myCode = code;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.NAME.ignore.errors.like.this", new Object[0]);
            if (string == null) {
                IgnoreErrorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull ProblemDescriptor previewDescriptor) {
            if (project2 == null) {
                IgnoreErrorFix.$$$reportNull$$$0(1);
            }
            if (previewDescriptor == null) {
                IgnoreErrorFix.$$$reportNull$$$0(2);
            }
            if (PyPep8NamingInspection.this.ignoredErrors.contains(this.myCode)) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    IgnoreErrorFix.$$$reportNull$$$0(3);
                }
                return intentionPreviewInfo;
            }
            ArrayList<String> updated = new ArrayList<String>(PyPep8NamingInspection.this.ignoredErrors);
            updated.add(this.myCode);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.addListOption(updated, (String)this.myCode, (String)PyPsiBundle.message("INSP.pep8.naming.column.name.ignored.errors", new Object[0]));
            if (intentionPreviewInfo == null) {
                IgnoreErrorFix.$$$reportNull$$$0(4);
            }
            return intentionPreviewInfo;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            if (project2 == null) {
                IgnoreErrorFix.$$$reportNull$$$0(5);
            }
            if (descriptor2 == null) {
                IgnoreErrorFix.$$$reportNull$$$0(6);
            }
            PsiFile file = descriptor2.getStartElement().getContainingFile();
            InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project2, model2 -> {
                PyPep8NamingInspection tool = (PyPep8NamingInspection)model2.getUnwrappedTool(PyPep8NamingInspection.INSPECTION_SHORT_NAME, (PsiElement)file);
                if (!tool.ignoredErrors.contains(this.myCode)) {
                    tool.ignoredErrors.add(this.myCode);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreErrorFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreErrorFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    public class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            PyFunction function;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)true, (Class[])new Class[]{PyClass.class})) == null) {
                return;
            }
            Scope scope = ControlFlowCache.getScope(function);
            for (Pair<PyExpression, PyExpression> pair : node.getTargetsToValuesMapping()) {
                PyExpression qualifier;
                String name2;
                PyExpression value = (PyExpression)pair.getFirst();
                if (value == null || (name2 = value.getName()) == null || scope.isGlobal(name2)) continue;
                if (value instanceof PyTargetExpression && (qualifier = ((PyTargetExpression)value).getQualifier()) != null) {
                    return;
                }
                PyCallExpression assignedValue = PyUtil.as(pair.getSecond(), PyCallExpression.class);
                if (assignedValue != null && assignedValue.getCallee() != null && "namedtuple".equals(assignedValue.getCallee().getName())) {
                    return;
                }
                String errorCode = "N806";
                if (LOWERCASE_REGEX.matcher(name2).matches() || name2.startsWith("_") || PyPep8NamingInspection.this.ignoredErrors.contains("N806")) continue;
                this.registerAndAddRenameAndIgnoreErrorQuickFixes((PsiElement)value, "N806");
            }
        }

        @Override
        public void visitPyParameter(@NotNull PyParameter node) {
            String name2;
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((name2 = node.getName()) == null) {
                return;
            }
            String errorCode = "N803";
            if (!LOWERCASE_REGEX.matcher(name2).matches() && !PyPep8NamingInspection.this.ignoredErrors.contains("N803")) {
                this.registerAndAddRenameAndIgnoreErrorQuickFixes((PsiElement)node, "N803");
            }
        }

        protected void registerAndAddRenameAndIgnoreErrorQuickFixes(@Nullable PsiElement node, @NotNull String errorCode) {
            if (errorCode == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (this.getHolder() != null && this.getHolder().isOnTheFly()) {
                this.registerProblem(node, ERROR_CODES_DESCRIPTION.get(errorCode).get(), PyPep8NamingInspection.this.createRenameAndIgnoreErrorQuickFixes(node, errorCode));
            } else {
                this.registerProblem(node, ERROR_CODES_DESCRIPTION.get(errorCode).get(), new IgnoreErrorFix(errorCode));
            }
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction function) {
            ASTNode nameNode;
            if (function == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            PyClass containingClass = function.getContainingClass();
            if (PyPep8NamingInspection.this.ignoreOverriddenFunctions && this.isOverriddenMethod(function)) {
                return;
            }
            String name2 = function.getName();
            if (name2 == null) {
                return;
            }
            if (containingClass != null && (PyUtilCore.isSpecialName((String)name2) || this.isIgnoredOrHasIgnoredAncestor(containingClass))) {
                return;
            }
            if (!LOWERCASE_REGEX.matcher(name2).matches() && (nameNode = function.getNameNode()) != null) {
                ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
                PyPep8NamingInspection.addFunctionQuickFixes(this.getHolder(), containingClass, nameNode, quickFixes, this.myTypeEvalContext);
                String errorCode = "N802";
                if (!PyPep8NamingInspection.this.ignoredErrors.contains("N802")) {
                    quickFixes.add(new IgnoreErrorFix("N802"));
                    this.registerProblem(nameNode.getPsi(), ERROR_CODES_DESCRIPTION.get("N802").get(), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }

        private boolean isOverriddenMethod(@NotNull PyFunction function) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            return PySuperMethodsSearch.search(function, this.myTypeEvalContext).findFirst() != null;
        }

        private boolean isIgnoredOrHasIgnoredAncestor(@NotNull PyClass pyClass) {
            HashSet blackList;
            if (pyClass == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if ((blackList = Sets.newHashSet(PyPep8NamingInspection.this.ignoredBaseClasses)).contains(pyClass.getQualifiedName())) {
                return true;
            }
            for (PyClassLikeType ancestor : pyClass.getAncestorTypes(this.myTypeEvalContext)) {
                if (ancestor == null || !blackList.contains(ancestor.getClassQName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            String name2;
            if (node == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if ((name2 = node.getName()) == null) {
                return;
            }
            String errorCode = "N801";
            if (!PyPep8NamingInspection.this.ignoredErrors.contains("N801")) {
                ASTNode nameNode;
                boolean isLowercaseContextManagerClass;
                boolean bl = isLowercaseContextManagerClass = this.isContextManager(node) && LOWERCASE_REGEX.matcher(name2).matches();
                if (!isLowercaseContextManagerClass && !MIXEDCASE_REGEX.matcher(name2).matches() && (nameNode = node.getNameNode()) != null) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(nameNode.getPsi(), "N801");
                }
            }
        }

        private boolean isContextManager(PyClass node) {
            String[] contextManagerFunctionNames;
            for (String name2 : contextManagerFunctionNames = new String[]{"__enter__", "__exit__"}) {
                if (node.findMethodByName(name2, false, this.myTypeEvalContext) != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public void visitPyImportElement(@NotNull PyImportElement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            String asName = node.getAsName();
            QualifiedName importedQName = node.getImportedQName();
            if (importedQName == null) {
                return;
            }
            String name2 = importedQName.getLastComponent();
            if (asName == null || name2 == null) {
                return;
            }
            if (UPPERCASE_REGEX.matcher(name2).matches()) {
                String errorCode = "N811";
                if (!UPPERCASE_REGEX.matcher(asName).matches() && !PyPep8NamingInspection.this.ignoredErrors.contains("N811")) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(node.getAsNameElement(), "N811");
                }
            } else if (LOWERCASE_REGEX.matcher(name2).matches()) {
                String errorCode = "N812";
                if (!LOWERCASE_REGEX.matcher(asName).matches() && !PyPep8NamingInspection.this.ignoredErrors.contains("N812")) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(node.getAsNameElement(), "N812");
                }
            } else if (LOWERCASE_REGEX.matcher(asName).matches()) {
                String errorCode = "N813";
                if (!PyPep8NamingInspection.this.ignoredErrors.contains("N813")) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(node.getAsNameElement(), "N813");
                }
            } else if (UPPERCASE_REGEX.matcher(asName).matches()) {
                String errorCode = "N814";
                if (!PyPep8NamingInspection.this.ignoredErrors.contains("N814")) {
                    this.registerAndAddRenameAndIgnoreErrorQuickFixes(node.getAsNameElement(), "N814");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorCode";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyClass";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPep8NamingInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAssignmentStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyParameter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerAndAddRenameAndIgnoreErrorQuickFixes";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOverriddenMethod";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIgnoredOrHasIgnoredAncestor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyImportElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

