/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyClassVarInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyClassVarInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\nH\u0016J\f\u0010#\u001a\u00020\r*\u00020\nH\u0002J\u001f\u0010$\u001a\u00020\r\"\f\b\u0000\u0010%*\u00020&*\u00020'*\u0002H%H\u0002\u00a2\u0006\u0002\u0010(\u00a8\u0006)"}, d2={"Lcom/jetbrains/python/inspections/PyClassVarInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "checkClassVarDeclaration", "", "target", "Lcom/jetbrains/python/psi/PyTargetExpression;", "checkClassVarReassignment", "checkDoesNotIncludeTypeVars", "", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "typeComment", "Lcom/intellij/psi/PsiComment;", "checkInheritedClassClassVarReassignmentOnClassLevel", "cls", "Lcom/jetbrains/python/psi/PyClass;", "checkInstanceClassVarReassignment", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "resolvesToClassVar", "toExpression", "contents", "", "anchor", "Lcom/intellij/psi/PsiElement;", "visitPyFunction", "node", "Lcom/jetbrains/python/psi/PyFunction;", "visitPyNamedParameter", "Lcom/jetbrains/python/psi/PyNamedParameter;", "visitPyTargetExpression", "hasExplicitType", "isClassVar", "T", "Lcom/jetbrains/python/psi/PyAnnotationOwner;", "Lcom/jetbrains/python/psi/PyTypeCommentOwner;", "(Lcom/jetbrains/python/psi/PyAnnotationOwner;)Z", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyClassVarInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyClassVarInspection.kt\ncom/jetbrains/python/inspections/PyClassVarInspection$Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1#2:166\n1855#3,2:167\n1747#3,3:169\n*S KotlinDebug\n*F\n+ 1 PyClassVarInspection.kt\ncom/jetbrains/python/inspections/PyClassVarInspection$Visitor\n*L\n128#1:167,2\n161#1:169,3\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            block7: {
                Object typeExpression;
                Object object;
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        super.visitPyTargetExpression(node);
                        if (node.hasAssignedValue()) {
                            if (node.isQualified()) {
                                this.checkClassVarReassignment(node);
                            } else {
                                this.checkClassVarDeclaration(node);
                            }
                        }
                        if (!this.isClassVar((PyAnnotationOwner)node)) break block7;
                        object = node.getTypeCommentAnnotation();
                        if (object == null) break block8;
                        String it = object;
                        boolean bl = false;
                        PyExpression pyExpression = this.toExpression(it, node);
                        object = pyExpression;
                        if (pyExpression != null) break block9;
                    }
                    PyAnnotation pyAnnotation = node.getAnnotation();
                    object = pyAnnotation != null ? pyAnnotation.getValue() : null;
                }
                if ((typeExpression = object) != null) {
                    this.checkDoesNotIncludeTypeVars((PyExpression)typeExpression, node.getTypeComment());
                }
            }
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyNamedParameter(node);
            if (this.isClassVar((PyAnnotationOwner)node)) {
                PyElement pyElement = (PyAnnotation)node.getAnnotation();
                this.registerProblem(pyElement != null && (pyElement = pyElement.getValue()) != null ? (PsiElement)pyElement : (PsiElement)node.getTypeComment(), PyPsiBundle.message("INSP.class.var.can.not.be.used.in.annotations.for.function.parameters", new Object[0]));
            }
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super.visitPyFunction(node);
                PyExpression pyExpression = PyTypingTypeProvider.getReturnTypeAnnotation(node, this.myTypeEvalContext);
                if (pyExpression == null) break block3;
                PyExpression it = pyExpression;
                boolean bl = false;
                PyExpression pyExpression2 = it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it;
                Intrinsics.checkNotNull((Object)pyExpression2);
                if (this.resolvesToClassVar(pyExpression2)) {
                    PsiElement psiElement;
                    PsiComment psiComment = node.getTypeComment();
                    if (psiComment != null) {
                        psiElement = (PsiElement)psiComment;
                    } else {
                        PyAnnotation pyAnnotation = (PyAnnotation)node.getAnnotation();
                        psiElement = (PsiElement)(pyAnnotation != null ? pyAnnotation.getValue() : null);
                    }
                    this.registerProblem(psiElement, PyPsiBundle.message("INSP.class.var.can.not.be.used.in.annotation.for.function.return.value", new Object[0]));
                }
            }
        }

        private final void checkClassVarDeclaration(PyTargetExpression target) {
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(target);
            if (scopeOwner instanceof PyFile) {
                if (PyUtil.isTopLevel(target) && this.isClassVar((PyAnnotationOwner)target)) {
                    PsiElement psiElement;
                    PsiComment psiComment = target.getTypeComment();
                    if (psiComment != null) {
                        psiElement = (PsiElement)psiComment;
                    } else {
                        PyAnnotation pyAnnotation = target.getAnnotation();
                        psiElement = (PsiElement)(pyAnnotation != null ? pyAnnotation.getValue() : null);
                    }
                    this.registerProblem(psiElement, PyPsiBundle.message("INSP.class.var.can.be.used.only.in.class.body", new Object[0]));
                }
            } else if (scopeOwner instanceof PyFunction) {
                if (this.isClassVar((PyAnnotationOwner)target)) {
                    PsiElement psiElement;
                    PsiComment psiComment = target.getTypeComment();
                    if (psiComment != null) {
                        psiElement = (PsiElement)psiComment;
                    } else {
                        PyAnnotation pyAnnotation = target.getAnnotation();
                        psiElement = (PsiElement)(pyAnnotation != null ? pyAnnotation.getValue() : null);
                    }
                    this.registerProblem(psiElement, PyPsiBundle.message("INSP.class.var.can.not.be.used.in.function.body", new Object[0]));
                }
            } else if (scopeOwner instanceof PyClass) {
                this.checkInheritedClassClassVarReassignmentOnClassLevel(target, (PyClass)scopeOwner);
            }
        }

        private final void checkClassVarReassignment(PyTargetExpression target) {
            PyType qualifierType;
            PyExpression pyExpression = target.getQualifier();
            if (pyExpression != null) {
                PyExpression it = pyExpression;
                boolean bl = false;
                v1 = this.myTypeEvalContext.getType(it);
            } else {
                v1 = qualifierType = null;
            }
            if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isDefinition()) {
                PyQualifiedExpression pyQualifiedExpression = target;
                PyClass pyClass = ((PyClassType)qualifierType).getPyClass();
                Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
                this.checkInstanceClassVarReassignment(pyQualifiedExpression, pyClass);
            }
        }

        private final void checkInheritedClassClassVarReassignmentOnClassLevel(PyTargetExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            String name2 = string;
            for (PyClass ancestor : cls.getAncestorClasses(this.myTypeEvalContext)) {
                PyTargetExpression ancestorClassAttribute = ancestor.findClassAttribute(name2, false, this.myTypeEvalContext);
                if (ancestorClassAttribute == null || !this.hasExplicitType(ancestorClassAttribute) || !this.hasExplicitType(target)) continue;
                if (this.isClassVar((PyAnnotationOwner)ancestorClassAttribute) && !this.isClassVar((PyAnnotationOwner)target)) {
                    Object[] objectArray = new Object[]{name2, ancestor.getName()};
                    this.registerProblem(target, PyPsiBundle.message("INSP.class.var.can.not.override.class.variable", objectArray));
                    break;
                }
                if (this.isClassVar((PyAnnotationOwner)ancestorClassAttribute) || !this.isClassVar((PyAnnotationOwner)target)) continue;
                Object[] objectArray = new Object[]{name2, ancestor.getName()};
                this.registerProblem(target, PyPsiBundle.message("INSP.class.var.can.not.override.instance.variable", objectArray));
                break;
            }
        }

        private final void checkInstanceClassVarReassignment(PyQualifiedExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            String name2 = string;
            Collection collection = CollectionsKt.listOf((Object)cls);
            List<PyClass> list = cls.getAncestorClasses(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAncestorClasses(...)");
            for (PyClass ancestor : CollectionsKt.plus((Collection)collection, (Iterable)list)) {
                PyTargetExpression inheritedClassAttribute = ancestor.findClassAttribute(name2, false, this.myTypeEvalContext);
                if (inheritedClassAttribute == null || !this.isClassVar((PyAnnotationOwner)inheritedClassAttribute)) continue;
                Object[] objectArray = new Object[]{name2};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.class.var.can.not.be.assigned.to.instance", objectArray));
                return;
            }
        }

        private final boolean checkDoesNotIncludeTypeVars(PyExpression expression, PsiComment typeComment) {
            PyExpression element = expression;
            while (element instanceof PySubscriptionExpression) {
                element = ((PySubscriptionExpression)element).getIndexExpression();
            }
            PyExpression pyExpression = element;
            if (pyExpression instanceof PyTupleExpression) {
                Iterable $this$forEach$iv = (Iterable)((Object)element);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PyExpression tupleElement = (PyExpression)element$iv;
                    boolean bl = false;
                    boolean reported = this.checkDoesNotIncludeTypeVars(tupleElement, typeComment);
                    if (!reported || typeComment == null) continue;
                    return true;
                }
            } else if (pyExpression instanceof PyReferenceExpression) {
                PyType type2;
                Ref<PyType> ref = PyTypingTypeProvider.getType(element, this.myTypeEvalContext);
                PyType pyType = type2 = ref != null ? (PyType)ref.get() : null;
                if (type2 instanceof PyTypeVarType) {
                    PsiComment psiComment = typeComment;
                    this.registerProblem(psiComment != null ? (PsiElement)psiComment : (PsiElement)element, PyPsiBundle.message("INSP.class.var.can.not.include.type.variables", new Object[0]));
                    return true;
                }
            }
            return false;
        }

        private final PyExpression toExpression(String contents, PsiElement anchor) {
            PsiFile psiFile = FileContextUtil.getContextFile((PsiElement)anchor);
            if (psiFile == null) {
                return null;
            }
            PsiFile file = psiFile;
            return PyUtil.createExpressionFromFragment(contents, (PsiElement)file);
        }

        private final boolean hasExplicitType(PyTargetExpression $this$hasExplicitType) {
            return $this$hasExplicitType.getAnnotationValue() != null || $this$hasExplicitType.getTypeCommentAnnotation() != null;
        }

        private final <T extends PyAnnotationOwner & PyTypeCommentOwner> boolean isClassVar(T $this$isClassVar) {
            return PyTypingTypeProvider.isClassVar($this$isClassVar, this.myTypeEvalContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean resolvesToClassVar(PyExpression expression) {
            String it;
            if (!(expression instanceof PyReferenceExpression)) return false;
            Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual((Object)it, (Object)"typing.ClassVar"));
            return true;
        }
    }
}

