/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.documentation.PyDocSignaturesHighlighterKt;
import com.jetbrains.python.documentation.PyDocumentationLink$possibleFunction$;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\"\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\"\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u000b\u0010\u001e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001fH\u0007J\u0012\u0010 \u001a\u00020\u001c2\b\b\u0001\u0010!\u001a\u00020\u0004H\u0007J\u001a\u0010\"\u001a\u00020\u001c2\b\b\u0001\u0010!\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0017H\u0007J\u001a\u0010$\u001a\u00020\u001c2\b\b\u0001\u0010!\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\"\u0010%\u001a\u00020\u001c2\b\b\u0001\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J%\u0010&\u001a\u00020\u001c2\u000b\u0010'\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010(\u001a\u00020\u001c2\b\b\u0001\u0010!\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/python/documentation/PyDocumentationLink;", "", "()V", "LINK_TYPE_CLASS", "", "LINK_TYPE_FUNC", "LINK_TYPE_MODULE", "LINK_TYPE_PARAM", "LINK_TYPE_TYPENAME", "containingClass", "Lcom/jetbrains/python/psi/PyClass;", "element", "Lcom/intellij/psi/PsiElement;", "elementForLink", "link", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "parameterPossibleClass", "parameter", "possibleClass", "type", "anchor", "possibleFunction", "Lcom/jetbrains/python/psi/PyFunction;", "qualifiedName", "possibleModule", "Lcom/jetbrains/python/psi/PyFile;", "toClass", "Lcom/intellij/openapi/util/text/HtmlChunk;", "pyClass", "linkText", "Lorg/jetbrains/annotations/Nls;", "toContainingClass", "content", "toFunction", "func", "toModule", "toParameterPossibleClass", "toPossibleClass", "typeName", "toTypeAliasStatement", "typeAliasStatement", "Lcom/jetbrains/python/psi/PyTypeAliasStatement;", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyDocumentationLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDocumentationLink.kt\ncom/jetbrains/python/documentation/PyDocumentationLink\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,162:1\n800#2,11:163\n1549#2:174\n1620#2,3:175\n800#2,11:178\n800#2,11:189\n473#3:200\n*S KotlinDebug\n*F\n+ 1 PyDocumentationLink.kt\ncom/jetbrains/python/documentation/PyDocumentationLink\n*L\n109#1:163,11\n110#1:174\n110#1:175,3\n111#1:178,11\n122#1:189,11\n129#1:200\n*E\n"})
public final class PyDocumentationLink {
    @NotNull
    public static final PyDocumentationLink INSTANCE = new PyDocumentationLink();
    @NotNull
    private static final String LINK_TYPE_CLASS = "#class#";
    @NotNull
    private static final String LINK_TYPE_PARAM = "#param#";
    @NotNull
    private static final String LINK_TYPE_TYPENAME = "#typename#";
    @NotNull
    private static final String LINK_TYPE_FUNC = "#func#";
    @NotNull
    private static final String LINK_TYPE_MODULE = "#module#";

    private PyDocumentationLink() {
    }

    @JvmStatic
    @NotNull
    public static final HtmlChunk toContainingClass(@NlsSafe @NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        HtmlChunk.Element element = HtmlChunk.link((String)"psi_element://#class#", (String)content2);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(...)");
        return (HtmlChunk)element;
    }

    @JvmStatic
    @NotNull
    public static final HtmlChunk toParameterPossibleClass(@NlsSafe @NotNull String type2, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        HtmlChunk htmlChunk;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (PyTypeParser.getTypeByName(anchor, type2, context) instanceof PyClassType) {
            HtmlChunk.Element element = HtmlChunk.link((String)"psi_element://#param#", (String)type2);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(...)");
            htmlChunk = (HtmlChunk)element;
        } else {
            HtmlChunk htmlChunk2 = HtmlChunk.text((String)type2);
            htmlChunk = htmlChunk2;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"text(...)");
        }
        return htmlChunk;
    }

    @JvmStatic
    @NotNull
    public static final HtmlChunk toPossibleClass(@NotNull String typeName, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        HtmlChunk htmlChunk;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyType type2 = PyTypeParser.getTypeByName(anchor, typeName, context);
        if (type2 instanceof PyClassType) {
            PyClass pyClass = ((PyClassType)type2).getPyClass();
            Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
            HtmlChunk htmlChunk2 = PyDocumentationLink.toClass(pyClass, typeName);
            PyClass pyClass2 = ((PyClassType)type2).getPyClass();
            Intrinsics.checkNotNullExpressionValue((Object)pyClass2, (String)"getPyClass(...)");
            htmlChunk = PyDocSignaturesHighlighterKt.styledReference(htmlChunk2, pyClass2);
        } else if (type2 instanceof PyNoneType) {
            TextAttributesKey textAttributesKey = PyHighlighter.PY_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"PY_KEYWORD");
            htmlChunk = PyDocSignaturesHighlighterKt.styledSpan(typeName, textAttributesKey);
        } else {
            HtmlChunk htmlChunk3 = HtmlChunk.text((String)typeName);
            htmlChunk = htmlChunk3;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk3, (String)"text(...)");
        }
        return htmlChunk;
    }

    @JvmStatic
    @NotNull
    public static final HtmlChunk toClass(@NotNull PyClass pyClass, @NotNull String linkText) {
        Intrinsics.checkNotNullParameter((Object)pyClass, (String)"pyClass");
        Intrinsics.checkNotNullParameter((Object)linkText, (String)"linkText");
        String qualifiedName = pyClass.getQualifiedName();
        HtmlChunk.Element element = HtmlChunk.link((String)("psi_element://#typename#" + qualifiedName), (String)linkText);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(...)");
        return (HtmlChunk)element;
    }

    @JvmStatic
    @NotNull
    public static final HtmlChunk toFunction(@NlsSafe @NotNull String content2, @NotNull PyFunction func) {
        HtmlChunk htmlChunk;
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)func, (String)"func");
        String qualifiedName = func.getQualifiedName();
        String string = qualifiedName;
        if (string != null) {
            HtmlChunk.Element element = HtmlChunk.link((String)("psi_element://#func#" + string), (String)content2);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(...)");
            htmlChunk = (HtmlChunk)element;
        } else {
            HtmlChunk htmlChunk2 = HtmlChunk.text((String)content2);
            htmlChunk = htmlChunk2;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"text(...)");
        }
        return htmlChunk;
    }

    @JvmStatic
    @NotNull
    public static final HtmlChunk toTypeAliasStatement(@NlsSafe @NotNull String content2, @NotNull PyTypeAliasStatement typeAliasStatement) {
        HtmlChunk htmlChunk;
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)typeAliasStatement, (String)"typeAliasStatement");
        String qualifiedName = typeAliasStatement.getQualifiedName();
        String string = qualifiedName;
        if (string != null) {
            HtmlChunk.Element element = HtmlChunk.link((String)("psi_element://#func#" + string), (String)content2);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(...)");
            htmlChunk = (HtmlChunk)element;
        } else {
            HtmlChunk htmlChunk2 = HtmlChunk.text((String)content2);
            htmlChunk = htmlChunk2;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"text(...)");
        }
        return htmlChunk;
    }

    @JvmStatic
    @NotNull
    public static final HtmlChunk toModule(@NlsSafe @NotNull String content2, @NotNull String qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        HtmlChunk.Element element = HtmlChunk.link((String)("psi_element://#module#" + qualifiedName), (String)content2);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(...)");
        return (HtmlChunk)element;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement elementForLink(@NotNull String link, @NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)link, (Object)LINK_TYPE_CLASS)) {
            psiElement = PyDocumentationLink.containingClass(element);
        } else if (Intrinsics.areEqual((Object)link, (Object)LINK_TYPE_PARAM)) {
            psiElement = PyDocumentationLink.parameterPossibleClass(element, context);
        } else if (StringsKt.startsWith$default((String)link, (String)LINK_TYPE_TYPENAME, (boolean)false, (int)2, null)) {
            String string = link.substring(10);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            psiElement = PyDocumentationLink.possibleClass(string, element, context);
        } else if (StringsKt.startsWith$default((String)link, (String)LINK_TYPE_FUNC, (boolean)false, (int)2, null)) {
            String string = link.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            psiElement = PyDocumentationLink.possibleFunction(string, element);
        } else if (StringsKt.startsWith$default((String)link, (String)LINK_TYPE_MODULE, (boolean)false, (int)2, null)) {
            String string = link.substring(8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            psiElement = (PsiElement)INSTANCE.possibleModule(string, element);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    private final PyFile possibleModule(String qualifiedName, PsiElement element) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        PyPsiFacade facade = PyPsiFacade.getInstance(element.getProject());
        QualifiedName qualifiedName2 = QualifiedName.fromDottedString((String)qualifiedName);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName2, (String)"fromDottedString(...)");
        QualifiedName qName = qualifiedName2;
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = facade.createResolveContextFromFoothold(element);
        Intrinsics.checkNotNullExpressionValue((Object)pyQualifiedNameResolveContext, (String)"createResolveContextFromFoothold(...)");
        PyQualifiedNameResolveContext resolveContext = pyQualifiedNameResolveContext;
        List<PsiElement> list = facade.resolveQualifiedName(qName, resolveContext);
        Intrinsics.checkNotNullExpressionValue(list, (String)"resolveQualifiedName(...)");
        Iterable iterable = list;
        boolean $i$f$filterIsInstance = false;
        void var8_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiFileSystemItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PyUtil.turnDirIntoInit((PsiElement)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PyFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (PyFile)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    private static final PyFunction possibleFunction(String qualifiedName, PsiElement element) {
        void $this$filterIsInstanceTo$iv$iv;
        PyPsiFacade facade = PyPsiFacade.getInstance(element.getProject());
        QualifiedName qualifiedName2 = QualifiedName.fromDottedString((String)qualifiedName);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName2, (String)"fromDottedString(...)");
        QualifiedName qName = qualifiedName2;
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = facade.createResolveContextFromFoothold(element).copyWithMembers();
        Intrinsics.checkNotNullExpressionValue((Object)pyQualifiedNameResolveContext, (String)"copyWithMembers(...)");
        PyQualifiedNameResolveContext resolveContext = pyQualifiedNameResolveContext;
        List<PsiElement> list = facade.resolveQualifiedName(qName, resolveContext);
        Intrinsics.checkNotNullExpressionValue(list, (String)"resolveQualifiedName(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PyFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        PyFunction topLevel = (PyFunction)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (topLevel != null) {
            return topLevel;
        }
        List<PsiElement> list2 = facade.resolveQualifiedName(qName.removeLastComponent(), resolveContext);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"resolveQualifiedName(...)");
        $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)list2);
        $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)possibleFunction$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (PyFunction)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)sequence, (Function1)((Function1)new Function1<PyClass, PyFunction>(qName){
            final /* synthetic */ QualifiedName $qName;
            {
                this.$qName = $qName;
                super(1);
            }

            @Nullable
            public final PyFunction invoke(@NotNull PyClass it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.findMethodByName(this.$qName.getLastComponent(), false, null);
            }
        })));
    }

    @JvmStatic
    private static final PyClass containingClass(PsiElement element) {
        PsiElement psiElement = element;
        return psiElement instanceof PyClass ? (PyClass)element : (psiElement instanceof PyFunction ? ((PyFunction)element).getContainingClass() : (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class));
    }

    @JvmStatic
    private static final PyClass parameterPossibleClass(PsiElement parameter, TypeEvalContext context) {
        PyType type2;
        if (parameter instanceof PyNamedParameter && (type2 = context.getType((PyTypedElement)parameter)) instanceof PyClassType) {
            return ((PyClassType)type2).getPyClass();
        }
        return null;
    }

    @JvmStatic
    private static final PyClass possibleClass(String type2, PsiElement anchor, TypeEvalContext context) {
        PyType pyType = PyTypeParser.getTypeByName(anchor, type2, context);
        return pyType instanceof PyClassType ? ((PyClassType)pyType).getPyClass() : null;
    }
}

