/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private MyTableEditor myEditor;
    private final Project myProject;
    private Object myLastValue;
    private static final Logger LOG = Logger.getInstance(ArrayTableCellEditor.class);

    public ArrayTableCellEditor(Project project2) {
        this.myProject = project2;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        this.myEditor = new MyTableEditor(this.myProject, new PyDebuggerEditorsProvider(), "numpy.array.table.view", null, (XExpression)new XExpressionImpl(value.toString(), (Language)PythonLanguage.getInstance(), "", EvaluationMode.CODE_FRAGMENT), this.getActionsAdapter(rowIndex, vColIndex));
        this.myLastValue = value;
        return this.myEditor.getComponent();
    }

    @Override
    @Nullable
    @NlsSafe
    public Object getCellEditorValue() {
        if (this.myEditor.getEditor() != null) {
            return this.myEditor.getEditor().getDocument().getText();
        }
        return null;
    }

    @NotNull
    private KeyAdapter getActionsAdapter(final int rowIndex, final int vColIndex) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ArrayTableCellEditor.this.doOKAction(rowIndex, vColIndex);
                } else if (e.getKeyCode() == 27) {
                    ArrayTableCellEditor.this.cancelEditing();
                }
            }
        };
    }

    public void doOKAction(int rowIndex, int vColIndex) {
    }

    public void cancelEditing() {
        WriteCommandAction.writeCommandAction(null).run(() -> {
            if (this.myEditor.getEditor() != null) {
                this.myEditor.getEditor().getDocument().setText((CharSequence)this.myLastValue.toString());
            }
        });
        this.myEditor.getComponent().repaint();
        this.stopCellEditing();
    }

    public MyTableEditor getEditor() {
        return this.myEditor;
    }

    public void setLastValue(Object lastValue) {
        this.myLastValue = lastValue;
    }

    public static class MyTableEditor
    extends XDebuggerEditorBase {
        private final EditorTextField myEditorTextField;
        private final XExpression myExpression;

        public MyTableEditor(Project project2, XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, @NotNull XExpression text, final @NotNull KeyAdapter actionAdapter) {
            if (text == null) {
                MyTableEditor.$$$reportNull$$$0(0);
            }
            if (actionAdapter == null) {
                MyTableEditor.$$$reportNull$$$0(1);
            }
            super(project2, debuggerEditorsProvider, EvaluationMode.CODE_FRAGMENT, historyId, sourcePosition);
            this.myExpression = XExpressionImpl.changeMode((XExpression)text, (EvaluationMode)this.getMode());
            this.myEditorTextField = new EditorTextField(this.createDocument(this.myExpression), project2, debuggerEditorsProvider.getFileType()){

                @NotNull
                protected EditorEx createEditor() {
                    EditorEx editor2 = super.createEditor();
                    editor2.setVerticalScrollbarVisible(false);
                    editor2.setOneLineMode(true);
                    editor2.getContentComponent().addKeyListener(actionAdapter);
                    EditorEx editorEx = editor2;
                    if (editorEx == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return editorEx;
                }

                protected boolean isOneLineMode() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/array/ArrayTableCellEditor$MyTableEditor$1", "createEditor"));
                }
            };
            this.myEditorTextField.setFontInheritedFromLAF(false);
        }

        public JComponent getComponent() {
            return this.myEditorTextField;
        }

        protected void doSetText(XExpression text) {
            this.myEditorTextField.setText(text.getExpression());
        }

        public XExpression getExpression() {
            return this.getEditorsProvider().createExpression(this.getProject(), this.myEditorTextField.getDocument(), this.myExpression.getLanguage(), EvaluationMode.CODE_FRAGMENT);
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            Editor editor2 = this.myEditorTextField.getEditor();
            return editor2 != null ? editor2.getContentComponent() : null;
        }

        @Nullable
        public Editor getEditor() {
            return this.myEditorTextField.getEditor();
        }

        public void selectAll() {
            this.myEditorTextField.selectAll();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionAdapter";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/array/ArrayTableCellEditor$MyTableEditor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

