/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.runners.ConsoleTitleGen;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.console.PyConsoleDebugProcess;
import com.jetbrains.python.console.PyConsoleDebugProcessHandler;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleOutputCustomizer;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PyConsoleProcessHandlers;
import com.jetbrains.python.console.PyConsoleRootType;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PyExecuteConsoleCustomizer;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationServer;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreatorKt;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.console.actions.ConsoleCopyOutputAction;
import com.jetbrains.python.console.actions.ScrollToTheEndAction;
import com.jetbrains.python.console.actions.ShowCommandQueueAction;
import com.jetbrains.python.console.actions.ShowVarsAction;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import com.jetbrains.python.debugger.ValuesPolicy;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.psi.icons.PythonPsiApiIcons;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyCustomProcessHandlerProvider;
import com.jetbrains.python.run.PyRunnerUtil;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonImportErrorFilter;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PydevConsoleRunnerImpl
implements PydevConsoleRunner {
    @NonNls
    private static final String LOCALHOST = "localhost";
    @NonNls
    public static final String WORKING_DIR_AND_PYTHON_PATHS = "WORKING_DIR_AND_PYTHON_PATHS";
    @NonNls
    public static final String PROJECT_ROOT = "PROJECT_ROOT";
    @NonNls
    public static final String CONSOLE_START_COMMAND = "import sys; print('Python %s on %s' % (sys.version, sys.platform))\nsys.path.extend([WORKING_DIR_AND_PYTHON_PATHS])\n";
    @NonNls
    public static final String STARTED_BY_RUNNER = "startedByRunner";
    @NonNls
    public static final String INLINE_OUTPUT_SUPPORTED = "INLINE_OUTPUT_SUPPORTED";
    @NonNls
    private static final String ASYNCIO_REPL_COMMAND = "-m asyncio";
    private static final Long WAIT_BEFORE_FORCED_CLOSE_MILLIS = 2000L;
    private static final Logger LOG = Logger.getInstance(PydevConsoleRunnerImpl.class);
    @NonNls
    public static final String PYDEV_PYDEVCONSOLE_PY = "pydev/pydevconsole.py";
    public static final int PORTS_WAITING_TIMEOUT = 20000;
    public static final Charset CONSOLE_CHARSET = StandardCharsets.UTF_8;
    private final Project myProject;
    @NlsContexts.TabTitle
    private final String myTitle;
    @Nullable
    private final String myWorkingDir;
    @Nullable
    private final Function<TargetEnvironment, String> myWorkingDirFunction;
    @Nullable
    private Sdk mySdk;
    private PydevConsoleCommunication myPydevConsoleCommunication;
    private ProcessHandler myProcessHandler;
    protected PythonConsoleExecuteActionHandler myConsoleExecuteActionHandler;
    private final List<PydevConsoleRunner.ConsoleListener> myConsoleListeners;
    private final PyConsoleType myConsoleType;
    @NotNull
    private final Map<String, String> myEnvironmentVariables;
    @NotNull
    protected final PyConsoleOptions.PyConsoleSettings myConsoleSettings;
    private final String @Nullable [] myStatementsToExecute;
    @Nullable
    @NlsContexts.TabTitle
    private String myConsoleInitTitle;
    private PythonConsoleView myConsoleView;
    private final @Nullable Function<TargetEnvironment, @NotNull String> myStatementsToExecuteFunction;
    @Nullable
    private String myResolvedStatementsToExecute;

    public PydevConsoleRunnerImpl(@NotNull Project project2, @Nullable Sdk sdk2, @NotNull PyConsoleType consoleType, @NotNull @NlsContexts.TabTitle String title, @Nullable Function<TargetEnvironment, String> workingDirFunction, @NotNull Map<String, String> environmentVariables, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull @NotNull Function<TargetEnvironment, @NotNull String> statementsToExecuteFunction) {
        if (project2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(0);
        }
        if (consoleType == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(1);
        }
        if (title == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(2);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(3);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(4);
        }
        if (statementsToExecuteFunction == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(5);
        }
        this.myConsoleListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myConsoleInitTitle = null;
        this.myProject = project2;
        this.mySdk = sdk2;
        this.myTitle = title;
        this.myWorkingDir = null;
        this.myWorkingDirFunction = workingDirFunction;
        this.myConsoleType = consoleType;
        this.myEnvironmentVariables = environmentVariables;
        this.myConsoleSettings = settingsProvider;
        this.myStatementsToExecute = null;
        this.myStatementsToExecuteFunction = statementsToExecuteFunction;
    }

    public PydevConsoleRunnerImpl(@NotNull Project project2, @Nullable Sdk sdk2, @NotNull PyConsoleType consoleType, @NotNull @NlsContexts.TabTitle String title, @Nullable String workingDir, @NotNull Map<String, String> environmentVariables, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, String ... statementsToExecute) {
        if (project2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(6);
        }
        if (consoleType == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(7);
        }
        if (title == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(8);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(9);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(10);
        }
        this.myConsoleListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myConsoleInitTitle = null;
        this.myProject = project2;
        this.mySdk = sdk2;
        this.myTitle = title;
        this.myWorkingDir = workingDir;
        this.myWorkingDirFunction = null;
        this.myConsoleType = consoleType;
        this.myEnvironmentVariables = environmentVariables;
        this.myConsoleSettings = settingsProvider;
        this.myStatementsToExecute = statementsToExecute;
        this.myStatementsToExecuteFunction = environment -> StringUtil.join((String[])statementsToExecute, (String)"\n");
    }

    public PydevConsoleRunnerImpl(@NotNull Project project2, @Nullable Sdk sdk2, @NotNull PyConsoleType consoleType, @Nullable String workingDir, @NotNull Map<String, String> environmentVariables, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, String ... statementsToExecute) {
        if (project2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(11);
        }
        if (consoleType == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(12);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(13);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(14);
        }
        this(project2, sdk2, consoleType, consoleType.getTitle(), workingDir, environmentVariables, settingsProvider, statementsToExecute);
    }

    public void setConsoleTitle(@NlsContexts.TabTitle String consoleTitle) {
        this.myConsoleInitTitle = consoleTitle;
    }

    private List<AnAction> fillRunActionsToolbar(DefaultActionGroup toolbarActions) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add(this.createRerunAction());
        actions.add(this.createStopAction());
        actions.add((AnAction)new ConsoleExecuteAction((LanguageConsoleView)this.myConsoleView, (ConsoleExecuteAction.ConsoleExecuteActionHandler)this.myConsoleExecuteActionHandler, this.myConsoleExecuteActionHandler.getEmptyExecuteAction(), (Condition)this.myConsoleExecuteActionHandler, PythonIcons.Python.ExecuteCurrentStatement));
        toolbarActions.addAll(actions);
        toolbarActions.add((AnAction)new ConnectDebuggerAction());
        toolbarActions.add((AnAction)new ShowCommandQueueAction(this.myConsoleView));
        toolbarActions.add((AnAction)new ScrollToTheEndAction(this.myConsoleView.getEditor()));
        toolbarActions.add((AnAction)Separator.create());
        DefaultActionGroup settings = DefaultActionGroup.createPopupGroup(() -> PyBundle.message("pydev.console.runner.settings", new Object[0]));
        settings.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        settings.add((AnAction)new PyVariableViewSettings.SimplifiedView(null));
        settings.add((AnAction)new PyVariableViewSettings.VariablesPolicyGroup());
        settings.add((AnAction)new PyVariableViewSettings.QuotingPolicyGroup());
        toolbarActions.add((AnAction)settings);
        DefaultActionGroup outputActions = DefaultActionGroup.createPopupGroup(() -> PyBundle.message("pydev.console.runner.output.actions", new Object[0]));
        outputActions.getTemplatePresentation().setIcon(AllIcons.General.InspectionsEye);
        outputActions.add((AnAction)new ShowVarsAction(this.myConsoleView, this.myPydevConsoleCommunication));
        outputActions.add((AnAction)new SoftWrapAction());
        outputActions.add((AnAction)Separator.create());
        outputActions.add(ConsoleHistoryController.getController((LanguageConsoleView)this.myConsoleView).getBrowseHistory());
        outputActions.add((AnAction)new ConsoleCopyOutputAction(this.myConsoleView));
        toolbarActions.add((AnAction)outputActions);
        actions.add(PyConsoleUtil.createInterruptAction(this.myConsoleView));
        actions.add(PyConsoleUtil.createTabCompletionAction(this.myConsoleView));
        actions.add(this.createSplitLineAction());
        return actions;
    }

    @Override
    public void open() {
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(this.myProject);
        if (toolWindow != null && toolWindow.isInitialized()) {
            toolWindow.getToolWindow().activate(() -> {}, true);
        } else {
            this.runSync(true);
        }
    }

    @Override
    public void runSync(final boolean requestEditorFocus) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, PyBundle.message("connecting.to.console.title", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    Sdk sdk2 = PydevConsoleRunnerImpl.this.mySdk;
                    if (sdk2 == null) {
                        throw new ExecutionException(PyBundle.message("pydev.console.python.interpreter.is.not.selected", new Object[0]));
                    }
                    PydevConsoleRunnerImpl.this.initAndRun(sdk2);
                    indicator.setText(PyBundle.message("connecting.to.console.progress", new Object[0]));
                    PydevConsoleRunnerImpl.this.connect(PydevConsoleRunnerImpl.this.getStatementsToExecute());
                    if (requestEditorFocus) {
                        PydevConsoleRunnerImpl.this.myConsoleView.requestFocus();
                    }
                }
                catch (ExecutionException e) {
                    LOG.warn("Error running console", (Throwable)e);
                    ApplicationManager.getApplication().invokeLater(() -> PydevConsoleRunnerImpl.this.showErrorsInConsole((Exception)((Object)e)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$1", "run"));
            }
        });
    }

    private String @NotNull [] getStatementsToExecute() {
        if (this.myResolvedStatementsToExecute != null) {
            String[] stringArray = new String[]{this.myResolvedStatementsToExecute};
            if (stringArray == null) {
                PydevConsoleRunnerImpl.$$$reportNull$$$0(15);
            }
            return stringArray;
        }
        if (this.myStatementsToExecute == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                PydevConsoleRunnerImpl.$$$reportNull$$$0(16);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (this.myStatementsToExecute == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(17);
        }
        return this.myStatementsToExecute;
    }

    @Override
    public void run(final boolean requestEditorFocus) {
        TransactionGuard.submitTransaction((Disposable)PythonPluginDisposable.getInstance(this.myProject), () -> FileDocumentManager.getInstance().saveAllDocuments());
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, PyBundle.message("connecting.to.console.title", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText(PyBundle.message("connecting.to.console.progress", new Object[0]));
                try {
                    if (PydevConsoleRunnerImpl.this.mySdk == null) {
                        throw new ExecutionException(PyBundle.message("pydev.console.python.interpreter.is.not.selected", new Object[0]));
                    }
                    PydevConsoleRunnerImpl.this.initAndRun(PydevConsoleRunnerImpl.this.mySdk);
                    PydevConsoleRunnerImpl.this.connect(PydevConsoleRunnerImpl.this.getStatementsToExecute());
                    if (requestEditorFocus) {
                        PydevConsoleRunnerImpl.this.myConsoleView.requestFocus();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error running console", (Throwable)e);
                    UIUtil.invokeAndWaitIfNeeded(() -> PydevConsoleRunnerImpl.this.showErrorsInConsole(e));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$2", "run"));
            }
        }));
    }

    private void showErrorsInConsole(Exception e) {
        String[] messages;
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{this.createRerunAction()});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunnerErrors", (ActionGroup)actionGroup, false);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)actionToolbar.getComponent(), "West");
        NewErrorTreeViewPanel errorViewPanel = new NewErrorTreeViewPanel(this.myProject, null, false, false, null);
        String[] stringArray = messages = StringUtil.isNotEmpty((String)e.getMessage()) ? StringUtil.splitByLines((String)e.getMessage()) : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (messages.length == 0) {
            messages = new String[]{PyBundle.message("pydev.console.runner.unknown.error", new Object[0])};
        }
        errorViewPanel.addMessage(4, messages, null, -1, -1, null);
        panel2.add((Component)errorViewPanel, "Center");
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, this.myProcessHandler, (JComponent)panel2, PyBundle.message("pydev.console.runner.error.running.console", new Object[0]));
        this.showContentDescriptor(contentDescriptor);
    }

    protected void showContentDescriptor(RunContentDescriptor contentDescriptor) {
        ToolWindow toolwindow = PythonConsoleToolWindow.getToolWindow(this.myProject);
        toolwindow.getComponent().putClientProperty(STARTED_BY_RUNNER, "true");
        PythonConsoleToolWindow.getInstance(this.myProject).init(toolwindow, contentDescriptor);
    }

    public static int findAvailablePort(@NotNull Project project2, PyConsoleType consoleType) throws ExecutionException {
        if (project2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(18);
        }
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            ExecutionHelper.showErrors((Project)project2, Collections.singletonList(e), (String)consoleType.getTitle(), null);
            throw new ExecutionException((Throwable)e);
        }
    }

    protected GeneralCommandLine createCommandLine(@NotNull Sdk sdk2, @NotNull Map<String, String> environmentVariables, @Nullable String workingDir, int port) {
        if (sdk2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(19);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(20);
        }
        return this.doCreateConsoleCmdLine(sdk2, environmentVariables, workingDir, port);
    }

    @NotNull
    private PythonExecution createPythonConsoleExecution(@NotNull Function<TargetEnvironment, HostPort> ideServerPort, @NotNull PythonConsoleRunParams runParams, @NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest) {
        if (ideServerPort == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(21);
        }
        if (runParams == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(22);
        }
        if (helpersAwareTargetRequest == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(23);
        }
        return this.doCreatePythonConsoleExecution(ideServerPort, runParams, helpersAwareTargetRequest);
    }

    @NotNull
    protected PythonConsoleRunParams createConsoleRunParams(@Nullable String workingDir, @NotNull Sdk sdk2, @NotNull Map<String, String> environmentVariables) {
        if (sdk2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(24);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(25);
        }
        return new PythonConsoleRunParams(this.myConsoleSettings, workingDir, sdk2, environmentVariables);
    }

    @NotNull
    private GeneralCommandLine doCreateConsoleCmdLine(final @NotNull Sdk sdk2, @NotNull Map<String, String> environmentVariables, @Nullable String workingDir, int port) {
        if (sdk2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(26);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(27);
        }
        final PythonConsoleRunParams runParams = this.createConsoleRunParams(workingDir, sdk2, environmentVariables);
        String title = PyBundle.message("connecting.to.console.title", new Object[0]);
        GeneralCommandLine cmd = (GeneralCommandLine)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<GeneralCommandLine, RuntimeException>(this.myProject, title, false){

            protected GeneralCommandLine compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PythonCommandLineState.createPythonCommandLine(this.myProject, sdk2.getSdkAdditionalData(), runParams, false, PtyCommandLine.isEnabled() && !SystemInfo.isWindows);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$3", "compute"));
            }
        });
        cmd.withWorkDirectory(this.myWorkingDir);
        ParamsGroup exeGroup = cmd.getParametersList().getParamsGroup("Exe Options");
        if (exeGroup != null && !runParams.getInterpreterOptions().isEmpty()) {
            exeGroup.addParametersString(runParams.getInterpreterOptions());
        }
        PydevConsoleCli.setupPythonConsoleScriptInClientMode(cmd, sdk2, port);
        GeneralCommandLine generalCommandLine = cmd;
        if (generalCommandLine == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(28);
        }
        return generalCommandLine;
    }

    @NotNull
    private PythonExecution doCreatePythonConsoleExecution(@NotNull Function<TargetEnvironment, HostPort> ideServerPort, @NotNull PythonConsoleRunParams runParams, @NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest) {
        if (ideServerPort == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(29);
        }
        if (runParams == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(30);
        }
        if (helpersAwareTargetRequest == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(31);
        }
        PythonExecution pythonConsoleScriptExecution = PydevConsoleCli.createPythonConsoleScriptInClientMode(ideServerPort, helpersAwareTargetRequest);
        PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData = PydevConsoleRunnerImpl.getRemoteAdditionalData(this.mySdk);
        PyRemotePathMapper pathMapper = remoteSdkAdditionalData != null ? PydevConsoleRunnerUtil.getPathMapper(this.myProject, this.myConsoleSettings, remoteSdkAdditionalData) : null;
        PythonCommandLineState.initEnvironment(this.myProject, pythonConsoleScriptExecution, runParams, helpersAwareTargetRequest, pathMapper, this.mySdk);
        if (this.myWorkingDirFunction != null) {
            pythonConsoleScriptExecution.setWorkingDir(this.myWorkingDirFunction);
        }
        PythonExecution pythonExecution2 = pythonConsoleScriptExecution;
        if (pythonExecution2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(32);
        }
        return pythonExecution2;
    }

    @NotNull
    private PythonConsoleView createConsoleView(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(33);
        }
        PythonConsoleView consoleView = new PythonConsoleView(this.myProject, this.myTitle, sdk2, false);
        this.myPydevConsoleCommunication.setConsoleFile(consoleView.getVirtualFile());
        consoleView.addMessageFilter(new PythonTracebackFilter(this.myProject));
        consoleView.addMessageFilter(new PythonImportErrorFilter(this.myProject));
        PythonConsoleView pythonConsoleView = consoleView;
        if (pythonConsoleView == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(34);
        }
        return pythonConsoleView;
    }

    @ApiStatus.Obsolete
    @NotNull
    private ConsoleProcessCreationResult createProcess(@NotNull Sdk sdk2) throws ExecutionException {
        PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData;
        if (sdk2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(35);
        }
        if ((remoteSdkAdditionalData = PydevConsoleRunnerImpl.getRemoteAdditionalData(sdk2)) != null) {
            PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
            if (remoteInterpreterManager == null) {
                throw new ExecutionException(PyBundle.message("remote.interpreter.feature.is.not.available", new Object[0]));
            }
            GeneralCommandLine generalCommandLine = this.createCommandLine(sdk2, this.myEnvironmentVariables, this.myWorkingDir, 0);
            PyRemotePathMapper pathMapper = PydevConsoleRunnerUtil.getPathMapper(this.myProject, this.myConsoleSettings, remoteSdkAdditionalData);
            RemoteConsoleProcessData remoteConsoleProcessData = PythonConsoleRemoteProcessCreatorKt.createRemoteConsoleProcess(generalCommandLine, pathMapper, this.myProject, remoteSdkAdditionalData, this.getRunnerFileFromHelpers());
            this.myPydevConsoleCommunication = remoteConsoleProcessData.getPydevConsoleCommunication();
            return new LegacyRemoteSdkProcessHandlerCreator(remoteSdkAdditionalData, remoteConsoleProcessData.getProcess(), remoteConsoleProcessData.getCommandLine(), this.myProject, remoteConsoleProcessData.getSocketProvider(), this.myPydevConsoleCommunication, remoteInterpreterManager);
        }
        int port = PydevConsoleRunnerImpl.findAvailablePort(this.myProject, this.myConsoleType);
        GeneralCommandLine generalCommandLine = this.createCommandLine(sdk2, this.myEnvironmentVariables, this.myWorkingDir, port);
        PydevConsoleCommunicationServer communicationServer = new PydevConsoleCommunicationServer(this.myProject, LOCALHOST, port);
        this.myPydevConsoleCommunication = communicationServer;
        try {
            communicationServer.serve();
        }
        catch (Exception e) {
            communicationServer.close();
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        Process process2 = generalCommandLine.createProcess();
        communicationServer.setPythonConsoleProcess(process2);
        return new LegacyLocalProcessHandlerCreator(process2, generalCommandLine.getCommandLineString(), communicationServer);
    }

    @NotNull
    private ConsoleProcessCreationResult createProcessUsingTargetsAPI(@NotNull Sdk sdk2) throws ExecutionException {
        String ideServerHost;
        int ideServerPort;
        if (sdk2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(36);
        }
        try {
            ideServerPort = NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareRequest = PythonCommandLineState.getPythonTargetInterpreter(this.myProject, sdk2);
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareRequest.getTargetEnvironmentRequest();
        TargetEnvironment.LocalPortBinding ideServerPortBinding = new TargetEnvironment.LocalPortBinding(ideServerPort, null);
        targetEnvironmentRequest.getLocalPortBindings().add(ideServerPortBinding);
        Function<TargetEnvironment, HostPort> ideServerHostPortOnTarget = targetEnvironment -> {
            ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)targetEnvironment.getLocalPortBindings().get(ideServerPortBinding);
            if (resolvedPortBinding == null) {
                throw new IllegalStateException(MessageFormat.format("Local port binding \"{0}\" must be registered", ideServerPortBinding));
            }
            return resolvedPortBinding.getTargetEndpoint();
        };
        this.addProjectAndModuleToRequest(targetEnvironmentRequest);
        PythonConsoleRunParams runParams = this.createConsoleRunParams(this.myWorkingDir, sdk2, this.myEnvironmentVariables);
        PythonExecution pythonConsoleExecution = this.createPythonConsoleExecution(ideServerHostPortOnTarget, runParams, helpersAwareRequest);
        pythonConsoleExecution.setCharset(CONSOLE_CHARSET);
        pythonConsoleExecution.getEnvs().put("PYTHONIOENCODING", environment -> CONSOLE_CHARSET.name());
        List interpreterOptions = !StringUtil.isEmptyOrSpaces((String)runParams.getInterpreterOptions()) ? ParametersListUtil.parse((String)runParams.getInterpreterOptions()) : Collections.emptyList();
        PythonSdkFlavor<?> flavor = PythonSdkFlavor.getFlavor(sdk2);
        if (flavor != null) {
            interpreterOptions.addAll(flavor.getExtraDebugOptions());
        }
        TargetEnvironment targetEnvironment2 = targetEnvironmentRequest.prepareEnvironment(TargetProgressIndicator.EMPTY);
        this.myResolvedStatementsToExecute = this.myStatementsToExecuteFunction.apply(targetEnvironment2);
        boolean usePty = PtyCommandLine.isEnabled() && !SystemInfo.isWindows;
        TargetedCommandLine targetedCommandLine = PythonScripts.buildTargetedCommandLine(pythonConsoleExecution, targetEnvironment2, sdk2, interpreterOptions);
        ResolvedPortBinding resolvedServerPortBinding = (ResolvedPortBinding)targetEnvironment2.getLocalPortBindings().get(ideServerPortBinding);
        if (resolvedServerPortBinding != null) {
            ideServerHost = resolvedServerPortBinding.getLocalEndpoint().getHost();
        } else {
            LOG.error("The resolution of the local port binding for \"" + ideServerPort + "\" port cannot be found in the prepared environment, falling back to \"localhost\" for the server socket binding on the local machine");
            ideServerHost = LOCALHOST;
        }
        PydevConsoleCommunicationServer communicationServer = new PydevConsoleCommunicationServer(this.myProject, ideServerHost, ideServerPort);
        this.myPydevConsoleCommunication = communicationServer;
        try {
            communicationServer.serve();
        }
        catch (Exception e) {
            communicationServer.close();
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        Process process2 = targetEnvironment2.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        communicationServer.setPythonConsoleProcess(process2);
        String commandLineString = StringUtil.join((String[])new String[]{targetedCommandLine.getCommandPresentation(targetEnvironment2), " "});
        PyRemotePathMapper pathMapper = PydevConsoleRunnerUtil.createTargetEnvironmentPathMapper(this.myProject, sdk2, this.myConsoleSettings, targetEnvironment2);
        boolean isMostlySilentProcess = true;
        ProcessHandler processHandler = PyCustomProcessHandlerProvider.createProcessHandler(process2, targetEnvironment2, commandLineString, targetedCommandLine.getCharset(), pathMapper, isMostlySilentProcess);
        return new TargetProcessHandlerFactory(processHandler, process2, commandLineString, communicationServer, targetEnvironment2);
    }

    @Nullable
    protected Module getModule() {
        return null;
    }

    private void addProjectAndModuleToRequest(@NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        Module module;
        if (targetEnvironmentRequest == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(37);
        }
        Module[] modules = (module = this.getModule()) != null ? new Module[]{module} : ModuleManager.getInstance((Project)this.myProject).getModules();
        PythonScripts.ensureProjectSdkAndModuleDirsAreOnTarget(targetEnvironmentRequest, this.myProject, modules);
    }

    @Contract(value="null -> null")
    @Nullable
    private static PyRemoteSdkAdditionalDataBase getRemoteAdditionalData(@Nullable Sdk sdk2) {
        if (sdk2 == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase) {
            return (PyRemoteSdkAdditionalDataBase)sdkAdditionalData;
        }
        return null;
    }

    protected String getRunnerFileFromHelpers() {
        return PYDEV_PYDEVCONSOLE_PY;
    }

    public static int getRemotePortFromProcess(@NotNull Process process2) throws ExecutionException {
        if (process2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(38);
        }
        Scanner s = new Scanner(process2.getInputStream());
        return PydevConsoleRunnerImpl.readInt(s, process2);
    }

    private static int readInt(Scanner s, Process process2) throws ExecutionException {
        long started = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        while (System.currentTimeMillis() - started < 20000L) {
            String error;
            if (s.hasNextLine()) {
                String line2 = s.nextLine();
                sb.append(line2).append("\n");
                try {
                    int i = Integer.parseInt(line2);
                    if (flag) {
                        LOG.warn("Unexpected strings in output:\n" + sb);
                    }
                    return i;
                }
                catch (NumberFormatException ignored) {
                    flag = true;
                    continue;
                }
            }
            TimeoutUtil.sleep((long)200L);
            if (process2.exitValue() == 0) break;
            try {
                error = PyBundle.message("pydev.console.console.process.terminated.with.error", StreamUtil.readText((Reader)new InputStreamReader(process2.getErrorStream(), StandardCharsets.UTF_8)), sb.toString());
            }
            catch (Exception ignored) {
                error = PyBundle.message("pydev.console.console.process.terminated.with.exit.code", process2.exitValue(), sb.toString());
            }
            throw new ExecutionException(error);
        }
        throw new ExecutionException(PyBundle.message("pydev.console.couldnt.read.integer.value.from.stream", new Object[0]));
    }

    private void initAndRun(@NotNull Sdk sdk2) throws ExecutionException {
        ConsoleProcessCreationResult processCreationResult;
        boolean isUseTargetsAPI;
        if (sdk2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(39);
        }
        if (isUseTargetsAPI = Registry.is((String)"python.use.targets.api")) {
            processCreationResult = this.createProcessUsingTargetsAPI(sdk2);
        } else {
            if (PyRunnerUtil.isTargetBased(sdk2)) {
                throw new ExecutionException(PySdkBundle.message("python.sdk.please.reconfigure.interpreter", new Object[0]));
            }
            processCreationResult = this.createProcess(sdk2);
        }
        TargetEnvironment targetEnvironment = processCreationResult.getTargetEnvironment();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            this.myConsoleView = this.createConsoleView(sdk2);
            this.myConsoleView.setRunner(this);
            this.myConsoleView.setBorder((Border)new SideBorder(JBColor.border(), 1));
            this.myPydevConsoleCommunication.setConsoleView(this.myConsoleView);
            this.myProcessHandler = processCreationResult.createPythonConsoleProcessHandler(this.myConsoleView);
            this.myConsoleExecuteActionHandler = this.createExecuteActionHandler();
            ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
            final PythonConsoleView consoleView = this.myConsoleView;
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    consoleView.setEditable(false);
                    consoleView.restoreQueueWindow(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/console/PydevConsoleRunnerImpl$4", "processTerminated"));
                }
            });
            if (targetEnvironment != null) {
                this.myConsoleView.setTargetEnvironment(targetEnvironment);
            }
            this.myConsoleView.attachToProcess(this.myProcessHandler);
            this.createContentDescriptorAndActions();
            this.myProcessHandler.startNotify();
        });
    }

    protected void createContentDescriptorAndActions() {
        boolean isHorizontalAndUnitedToolbar = PyExecuteConsoleCustomizer.Companion.getInstance().isHorizontalAndUnitedToolbar();
        DefaultActionGroup runToolbarActions = new DefaultActionGroup();
        ActionToolbar runActionsToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunner", (ActionGroup)runToolbarActions, isHorizontalAndUnitedToolbar);
        JPanel actionsPanel = new JPanel(new BorderLayout());
        actionsPanel.add((Component)runActionsToolbar.getComponent(), "West");
        JPanel mainPanel2 = new JPanel(new BorderLayout());
        mainPanel2.add((Component)this.myConsoleView.getComponent(), "Center");
        this.myConsoleView.setToolbar(runActionsToolbar);
        runActionsToolbar.setTargetComponent((JComponent)mainPanel2);
        DefaultActionGroup outputToolbarActions = new DefaultActionGroup();
        if (!isHorizontalAndUnitedToolbar) {
            ActionToolbar outputActionsToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunner", (ActionGroup)outputToolbarActions, false);
            JComponent outputActionsComponent = outputActionsToolbar.getComponent();
            int emptyBorderSize = outputActionsComponent.getBorder().getBorderInsets((Component)outputActionsComponent).left;
            outputActionsComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, JBColor.border()), (Border)new JBEmptyBorder(emptyBorderSize)));
            actionsPanel.add((Component)outputActionsComponent, "Center");
            this.myConsoleView.setToolbar(outputActionsToolbar);
            outputActionsToolbar.setTargetComponent((JComponent)mainPanel2);
            mainPanel2.add((Component)actionsPanel, "West");
        } else {
            mainPanel2.add((Component)actionsPanel, "First");
        }
        if (this.myConsoleInitTitle == null) {
            ConsoleTitleGen consoleTitleGen = new ConsoleTitleGen(this.myProject, this.myTitle){

                @NotNull
                protected List<String> getActiveConsoles(@NotNull String consoleTitle) {
                    PythonConsoleToolWindow toolWindow;
                    if (consoleTitle == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if ((toolWindow = PythonConsoleToolWindow.getInstance(PydevConsoleRunnerImpl.this.myProject)) != null && toolWindow.isInitialized()) {
                        List<String> list = Arrays.stream(toolWindow.getToolWindow().getContentManager().getContents()).map(c -> c.getDisplayName()).filter(s -> s.startsWith(PydevConsoleRunnerImpl.this.myTitle)).collect(Collectors.toList());
                        if (list == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        return list;
                    }
                    List list = super.getActiveConsoles(consoleTitle);
                    if (list == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "consoleTitle";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$5";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$5";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActiveConsoles";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getActiveConsoles";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            };
            this.myConsoleInitTitle = consoleTitleGen.makeTitle();
        }
        RunContentDescriptor contentDescriptor = new RunContentDescriptor((ExecutionConsole)this.myConsoleView, this.myProcessHandler, (JComponent)mainPanel2, this.myConsoleInitTitle, null);
        Disposer.register((Disposable)PythonPluginDisposable.getInstance(this.myProject), (Disposable)contentDescriptor);
        contentDescriptor.setFocusComputable(() -> this.myConsoleView.getConsoleEditor().getContentComponent());
        contentDescriptor.setAutoFocusContent(true);
        List<AnAction> actions = this.fillRunActionsToolbar(runToolbarActions);
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, (JComponent)this.myConsoleView.getConsoleEditor().getComponent());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, (JComponent)mainPanel2);
        this.getConsoleView().addConsoleFolding(false, false);
        this.showContentDescriptor(contentDescriptor);
    }

    private void connect(String @NotNull [] statements2execute) {
        if (statements2execute == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(40);
        }
        if (this.handshake()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                PythonConsoleView consoleView = this.myConsoleView;
                consoleView.setConsoleCommunication(this.myPydevConsoleCommunication);
                consoleView.setSdk(this.mySdk);
                consoleView.setExecutionHandler(this.myConsoleExecuteActionHandler);
                this.enableConsoleExecuteAction();
                if (statements2execute.length == 1 && statements2execute[0].isEmpty()) {
                    statements2execute[0] = "\t";
                }
                for (String statement : statements2execute) {
                    consoleView.executeStatement(statement + "\n", ProcessOutputTypes.SYSTEM);
                }
                this.setUserTypeRenderers();
                this.fireConsoleInitializedEvent((LanguageConsoleView)consoleView);
                consoleView.initialized();
            });
        } else {
            this.myConsoleView.print(PyBundle.message("pydev.console.couldnt.connect.to.console.process", new Object[0]), ProcessOutputTypes.STDERR);
            this.myProcessHandler.destroyProcess();
            this.myConsoleView.setEditable(false);
        }
    }

    @Override
    public AnAction createRerunAction() {
        return new RestartAction(this, this.myConsoleInitTitle);
    }

    private void enableConsoleExecuteAction() {
        this.myConsoleExecuteActionHandler.setEnabled(true);
    }

    private boolean handshake() {
        return this.myPydevConsoleCommunication.handshake();
    }

    private void setUserTypeRenderers() {
        this.myPydevConsoleCommunication.setUserTypeRenderersSettings();
    }

    private AnAction createStopAction() {
        return new DumbAwareAction(PyBundle.messagePointer("action.DumbAware.PydevConsoleRunnerImpl.text.stop.console", new Object[0]), PyBundle.messagePointer("action.DumbAware.PydevConsoleRunnerImpl.description.stop.python.console", new Object[0]), AllIcons.Actions.Suspend){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!PydevConsoleRunnerImpl.this.isConsoleProcessTerminated());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                PydevConsoleRunnerImpl.this.stopAndRerunConsole(false, PyBundle.message("console.stopping.console", new Object[0]), null);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    6.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$6";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    protected AnAction createSplitLineAction() {
        class ConsoleSplitLineAction
        extends EditorAction {
            private static final String CONSOLE_SPLIT_LINE_ACTION_ID = "Console.SplitLine";

            ConsoleSplitLineAction() {
                super((EditorActionHandler)new EditorWriteActionHandler(){
                    private final SplitLineAction mySplitLineAction = new SplitLineAction();

                    public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
                        if (editor2 == null) {
                            1ConsoleSplitLineAction.1.$$$reportNull$$$0(0);
                        }
                        if (caret == null) {
                            1ConsoleSplitLineAction.1.$$$reportNull$$$0(1);
                        }
                        return this.mySplitLineAction.getHandler().isEnabled(editor2, caret, dataContext);
                    }

                    public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext) {
                        if (editor2 == null) {
                            1ConsoleSplitLineAction.1.$$$reportNull$$$0(2);
                        }
                        this.mySplitLineAction.getHandler().execute(editor2, caret, dataContext);
                        editor2.getCaretModel().getCurrentCaret().moveCaretRelatively(0, 1, false, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "editor";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "caret";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$1ConsoleSplitLineAction$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "isEnabledForCaret";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "executeWriteAction";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            public void setup() {
                ActionUtil.mergeFrom((AnAction)this, (String)CONSOLE_SPLIT_LINE_ACTION_ID);
            }
        }
        ConsoleSplitLineAction action = new ConsoleSplitLineAction();
        action.setup();
        return action;
    }

    private void closeCommunication() {
        if (!this.myProcessHandler.isProcessTerminated()) {
            this.myPydevConsoleCommunication.close();
        }
    }

    private boolean isConsoleProcessTerminated() {
        return this.myProcessHandler.isProcessTerminated();
    }

    @NotNull
    protected PythonConsoleExecuteActionHandler createExecuteActionHandler() {
        this.myConsoleExecuteActionHandler = new PydevConsoleExecuteActionHandler((LanguageConsoleView)this.myConsoleView, this.myProcessHandler, this.myPydevConsoleCommunication);
        this.myConsoleExecuteActionHandler.setEnabled(false);
        new ConsoleHistoryController((ConsoleRootType)PyConsoleRootType.Companion.getInstance(), "", (LanguageConsoleView)this.myConsoleView, true).install();
        PythonConsoleExecuteActionHandler pythonConsoleExecuteActionHandler = this.myConsoleExecuteActionHandler;
        if (pythonConsoleExecuteActionHandler == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(41);
        }
        return pythonConsoleExecuteActionHandler;
    }

    @Override
    public PydevConsoleCommunication getPydevConsoleCommunication() {
        return this.myPydevConsoleCommunication;
    }

    static VirtualFile getConsoleFile(PsiFile psiFile) {
        VirtualFile file = psiFile.getViewProvider().getVirtualFile();
        if (file instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        return file;
    }

    @Override
    public void addConsoleListener(PydevConsoleRunner.ConsoleListener consoleListener) {
        this.myConsoleListeners.add(consoleListener);
    }

    private void fireConsoleInitializedEvent(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(42);
        }
        for (PydevConsoleRunner.ConsoleListener listener2 : this.myConsoleListeners) {
            listener2.handleConsoleInitialized(consoleView);
        }
    }

    @Override
    public PythonConsoleExecuteActionHandler getConsoleExecuteActionHandler() {
        return this.myConsoleExecuteActionHandler;
    }

    @Nullable
    private static String getConsoleDisplayName(@NotNull Project project2) {
        PythonConsoleToolWindow toolWindow;
        ToolWindow window;
        Content content2;
        if (project2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(43);
        }
        if ((content2 = (window = (toolWindow = PythonConsoleToolWindow.getInstance(project2)).getToolWindow()).getContentManager().getSelectedContent()) == null) {
            return null;
        }
        return content2.getDisplayName();
    }

    @Override
    public void reRun(boolean requestEditorFocus, @NlsContexts.TabTitle String title) {
        this.setConsoleTitle(title);
        this.run(requestEditorFocus);
    }

    private void stopAndRerunConsole(final Boolean rerun, @NotNull @Nls String message, final @Nullable @NlsContexts.TabTitle String displayName) {
        if (message == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(44);
        }
        new Task.Backgroundable(this.myProject, message, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (PydevConsoleRunnerImpl.this.myProcessHandler != null) {
                    UIUtil.invokeAndWaitIfNeeded(() -> PydevConsoleRunnerImpl.this.closeCommunication());
                    boolean processStopped = PydevConsoleRunnerImpl.this.myProcessHandler.waitFor(WAIT_BEFORE_FORCED_CLOSE_MILLIS.longValue());
                    if (!processStopped) {
                        PydevConsoleRunnerImpl.tryKillProcess(PydevConsoleRunnerImpl.this.myProcessHandler);
                    }
                    PydevConsoleRunnerImpl.this.myProcessHandler.waitFor();
                }
                if (rerun.booleanValue()) {
                    ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> PydevConsoleRunnerImpl.this.reRun(true, displayName));
                } else {
                    PydevConsoleRunnerImpl.this.myConsoleListeners.clear();
                }
                if (PyConsoleUtil.isCommandQueueEnabled(this.myProject)) {
                    PydevConsoleRunnerImpl.this.myConsoleView.restoreQueueWindow(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$7", "run"));
            }
        }.queue();
    }

    private static void tryKillProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(45);
        }
        if (processHandler instanceof KillableProcessHandler && ((KillableProcessHandler)processHandler).canKillProcess()) {
            ((KillableProcessHandler)processHandler).killProcess();
        }
    }

    @Override
    @TestOnly
    public void setSdk(@Nullable Sdk sdk2) {
        this.mySdk = sdk2;
    }

    @Override
    @Nullable
    public Sdk getSdk() {
        return this.mySdk;
    }

    private XDebugSession connectToDebugger() throws ExecutionException {
        final ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        return XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(PyBundle.message("pydev.console.runner.python.console.debugger", new Object[0]), PythonPsiApiIcons.Python, null, true, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(final @NotNull XDebugSession session) {
                if (session == null) {
                    8.$$$reportNull$$$0(0);
                }
                PythonDebugLanguageConsoleView debugConsoleView = new PythonDebugLanguageConsoleView(PydevConsoleRunnerImpl.this.myProject, PydevConsoleRunnerImpl.this.mySdk);
                PyConsoleDebugProcessHandler consoleDebugProcessHandler = new PyConsoleDebugProcessHandler(PydevConsoleRunnerImpl.this.myProcessHandler);
                PyConsoleDebugProcess consoleDebugProcess = new PyConsoleDebugProcess(session, serverSocket, (ExecutionConsole)debugConsoleView, consoleDebugProcessHandler);
                PythonDebugConsoleCommunication communication = PyDebugRunner.initDebugConsoleView(PydevConsoleRunnerImpl.this.myProject, consoleDebugProcess, debugConsoleView, consoleDebugProcessHandler, session);
                communication.addCommunicationListener(new ConsoleCommunicationListener(){

                    @Override
                    public void commandExecuted(boolean more) {
                        session.rebuildViews();
                    }

                    @Override
                    public void inputRequested() {
                    }
                });
                PydevConsoleRunnerImpl.this.myPydevConsoleCommunication.setDebugCommunication(communication);
                debugConsoleView.attachToProcess(consoleDebugProcessHandler);
                consoleDebugProcess.waitForNextConnection();
                try {
                    consoleDebugProcess.connect(PydevConsoleRunnerImpl.this.myPydevConsoleCommunication);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                PydevConsoleRunnerImpl.this.myProcessHandler.notifyTextAvailable(PyBundle.message("pydev.console.debugger.connected", new Object[0]), ProcessOutputTypes.STDERR);
                PyConsoleDebugProcess pyConsoleDebugProcess = consoleDebugProcess;
                if (pyConsoleDebugProcess == null) {
                    8.$$$reportNull$$$0(1);
                }
                return pyConsoleDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$8";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Override
    public PythonConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    public static PythonConsoleRunnerFactory factory() {
        return new PydevConsoleRunnerFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17, 28, 32, 34, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 20: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentVariables";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsToExecuteFunction";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 32: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl";
                break;
            }
            case 19: 
            case 24: 
            case 26: 
            case 33: 
            case 35: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideServerPort";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParams";
                break;
            }
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareTargetRequest";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements2execute";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsToExecute";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsoleCmdLine";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreatePythonConsoleExecution";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleView";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecuteActionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 32: 
            case 34: 
            case 41: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findAvailablePort";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createPythonConsoleExecution";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunParams";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConsoleCmdLine";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doCreatePythonConsoleExecution";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleView";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createProcessUsingTargetsAPI";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addProjectAndModuleToRequest";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePortFromProcess";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "initAndRun";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fireConsoleInitializedEvent";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleDisplayName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "stopAndRerunConsole";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "tryKillProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17, 28, 32, 34, 41 -> new IllegalStateException(string);
        };
    }

    private class ConnectDebuggerAction
    extends ToggleAction
    implements DumbAware {
        private boolean mySelected;
        private XDebugSession mySession;

        ConnectDebuggerAction() {
            super(PyBundle.messagePointer("console.attach.debugger", new Object[0]), PyBundle.messagePointer("console.attach.debugger.description", new Object[0]), PythonIcons.Python.AttachDebugger);
            this.mySelected = false;
            this.mySession = null;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ConnectDebuggerAction.$$$reportNull$$$0(0);
            }
            return this.mySelected;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ConnectDebuggerAction.$$$reportNull$$$0(1);
            }
            if (this.mySession != null) {
                e.getPresentation().setEnabled(false);
            } else {
                super.update(e);
                e.getPresentation().setEnabled(true);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ConnectDebuggerAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ConnectDebuggerAction.$$$reportNull$$$0(3);
            }
            this.mySelected = state;
            if (this.mySelected) {
                try {
                    this.mySession = PydevConsoleRunnerImpl.this.connectToDebugger();
                }
                catch (Exception e1) {
                    LOG.error((Throwable)e1);
                    Messages.showErrorDialog((String)PyBundle.message("console.cannot.connect.to.debugger", new Object[0]), (String)PyBundle.message("console.error.connecting.debugger", new Object[0]));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$ConnectDebuggerAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$ConnectDebuggerAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class SoftWrapAction
    extends ToggleAction
    implements DumbAware {
        private boolean isSelected;

        SoftWrapAction() {
            super(ActionsBundle.actionText((String)"EditorToggleUseSoftWraps"), ActionsBundle.actionDescription((String)"EditorToggleUseSoftWraps"), AllIcons.Actions.ToggleSoftWrap);
            this.isSelected = PydevConsoleRunnerImpl.this.myConsoleSettings.isUseSoftWraps();
            this.updateEditors();
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SoftWrapAction.$$$reportNull$$$0(0);
            }
            return this.isSelected;
        }

        private void updateEditors() {
            PydevConsoleRunnerImpl.this.myConsoleView.getEditor().getSettings().setUseSoftWraps(this.isSelected);
            PydevConsoleRunnerImpl.this.myConsoleView.getConsoleEditor().getSettings().setUseSoftWraps(this.isSelected);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SoftWrapAction.$$$reportNull$$$0(1);
            }
            this.isSelected = state;
            this.updateEditors();
            PydevConsoleRunnerImpl.this.myConsoleSettings.setUseSoftWraps(this.isSelected);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SoftWrapAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$SoftWrapAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$SoftWrapAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class PythonConsoleRunParams
    implements PythonRunParams {
        private final PyConsoleOptions.PyConsoleSettings myConsoleSettings;
        private final String myWorkingDir;
        @NotNull
        private final Sdk mySdk;
        private final Map<String, String> myEnvironmentVariables;
        @NotNull
        private List<String> myEnvFiles;

        public PythonConsoleRunParams(@NotNull PyConsoleOptions.PyConsoleSettings consoleSettings, @Nullable String workingDir, @NotNull Sdk sdk2, @NotNull Map<String, String> envs) {
            if (consoleSettings == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(0);
            }
            if (sdk2 == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(1);
            }
            if (envs == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(2);
            }
            this.myConsoleSettings = consoleSettings;
            this.myWorkingDir = workingDir;
            this.mySdk = sdk2;
            this.myEnvironmentVariables = envs;
            this.myEnvironmentVariables.putAll(consoleSettings.getEnvs());
            this.myEnvFiles = consoleSettings.myEnvFiles;
            PyDebuggerSettings debuggerSettings = PyDebuggerSettings.getInstance();
            if (debuggerSettings.getValuesPolicy() != ValuesPolicy.SYNC) {
                this.myEnvironmentVariables.put(PyDebugValue.POLICY_ENV_VARS.get(debuggerSettings.getValuesPolicy()), "True");
            }
            if (PyConsoleOutputCustomizer.Companion.getInstance().isInlineOutputSupported()) {
                this.myEnvironmentVariables.put(PydevConsoleRunnerImpl.INLINE_OUTPUT_SUPPORTED, "True");
            }
            if (RegistryManager.getInstance().is("python.console.asyncio.repl")) {
                this.myEnvironmentVariables.put("ASYNCIO_REPL", "True");
            }
            if (this.myConsoleSettings.myInterpreterOptions.contains(PydevConsoleRunnerImpl.ASYNCIO_REPL_COMMAND)) {
                this.myConsoleSettings.myInterpreterOptions = "";
            }
            PythonEnvUtil.setPythonDontWriteBytecode(this.myEnvironmentVariables);
        }

        @Override
        public String getInterpreterOptions() {
            return this.myConsoleSettings.getInterpreterOptions();
        }

        @Override
        public void setInterpreterOptions(String interpreterOptions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkingDirectory() {
            return this.myWorkingDir;
        }

        @Override
        public void setWorkingDirectory(String workingDirectory) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getSdkHome() {
            return this.mySdk.getHomePath();
        }

        @Override
        @NotNull
        public Sdk getSdk() {
            Sdk sdk2 = this.mySdk;
            if (sdk2 == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(3);
            }
            return sdk2;
        }

        @Override
        public void setSdkHome(String sdkHome) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSdk(@Nullable Sdk sdk2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setModule(Module module) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getModuleName() {
            return this.myConsoleSettings.getModuleName();
        }

        @Override
        public boolean isUseModuleSdk() {
            return this.myConsoleSettings.isUseModuleSdk();
        }

        @Override
        public void setUseModuleSdk(boolean useModuleSdk) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPassParentEnvs() {
            return this.myConsoleSettings.isPassParentEnvs();
        }

        @Override
        public void setPassParentEnvs(boolean passParentEnvs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getEnvs() {
            return this.myEnvironmentVariables;
        }

        @Override
        public void setEnvs(Map<String, String> envs) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public PathMappingSettings getMappingSettings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldAddContentRoots() {
            return this.myConsoleSettings.shouldAddContentRoots();
        }

        @Override
        public boolean shouldAddSourceRoots() {
            return this.myConsoleSettings.shouldAddSourceRoots();
        }

        @Override
        public void setAddContentRoots(boolean flag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAddSourceRoots(boolean flag) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public List<String> getEnvFilePaths() {
            List<String> list = this.myEnvFiles;
            if (list == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(4);
            }
            return list;
        }

        public void setEnvFilePaths(@NotNull List<String> strings) {
            if (strings == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(5);
            }
            this.myEnvFiles = strings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envs";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$PythonConsoleRunParams";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$PythonConsoleRunParams";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdk";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvFilePaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setEnvFilePaths";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Obsolete
    private static final class LegacyRemoteSdkProcessHandlerCreator
    extends ConsoleProcessCreationResult {
        @NotNull
        private final PyRemoteSdkAdditionalDataBase mySdkAdditionalData;
        @NotNull
        private final Project myProject;
        @NotNull
        private final PyRemoteSocketToLocalHostProvider mySocketProvider;
        @NotNull
        private final PythonRemoteInterpreterManager myRemoteInterpreterManager;

        private LegacyRemoteSdkProcessHandlerCreator(@NotNull PyRemoteSdkAdditionalDataBase data, @NotNull Process process2, @NotNull String commandLineString, @NotNull Project project2, @NotNull PyRemoteSocketToLocalHostProvider socketProvider, @NotNull PydevConsoleCommunication consoleCommunication, @NotNull PythonRemoteInterpreterManager remoteInterpreterManager) {
            if (data == null) {
                LegacyRemoteSdkProcessHandlerCreator.$$$reportNull$$$0(0);
            }
            if (process2 == null) {
                LegacyRemoteSdkProcessHandlerCreator.$$$reportNull$$$0(1);
            }
            if (commandLineString == null) {
                LegacyRemoteSdkProcessHandlerCreator.$$$reportNull$$$0(2);
            }
            if (project2 == null) {
                LegacyRemoteSdkProcessHandlerCreator.$$$reportNull$$$0(3);
            }
            if (socketProvider == null) {
                LegacyRemoteSdkProcessHandlerCreator.$$$reportNull$$$0(4);
            }
            if (consoleCommunication == null) {
                LegacyRemoteSdkProcessHandlerCreator.$$$reportNull$$$0(5);
            }
            if (remoteInterpreterManager == null) {
                LegacyRemoteSdkProcessHandlerCreator.$$$reportNull$$$0(6);
            }
            super(process2, commandLineString, consoleCommunication, null);
            this.mySdkAdditionalData = data;
            this.myProject = project2;
            this.mySocketProvider = socketProvider;
            this.myRemoteInterpreterManager = remoteInterpreterManager;
        }

        @Override
        @NotNull
        public ProcessHandler createPythonConsoleProcessHandler(@NotNull PythonConsoleView consoleView) {
            if (consoleView == null) {
                LegacyRemoteSdkProcessHandlerCreator.$$$reportNull$$$0(7);
            }
            PyConsoleProcessHandler pyConsoleProcessHandler = this.myRemoteInterpreterManager.createConsoleProcessHandler(this.myProcess, consoleView, this.myConsoleCommunication, this.myCommandLineString, CONSOLE_CHARSET, PythonRemoteInterpreterManager.appendBasicMappings(this.myProject, null, this.mySdkAdditionalData), this.mySocketProvider);
            if (pyConsoleProcessHandler == null) {
                LegacyRemoteSdkProcessHandlerCreator.$$$reportNull$$$0(8);
            }
            return pyConsoleProcessHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineString";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "socketProvider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleCommunication";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteInterpreterManager";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$LegacyRemoteSdkProcessHandlerCreator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$LegacyRemoteSdkProcessHandlerCreator";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPythonConsoleProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createPythonConsoleProcessHandler";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Obsolete
    private static final class LegacyLocalProcessHandlerCreator
    extends ConsoleProcessCreationResult {
        private LegacyLocalProcessHandlerCreator(@NotNull Process process2, @NotNull String commandLineString, @NotNull PydevConsoleCommunication consoleCommunication) {
            if (process2 == null) {
                LegacyLocalProcessHandlerCreator.$$$reportNull$$$0(0);
            }
            if (commandLineString == null) {
                LegacyLocalProcessHandlerCreator.$$$reportNull$$$0(1);
            }
            if (consoleCommunication == null) {
                LegacyLocalProcessHandlerCreator.$$$reportNull$$$0(2);
            }
            super(process2, commandLineString, consoleCommunication, null);
        }

        @Override
        @NotNull
        public ProcessHandler createPythonConsoleProcessHandler(@NotNull PythonConsoleView consoleView) {
            if (consoleView == null) {
                LegacyLocalProcessHandlerCreator.$$$reportNull$$$0(3);
            }
            return new PyConsoleProcessHandler(this.myProcess, consoleView, this.myConsoleCommunication, this.myCommandLineString, CONSOLE_CHARSET);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineString";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleCommunication";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$LegacyLocalProcessHandlerCreator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPythonConsoleProcessHandler";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TargetProcessHandlerFactory
    extends ConsoleProcessCreationResult {
        @NotNull
        private final ProcessHandler myProcessHandler;

        private TargetProcessHandlerFactory(@NotNull ProcessHandler handler2, @NotNull Process process2, @NotNull String commandLineString, @NotNull PydevConsoleCommunication consoleCommunication, @NotNull TargetEnvironment targetEnvironment) {
            if (handler2 == null) {
                TargetProcessHandlerFactory.$$$reportNull$$$0(0);
            }
            if (process2 == null) {
                TargetProcessHandlerFactory.$$$reportNull$$$0(1);
            }
            if (commandLineString == null) {
                TargetProcessHandlerFactory.$$$reportNull$$$0(2);
            }
            if (consoleCommunication == null) {
                TargetProcessHandlerFactory.$$$reportNull$$$0(3);
            }
            if (targetEnvironment == null) {
                TargetProcessHandlerFactory.$$$reportNull$$$0(4);
            }
            super(process2, commandLineString, consoleCommunication, targetEnvironment);
            this.myProcessHandler = handler2;
        }

        @Override
        @NotNull
        public ProcessHandler createPythonConsoleProcessHandler(@NotNull PythonConsoleView consoleView) {
            if (consoleView == null) {
                TargetProcessHandlerFactory.$$$reportNull$$$0(5);
            }
            PyConsoleProcessHandlers.configureProcessHandlerForPythonConsole(this.myProcessHandler, consoleView, this.myConsoleCommunication);
            ProcessHandler processHandler = this.myProcessHandler;
            if (processHandler == null) {
                TargetProcessHandlerFactory.$$$reportNull$$$0(6);
            }
            return processHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineString";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleCommunication";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetEnvironment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$TargetProcessHandlerFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$TargetProcessHandlerFactory";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPythonConsoleProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createPythonConsoleProcessHandler";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class ConsoleProcessCreationResult {
        @NotNull
        protected final Process myProcess;
        @NotNull
        protected final String myCommandLineString;
        @NotNull
        protected final PydevConsoleCommunication myConsoleCommunication;
        @Nullable
        protected final TargetEnvironment myTargetEnvironment;

        private ConsoleProcessCreationResult(@NotNull Process process2, @NotNull String commandLineString, @NotNull PydevConsoleCommunication consoleCommunication, @Nullable TargetEnvironment environment) {
            if (process2 == null) {
                ConsoleProcessCreationResult.$$$reportNull$$$0(0);
            }
            if (commandLineString == null) {
                ConsoleProcessCreationResult.$$$reportNull$$$0(1);
            }
            if (consoleCommunication == null) {
                ConsoleProcessCreationResult.$$$reportNull$$$0(2);
            }
            this.myProcess = process2;
            this.myCommandLineString = commandLineString;
            this.myConsoleCommunication = consoleCommunication;
            this.myTargetEnvironment = environment;
        }

        @Nullable
        public final TargetEnvironment getTargetEnvironment() {
            return this.myTargetEnvironment;
        }

        @NotNull
        public abstract ProcessHandler createPythonConsoleProcessHandler(@NotNull PythonConsoleView var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "process";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commandLineString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleCommunication";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$ConsoleProcessCreationResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RestartAction
    extends AnAction {
        private final PydevConsoleRunnerImpl myConsoleRunner;
        @NlsContexts.TabTitle
        private final String myInitTitle;

        private RestartAction(PydevConsoleRunnerImpl runner, @NlsContexts.TabTitle String initTitle) {
            ActionUtil.copyFrom((AnAction)this, (String)"Rerun");
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Restart);
            this.myConsoleRunner = runner;
            this.myInitTitle = initTitle;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name2;
            if (e == null) {
                RestartAction.$$$reportNull$$$0(0);
            }
            String displayName = this.myInitTitle;
            Project project2 = e.getProject();
            if (project2 != null && !displayName.equals(name2 = PydevConsoleRunnerImpl.getConsoleDisplayName(project2))) {
                displayName = name2;
            }
            this.myConsoleRunner.stopAndRerunConsole(true, PyBundle.message("console.restarting.console", new Object[0]), displayName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/console/PydevConsoleRunnerImpl$RestartAction", "actionPerformed"));
        }
    }
}

