/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModChooseAction;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.stubs.PyImportStatementStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportToImportFromIntention
extends PsiBasedModCommandAction<PyReferenceExpression> {
    @NotNull
    private final ThreeState myUnqualifyAll;

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.convert.import.unqualify", new Object[0]);
        if (string == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static IntentionState createState(@NotNull PyReferenceExpression refExprUnderCaret) {
        ResolveResult[] resolveResultArray;
        PyImportElement importElement;
        if (refExprUnderCaret == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(1);
        }
        if ((importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)refExprUnderCaret, PyImportElement.class)) != null) {
            return new IntentionState(importElement, null);
        }
        PyReferenceExpression reference = Objects.requireNonNullElse((PyReferenceExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)refExprUnderCaret, PyReferenceExpression.class), refExprUnderCaret);
        while ((resolveResultArray = reference.getQualifier()) instanceof PyReferenceExpression) {
            PyReferenceExpression refQualifier = (PyReferenceExpression)resolveResultArray;
            resolveResultArray = refQualifier.getReference().multiResolve(false);
            int n = resolveResultArray.length;
            for (int i = 0; i < n; ++i) {
                PyImportElement importDefiner;
                ImportedResolveResult irr;
                PyImportedNameDefiner pyImportedNameDefiner;
                ResolveResult rr = resolveResultArray[i];
                if (!rr.isValidResult() || !(rr instanceof ImportedResolveResult) || !((pyImportedNameDefiner = (irr = (ImportedResolveResult)rr).getDefiner()) instanceof PyImportElement) || (importDefiner = (PyImportElement)pyImportedNameDefiner).getContainingFile() != refExprUnderCaret.getContainingFile()) continue;
                return new IntentionState(importDefiner, reference.asQualifiedName());
            }
            reference = refQualifier;
        }
        return null;
    }

    public ImportToImportFromIntention() {
        this(ThreeState.UNSURE);
    }

    private ImportToImportFromIntention(@NotNull ThreeState unqualifyAll) {
        if (unqualifyAll == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(2);
        }
        super(PyReferenceExpression.class);
        this.myUnqualifyAll = unqualifyAll;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PyReferenceExpression element) {
        if (context == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(4);
        }
        if (!(context.file() instanceof PyFile)) {
            return null;
        }
        IntentionState state = ImportToImportFromIntention.createState(element);
        if (state != null && state.isAvailable()) {
            return Presentation.of((String)(switch (this.myUnqualifyAll) {
                default -> throw new IncompatibleClassChangeError();
                case ThreeState.YES -> PyPsiBundle.message("INTN.remove.qualifier.from.all.usages", new Object[0]);
                case ThreeState.NO -> PyPsiBundle.message("INTN.remove.qualifier.from.this.name", new Object[0]);
                case ThreeState.UNSURE -> state.getText();
            }));
        }
        return null;
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PyReferenceExpression element) {
        if (context == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(6);
        }
        return switch (this.myUnqualifyAll) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeState.YES -> ImportToImportFromIntention.invoke(element, true);
            case ThreeState.NO -> ImportToImportFromIntention.invoke(element, false);
            case ThreeState.UNSURE -> {
                IntentionState state = ImportToImportFromIntention.createAndCheckState(element);
                if (state.allReferencesHaveSameName()) {
                    yield ImportToImportFromIntention.invoke(element, true);
                }
                yield new ModChooseAction(PyPsiBundle.message("INTN.multiple.usages.of.import.found", new Object[0]), List.of(new ImportToImportFromIntention(ThreeState.YES), new ImportToImportFromIntention(ThreeState.NO)));
            }
        };
    }

    @NotNull
    private static ModCommand invoke(@NotNull PyReferenceExpression refExpr, boolean unqualifyAll) {
        if (refExpr == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(7);
        }
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)refExpr, refExprCopy -> ImportToImportFromIntention.createAndCheckState(refExprCopy).invoke(unqualifyAll));
        if (modCommand == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(8);
        }
        return modCommand;
    }

    @NotNull
    private static IntentionState createAndCheckState(@NotNull PyReferenceExpression refExpr) {
        IntentionState state;
        if (refExpr == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(9);
        }
        if ((state = ImportToImportFromIntention.createState(refExpr)) == null || !state.isAvailable()) {
            throw new IllegalStateException();
        }
        IntentionState intentionState = state;
        if (intentionState == null) {
            ImportToImportFromIntention.$$$reportNull$$$0(10);
        }
        return intentionState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExprUnderCaret";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unqualifyAll";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndCheckState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAndCheckState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9 -> new IllegalArgumentException(string);
        };
    }

    private static class IntentionState {
        @NotNull
        private final PyImportElement myImportElement;
        @Nullable
        private final QualifiedName myQualifiedName;
        @NotNull
        private final List<PyReferenceExpression> myReferences;
        @NotNull
        private final String myNewImportSource;
        private boolean myHasModuleReference;

        IntentionState(@NotNull PyImportElement importElement, @Nullable QualifiedName qualifiedName) {
            PyFromImportStatement fromImport;
            if (importElement == null) {
                IntentionState.$$$reportNull$$$0(0);
            }
            this.myReferences = new ArrayList<PyReferenceExpression>();
            this.myHasModuleReference = false;
            int relativeLevel = 0;
            boolean available = false;
            this.myImportElement = importElement;
            this.myQualifiedName = qualifiedName;
            PsiElement parent = this.myImportElement.getParent();
            if (parent instanceof PyImportStatement) {
                available = true;
            } else if (parent instanceof PyFromImportStatement && (relativeLevel = (fromImport = (PyFromImportStatement)parent).getRelativeLevel()) > 0 && fromImport.getImportSource() == null) {
                available = true;
            }
            PyReferenceExpression oldImportSource = this.myImportElement.getImportReferenceExpression();
            assert (oldImportSource != null);
            this.myNewImportSource = StringUtil.repeat((String)".", (int)relativeLevel) + PyPsiUtils.toPath(oldImportSource);
            if (available) {
                this.collectReferencesAndOtherData(oldImportSource);
            }
        }

        public boolean isAvailable() {
            return !this.myReferences.isEmpty();
        }

        private void collectReferencesAndOtherData(@NotNull PyReferenceExpression oldImportSource) {
            if (oldImportSource == null) {
                IntentionState.$$$reportNull$$$0(1);
            }
            final String qualifierName = IntentionState.getQualifierName(this.myImportElement);
            final PsiElement referee = oldImportSource.getReference().resolve();
            this.myHasModuleReference = false;
            if (referee != null && qualifierName != null) {
                PsiTreeUtil.processElements((PsiElement)oldImportSource.getContainingFile(), (PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

                    public boolean execute(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof PyReferenceExpression) {
                            PyReferenceExpression ref = (PyReferenceExpression)element;
                            if (PsiTreeUtil.getParentOfType((PsiElement)element, PyImportElement.class) == null && qualifierName.equals(PyPsiUtils.toPath(ref))) {
                                if (ref.getParent() instanceof PyReferenceExpression) {
                                    PsiElement resolved = ref.getReference().resolve();
                                    if (resolved == referee) {
                                        myReferences.add(ref);
                                    }
                                } else {
                                    myHasModuleReference = true;
                                }
                            }
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState$1", "execute"));
                    }
                });
            }
        }

        public boolean allReferencesHaveSameName() {
            return this.myReferences.size() == this.getSameNameReferences().size();
        }

        @NotNull
        private Collection<PyReferenceExpression> getSameNameReferences() {
            if (this.myQualifiedName == null) {
                List<PyReferenceExpression> list = this.myReferences;
                if (list == null) {
                    IntentionState.$$$reportNull$$$0(2);
                }
                return list;
            }
            List list = ContainerUtil.filter(this.myReferences, ref -> {
                PyReferenceExpression parentRef;
                PsiElement patt4646$temp = ref.getParent();
                return patt4646$temp instanceof PyReferenceExpression && this.myQualifiedName.equals((Object)(parentRef = (PyReferenceExpression)patt4646$temp).asQualifiedName());
            });
            if (list == null) {
                IntentionState.$$$reportNull$$$0(3);
            }
            return list;
        }

        public void invoke(boolean unqualifyAll) {
            Project project2 = this.myImportElement.getProject();
            PyElementGenerator generator = PyElementGenerator.getInstance(project2);
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)this.myImportElement);
            try {
                boolean canRemoveImport;
                PyImportElement[] importElements;
                StubBasedPsiElement<PyImportStatementStub> importStatement;
                HashSet<String> usedNames = new HashSet<String>();
                Collection<PyReferenceExpression> referencesToUpdate = unqualifyAll ? this.myReferences : this.getSameNameReferences();
                for (PyReferenceExpression ref : referencesToUpdate) {
                    PsiElement parentElt = ref.getParent();
                    assert (parentElt instanceof PyReferenceExpression) : parentElt.getClass();
                    String nameUsed = Objects.requireNonNull(((PyReferenceExpression)parentElt).getReferencedName());
                    usedNames.add(nameUsed);
                    PyExpression newReference = generator.createExpressionFromText(languageLevel, nameUsed);
                    parentElt.replace((PsiElement)newReference);
                }
                PsiElement importer = this.myImportElement.getParent();
                if (importer instanceof PyImportStatement) {
                    PyImportStatement qualifiedImportStatement = (PyImportStatement)importer;
                    importStatement = qualifiedImportStatement;
                    importElements = importStatement.getImportElements();
                } else if (importer instanceof PyFromImportStatement) {
                    PyFromImportStatement fromImportStatement = (PyFromImportStatement)importer;
                    importStatement = fromImportStatement;
                    importElements = importStatement.getImportElements();
                } else {
                    throw new IncorrectOperationException("Not an import at all");
                }
                PyFromImportStatement newImportStatement = generator.createFromImportStatement(languageLevel, this.myNewImportSource, StringUtil.join(usedNames, (String)", "), null);
                PsiElement parent = importStatement.getParent();
                boolean bl = canRemoveImport = !this.myHasModuleReference && referencesToUpdate.size() == this.myReferences.size();
                if (importElements.length == 1) {
                    if (!canRemoveImport) {
                        parent.addAfter((PsiElement)newImportStatement, importStatement);
                    } else {
                        importStatement.replace((PsiElement)newImportStatement);
                    }
                } else {
                    if (canRemoveImport) {
                        this.myImportElement.delete();
                    }
                    parent.addAfter((PsiElement)newImportStatement, importStatement);
                }
            }
            catch (IncorrectOperationException ignored) {
                PythonUiService.getInstance().showBalloonWarning(project2, PyPsiBundle.message("QFIX.action.failed", new Object[0]));
            }
        }

        @NotNull
        @IntentionName
        public String getText() {
            if (this.myQualifiedName == null) {
                String string = PyPsiBundle.message("INTN.convert.to.from.import", this.myNewImportSource, "...");
                if (string == null) {
                    IntentionState.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = PyPsiBundle.message("INTN.remove.qualifier", IntentionState.getQualifierName(this.myImportElement));
            if (string == null) {
                IntentionState.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        private static String getQualifierName(@NotNull PyImportElement importElement) {
            String asName;
            if (importElement == null) {
                IntentionState.$$$reportNull$$$0(6);
            }
            if ((asName = importElement.getAsName()) != null) {
                return asName;
            }
            QualifiedName importedQName = importElement.getImportedQName();
            if (importedQName != null) {
                return importedQName.toString();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldImportSource";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSameNameReferences";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "collectReferencesAndOtherData";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifierName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

