/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.codeInsight.imports.ImportChooser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportFromExistingAction
implements QuestionAction {
    private final PsiElement myTarget;
    private final List<ImportCandidateHolder> mySources;
    private final String myName;
    @Nullable
    private final PsiElement myInsertBefore;
    private final boolean myUseQualifiedImport;
    private Runnable myOnDoneCallback;
    private final boolean myImportLocally;

    public ImportFromExistingAction(@NotNull PsiElement target, @NotNull List<ImportCandidateHolder> sources, @NotNull String name2, @Nullable PsiElement insertBefore, boolean useQualified, boolean importLocally) {
        if (target == null) {
            ImportFromExistingAction.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            ImportFromExistingAction.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            ImportFromExistingAction.$$$reportNull$$$0(2);
        }
        this.myTarget = target;
        this.mySources = sources;
        this.myName = name2;
        this.myInsertBefore = insertBefore;
        this.myUseQualifiedImport = useQualified;
        this.myImportLocally = importLocally;
    }

    public void onDone(Runnable callback) {
        assert (this.myOnDoneCallback == null);
        this.myOnDoneCallback = callback;
    }

    public boolean execute() {
        PyPsiUtils.assertValid(this.myTarget);
        if (this.myTarget instanceof PyQualifiedExpression && ((PyQualifiedExpression)this.myTarget).isQualified()) {
            return false;
        }
        for (ImportCandidateHolder item : this.mySources) {
            PyPsiUtils.assertValid((PsiElement)item.getImportable());
            PyPsiUtils.assertValid((PsiElement)item.getFile());
            PyImportElement element = item.getImportElement();
            if (element == null) continue;
            PyPsiUtils.assertValid((PsiElement)element);
        }
        if (this.mySources.isEmpty()) {
            return false;
        }
        if (this.insideIntentionPreview()) {
            ImportCandidateHolder item = this.mySources.get(0);
            if (item.getImportable() == null) {
                return false;
            }
            this.doIt(item);
        } else if (this.mySources.size() == 1) {
            this.doWriteAction(this.mySources.get(0));
        } else {
            this.selectSourceAndDo();
        }
        return true;
    }

    private boolean insideIntentionPreview() {
        return !this.myTarget.isPhysical();
    }

    private void selectSourceAndDo() {
        ImportChooser.getInstance().selectImport(this.mySources, this.myUseQualifiedImport).onSuccess(candidate -> {
            PsiDocumentManager.getInstance((Project)this.myTarget.getProject()).commitAllDocuments();
            this.doWriteAction((ImportCandidateHolder)candidate);
        });
    }

    private void doIt(ImportCandidateHolder item) {
        if (item.getImportElement() != null) {
            this.addToExistingImport(item);
        } else {
            this.addImportStatement(item);
        }
    }

    private void addImportStatement(@NotNull ImportCandidateHolder item) {
        if (item == null) {
            ImportFromExistingAction.$$$reportNull$$$0(3);
        }
        Project project2 = this.myTarget.getProject();
        PyElementGenerator gen = PyElementGenerator.getInstance(project2);
        PsiFileSystemItem filesystemAnchor = (PsiFileSystemItem)ObjectUtils.chooseNotNull((Object)PyUtil.as(item.getImportable(), PsiFileSystemItem.class), (Object)item.getFile());
        if (filesystemAnchor == null) {
            return;
        }
        AddImportHelper.ImportPriority priority = AddImportHelper.getImportPriority(this.myTarget, filesystemAnchor);
        PsiFile file = this.myTarget.getContainingFile();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project2);
        if (manager.isInjectedFragment(file)) {
            file = manager.getTopLevelFile(this.myTarget);
        }
        if (PyUtil.isRoot(item.getFile())) {
            if (this.myImportLocally) {
                AddImportHelper.addLocalImportStatement(this.myTarget, item.getImportableName(), item.getAsName());
            } else {
                AddImportHelper.addImportStatement(file, item.getImportableName(), item.getAsName(), priority, this.myTarget, this.myInsertBefore);
            }
        } else {
            String qualifiedName = Objects.toString(item.getPath(), "");
            if (this.myUseQualifiedImport) {
                Object nameToImport = qualifiedName;
                if (item.getImportable() instanceof PsiFileSystemItem) {
                    nameToImport = (String)nameToImport + "." + item.getImportableName();
                }
                if (this.myImportLocally) {
                    AddImportHelper.addLocalImportStatement(this.myTarget, (String)nameToImport, item.getAsName());
                } else {
                    AddImportHelper.addImportStatement(file, (String)nameToImport, item.getAsName(), priority, this.myTarget, this.myInsertBefore);
                }
                if (item.getAsName() == null) {
                    this.myTarget.replace((PsiElement)gen.createExpressionFromText(LanguageLevel.forElement((PsiElement)this.myTarget), qualifiedName + "." + this.myName));
                }
            } else if (this.myImportLocally) {
                AddImportHelper.addLocalFromImportStatement(this.myTarget, qualifiedName, item.getImportableName(), item.getAsName());
            } else {
                AddImportHelper.addOrUpdateFromImportStatement(file, qualifiedName, item.getImportableName(), item.getAsName(), priority, this.myTarget, this.myInsertBefore);
            }
        }
    }

    private void addToExistingImport(@NotNull ImportCandidateHolder item) {
        if (item == null) {
            ImportFromExistingAction.$$$reportNull$$$0(4);
        }
        PyImportElement importElement = item.getImportElement();
        assert (importElement != null);
        PsiElement parent = importElement.getParent();
        if (parent instanceof PyFromImportStatement) {
            AddImportHelper.addNameToFromImportStatement((PyFromImportStatement)parent, item.getImportableName(), item.getAsName());
        } else {
            PyElementGenerator gen = PyElementGenerator.getInstance(this.myTarget.getProject());
            this.myTarget.replace((PsiElement)gen.createExpressionFromText(LanguageLevel.forElement((PsiElement)this.myTarget), importElement.getVisibleName() + "." + this.myName));
        }
    }

    private void doWriteAction(ImportCandidateHolder item) {
        PsiNamedElement src = item.getImportable();
        if (src == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)src.getProject(), (PsiFile[])new PsiFile[]{this.myTarget.getContainingFile()}).withName(PyPsiBundle.message("ACT.CMD.use.import", new Object[0])).run(() -> this.doIt(item));
        if (this.myOnDoneCallback != null) {
            this.myOnDoneCallback.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/imports/ImportFromExistingAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addImportStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addToExistingImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

