/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public enum PythonHelper implements HelperPackage
{
    GENERATOR3("generator3/__main__.py"),
    REMOTE_SYNC("remote_sync.py"),
    PACKAGING_TOOL("packaging_tool.py"),
    VIRTUALENV_ZIPAPP("virtualenv-20.24.5.pyz"),
    LEGACY_VIRTUALENV_ZIPAPP("virtualenv-20.13.0.pyz"),
    COVERAGEPY_OLD("coveragepy_old", "", new String[0]),
    COVERAGEPY_NEW("coveragepy_new", "", new String[0]),
    COVERAGE("coverage_runner", "run_coverage", new String[0]),
    DEBUGGER("pydev", "pydevd", "thriftpy"),
    ATTACH_DEBUGGER("pydev/pydevd_attach_to_process/attach_pydevd.py"),
    CONSOLE("pydev", "pydevconsole", "thriftpy"),
    PROFILER("profiler", "run_profiler", "thriftpy"),
    LOAD_PSTAT("profiler", "load_pstat", "thriftpy"),
    LOAD_ENTRY_POINT("pycharm", "pycharm_load_entry_point", new String[0]),
    UT_OLD("pycharm", "utrunner", new String[0]),
    TOX("pycharm", "_jb_tox_runner", new String[0]),
    SETUPPY("pycharm", "pycharm_setup_runner", new String[0]),
    NOSE_OLD("pycharm", "noserunner", new String[0]),
    PYTEST_OLD("pycharm", "pytestrunner", new String[0]),
    DOCSTRING("pycharm", "docrunner", new String[0]),
    UNITTEST("pycharm", "_jb_unittest_runner", new String[0]),
    PYTEST("pycharm", "_jb_pytest_runner", new String[0]),
    TRIAL("pycharm", "_jb_trialtest_runner", new String[0]),
    NOSE("pycharm", "_jb_nosetest_runner", new String[0]),
    BEHAVE("pycharm", "behave_runner", new String[0]),
    DJANGO_TEST_MANAGE("pycharm", "django_test_manage", new String[0]),
    DJANGO_MANAGE("pycharm", "django_manage", new String[0]),
    DJANGO_PROJECT_CREATOR("pycharm", "_jb_django_project_creator", new String[0]),
    MANAGE_TASKS_PROVIDER("pycharm", "_jb_manage_tasks_provider", new String[0]),
    APPCFG_CONSOLE("pycharm", "appcfg_fetcher", new String[0]),
    DOCSTRING_FORMATTER("docstring_formatter.py"),
    EXTRA_SYSPATH("extra_syspath.py"),
    SYSPATH("syspath.py"),
    PYCODESTYLE("pycodestyle.py"),
    PYCODESTYLE_2_10_0("pycodestyle-2.10.0.py"),
    PYCODESTYLE_2_8_0("pycodestyle-2.8.0.py"),
    REST_RUNNER("rest_runners/rst2smth.py"),
    SPHINX_RUNNER("rest_runners/sphinx_runner.py"),
    JUPYTER("pycharm", "jupyter", new String[0]);

    public static final String PY3_HELPER_DEPENDENCIES_DIR = "py3only";
    public static final String PY2_HELPER_DEPENDENCIES_DIR = "py2only";
    private final PathHelperPackage myModule;

    @NotNull
    private static PathHelperPackage findModule(String moduleEntryPoint, String path2, boolean asModule, String[] thirdPartyDependencies) {
        List<HelperDependency> dependencies = HelperDependency.findThirdPartyDependencies(thirdPartyDependencies);
        if (PythonHelpersLocator.findPathInHelpers(path2 + ".zip") != null) {
            return new ModuleHelperPackage(moduleEntryPoint, path2 + ".zip", dependencies);
        }
        Path pathInHelpers = PythonHelpersLocator.findPathInHelpers(path2);
        if (!asModule && pathInHelpers != null && new File(pathInHelpers.toFile(), moduleEntryPoint + ".py").isFile()) {
            return new ScriptPythonHelper(moduleEntryPoint + ".py", pathInHelpers.toFile(), dependencies);
        }
        return new ModuleHelperPackage(moduleEntryPoint, path2, dependencies);
    }

    private PythonHelper(String pythonPath, String moduleName, String ... dependencies) {
        this(pythonPath, moduleName, false, dependencies);
    }

    private PythonHelper(String pythonPath, String moduleName, boolean asModule, String ... dependencies) {
        this.myModule = PythonHelper.findModule(moduleName, pythonPath, asModule, dependencies);
    }

    private PythonHelper(String helperScript) {
        this.myModule = new ScriptPythonHelper(helperScript, PythonHelpersLocator.getCommunityHelpersRoot().toFile(), Collections.emptyList());
    }

    @Override
    @NotNull
    public String getPythonPathEntry() {
        String string = this.myModule.getPythonPathEntry();
        if (string == null) {
            PythonHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getPythonPathEntries() {
        List<String> list = this.myModule.getPythonPathEntries();
        if (list == null) {
            PythonHelper.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void addToPythonPath(@NotNull Map<String, String> environment) {
        if (environment == null) {
            PythonHelper.$$$reportNull$$$0(2);
        }
        this.myModule.addToPythonPath(environment);
    }

    @Override
    public void addToGroup(@NotNull ParamsGroup group2, @NotNull GeneralCommandLine cmd) {
        if (group2 == null) {
            PythonHelper.$$$reportNull$$$0(3);
        }
        if (cmd == null) {
            PythonHelper.$$$reportNull$$$0(4);
        }
        this.myModule.addToGroup(group2, cmd);
    }

    @Override
    @NotNull
    public String asParamString() {
        String string = this.myModule.asParamString();
        if (string == null) {
            PythonHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public GeneralCommandLine newCommandLine(@NotNull String sdkPath, @NotNull List<String> parameters) {
        if (sdkPath == null) {
            PythonHelper.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            PythonHelper.$$$reportNull$$$0(7);
        }
        GeneralCommandLine generalCommandLine = this.myModule.newCommandLine(sdkPath, parameters);
        if (generalCommandLine == null) {
            PythonHelper.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    @Override
    @NotNull
    public GeneralCommandLine newCommandLine(@NotNull Sdk pythonSdk, @NotNull List<String> parameters) {
        if (pythonSdk == null) {
            PythonHelper.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            PythonHelper.$$$reportNull$$$0(10);
        }
        GeneralCommandLine generalCommandLine = this.myModule.newCommandLine(pythonSdk, parameters);
        if (generalCommandLine == null) {
            PythonHelper.$$$reportNull$$$0(11);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PythonHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonPathEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonPathEntries";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PythonHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asParamString";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addToPythonPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToGroup";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    private static final class HelperDependency {
        private static final String THRIFTPY = "thriftpy";
        @NotNull
        private final String myPythonPath;

        private HelperDependency(@NotNull String pythonPath) {
            if (pythonPath == null) {
                HelperDependency.$$$reportNull$$$0(0);
            }
            this.myPythonPath = pythonPath;
        }

        public void addToPythonPath(@NotNull Map<String, String> environment) {
            if (environment == null) {
                HelperDependency.$$$reportNull$$$0(1);
            }
            PythonEnvUtil.addToPythonPath(environment, this.myPythonPath);
        }

        @NotNull
        public List<String> getPythonPathEntries() {
            List<String> list = Collections.singletonList(this.myPythonPath);
            if (list == null) {
                HelperDependency.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        private static List<HelperDependency> findThirdPartyDependencies(String ... dependencies) {
            if (dependencies == null) {
                List<HelperDependency> list = Collections.emptyList();
                if (list == null) {
                    HelperDependency.$$$reportNull$$$0(3);
                }
                return list;
            }
            List list = ContainerUtil.map((Object[])dependencies, s -> HelperDependency.getThirdPartyDependency(s));
            if (list == null) {
                HelperDependency.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private static HelperDependency getThirdPartyDependency(@NotNull String name2) {
            if (name2 == null) {
                HelperDependency.$$$reportNull$$$0(5);
            }
            String path2 = new File(HelperDependency.getHelpersThirdPartyDir(), name2).getAbsolutePath();
            return new HelperDependency(path2);
        }

        @NotNull
        private static File getHelpersThirdPartyDir() {
            File file = Objects.requireNonNull(PythonHelpersLocator.findPathInHelpers("third_party")).toFile();
            if (file == null) {
                HelperDependency.$$$reportNull$$$0(6);
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pythonPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/PythonHelper$HelperDependency";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/PythonHelper$HelperDependency";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPythonPathEntries";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findThirdPartyDependencies";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHelpersThirdPartyDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addToPythonPath";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getThirdPartyDependency";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static class ModuleHelperPackage
    extends PathHelperPackage {
        private final String myModuleName;

        public ModuleHelperPackage(String moduleName, String relativePath, @NotNull List<HelperDependency> dependencies) {
            if (dependencies == null) {
                ModuleHelperPackage.$$$reportNull$$$0(0);
            }
            super(PythonHelpersLocator.findPathStringInHelpers(relativePath), dependencies);
            this.myModuleName = moduleName;
        }

        @Override
        @NotNull
        public String asParamString() {
            String string = "-m" + this.myModuleName;
            if (string == null) {
                ModuleHelperPackage.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPythonPathEntry() {
            String string = FileUtil.toSystemDependentName((String)this.myPath.getAbsolutePath());
            if (string == null) {
                ModuleHelperPackage.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/PythonHelper$ModuleHelperPackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/PythonHelper$ModuleHelperPackage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asParamString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPythonPathEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class ScriptPythonHelper
    extends PathHelperPackage {
        private final String myPythonPath;

        public ScriptPythonHelper(String script, File pythonPath, @NotNull List<HelperDependency> dependencies) {
            if (dependencies == null) {
                ScriptPythonHelper.$$$reportNull$$$0(0);
            }
            super(new File(pythonPath, script).getAbsolutePath(), dependencies);
            this.myPythonPath = pythonPath.getAbsolutePath();
        }

        @Override
        public void addToPythonPath(@NotNull Map<String, String> environment) {
            if (environment == null) {
                ScriptPythonHelper.$$$reportNull$$$0(1);
            }
            PythonEnvUtil.setPythonDontWriteBytecode(environment);
            super.addToPythonPath(environment);
        }

        @Override
        @NotNull
        public String getPythonPathEntry() {
            String string = this.myPythonPath;
            if (string == null) {
                ScriptPythonHelper.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/PythonHelper$ScriptPythonHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/PythonHelper$ScriptPythonHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPythonPathEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addToPythonPath";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class PathHelperPackage
    implements HelperPackage {
        protected final File myPath;
        @NotNull
        protected final List<HelperDependency> myDependencies;

        PathHelperPackage(String path2, @NotNull List<HelperDependency> dependencies) {
            if (dependencies == null) {
                PathHelperPackage.$$$reportNull$$$0(0);
            }
            this.myPath = new File(path2);
            this.myDependencies = dependencies;
        }

        @Override
        public void addToPythonPath(@NotNull Map<String, String> environment) {
            if (environment == null) {
                PathHelperPackage.$$$reportNull$$$0(1);
            }
            this.myDependencies.forEach(dependency -> dependency.addToPythonPath(environment));
            PythonEnvUtil.addToPythonPath(environment, this.getPythonPathEntry());
        }

        @Override
        @NotNull
        public List<String> getPythonPathEntries() {
            ArrayList entries = this.myDependencies.stream().flatMap(dependency -> dependency.getPythonPathEntries().stream()).collect(Collectors.toCollection(ArrayList::new));
            entries.add(this.getPythonPathEntry());
            ArrayList arrayList = entries;
            if (arrayList == null) {
                PathHelperPackage.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        public void addToGroup(@NotNull ParamsGroup group2, @NotNull GeneralCommandLine cmd) {
            if (group2 == null) {
                PathHelperPackage.$$$reportNull$$$0(3);
            }
            if (cmd == null) {
                PathHelperPackage.$$$reportNull$$$0(4);
            }
            this.addToPythonPath(cmd.getEnvironment());
            group2.addParameter(this.asParamString());
        }

        @Override
        @NotNull
        public String asParamString() {
            String string = FileUtil.toSystemDependentName((String)this.myPath.getAbsolutePath());
            if (string == null) {
                PathHelperPackage.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        public GeneralCommandLine newCommandLine(@NotNull String sdkPath, @NotNull List<String> parameters) {
            if (sdkPath == null) {
                PathHelperPackage.$$$reportNull$$$0(6);
            }
            if (parameters == null) {
                PathHelperPackage.$$$reportNull$$$0(7);
            }
            ArrayList<String> args2 = new ArrayList<String>();
            args2.add(sdkPath);
            args2.add(this.asParamString());
            args2.addAll(parameters);
            GeneralCommandLine cmd = new GeneralCommandLine(args2);
            Map env = cmd.getEnvironment();
            this.addToPythonPath(env);
            PythonEnvUtil.resetHomePathChanges(sdkPath, env);
            GeneralCommandLine generalCommandLine = cmd;
            if (generalCommandLine == null) {
                PathHelperPackage.$$$reportNull$$$0(8);
            }
            return generalCommandLine;
        }

        @Override
        @NotNull
        public GeneralCommandLine newCommandLine(@NotNull Sdk pythonSdk, @NotNull List<String> parameters) {
            if (pythonSdk == null) {
                PathHelperPackage.$$$reportNull$$$0(9);
            }
            if (parameters == null) {
                PathHelperPackage.$$$reportNull$$$0(10);
            }
            String sdkHomePath = pythonSdk.getHomePath();
            assert (sdkHomePath != null);
            GeneralCommandLine cmd = this.newCommandLine(sdkHomePath, parameters);
            LanguageLevel version2 = PythonSdkType.getLanguageLevelForSdk(pythonSdk);
            String perVersionDependenciesDir = version2.isPython2() ? PythonHelper.PY2_HELPER_DEPENDENCIES_DIR : PythonHelper.PY3_HELPER_DEPENDENCIES_DIR;
            PythonEnvUtil.addToPythonPath((Map<String, String>)cmd.getEnvironment(), FileUtil.join((String[])new String[]{this.getPythonPathEntry(), perVersionDependenciesDir}));
            GeneralCommandLine generalCommandLine = cmd;
            if (generalCommandLine == null) {
                PathHelperPackage.$$$reportNull$$$0(11);
            }
            return generalCommandLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 8, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/PythonHelper$PathHelperPackage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmd";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkPath";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pythonSdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/PythonHelper$PathHelperPackage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPythonPathEntries";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asParamString";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newCommandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addToPythonPath";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 11: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addToGroup";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "newCommandLine";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 8, 11 -> new IllegalStateException(string);
            };
        }
    }
}

