/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.java.inspections;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.python.community.plugin.java.facet.JavaPythonFacet;
import com.intellij.python.community.plugin.java.facet.JavaPythonFacetConfiguration;
import com.intellij.python.community.plugin.java.facet.JavaPythonFacetType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonPluginCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "python";
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription() {
        String string = PyBundle.message("py.commandline.configure", new Object[0]);
        if (string == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isApplicable(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        boolean bl;
        block10: {
            if (context == null) {
                PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(1);
            }
            Stream<Path> stream = Files.walk(context.getProjectPath(), new FileVisitOption[0]);
            try {
                boolean hasAnyPythonFiles = stream.anyMatch(f -> f.toString().endsWith(".py"));
                if (!hasAnyPythonFiles) {
                    context.getLogger().reportMessage(3, "Skipping Python interpreter configuration because the project doesn't contain any Python files");
                }
                bl = hasAnyPythonFiles;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        if (context == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(2);
        }
        CommandLineInspectionProgressReporter logger = context.getLogger();
        logger.reportMessage(3, "Python environment configuration...");
        List<Sdk> sdks2 = PythonSdkUtil.getAllSdks();
        PythonPluginCommandLineInspectionProjectConfigurator.logSdks(logger, sdks2, "Already configured Python interpreters:");
        if (sdks2.isEmpty()) {
            logger.reportMessage(3, "No previously configured Python interpreters, detecting...");
            List<Sdk> detectedSdks = PySdkExtKt.findAllPythonSdks(context.getProjectPath());
            PythonPluginCommandLineInspectionProjectConfigurator.logSdks(logger, detectedSdks, "Python interpreters detected:");
            if (!detectedSdks.isEmpty()) {
                Sdk detectedSdk = detectedSdks.get(0);
                Sdk sdk2 = PythonPluginCommandLineInspectionProjectConfigurator.configureSdk(detectedSdk);
                if (sdk2 != null) {
                    logger.reportMessage(3, "Python interpreter has been configured: " + sdk2.getHomePath());
                } else {
                    logger.reportMessage(1, "Can't configure Python interpreter: " + detectedSdk.getHomePath());
                }
            } else {
                logger.reportMessage(1, "Can't find Python interpreter");
            }
        }
    }

    private static void logSdks(@NotNull CommandLineInspectionProgressReporter logger, @NotNull List<Sdk> sdks2, @NotNull String prefix) {
        if (logger == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(3);
        }
        if (sdks2 == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(5);
        }
        logger.reportMessage(3, prefix);
        for (Sdk sdk2 : sdks2) {
            logger.reportMessage(3, sdk2.getHomePath());
        }
    }

    @Nullable
    private static Sdk configureSdk(@NotNull Sdk detectedSdk) {
        Sdk sdk2;
        if (detectedSdk == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(6);
        }
        Sdk sdk3 = sdk2 = detectedSdk instanceof PyDetectedSdk ? PySdkExtKt.setup((PyDetectedSdk)detectedSdk, Arrays.asList(ProjectJdkTable.getInstance().getAllJdks())) : detectedSdk;
        if (sdk2 != null) {
            PythonPluginCommandLineInspectionProjectConfigurator.invokeLaterOnWriteThreadUnderLock(() -> ProjectJdkTable.getInstance().addJdk(sdk2));
        }
        return sdk2;
    }

    public void configureProject(@NotNull Project project2, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        if (project2 == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(8);
        }
        CommandLineInspectionProgressReporter logger = context.getLogger();
        if (PythonSdkUtil.getAllSdks().isEmpty()) {
            logger.reportMessage(1, "No configured python interpreters");
            return;
        }
        JavaPythonFacetType facetType = JavaPythonFacetType.getInstance();
        int skippedModules = 0;
        for (Module m : ModuleManager.getInstance((Project)project2).getModules()) {
            if (((Boolean)ReadAction.compute(() -> !FileTypeIndex.containsFileOfType((FileType)PythonFileType.INSTANCE, (GlobalSearchScope)m.getModuleContentScope()))).booleanValue()) {
                ++skippedModules;
                continue;
            }
            FacetManager facetManager = FacetManager.getInstance((Module)m);
            JavaPythonFacet facet = (JavaPythonFacet)facetManager.getFacetByType(facetType.getId());
            if (facet == null) {
                logger.reportMessage(3, "Setting Python facet for: " + m.getName());
                PythonPluginCommandLineInspectionProjectConfigurator.invokeLaterOnWriteThreadUnderLock(() -> {
                    JavaPythonFacet addedFacet = (JavaPythonFacet)facetManager.addFacet((FacetType)facetType, facetType.getPresentableName(), null);
                    PySdkExtKt.excludeInnerVirtualEnv(m, ((JavaPythonFacetConfiguration)addedFacet.getConfiguration()).getSdk());
                });
                continue;
            }
            logger.reportMessage(3, "Python facet already here: " + m.getName());
        }
        logger.reportMessage(3, "Skipped Python interpreter configuration for " + skippedModules + " module(s) because they don't contain any Python files");
    }

    private static void invokeLaterOnWriteThreadUnderLock(@NotNull Runnable runnable) {
        if (runnable == null) {
            PythonPluginCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(9);
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLaterOnWriteThread(() -> application.runWriteAction(runnable));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/community/plugin/java/inspections/PythonPluginCommandLineInspectionProjectConfigurator";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedSdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/community/plugin/java/inspections/PythonPluginCommandLineInspectionProjectConfigurator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configureEnvironment";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logSdks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureSdk";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterOnWriteThreadUnderLock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

