/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.grouping;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007J\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0013\u001a\u00020\fH\u0086\u0002J\u001c\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\nR\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ui/grouping/NodeGroupRepository;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "", "()V", "groups", "", "Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "root2GroupMap", "Ljava/util/IdentityHashMap;", "Lcom/intellij/profiler/model/CallTreeNode;", "size", "", "getSize", "()I", "addGroup", "", "group", "get", "index", "groupStartingWithNode", "node", "intellij.profiler.common"})
@ApiStatus.Experimental
public final class NodeGroupRepository<Call extends BaseCallStackElement> {
    @NotNull
    private final List<FoldingNodesGroup<Call>> groups = new ArrayList();
    @NotNull
    private final IdentityHashMap<CallTreeNode<Call>, FoldingNodesGroup<Call>> root2GroupMap = new IdentityHashMap();

    public final void addGroup(@NotNull FoldingNodesGroup<Call> group2) {
        Intrinsics.checkNotNullParameter(group2, (String)"group");
        ((Collection)this.groups).add(group2);
        ((Map)this.root2GroupMap).put(group2.getGroupStart(), group2);
    }

    @Nullable
    public final FoldingNodesGroup<Call> groupStartingWithNode(@NotNull CallTreeNode<? extends Call> node2) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        return this.root2GroupMap.get(node2);
    }

    public final int getSize() {
        return this.groups.size();
    }

    @NotNull
    public final FoldingNodesGroup<Call> get(int index) {
        return this.groups.get(index);
    }
}

