/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.block.completion.TerminalInlineCompletion;
import org.jetbrains.plugins.terminal.block.history.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.block.history.CommandSearchPresenter;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptController;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorDescription;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorStateListener;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorUtil;
import org.jetbrains.plugins.terminal.block.prompt.lang.TerminalPromptLanguage;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.ui.TerminalUi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001&B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0002J\b\u0010%\u001a\u00020\u001dH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptView;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController$PromptStateListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "commandExecutor", "Lorg/jetbrains/plugins/terminal/block/TerminalCommandExecutor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/TerminalCommandExecutor;)V", "commandHistoryPresenter", "Lorg/jetbrains/plugins/terminal/block/history/CommandHistoryPresenter;", "commandSearchPresenter", "Lorg/jetbrains/plugins/terminal/block/history/CommandSearchPresenter;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "controller", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;", "getController", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "preferredFocusableComponent", "getPreferredFocusableComponent", "commandHistoryStateChanged", "", "showing", "", "commandSearchRequested", "createPromptTextField", "Lcom/intellij/ui/LanguageTextField;", "createToolbarComponent", "targetComponent", "dispose", "TerminalPromptPanel", "intellij.terminal"})
public final class TerminalPromptView
implements TerminalPromptController.PromptStateListener,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalPromptController controller;
    @NotNull
    private final JComponent component;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final CommandHistoryPresenter commandHistoryPresenter;
    @NotNull
    private final CommandSearchPresenter commandSearchPresenter;

    public TerminalPromptView(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull BlockTerminalSession session2, @NotNull TerminalCommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        this.project = project;
        this.settings = settings;
        LanguageTextField editorTextField = this.createPromptTextField(session2);
        EditorEx editorEx = editorTextField.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        this.editor = (EditorImpl)editorEx;
        this.controller = new TerminalPromptController(this.project, (EditorEx)this.editor, session2, commandExecutor);
        this.controller.addListener(this);
        this.commandHistoryPresenter = new CommandHistoryPresenter(this.project, (Editor)this.editor, this.controller);
        this.commandSearchPresenter = new CommandSearchPresenter(this.project, (Editor)this.editor, this.controller.getModel());
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        JComponent toolbarComponent = this.createToolbarComponent((JComponent)editorComponentImpl);
        final TerminalPromptPanel promptPanel = new TerminalPromptPanel((JComponent)editorTextField, toolbarComponent);
        this.component = (JComponent)((Object)promptPanel);
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)11, (int)19, (int)12, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        JBEmptyBorder innerBorder = jBEmptyBorder;
        Color color = TerminalUi.INSTANCE.promptSeparatorColor((Editor)this.editor);
        JBInsets jBInsets = new JBInsets(1, 0, 0, 0);
        CustomLineBorder outerBorder2 = new CustomLineBorder(color, jBInsets){

            public void paintBorder(@NotNull Component c, @Nullable Graphics g, int x, int y, int w, int h) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                if (c.getY() != 0) {
                    super.paintBorder(c, g, x, y, w, h);
                }
            }
        };
        ((TerminalPromptPanel)((Object)this.component)).setBorder(JBUI.Borders.compound((Border)((Border)outerBorder2), (Border)((Border)innerBorder)));
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@Nullable MouseEvent e) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)editor.getContentComponent(), true);
            }
        });
        this.controller.getModel().addErrorStateListener(new TerminalPromptErrorStateListener(){

            @Override
            public void errorStateChanged(@Nullable TerminalPromptErrorDescription description2) {
                JComponent jComponent;
                if (description2 != null) {
                    EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
                    Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
                    jComponent = TerminalPromptErrorUtil.INSTANCE.createErrorComponent(description2, editorColorsScheme);
                } else {
                    jComponent = null;
                }
                JComponent errorComponent = jComponent;
                promptPanel.setBottomComponent(errorComponent);
            }
        }, this);
    }

    @NotNull
    public final TerminalPromptController getController() {
        return this.controller;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        return (JComponent)editorComponentImpl;
    }

    @Override
    public void commandHistoryStateChanged(boolean showing) {
        if (showing) {
            List<String> history = this.controller.getCommandHistory();
            if (!((Collection)history).isEmpty()) {
                this.commandHistoryPresenter.showCommandHistory(history);
            }
        } else {
            this.commandHistoryPresenter.onCommandHistoryClosed();
        }
    }

    @Override
    public void commandSearchRequested() {
        List<String> history = this.controller.getCommandHistory();
        if (!((Collection)history).isEmpty()) {
            this.commandSearchPresenter.showCommandSearch(history);
        }
    }

    private final LanguageTextField createPromptTextField(BlockTerminalSession session2) {
        TerminalPromptLanguage terminalPromptLanguage = TerminalPromptLanguage.INSTANCE;
        Project project = this.project;
        LanguageTextField textField2 = new LanguageTextField(terminalPromptLanguage, project){

            public void setBackground(@Nullable Color bg) {
            }

            public void updateUI() {
                super.updateUI();
                this.setFont(EditorUtil.getEditorFont());
            }
        };
        textField2.setDisposedWith((Disposable)this);
        textField2.setAlignmentX(0.0f);
        EditorEx editorEx = textField2.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor = (EditorImpl)editorEx;
        editor.getSettings().setUseSoftWraps(true);
        editor.getSettings().setShowingSpecialChars(false);
        editor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor.getScrollPane().setVerticalScrollBarPolicy(20);
        editor.getScrollPane().setHorizontalScrollBarPolicy(31);
        editor.setVerticalScrollbarVisible(true);
        editor.getGutterComponentEx().setPaintBackground(false);
        TerminalUi.INSTANCE.useTerminalDefaultBackground((EditorEx)editor, this);
        Project $this$createPromptTextField_u24lambda_u240 = project = editor.getColorsScheme();
        boolean bl = false;
        $this$createPromptTextField_u24lambda_u240.setEditorFontName(this.settings.getTerminalFont().getFontName());
        $this$createPromptTextField_u24lambda_u240.setEditorFontSize(this.settings.getTerminalFont().getSize());
        $this$createPromptTextField_u24lambda_u240.setLineSpacing(1.0f);
        $this$createPromptTextField_u24lambda_u240.setColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, null);
        editor.getCaretModel().getPrimaryCaret().setVisualAttributes(new CaretVisualAttributes(null, CaretVisualAttributes.Weight.HEAVY));
        editor.putUserData(AutoPopupController.SHOW_BOTTOM_PANEL_IN_LOOKUP_UI, (Object)false);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)editor.getDocument());
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            editor.setFile(it);
            it.putUserData(NavBarModelExtension.IGNORE_IN_NAVBAR, (Object)true);
        }
        if (Registry.is((String)"terminal.new.ui.inline.completion")) {
            TerminalInlineCompletion.Companion.getInstance(this.project).install((EditorEx)editor);
        }
        editor.setContextMenuGroupId("Terminal.PromptContextMenu");
        return textField2;
    }

    private final JComponent createToolbarComponent(JComponent targetComponent) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Terminal.PromptToolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup toolbarGroup = (ActionGroup)anAction;
        ActionToolbar actionToolbar = actionManager.createActionToolbar("TerminalPrompt", toolbarGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(targetComponent);
        toolbar.getComponent().setOpaque(false);
        toolbar.getComponent().setBorder((Border)JBUI.Borders.emptyRight((int)10));
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    public void dispose() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptView$TerminalPromptPanel;", "Lcom/intellij/ui/components/JBLayeredPane;", "mainComponent", "Ljavax/swing/JComponent;", "sideComponent", "(Ljavax/swing/JComponent;Ljavax/swing/JComponent;)V", "bottomComponent", "doLayout", "", "getPreferredSize", "Ljava/awt/Dimension;", "layoutMainAndBottomComponents", "main", "Ljava/awt/Component;", "bottom", "rect", "Ljava/awt/Rectangle;", "layoutSideComponent", "component", "setBottomComponent", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalPromptView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPromptView.kt\norg/jetbrains/plugins/terminal/block/prompt/TerminalPromptView$TerminalPromptPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
    private static final class TerminalPromptPanel
    extends JBLayeredPane {
        @NotNull
        private final JComponent mainComponent;
        @NotNull
        private final JComponent sideComponent;
        @Nullable
        private JComponent bottomComponent;

        public TerminalPromptPanel(@NotNull JComponent mainComponent, @NotNull JComponent sideComponent) {
            Intrinsics.checkNotNullParameter((Object)mainComponent, (String)"mainComponent");
            Intrinsics.checkNotNullParameter((Object)sideComponent, (String)"sideComponent");
            this.mainComponent = mainComponent;
            this.sideComponent = sideComponent;
            this.setOpaque(false);
            Component component2 = this.mainComponent;
            Integer n = JLayeredPane.DEFAULT_LAYER;
            Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
            this.add(component2, n);
            Component component3 = this.sideComponent;
            Integer n2 = JLayeredPane.POPUP_LAYER;
            Intrinsics.checkNotNull((Object)n2, (String)"null cannot be cast to non-null type kotlin.Any");
            this.add(component3, n2);
        }

        public final void setBottomComponent(@Nullable JComponent component2) {
            JComponent jComponent = this.bottomComponent;
            if (jComponent != null) {
                JComponent it = jComponent;
                boolean bl = false;
                this.remove(it);
            }
            if (component2 != null) {
                Component component3 = component2;
                Integer n = JLayeredPane.DEFAULT_LAYER;
                Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
                this.add(component3, n);
            }
            this.bottomComponent = component2;
            this.revalidate();
            this.repaint();
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension mainComponentSize = this.mainComponent.getPreferredSize();
            JComponent jComponent = this.bottomComponent;
            Dimension dimension = jComponent != null ? jComponent.getPreferredSize() : null;
            if (dimension == null) {
                dimension = new Dimension(0, 0);
            }
            Dimension bottomComponentSize = dimension;
            Dimension size = new Dimension(mainComponentSize.width, mainComponentSize.height + bottomComponentSize.height);
            JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
            return size;
        }

        public void doLayout() {
            Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
            this.layoutMainAndBottomComponents(this.mainComponent, this.bottomComponent, rect);
            this.layoutSideComponent(this.sideComponent, rect);
        }

        private final void layoutMainAndBottomComponents(Component main, Component bottom, Rectangle rect) {
            int mainPrefHeight = main.getPreferredSize().height;
            int mainHeight = Math.min(rect.height, mainPrefHeight);
            main.setBounds(rect.x, rect.y, rect.width, mainHeight);
            if (bottom != null) {
                int bottomPrefHeight = bottom.getPreferredSize().height;
                int bottomHeight = Math.min(rect.height - mainHeight, bottomPrefHeight);
                bottom.setBounds(rect.x, rect.y + mainHeight, rect.width, bottomHeight);
            }
        }

        private final void layoutSideComponent(Component component2, Rectangle rect) {
            Dimension prefSize = component2.getPreferredSize();
            int compWidth = Math.min(rect.width, prefSize.width);
            component2.setBounds(rect.x + rect.width - compWidth, rect.y, compWidth, prefSize.height);
        }
    }
}

