/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdBatchAction;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdBatchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.c.clangdBridge"})
public final class ClangdBatchAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<Collection<VirtualFile>>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Collection<VirtualFile> invoke() {
                return OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)this.$project);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        Collection files2 = (Collection)object;
        long startTime = System.nanoTime();
        ClangLanguageService clangdService = ClangLanguageServiceProvider.getOrStart((Project)project2);
        if (clangdService == null) {
            ClangUtils.LOG.warn("ClangLanguageService is not found");
            return;
        }
        int nThreads = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        Set filesWithErrors = new LinkedHashSet();
        Set filesWithCrashes = new LinkedHashSet();
        AtomicInteger processedCount = new AtomicInteger(0);
        String string = ClangdBundle.message((String)"language.cpp.clangd.batch.action.title", (Object[])new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(project2, files2, executorService, startTime, filesWithErrors, filesWithCrashes, clangdService, processedCount, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection<VirtualFile> $files;
            final /* synthetic */ ExecutorService $executorService;
            final /* synthetic */ long $startTime;
            final /* synthetic */ Set<VirtualFile> $filesWithErrors;
            final /* synthetic */ Set<VirtualFile> $filesWithCrashes;
            final /* synthetic */ ClangLanguageService $clangdService;
            final /* synthetic */ AtomicInteger $processedCount;
            {
                this.$project = $project;
                this.$files = $files;
                this.$executorService = $executorService;
                this.$startTime = $startTime;
                this.$filesWithErrors = $filesWithErrors;
                this.$filesWithCrashes = $filesWithCrashes;
                this.$clangdService = $clangdService;
                this.$processedCount = $processedCount;
                super($project, $super_call_param$1, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$forEach$iv;
                ClangLanguageService $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(false);
                Iterable $this$filter$iv = this.$files;
                boolean $i$f$filter22 = false;
                Iterable iterable = $this$filter$iv;
                Set<VirtualFile> destination$iv$iv = (Set<VirtualFile>)((Object)new ArrayList<E>());
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    if (!OCLanguageUtils.isSupported((VirtualFile)it)) continue;
                    destination$iv$iv.add((VirtualFile)element$iv$iv);
                }
                $this$filter$iv = (List)((Object)destination$iv$iv);
                ExecutorService $i$f$filter22 = this.$executorService;
                $this$filterTo$iv$iv = this.$clangdService;
                destination$iv$iv = this.$filesWithCrashes;
                Set<VirtualFile> set = this.$filesWithErrors;
                AtomicInteger atomicInteger = this.$processedCount;
                Collection<VirtualFile> collection = this.$files;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VirtualFile file = (VirtualFile)element$iv;
                    boolean bl = false;
                    $i$f$filter22.submit(() -> actionPerformed.task.1.run$lambda$2$lambda$1(indicator, file, $this$filterTo$iv$iv, destination$iv$iv, set, atomicInteger, collection));
                }
                this.$executorService.shutdown();
                try {
                    while (!this.$executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                        ProgressManager.checkCanceled();
                    }
                    this.$executorService.shutdownNow();
                }
                catch (Throwable throwable) {
                    this.$executorService.shutdownNow();
                    long totalDurationMS = (System.nanoTime() - this.$startTime) / (long)1000000;
                    String result2 = "total duration: " + totalDurationMS + "ms, avg: " + totalDurationMS / (long)this.$files.size() + "ms/file\nErrors:\n" + CollectionsKt.joinToString$default((Iterable)this.$filesWithErrors, (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.task.run.result.1.INSTANCE, (int)30, null) + "\nCrashes:\n" + CollectionsKt.joinToString$default((Iterable)this.$filesWithCrashes, (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.task.run.result.2.INSTANCE, (int)30, null) + "\n";
                    ClangdBatchAction.access$getLOG$cp().warn(result2);
                    ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(result2, this.$project){
                        final /* synthetic */ String $result;
                        final /* synthetic */ Project $project;
                        {
                            this.$result = $result;
                            this.$project = $project;
                            super(0);
                        }

                        public final void invoke() {
                            LightVirtualFile infoFile = new LightVirtualFile("Clangd Batch Result", (FileType)PlainTextFileType.INSTANCE, (CharSequence)this.$result);
                            FileEditorManager.getInstance((Project)this.$project).openFile((VirtualFile)infoFile, true);
                        }
                    }), (int)1, null);
                    throw throwable;
                }
                long totalDurationMS = (System.nanoTime() - this.$startTime) / (long)1000000;
                String result3 = "total duration: " + totalDurationMS + "ms, avg: " + totalDurationMS / (long)this.$files.size() + "ms/file\nErrors:\n" + CollectionsKt.joinToString$default((Iterable)this.$filesWithErrors, (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.task.run.result.1.INSTANCE, (int)30, null) + "\nCrashes:\n" + CollectionsKt.joinToString$default((Iterable)this.$filesWithCrashes, (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.task.run.result.2.INSTANCE, (int)30, null) + "\n";
                ClangdBatchAction.access$getLOG$cp().warn(result3);
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (int)1, null);
            }

            public void onCancel() {
                super.onCancel();
                this.$executorService.shutdownNow();
            }

            private static final void run$lambda$2$lambda$1(ProgressIndicator $indicator, VirtualFile $file, ClangLanguageService $clangdService, Set $filesWithCrashes, Set $filesWithErrors, AtomicInteger $processedCount, Collection $files) {
                Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
                Intrinsics.checkNotNullParameter((Object)$filesWithCrashes, (String)"$filesWithCrashes");
                Intrinsics.checkNotNullParameter((Object)$filesWithErrors, (String)"$filesWithErrors");
                Intrinsics.checkNotNullParameter((Object)$processedCount, (String)"$processedCount");
                Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
                ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>($indicator, $file, $clangdService, (Set<VirtualFile>)$filesWithCrashes, (Set<VirtualFile>)$filesWithErrors, $processedCount, (Collection<VirtualFile>)$files){
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ ClangLanguageService $clangdService;
                    final /* synthetic */ Set<VirtualFile> $filesWithCrashes;
                    final /* synthetic */ Set<VirtualFile> $filesWithErrors;
                    final /* synthetic */ AtomicInteger $processedCount;
                    final /* synthetic */ Collection<VirtualFile> $files;
                    {
                        this.$indicator = $indicator;
                        this.$file = $file;
                        this.$clangdService = $clangdService;
                        this.$filesWithCrashes = $filesWithCrashes;
                        this.$filesWithErrors = $filesWithErrors;
                        this.$processedCount = $processedCount;
                        this.$files = $files;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        this.$indicator.setText(this.$file.getUrl());
                        SimpleOpenRequestId requestId = new SimpleOpenRequestId(ClangdBatchAction.class, "opened [" + this.$file.getName() + "]");
                        this.$clangdService.notifyDocumentOpened(this.$file, (OpenRequestId)requestId);
                        try {
                            int n;
                            long time = System.nanoTime();
                            VirtualFile virtualFile = this.$file;
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"$file");
                            List diagnostics2 = (List)ClangLanguageServiceUtilsKt.computeWithParsedKt((ClangLanguageService)this.$clangdService, (VirtualFile)virtualFile, (Function1)actionPerformed.task.run.2.1.diagnostics.1.INSTANCE);
                            if (diagnostics2 == null) {
                                if (!this.$indicator.isCanceled()) {
                                    ClangdBatchAction.access$getLOG$cp().error(this.$file.getUrl() + ": clangd crashed");
                                    VirtualFile virtualFile2 = this.$file;
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"$file");
                                    this.$filesWithCrashes.add(virtualFile2);
                                }
                                return;
                            }
                            Iterable $this$count$iv = diagnostics2;
                            boolean $i$f$count = false;
                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                n = 0;
                            } else {
                                int count$iv = 0;
                                for (T element$iv : $this$count$iv) {
                                    ClangDiagnostic it = (ClangDiagnostic)element$iv;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getSeverity(), (Object)HighlightSeverity.ERROR) || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                n = count$iv;
                            }
                            int numErrors = n;
                            long durationMS = (System.nanoTime() - time) / (long)1000000;
                            long fileLength = this.$file.getLength();
                            if (numErrors > 0) {
                                VirtualFile virtualFile3 = this.$file;
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"$file");
                                this.$filesWithErrors.add(virtualFile3);
                            }
                            ClangdBatchAction.access$getLOG$cp().info(this.$file.getUrl() + ", wait time: " + durationMS + "ms, length:" + fileLength / (long)1024 + "kb, performance: " + fileLength / durationMS + " kb/s, numErrors = " + numErrors);
                        }
                        catch (Throwable ex) {
                            ClangdBatchAction.access$getLOG$cp().error(this.$file.getUrl() + ": clangd crashed");
                            VirtualFile virtualFile = this.$file;
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"$file");
                            this.$filesWithCrashes.add(virtualFile);
                            return;
                        }
                        finally {
                            this.$clangdService.notifyDocumentClosed(this.$file, (OpenRequestId)requestId);
                            int processed = this.$processedCount.incrementAndGet();
                            this.$indicator.setFraction(1.0 * (double)processed / (double)this.$files.size());
                        }
                    }
                }));
            }
        };
        task2.queue();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance((String)ClangdBatchAction.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdBatchAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.c.clangdBridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

