/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.indexing.DumbModeAccessType;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.completion.ClangdCodeCompletionProviderBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdInsertHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.SnippetInsertHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.editor.completion.NameSuggestionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCNonImportedReferenceCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.QualifiedSelectorCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCExpressionCodeFragmentType;
import com.jetbrains.cidr.lang.parser.OCQualifiedIdCodeFragmentType;
import com.jetbrains.cidr.lang.parser.OCTypeCodeFragmentType;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.psi.OCUDLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.settings.OCCodeInsightSettings;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.List;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdCodeCompletionProviderImpl
extends ClangdCodeCompletionProviderBase {
    protected boolean isCppFile(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(0);
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        @NotNull FileType type = fileTypeManager.getFileTypeByFile(file);
        return type.equals(OCLanguageUtils.getBaseFileType());
    }

    protected void runNameSuggestionContributor(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(2);
        }
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            List contributors = CompletionContributor.forParameters((CompletionParameters)parameters);
            for (CompletionContributor contributor : contributors) {
                if (!(contributor instanceof NameSuggestionContributor)) continue;
                contributor.fillCompletionVariants(parameters, result2);
            }
        });
    }

    protected void runExtraCompletionContributors(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, int invocationCount, boolean allowNameSuggestions) {
        if (parameters == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(4);
        }
        if (parameters.getCompletionType() == CompletionType.SMART || !allowNameSuggestions && invocationCount <= 1) {
            return;
        }
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            List contributors = CompletionContributor.forParameters((CompletionParameters)parameters);
            for (CompletionContributor contributor : contributors) {
                if (invocationCount > 1 && (contributor instanceof OCNonImportedReferenceCompletionContributor || contributor instanceof QualifiedSelectorCompletionContributor)) {
                    parameters.setCompleteOnlyNotImported(true);
                    contributor.fillCompletionVariants(parameters, result2);
                }
                if (contributor instanceof NameSuggestionContributor && allowNameSuggestions) {
                    contributor.fillCompletionVariants(parameters, result2);
                }
                if (!result2.isStopped()) continue;
                break;
            }
        });
    }

    protected boolean isUDLElement(PsiElement psiContextElement) {
        return psiContextElement instanceof OCUDLiteralExpression;
    }

    @Nullable
    protected IElementType getCodeFragmentType(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(5);
        }
        if (psiFile instanceof OCCodeFragmentImpl) {
            OCCodeFragmentImpl fragment = (OCCodeFragmentImpl)psiFile;
            return fragment.getContentElementType();
        }
        return null;
    }

    @Nullable
    protected VirtualFile getVirtualFileForCodeFragment(@NotNull PsiFile psiFile, @NotNull VirtualFile virtualFile, IElementType fragmentElementType) {
        if (psiFile == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(7);
        }
        if (psiFile instanceof OCCodeFragmentImpl) {
            if (!(virtualFile instanceof OCFragmentVirtualFile)) {
                PsiElement psiContext = psiFile.getContext();
                if (psiContext == null) {
                    return null;
                }
                OCCodeFragmentImpl newFragment = new OCCodeFragmentImpl(psiContext.getProject(), OCElementFactory.getLanguageKindFromContext((PsiElement)psiContext), (CharSequence)psiFile.getText(), true, fragmentElementType);
                newFragment.setContext(psiContext);
                return newFragment.getVirtualFile();
            }
            return virtualFile;
        }
        return null;
    }

    protected int getCompletionKind(@NotNull CompletionParameters parameters, IElementType fragmentElementType, boolean isUDL) {
        CodeInsightSettings codeInsightSettings;
        int caseSensitivity;
        boolean completeInNamespacesByDefault;
        if (parameters == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(8);
        }
        int completionKind = CLionCompletionKind.Default.getValue();
        CompletionType completionType = parameters.getCompletionType();
        if (completionType == CompletionType.SMART) {
            completionKind = CLionCompletionKind.Smart.getValue();
        } else if (fragmentElementType != null) {
            completionKind = fragmentElementType instanceof OCQualifiedIdCodeFragmentType ? CLionCompletionKind.Namespace.getValue() : (fragmentElementType instanceof OCTypeCodeFragmentType ? CLionCompletionKind.Type.getValue() : (fragmentElementType instanceof OCExpressionCodeFragmentType ? CLionCompletionKind.Expression.getValue() : CLionCompletionKind.OrdinaryName.getValue()));
        }
        @Nullable Project project = parameters.getEditor().getProject();
        boolean bl = completeInNamespacesByDefault = project != null && ClangdSettings.getInstance((Project)project).isCompleteInNamespacesByDefault();
        if (completeInNamespacesByDefault || completionType == CompletionType.SMART || parameters.getInvocationCount() > 1) {
            completionKind |= CLionCompletionKind.NestedNamespaces.getValue();
        }
        if (!OCCodeInsightSettings.getInstance().ALLOW_IMPORT_IN_COMPLETION || isUDL || parameters.getInvocationCount() <= 1) {
            completionKind |= CLionCompletionKind.DisableIndex.getValue();
        }
        if ((caseSensitivity = (codeInsightSettings = CodeInsightSettings.getInstance()).getCompletionCaseSensitive()) == 3) {
            completionKind |= CLionCompletionKind.MatchCaseFirstLetter.getValue();
        } else if (caseSensitivity == 1) {
            completionKind |= CLionCompletionKind.MatchCase.getValue();
        }
        if (!EditorSettingsExternalizable.getInstance().isInsertParenthesesAutomatically()) {
            completionKind |= CLionCompletionKind.DontAddParentheses.getValue();
        }
        return completionKind;
    }

    protected OCResolveConfiguration getActiveResolveConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(9);
        }
        if (project == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(10);
        }
        return OCFileActiveConfigurationCache.getActiveConfiguration((VirtualFile)virtualFile, (Project)project);
    }

    protected LookupElementBuilder createSnippetLookup(@NotNull CLionCompletionItem completion) {
        if (completion == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(11);
        }
        return SnippetInsertHandler.snippetLookup(completion);
    }

    protected InsertHandler<LookupElement> createClangdInsertHandler(@NotNull CLionCompletionItem completion, int prefixLength, String charBeforePrefix, Position completionCaretPosition) {
        if (completion == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(12);
        }
        return new ClangdInsertHandler(completion, prefixLength, charBeforePrefix, completionCaretPosition);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            ClangdCodeCompletionProviderImpl.$$$reportNull$$$0(13);
        }
        if (this.isEnabled(context.getProject()) && !context.getDummyIdentifier().contains("CIDR_RULE_ZZZ")) {
            context.setDummyIdentifier("CIDR_RULE_ZZZ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completion";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/completion/ClangdCodeCompletionProviderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCppFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runNameSuggestionContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runExtraCompletionContributors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getCodeFragmentType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getVirtualFileForCodeFragment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompletionKind";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getActiveResolveConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createSnippetLookup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createClangdInsertHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

