/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.AxisBreaksProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisLayouter;", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "labelsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;)V", "getOrientation", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "axisLength", "", "Companion", "plot-builder"})
public final class AxisLayouter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final AxisLabelsLayout labelsLayout;

    private AxisLayouter(Orientation orientation, AxisLabelsLayout labelsLayout) {
        this.orientation = orientation;
        this.labelsLayout = labelsLayout;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final AxisLayoutInfo doLayout(@NotNull DoubleSpan axisDomain, double axisLength) {
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        AxisLabelsLayoutInfo labelsInfo = this.labelsLayout.doLayout(axisDomain, axisLength);
        ScaleBreaks scaleBreaks = labelsInfo.getBreaks();
        Intrinsics.checkNotNull((Object)scaleBreaks);
        ScaleBreaks axisBreaks = scaleBreaks;
        DoubleRectangle doubleRectangle = labelsInfo.getBounds();
        Intrinsics.checkNotNull((Object)doubleRectangle);
        DoubleRectangle labelsBounds = doubleRectangle;
        return new AxisLayoutInfo(axisLength, axisDomain, this.orientation, axisBreaks, labelsBounds, labelsInfo.getLabelRotationAngle(), labelsInfo.getLabelHorizontalAnchor(), labelsInfo.getLabelVerticalAnchor(), labelsInfo.getLabelAdditionalOffsets(), BreakLabelsLayoutUtil.INSTANCE.textBounds(labelsBounds, this.labelsLayout.getTheme().tickLabelMargins(), this.orientation), labelsInfo.getLabelBoundsList());
    }

    public /* synthetic */ AxisLayouter(Orientation orientation, AxisLabelsLayout labelsLayout, DefaultConstructorMarker $constructor_marker) {
        this(orientation, labelsLayout);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisLayouter$Companion;", "", "()V", "create", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisLayouter;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaksProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProvider;", "geomAreaInsets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "polar", "", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AxisLayouter create(@NotNull Orientation orientation, @NotNull AxisBreaksProvider breaksProvider, @NotNull Insets geomAreaInsets, @NotNull AxisTheme theme2, boolean polar) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
            Intrinsics.checkNotNullParameter((Object)geomAreaInsets, (String)"geomAreaInsets");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            AxisLabelsLayout labelsLayout = breaksProvider.isFixedBreaks() ? (orientation.isHorizontal() ? AxisLabelsLayout.Companion.horizontalFixedBreaks(orientation, breaksProvider.getFixedBreaks(), geomAreaInsets, theme2, polar) : AxisLabelsLayout.Companion.verticalFixedBreaks(orientation, breaksProvider.getFixedBreaks(), theme2)) : (orientation.isHorizontal() ? AxisLabelsLayout.Companion.horizontalFlexBreaks(orientation, breaksProvider, theme2) : AxisLabelsLayout.Companion.verticalFlexBreaks(orientation, breaksProvider, theme2));
            return new AxisLayouter(orientation, labelsLayout, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

