/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsDefaults;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.FacetsTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ColorBarAssembler;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ColorBarOptions;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GuideOptions;
import org.jetbrains.letsPlot.core.plot.builder.assemble.LegendAssembler;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotGeomTiles;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotGuidesAssemblerUtil;
import org.jetbrains.letsPlot.core.plot.builder.assemble.tiles.GeomLayerInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.SingleTilePlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\n\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u000b2\u0016\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011JD\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 J6\u0010!\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010$\u001a\u0004\u0018\u00010%2\u0016\u0010&\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020%0'H\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerUtil;", "", "()V", "createLegends", "", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxInfo;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "geomTiles", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGeomTiles;", "scaleMappersNP", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "guideOptionsMap", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GuideOptions;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "createPlotLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayout;", "layoutProviderByTile", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "insideOut", "", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "facetsTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetsTheme;", "hAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "vAxisTheme", "plotTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;", "updateAesRangeMap", "", "aes", "range", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "rangeByAes", "", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotAssemblerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotAssemblerUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerUtil\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,183:1\n372#2,7:184\n372#2,7:191\n*S KotlinDebug\n*F\n+ 1 PlotAssemblerUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerUtil\n*L\n103#1:184,7\n108#1:191,7\n*E\n"})
public final class PlotAssemblerUtil {
    @NotNull
    public static final PlotAssemblerUtil INSTANCE = new PlotAssemblerUtil();

    private PlotAssemblerUtil() {
    }

    private final void updateAesRangeMap(Aes<?> aes2, DoubleSpan range, Map<Aes<?>, DoubleSpan> rangeByAes) {
        DoubleSpan range2 = range;
        if (range2 != null) {
            DoubleSpan wasRange = rangeByAes.get(aes2);
            if (wasRange != null) {
                range2 = wasRange.union(range2);
            }
            rangeByAes.put(aes2, range2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LegendBoxInfo> createLegends(@NotNull PlotContext ctx2, @NotNull PlotGeomTiles geomTiles, @NotNull Map<Aes<?>, ? extends ScaleMapper<?>> scaleMappersNP, @NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, @NotNull LegendTheme theme2) {
        LegendBoxInfo boxInfo;
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)geomTiles, (String)"geomTiles");
        Intrinsics.checkNotNullParameter(scaleMappersNP, (String)"scaleMappersNP");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        LinkedHashMap legendAssemblerByTitle = new LinkedHashMap();
        LinkedHashMap colorBarAssemblerByTitle = new LinkedHashMap();
        for (GeomLayerInfo layerInfo : geomTiles.layerInfos()) {
            Object scaleName;
            HashMap layerConstantByAes = new HashMap();
            for (Aes<?> aes2 : layerInfo.renderedAes()) {
                if (!layerInfo.hasConstant(aes2)) continue;
                Map map2 = layerConstantByAes;
                Object obj = layerInfo.getConstant(aes2);
                Intrinsics.checkNotNull(obj);
                map2.put(aes2, obj);
            }
            LinkedHashMap aesListByScaleName = new LinkedHashMap();
            List<Aes<?>> aesList = PlotGuidesAssemblerUtil.INSTANCE.mappedRenderedAesToCreateGuides(layerInfo, guideOptionsMap);
            for (Aes<?> aes3 : aesList) {
                Object object;
                block17: {
                    Object object2;
                    ColorBarAssembler colorBarAssembler;
                    block19: {
                        block18: {
                            ColorBarOptions colorBarOptions;
                            ColorBarOptions colorBarOptions2;
                            Scale scale = ctx2.getScale(aes3);
                            scaleName = scale.getName();
                            if (guideOptionsMap.get(aes3) != null) {
                                GuideOptions it;
                                boolean bl = false;
                                if (it instanceof ColorBarOptions) {
                                    PlotGuidesAssemblerUtil.INSTANCE.checkFitsColorBar(aes3, scale);
                                    colorBarOptions2 = (ColorBarOptions)it;
                                } else {
                                    colorBarOptions2 = null;
                                }
                            } else {
                                colorBarOptions2 = colorBarOptions = null;
                            }
                            if (colorBarOptions == null && !PlotGuidesAssemblerUtil.INSTANCE.fitsColorBar(aes3, scale)) break block17;
                            DoubleSpan doubleSpan = ctx2.overallTransformedDomain(aes3);
                            Object object3 = MapsKt.getValue(scaleMappersNP, aes3);
                            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.ScaleMapper<org.jetbrains.letsPlot.commons.values.Color>");
                            colorBarAssembler = PlotGuidesAssemblerUtil.INSTANCE.createColorBarAssembler((String)scaleName, doubleSpan, scale, (ScaleMapper)object3, colorBarOptions, theme2);
                            object2 = (ColorBarAssembler)colorBarAssemblerByTitle.get(scaleName);
                            if (object2 == null) break block18;
                            ColorBarAssembler existingAssembler = object2;
                            boolean bl = false;
                            Object object4 = colorBarAssembler.equalScalesAndOptions(existingAssembler) ? scaleName : (String)scaleName + " (" + aes3.getName() + ')';
                            object2 = object4;
                            if (object4 != null) break block19;
                        }
                        object2 = scaleName;
                    }
                    Object colorbarName = object2;
                    ((Map)colorBarAssemblerByTitle).put(colorbarName, colorBarAssembler.withTitle((String)colorbarName));
                    continue;
                }
                Map $this$getOrPut$iv = aesListByScaleName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(scaleName);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(scaleName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(aes3);
            }
            for (String scaleName2 : aesListByScaleName.keySet()) {
                Object object;
                void $this$getOrPut$iv;
                scaleName = legendAssemblerByTitle;
                Intrinsics.checkNotNull((Object)scaleName2);
                String key$iv = scaleName2;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    LegendAssembler answer$iv = new LegendAssembler(scaleName2, guideOptionsMap, scaleMappersNP, theme2);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                LegendAssembler legendAssembler = (LegendAssembler)object;
                List aesListForScaleName = (List)MapsKt.getValue((Map)aesListByScaleName, (Object)scaleName2);
                LegendKeyElementFactory legendKeyFactory = layerInfo.getLegendKeyElementFactory();
                AestheticsDefaults aestheticsDefaults = layerInfo.getAestheticsDefaults();
                legendAssembler.addLayer(legendKeyFactory, aesListForScaleName, layerConstantByAes, aestheticsDefaults, layerInfo.getColorByAes(), layerInfo.getFillByAes(), layerInfo.isMarginal(), ctx2);
            }
        }
        ArrayList<LegendBoxInfo> legendBoxInfos = new ArrayList<LegendBoxInfo>();
        for (String legendTitle : colorBarAssemblerByTitle.keySet()) {
            Map map3 = colorBarAssemblerByTitle;
            Intrinsics.checkNotNull((Object)legendTitle);
            boxInfo = ((ColorBarAssembler)MapsKt.getValue((Map)map3, (Object)legendTitle)).createColorBar();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        for (String legendTitle : legendAssemblerByTitle.keySet()) {
            Map map4 = legendAssemblerByTitle;
            Intrinsics.checkNotNull((Object)legendTitle);
            boxInfo = ((LegendAssembler)MapsKt.getValue((Map)map4, (Object)legendTitle)).createLegend();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        return legendBoxInfos;
    }

    @NotNull
    public final PlotLayout createPlotLayout(@NotNull List<? extends TileLayoutProvider> layoutProviderByTile, boolean insideOut, @NotNull PlotFacets facets, @NotNull FacetsTheme facetsTheme, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme, @NotNull PlotTheme plotTheme) {
        PlotLayout plotLayout;
        Intrinsics.checkNotNullParameter(layoutProviderByTile, (String)"layoutProviderByTile");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter((Object)facetsTheme, (String)"facetsTheme");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        if (facets.isDefined()) {
            plotLayout = new FacetedPlotLayout(facets, layoutProviderByTile, facetsTheme.showStrip(), hAxisTheme, vAxisTheme, plotTheme, facetsTheme);
        } else {
            TileLayout tileLayout = insideOut ? layoutProviderByTile.get(0).createInsideOutTileLayout() : layoutProviderByTile.get(0).createTopDownTileLayout();
            plotLayout = new SingleTilePlotLayout(tileLayout, plotTheme);
        }
        return plotLayout;
    }
}

