/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.dataframe.analyzing;

import com.intellij.bigdatatools.visualization.dataframe.analyzing.AnalysisFail;
import com.intellij.bigdatatools.visualization.dataframe.analyzing.AnalysisResult;
import com.intellij.bigdatatools.visualization.dataframe.analyzing.AnalyzerState;
import com.intellij.bigdatatools.visualization.dataframe.analyzing.FileContentProvider;
import com.intellij.bigdatatools.visualization.dataframe.analyzing.NextPartNeeded;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH&\u00a8\u0006\u000e"}, d2={"Lcom/intellij/bigdatatools/visualization/dataframe/analyzing/StructuredFileAnalyzer;", "", "()V", "analyze", "Lcom/intellij/bigdatatools/visualization/dataframe/analyzing/AnalysisResult;", "contentProvider", "Lcom/intellij/bigdatatools/visualization/dataframe/analyzing/FileContentProvider;", "continueAnalysis", "Lcom/intellij/bigdatatools/visualization/dataframe/analyzing/AnalyzerState;", "nextPart", "", "startAnalysis", "startPart", "Companion", "intellij.charts"})
public abstract class StructuredFileAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAGIC_LIMIT = 10;

    @NotNull
    public abstract AnalyzerState startAnalysis(@NotNull String var1);

    @NotNull
    public abstract AnalyzerState continueAnalysis(@NotNull String var1);

    @NotNull
    public final AnalysisResult analyze(@NotNull FileContentProvider contentProvider) {
        AnalysisResult analysisResult;
        int counter2;
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        String currentPart = contentProvider.getCurrentPart();
        if (currentPart == null) {
            return new AnalysisFail("Empty file");
        }
        AnalyzerState currentState = this.startAnalysis(currentPart);
        for (counter2 = 0; currentState instanceof NextPartNeeded && contentProvider.hasNextPart() && counter2 < 10; ++counter2) {
            currentState = ((NextPartNeeded)currentState).providePart(contentProvider.getNextPart());
        }
        if (currentState instanceof AnalysisResult) {
            analysisResult = (AnalysisResult)currentState;
        } else {
            String errorMessage = counter2 >= 10 ? "Read limit exceeded" : (!contentProvider.hasNextPart() ? "Provider depleted before analysis end" : "Expected result, but got: " + currentState);
            analysisResult = new AnalysisFail(errorMessage);
        }
        return analysisResult;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/bigdatatools/visualization/dataframe/analyzing/StructuredFileAnalyzer$Companion;", "", "()V", "MAGIC_LIMIT", "", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

