/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.style;

import com.intellij.bigdatatools.visualization.charts.style.ChartsJBColor;
import com.intellij.bigdatatools.visualization.charts.style.ColorTableModel;
import com.intellij.bigdatatools.visualization.charts.style.PaletteDialogKt;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/style/ColorTablePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "table", "Ljavax/swing/JTable;", "(Ljavax/swing/JTable;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isPasteEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isPastePossible", "performPaste", "", "intellij.charts"})
public final class ColorTablePasteProvider
implements PasteProvider {
    @NotNull
    private final JTable table;

    public ColorTablePasteProvider(@NotNull JTable table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.table = table2;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        int index;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        TableModel tableModel = this.table.getModel();
        ColorTableModel colorTableModel = tableModel instanceof ColorTableModel ? (ColorTableModel)tableModel : null;
        if (colorTableModel == null) {
            return;
        }
        ColorTableModel model2 = colorTableModel;
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        if (transferable == null) {
            return;
        }
        Transferable contents = transferable;
        Object object = contents.getTransferData(DataFlavor.stringFlavor);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String data = string;
        int splitSize = 0;
        List result2 = new ArrayList();
        Object object2 = new char[]{'\n'};
        List lines = StringsKt.split$default((CharSequence)data, (char[])object2, (boolean)false, (int)0, (int)6, null);
        object2 = lines.iterator();
        while (object2.hasNext()) {
            String line2 = (String)object2.next();
            if (StringsKt.isBlank((CharSequence)line2)) continue;
            char[] cArray = new char[]{';'};
            List split = StringsKt.split$default((CharSequence)line2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (split.size() > 2 || splitSize != 0 && split.size() != splitSize) {
                return;
            }
            splitSize = split.size();
            Integer n = PaletteDialogKt.fromHexStringToColorInt((String)split.get(0));
            if (n == null) {
                return;
            }
            int first2 = n;
            if (splitSize == 1) {
                result2.add(CollectionsKt.listOf((Object)first2));
                continue;
            }
            Integer n2 = PaletteDialogKt.fromHexStringToColorInt((String)split.get(1));
            if (n2 == null) {
                return;
            }
            int second = n2;
            Object[] objectArray = new Integer[]{first2, second};
            result2.add(CollectionsKt.listOf((Object[])objectArray));
        }
        int line2 = Math.min(this.table.getRowCount(), result2.size());
        int n = 0;
        for (int i = this.table.getSelectedRow(); i < line2; ++i) {
            index = n++;
            int i2 = i;
            if (this.table.getSelectedColumn() > 2) {
                model2.setValueAt(i2, 2, ((Number)CollectionsKt.first((List)((List)result2.get(index)))).intValue());
                continue;
            }
            model2.setValueAt(i2, 0, ((Number)CollectionsKt.first((List)((List)result2.get(index)))).intValue());
            if (splitSize <= 1) continue;
            model2.setValueAt(i2, 2, ((Number)CollectionsKt.last((List)((List)result2.get(index)))).intValue());
        }
        int filledRows = this.table.getRowCount() - this.table.getSelectedRow();
        n = result2.size() - filledRows;
        for (int i = 0; i < n; ++i) {
            index = filledRows + i;
            if (splitSize > 1) {
                model2.addRow(new ChartsJBColor(((Number)CollectionsKt.first((List)((List)result2.get(index)))).intValue(), ((Number)CollectionsKt.last((List)((List)result2.get(index)))).intValue()));
                continue;
            }
            model2.addRow(new ChartsJBColor(((Number)CollectionsKt.first((List)((List)result2.get(index)))).intValue(), ((Number)CollectionsKt.first((List)((List)result2.get(index)))).intValue()));
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

