/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceUnversionedTracker;
import org.jetbrains.idea.perforce.application.UnversionedScopeScanner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4EnvHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u000eJ\u0014\u0010*\u001a\u00020\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0,J\u001c\u0010-\u001a\u00020 2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0002J\u0006\u0010/\u001a\u00020\u0018J\u001c\u00100\u001a\b\u0012\u0004\u0012\u0002010,2\u0006\u0010$\u001a\u00020%2\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020\u0018R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/idea/perforce/application/PerforceDirtyFilesHandler;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myUnversionedTracker", "Lorg/jetbrains/idea/perforce/application/PerforceUnversionedTracker;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/perforce/application/PerforceUnversionedTracker;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isActive", "", "myDirtyFiles", "", "Lcom/intellij/openapi/vcs/FilePath;", "myDirtyScopeManager", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeManager;", "myPreviousRescanProblem", "myScannerLock", "Ljava/lang/Object;", "myTotalRescanThresholdPassed", "ourFilesThreshold", "", "activate", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addDirtyFile", "holder", "cancelAndRescheduleTotalRescan", "createScanner", "Lcom/intellij/openapi/util/ThrowableComputable;", "Lorg/jetbrains/idea/perforce/application/UnversionedScopeScanner$ScanResult;", "Lcom/intellij/openapi/vcs/VcsException;", "deactivate", "isKnownToPerforce", "addGate", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerGate;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "reportDelete", "path", "reportRecheck", "targets", "", "rescan", "scanner", "rescanIfProblems", "scanAndGetMissingFiles", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "scheduleTotalRescan", "intellij.vcs.perforce"})
@SourceDebugExtension(value={"SMAP\nPerforceDirtyFilesHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerforceDirtyFilesHandler.kt\norg/jetbrains/idea/perforce/application/PerforceDirtyFilesHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n766#2:171\n857#2,2:172\n*S KotlinDebug\n*F\n+ 1 PerforceDirtyFilesHandler.kt\norg/jetbrains/idea/perforce/application/PerforceDirtyFilesHandler\n*L\n84#1:171\n84#1:172,2\n*E\n"})
public final class PerforceDirtyFilesHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PerforceUnversionedTracker myUnversionedTracker;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Set<FilePath> myDirtyFiles;
    @NotNull
    private final Object myScannerLock;
    @NotNull
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final int ourFilesThreshold;
    private boolean myTotalRescanThresholdPassed;
    private volatile boolean isActive;
    private volatile boolean myPreviousRescanProblem;

    public PerforceDirtyFilesHandler(@NotNull Project myProject, @NotNull PerforceUnversionedTracker myUnversionedTracker) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myUnversionedTracker, (String)"myUnversionedTracker");
        this.myProject = myProject;
        this.myUnversionedTracker = myUnversionedTracker;
        Logger logger = Logger.getInstance(PerforceDirtyFilesHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.myDirtyFiles = new LinkedHashSet();
        this.myScannerLock = new Object();
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)vcsDirtyScopeManager, (String)"getInstance(...)");
        this.myDirtyScopeManager = vcsDirtyScopeManager;
        this.ourFilesThreshold = 200;
        this.myTotalRescanThresholdPassed = true;
        this.myDirtyScopeManager.markEverythingDirty();
    }

    public final void activate(@NotNull Disposable parentDisposable) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Disposer.register((Disposable)parentDisposable, () -> PerforceDirtyFilesHandler.activate$lambda$0(this));
        MessageBusConnection $this$activate_u24lambda_u244 = messageBusConnection = this.myProject.getMessageBus().connect(parentDisposable);
        boolean bl = false;
        Topic topic = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VCS_CONFIGURATION_CHANGED");
        $this$activate_u24lambda_u244.subscribe(topic, () -> PerforceDirtyFilesHandler.activate$lambda$4$lambda$1(this));
        Topic<Runnable> topic2 = PerforceSettings.OFFLINE_MODE_EXITED;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"OFFLINE_MODE_EXITED");
        $this$activate_u24lambda_u244.subscribe(topic2, () -> PerforceDirtyFilesHandler.activate$lambda$4$lambda$2(this));
        Topic<P4EnvHelper.P4EnvListener> topic3 = P4EnvHelper.P4_ENV_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"P4_ENV_CHANGED");
        $this$activate_u24lambda_u244.subscribe(topic3, () -> PerforceDirtyFilesHandler.activate$lambda$4$lambda$3(this));
    }

    private final void deactivate() {
        this.isActive = false;
    }

    private final void cancelAndRescheduleTotalRescan() {
        this.isActive = false;
        this.scheduleTotalRescan();
    }

    public final void rescanIfProblems() {
        if (this.myPreviousRescanProblem) {
            this.scheduleTotalRescan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scheduleTotalRescan() {
        this.LOG.debug("totalRescan scheduled");
        Object object = this.myScannerLock;
        synchronized (object) {
            boolean bl = false;
            this.myTotalRescanThresholdPassed = true;
            this.myDirtyFiles.clear();
            this.myDirtyScopeManager.markEverythingDirty();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> scanAndGetMissingFiles(@NotNull ChangeListManagerGate addGate, @NotNull ProgressIndicator progress) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)addGate, (String)"addGate");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        ThrowableComputable<UnversionedScopeScanner.ScanResult, VcsException> scanner2 = this.createScanner();
        progress.checkCanceled();
        UnversionedScopeScanner.ScanResult result = this.rescan(scanner2);
        progress.checkCanceled();
        this.myUnversionedTracker.markUnknown(result.allLocalFiles);
        List<VirtualFile> list = result.localOnly;
        Intrinsics.checkNotNullExpressionValue(list, (String)"localOnly");
        Iterable iterable = list;
        PerforceUnversionedTracker perforceUnversionedTracker = this.myUnversionedTracker;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!this.isKnownToPerforce(addGate, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        perforceUnversionedTracker.markUnversioned((List)destination$iv$iv);
        this.myUnversionedTracker.scheduleUpdate();
        Set<String> set = result.missingFiles;
        Intrinsics.checkNotNullExpressionValue(set, (String)"missingFiles");
        return set;
    }

    private final boolean isKnownToPerforce(ChangeListManagerGate addGate, VirtualFile file) {
        FileStatus status = addGate.getStatus(file);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("status " + status + " for " + file);
        }
        return status != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ThrowableComputable<UnversionedScopeScanner.ScanResult, VcsException> createScanner() {
        Project project = this.myProject;
        UnversionedScopeScanner scanner2 = new UnversionedScopeScanner(this, project){
            final /* synthetic */ PerforceDirtyFilesHandler this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void checkCanceled() {
                if (!PerforceDirtyFilesHandler.access$isActive$p(this.this$0)) {
                    throw new ProcessCanceledException();
                }
            }
        };
        Object object = this.myScannerLock;
        synchronized (object) {
            ThrowableComputable throwableComputable;
            boolean bl = false;
            if (this.myTotalRescanThresholdPassed) {
                this.myTotalRescanThresholdPassed = false;
                throwableComputable = () -> PerforceDirtyFilesHandler.createScanner$lambda$9$lambda$7(scanner2, this);
            } else {
                Set dirtyFiles = new HashSet(this.myDirtyFiles);
                this.myDirtyFiles.clear();
                throwableComputable = () -> PerforceDirtyFilesHandler.createScanner$lambda$9$lambda$8(scanner2, dirtyFiles);
            }
            ThrowableComputable throwableComputable2 = throwableComputable;
            return throwableComputable2;
        }
    }

    private final UnversionedScopeScanner.ScanResult rescan(ThrowableComputable<UnversionedScopeScanner.ScanResult, VcsException> scanner2) throws VcsException {
        Object object;
        this.isActive = true;
        this.myPreviousRescanProblem = false;
        try {
            object = scanner2.compute();
            Intrinsics.checkNotNull((Object)object);
            object = (UnversionedScopeScanner.ScanResult)object;
        }
        catch (VcsException e) {
            this.myPreviousRescanProblem = true;
            throw e;
        }
        return object;
    }

    public final void reportRecheck(@NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.myUnversionedTracker.markUnknown(path);
        if (this.addDirtyFile(path)) {
            this.myDirtyScopeManager.fileDirty(path);
        }
    }

    public final void reportDelete(@NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.addDirtyFile(path)) {
            this.myDirtyScopeManager.fileDirty(path);
        }
    }

    public final void reportRecheck(@NotNull Set<? extends FilePath> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        for (FilePath filePath : targets) {
            if (this.addDirtyFile(filePath)) continue;
            return;
        }
        this.myDirtyScopeManager.filePathsDirty((Collection)targets, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addDirtyFile(FilePath holder) {
        Object object = this.myScannerLock;
        synchronized (object) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (!this.myTotalRescanThresholdPassed) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
                this.LOG.debug("addDirtyFile: " + holder);
                this.myDirtyFiles.add(holder);
                if (this.myDirtyFiles.size() <= this.ourFilesThreshold) break block6;
                this.scheduleTotalRescan();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private static final void activate$lambda$0(PerforceDirtyFilesHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.deactivate();
    }

    private static final void activate$lambda$4$lambda$1(PerforceDirtyFilesHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cancelAndRescheduleTotalRescan();
    }

    private static final void activate$lambda$4$lambda$2(PerforceDirtyFilesHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cancelAndRescheduleTotalRescan();
    }

    private static final void activate$lambda$4$lambda$3(PerforceDirtyFilesHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cancelAndRescheduleTotalRescan();
    }

    private static final UnversionedScopeScanner.ScanResult createScanner$lambda$9$lambda$7(UnversionedScopeScanner $scanner, PerforceDirtyFilesHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)$scanner, (String)"$scanner");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $scanner.doRescan((Collection<FilePath>)UnversionedScopeScanner.createEverythingDirtyScope(this$0.myProject), true);
    }

    private static final UnversionedScopeScanner.ScanResult createScanner$lambda$9$lambda$8(UnversionedScopeScanner $scanner, Set $dirtyFiles) {
        Intrinsics.checkNotNullParameter((Object)$scanner, (String)"$scanner");
        Intrinsics.checkNotNullParameter((Object)$dirtyFiles, (String)"$dirtyFiles");
        return $scanner.doRescan($dirtyFiles, false);
    }

    public static final /* synthetic */ boolean access$isActive$p(PerforceDirtyFilesHandler $this) {
        return $this.isActive;
    }
}

