/*
 * Decompiled with CFR 0.152.
 */
package training.statistic;

import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.ui.text.ShortcutsRenderingUtil;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FusInputEvent;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.TimeoutUtil;
import java.awt.AWTKeyStroke;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.impl.LessonExecutor;
import training.lang.LangManager;
import training.learn.CourseManager;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.statistic.ActionIdRuleValidator;
import training.statistic.FeedbackEntryPlace;
import training.statistic.FeedbackLikenessAnswer;
import training.statistic.IdeFeaturesTrainerRuleValidator;
import training.statistic.KeymapSchemeRuleValidator;
import training.statistic.LearnProjectState;
import training.statistic.LearningInternalProblems;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.statistic.SupportedLanguageRuleValidator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0017*\u0001'\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003{|}B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010M\u001a\u000206H\u0002J\b\u0010N\u001a\u00020\u0017H\u0002J\u0012\u0010O\u001a\u0004\u0018\u00010\u001a2\u0006\u0010P\u001a\u00020\u0017H\u0002J\n\u0010Q\u001a\u0004\u0018\u00010RH\u0002J\b\u0010S\u001a\u00020\u0004H\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010\u00172\u0006\u0010U\u001a\u00020VH\u0002J\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0017J\u000e\u0010Z\u001a\u00020X2\u0006\u0010[\u001a\u00020*J\u0016\u0010\\\u001a\u00020X2\u0006\u0010]\u001a\u00020\u001d2\u0006\u0010U\u001a\u00020VJ\u0016\u0010^\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u00172\u0006\u0010_\u001a\u00020\u0017J\u000e\u0010`\u001a\u00020X2\u0006\u0010U\u001a\u00020VJ\u0016\u0010a\u001a\u00020X2\u0006\u0010U\u001a\u00020V2\u0006\u0010b\u001a\u000201J\u000e\u0010c\u001a\u00020X2\u0006\u0010d\u001a\u00020CJ\u0018\u0010e\u001a\u00020X2\u0006\u00107\u001a\u0002062\b\u0010f\u001a\u0004\u0018\u00010gJ\u000e\u0010h\u001a\u00020X2\u0006\u0010[\u001a\u00020*J\u0016\u0010i\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u00172\u0006\u0010j\u001a\u00020\u0017J\u000e\u0010k\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0017J5\u0010l\u001a\u00020X2\u0006\u0010m\u001a\u00020\u000e2\u0006\u0010n\u001a\u00020 2\u0006\u0010o\u001a\u00020 2\u0006\u0010p\u001a\u00020\u00132\u0006\u0010q\u001a\u00020 H\u0000\u00a2\u0006\u0002\brJ\u0015\u0010s\u001a\u00020X2\u0006\u0010m\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\btJ\u0016\u0010u\u001a\u00020X2\u0006\u0010U\u001a\u00020V2\u0006\u0010v\u001a\u000206J\u000e\u0010w\u001a\u00020X2\u0006\u0010P\u001a\u00020\u0017J\u0018\u0010x\u001a\u00020X2\u0006\u00107\u001a\u0002062\b\u0010f\u001a\u0004\u0018\u00010gJ \u0010y\u001a\u00020X2\u0006\u00107\u001a\u0002062\b\u0010f\u001a\u0004\u0018\u00010g2\u0006\u0010z\u001a\u00020 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(R\u001c\u0010)\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020*0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010-\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010.\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020/0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00100\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u0002010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00105\u001a\u0016\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020 0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00108\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020*0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010;\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000e0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020/0FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010H\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010L\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006~"}, d2={"Ltraining/statistic/StatisticBase;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "actionIdField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "completedCountField", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "courseSizeField", "feedbackEntryPlace", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Ltraining/statistic/FeedbackEntryPlace;", "feedbackExperiencedUser", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "feedbackHasBeenSent", "feedbackLikenessAnswer", "Ltraining/statistic/FeedbackLikenessAnswer;", "feedbackOpenedViaNotification", "helpLinkClicked", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "inputEventField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/eventLog/events/FusInputEvent;", "internalProblem", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "Ltraining/statistic/LearningInternalProblems;", "internalProblemField", "isLearnProjectCloseLogged", "", "()Z", "setLearnProjectCloseLogged", "(Z)V", "keymapSchemeField", "languageField", "lastBuildLearningOpened", "training/statistic/StatisticBase$lastBuildLearningOpened$1", "Ltraining/statistic/StatisticBase$lastBuildLearningOpened$1;", "learnProjectOpenedFirstTimeEvent", "Ltraining/statistic/StatisticBase$LearnProjectOpeningWay;", "learnProjectOpeningWayField", "lessonIdField", "lessonLinkClickedFromTip", "lessonPassedEvent", "", "lessonStartedEvent", "Ltraining/statistic/LessonStartingWay;", "lessonStartingWayField", "lessonStoppedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "needShowNewLessonsNotifications", "", "newLessonsCount", "newLessonsNotificationShown", "nonLearningProjectOpened", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "onboardingBannerShown", "onboardingBannerSwitcherExpanded", "onboardingFeedbackDialogResult", "onboardingFeedbackNotificationShown", "prevRestoreLessonProgress", "Ltraining/statistic/StatisticBase$LessonProgress;", "progressUpdatedEvent", "reasonField", "Ltraining/statistic/StatisticBase$LessonStopReason;", "restorePerformedEvent", "sessionLessonTimestamp", "Ljava/util/concurrent/ConcurrentHashMap;", "shortcutClickedEvent", "showNewLessonsEvent", "showNewLessonsState", "taskIdField", "tipIdField", "versionField", "completedCount", "courseLanguage", "createInputEvent", "actionId", "getDefaultKeymap", "Lcom/intellij/openapi/keymap/Keymap;", "getGroup", "getPluginVersion", "lesson", "Ltraining/learn/course/Lesson;", "logHelpLinkClicked", "", "lessonId", "logLearnProjectOpenedForTheFirstTime", "way", "logLearningProblem", "problem", "logLessonLinkClickedFromTip", "tipId", "logLessonPassed", "logLessonStarted", "startingWay", "logLessonStopped", "reason", "logNewLessonsNotification", "previousOpenedVersion", "Lcom/intellij/openapi/util/BuildNumber;", "logNonLearningProjectOpened", "logOnboardingBannerShown", "languageId", "logOnboardingBannerSwitcherExpanded", "logOnboardingFeedbackDialogResult", "place", "hasBeenSent", "openedViaNotification", "likenessAnswer", "experiencedUser", "logOnboardingFeedbackDialogResult$intellij_featuresTrainer", "logOnboardingFeedbackNotification", "logOnboardingFeedbackNotification$intellij_featuresTrainer", "logRestorePerformed", "taskId", "logShortcutClicked", "logShowNewLessonsEvent", "logShowNewLessonsNotificationState", "showNewLessons", "LearnProjectOpeningWay", "LessonProgress", "LessonStopReason", "intellij.featuresTrainer"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStatisticBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticBase.kt\ntraining/statistic/StatisticBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,331:1\n1774#2,4:332\n13#3:336\n262#4,3:337\n262#4,3:340\n262#4,3:343\n262#4,3:346\n262#4,3:349\n262#4,3:352\n*S KotlinDebug\n*F\n+ 1 StatisticBase.kt\ntraining/statistic/StatisticBase\n*L\n306#1:332,4\n95#1:336\n112#1:337,3\n113#1:340,3\n117#1:343,3\n118#1:346,3\n121#1:349,3\n123#1:352,3\n*E\n"})
public final class StatisticBase
extends CounterUsagesCollector {
    @NotNull
    public static final StatisticBase INSTANCE;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ConcurrentHashMap<String, Long> sessionLessonTimestamp;
    @NotNull
    private static LessonProgress prevRestoreLessonProgress;
    @NotNull
    private static final EventLogGroup GROUP;
    private static boolean isLearnProjectCloseLogged;
    @NotNull
    private static final StringEventField lessonIdField;
    @NotNull
    private static final StringEventField languageField;
    @NotNull
    private static final IntEventField completedCountField;
    @NotNull
    private static final IntEventField courseSizeField;
    @NotNull
    private static final IntEventField taskIdField;
    @NotNull
    private static final StringEventField actionIdField;
    @NotNull
    private static final StringEventField keymapSchemeField;
    @NotNull
    private static final PrimitiveEventField<String> versionField;
    @NotNull
    private static final PrimitiveEventField<FusInputEvent> inputEventField;
    @NotNull
    private static final EnumEventField<LearnProjectOpeningWay> learnProjectOpeningWayField;
    @NotNull
    private static final EnumEventField<LessonStopReason> reasonField;
    @NotNull
    private static final IntEventField newLessonsCount;
    @NotNull
    private static final BooleanEventField showNewLessonsState;
    @NotNull
    private static final StringEventField tipIdField;
    @NotNull
    private static final EnumEventField<LessonStartingWay> lessonStartingWayField;
    @NotNull
    private static final EnumEventField<FeedbackEntryPlace> feedbackEntryPlace;
    @NotNull
    private static final BooleanEventField feedbackHasBeenSent;
    @NotNull
    private static final BooleanEventField feedbackOpenedViaNotification;
    @NotNull
    private static final EnumEventField<FeedbackLikenessAnswer> feedbackLikenessAnswer;
    @NotNull
    private static final BooleanEventField feedbackExperiencedUser;
    @NotNull
    private static final EnumEventField<LearningInternalProblems> internalProblemField;
    @NotNull
    private static final lastBuildLearningOpened.1 lastBuildLearningOpened;
    @NotNull
    private static final EventId3<String, String, LessonStartingWay> lessonStartedEvent;
    @NotNull
    private static final EventId3<String, String, Long> lessonPassedEvent;
    @NotNull
    private static final VarargEventId lessonStoppedEvent;
    @NotNull
    private static final VarargEventId progressUpdatedEvent;
    @NotNull
    private static final VarargEventId shortcutClickedEvent;
    @NotNull
    private static final VarargEventId restorePerformedEvent;
    @NotNull
    private static final EventId2<LearnProjectOpeningWay, String> learnProjectOpenedFirstTimeEvent;
    @NotNull
    private static final EventId1<LearnProjectOpeningWay> nonLearningProjectOpened;
    @NotNull
    private static final EventId2<Integer, String> newLessonsNotificationShown;
    @NotNull
    private static final EventId2<Integer, String> showNewLessonsEvent;
    @NotNull
    private static final EventId3<Integer, String, Boolean> needShowNewLessonsNotifications;
    @NotNull
    private static final EventId3<LearningInternalProblems, String, String> internalProblem;
    @NotNull
    private static final EventId3<String, String, String> lessonLinkClickedFromTip;
    @NotNull
    private static final EventId2<String, String> helpLinkClicked;
    @NotNull
    private static final EventId1<FeedbackEntryPlace> onboardingFeedbackNotificationShown;
    @NotNull
    private static final VarargEventId onboardingFeedbackDialogResult;
    @NotNull
    private static final EventId2<String, String> onboardingBannerShown;
    @NotNull
    private static final EventId1<String> onboardingBannerSwitcherExpanded;

    private StatisticBase() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final boolean isLearnProjectCloseLogged() {
        return isLearnProjectCloseLogged;
    }

    public final void setLearnProjectCloseLogged(boolean bl) {
        isLearnProjectCloseLogged = bl;
    }

    public final void logLessonStarted(@NotNull Lesson lesson, @NotNull LessonStartingWay startingWay) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        Intrinsics.checkNotNullParameter((Object)((Object)startingWay), (String)"startingWay");
        ((Map)sessionLessonTimestamp).put(lesson.getId(), System.nanoTime());
        lessonStartedEvent.log((Object)lesson.getId(), (Object)this.courseLanguage(), (Object)startingWay);
    }

    public final void logLessonPassed(@NotNull Lesson lesson) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        Long timestamp = sessionLessonTimestamp.get(lesson.getId());
        if (timestamp == null) {
            LOG.warn("Unable to find timestamp for a lesson: " + lesson.getName());
            return;
        }
        long delta = TimeoutUtil.getDurationMillis((long)timestamp);
        lessonPassedEvent.log((Object)lesson.getId(), (Object)this.courseLanguage(), (Object)delta);
        EventPair[] eventPairArray = new EventPair[]{lessonIdField.with((Object)lesson.getId()), completedCountField.with((Object)this.completedCount()), courseSizeField.with((Object)CourseManager.Companion.getInstance().getLessonsForModules().size()), languageField.with((Object)this.courseLanguage())};
        progressUpdatedEvent.log(eventPairArray);
    }

    public final void logLessonStopped(@NotNull LessonStopReason reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        LessonManager lessonManager = LessonManager.Companion.getInstance();
        if (lessonManager.lessonIsRunning()) {
            Lesson lesson = lessonManager.getCurrentLesson();
            Intrinsics.checkNotNull((Object)lesson);
            String lessonId = lesson.getId();
            LessonExecutor lessonExecutor = lessonManager.getCurrentLessonExecutor$intellij_featuresTrainer();
            Intrinsics.checkNotNull((Object)lessonExecutor);
            int taskId = lessonExecutor.getCurrentTaskIndex$intellij_featuresTrainer();
            EventPair[] eventPairArray = new EventPair[]{lessonIdField.with((Object)lessonId), taskIdField.with((Object)taskId), languageField.with((Object)this.courseLanguage()), reasonField.with((Object)reason)};
            lessonStoppedEvent.log(eventPairArray);
            if (reason == LessonStopReason.CLOSE_PROJECT || reason == LessonStopReason.EXIT_LINK) {
                isLearnProjectCloseLogged = true;
            }
        }
    }

    public final void logShortcutClicked(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        LessonManager lessonManager = LessonManager.Companion.getInstance();
        if (lessonManager.lessonIsRunning()) {
            Lesson lesson = lessonManager.getCurrentLesson();
            Intrinsics.checkNotNull((Object)lesson);
            Lesson lesson2 = lesson;
            Keymap keymap = this.getDefaultKeymap();
            if (keymap == null) {
                return;
            }
            Keymap keymap2 = keymap;
            EventPair[] eventPairArray = new EventPair[6];
            eventPairArray[0] = inputEventField.with((Object)this.createInputEvent(actionId));
            eventPairArray[1] = keymapSchemeField.with((Object)keymap2.getName());
            eventPairArray[2] = lessonIdField.with((Object)lesson2.getId());
            LessonExecutor lessonExecutor = lessonManager.getCurrentLessonExecutor$intellij_featuresTrainer();
            Integer n = lessonExecutor != null ? Integer.valueOf(lessonExecutor.getCurrentTaskIndex$intellij_featuresTrainer()) : null;
            Intrinsics.checkNotNull((Object)n);
            eventPairArray[3] = taskIdField.with((Object)n);
            eventPairArray[4] = actionIdField.with((Object)actionId);
            eventPairArray[5] = versionField.with((Object)this.getPluginVersion(lesson2));
            shortcutClickedEvent.log(eventPairArray);
        }
    }

    public final void logRestorePerformed(@NotNull Lesson lesson, int taskId) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        LessonProgress curLessonProgress = new LessonProgress(lesson.getId(), taskId);
        if (!Intrinsics.areEqual((Object)curLessonProgress, (Object)prevRestoreLessonProgress)) {
            prevRestoreLessonProgress = curLessonProgress;
            EventPair[] eventPairArray = new EventPair[]{lessonIdField.with((Object)lesson.getId()), taskIdField.with((Object)taskId), versionField.with((Object)this.getPluginVersion(lesson))};
            restorePerformedEvent.log(eventPairArray);
        }
    }

    public final void logLearnProjectOpenedForTheFirstTime(@NotNull LearnProjectOpeningWay way) {
        Intrinsics.checkNotNullParameter((Object)((Object)way), (String)"way");
        LangManager langManager = LangManager.Companion.getInstance();
        String string = langManager.getLanguageId();
        if (string == null) {
            return;
        }
        String languageId = string;
        if (langManager.getLearningProjectPath(languageId) == null) {
            LearnProjectState.Companion.getInstance$intellij_featuresTrainer().setFirstTimeOpenedWay(way);
            learnProjectOpenedFirstTimeEvent.log((Object)way, (Object)this.courseLanguage());
        }
    }

    public final void logNonLearningProjectOpened(@NotNull LearnProjectOpeningWay way) {
        Intrinsics.checkNotNullParameter((Object)((Object)way), (String)"way");
        nonLearningProjectOpened.log((Object)way);
    }

    public final void logNewLessonsNotification(int newLessonsCount, @Nullable BuildNumber previousOpenedVersion) {
        BuildNumber buildNumber = previousOpenedVersion;
        newLessonsNotificationShown.log((Object)newLessonsCount, (Object)(buildNumber != null ? buildNumber.asString() : null));
    }

    public final void logShowNewLessonsEvent(int newLessonsCount, @Nullable BuildNumber previousOpenedVersion) {
        BuildNumber buildNumber = previousOpenedVersion;
        showNewLessonsEvent.log((Object)newLessonsCount, (Object)(buildNumber != null ? buildNumber.asString() : null));
    }

    public final void logShowNewLessonsNotificationState(int newLessonsCount, @Nullable BuildNumber previousOpenedVersion, boolean showNewLessons) {
        BuildNumber buildNumber = previousOpenedVersion;
        needShowNewLessonsNotifications.log((Object)newLessonsCount, (Object)(buildNumber != null ? buildNumber.asString() : null), (Object)showNewLessons);
    }

    public final void logLessonLinkClickedFromTip(@NotNull String lessonId, @NotNull String tipId) {
        Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
        Intrinsics.checkNotNullParameter((Object)tipId, (String)"tipId");
        lessonLinkClickedFromTip.log((Object)lessonId, (Object)this.courseLanguage(), (Object)tipId);
    }

    public final void logHelpLinkClicked(@NotNull String lessonId) {
        Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
        helpLinkClicked.log((Object)lessonId, (Object)this.courseLanguage());
    }

    public final void logOnboardingFeedbackNotification$intellij_featuresTrainer(@NotNull FeedbackEntryPlace place) {
        Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
        onboardingFeedbackNotificationShown.log((Object)place);
    }

    public final void logOnboardingFeedbackDialogResult$intellij_featuresTrainer(@NotNull FeedbackEntryPlace place, boolean hasBeenSent, boolean openedViaNotification, @NotNull FeedbackLikenessAnswer likenessAnswer, boolean experiencedUser) {
        Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
        Intrinsics.checkNotNullParameter((Object)((Object)likenessAnswer), (String)"likenessAnswer");
        EventPair[] eventPairArray = new EventPair[]{feedbackEntryPlace.with((Object)place), feedbackHasBeenSent.with((Object)hasBeenSent), feedbackOpenedViaNotification.with((Object)openedViaNotification), feedbackLikenessAnswer.with((Object)likenessAnswer), feedbackExperiencedUser.with((Object)experiencedUser)};
        onboardingFeedbackDialogResult.log(eventPairArray);
    }

    public final void logLearningProblem(@NotNull LearningInternalProblems problem, @NotNull Lesson lesson) {
        Intrinsics.checkNotNullParameter((Object)((Object)problem), (String)"problem");
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        internalProblem.log((Object)problem, (Object)lesson.getId(), (Object)this.courseLanguage());
    }

    public final void logOnboardingBannerShown(@NotNull String lessonId, @NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        String string = languageId.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        onboardingBannerShown.log((Object)lessonId, (Object)string);
    }

    public final void logOnboardingBannerSwitcherExpanded(@NotNull String lessonId) {
        Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
        onboardingBannerSwitcherExpanded.log((Object)lessonId);
    }

    private final String courseLanguage() {
        Object object;
        block3: {
            block2: {
                object = LangManager.Companion.getInstance().getLangSupport();
                if (object == null || (object = object.getPrimaryLanguage()) == null) break block2;
                String string = ((String)object).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final int completedCount() {
        int n;
        Iterable $this$count$iv = CourseManager.Companion.getInstance().getLessonsForModules();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Lesson it = (Lesson)element$iv;
                boolean bl = false;
                if (!it.getPassed$intellij_featuresTrainer() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    private final FusInputEvent createInputEvent(String actionId) {
        Object object = ShortcutsRenderingUtil.INSTANCE.getShortcutByActionId(actionId);
        if (object == null || (object = object.getFirstKeyStroke()) == null) {
            return null;
        }
        Object keyStroke = object;
        KeyEvent inputEvent = new KeyEvent(JOptionPane.getRootFrame(), 401, System.currentTimeMillis(), ((AWTKeyStroke)keyStroke).getModifiers(), ((AWTKeyStroke)keyStroke).getKeyCode(), ((AWTKeyStroke)keyStroke).getKeyChar(), 1);
        return new FusInputEvent((InputEvent)inputEvent, "");
    }

    private final String getPluginVersion(Lesson lesson) {
        PluginDescriptor pluginDescriptor = PluginManager.getPluginByClass(lesson.getClass());
        return pluginDescriptor != null ? pluginDescriptor.getVersion() : null;
    }

    private final Keymap getDefaultKeymap() {
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getActiveKeymap(...)");
        Keymap keymap2 = keymap;
        if (keymap2 instanceof DefaultKeymapImpl) {
            return keymap2;
        }
        Keymap keymap3 = keymap2.getParent();
        return (Keymap)(keymap3 instanceof DefaultKeymapImpl ? (DefaultKeymapImpl)keymap3 : null);
    }

    static {
        EventFields $this$iv;
        INSTANCE = new StatisticBase();
        boolean $i$f$logger22 = false;
        Logger logger = Logger.getInstance(StatisticBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        sessionLessonTimestamp = new ConcurrentHashMap();
        prevRestoreLessonProgress = new LessonProgress("", 0);
        GROUP = new EventLogGroup("ideFeaturesTrainer", 21, null, 4, null);
        lessonIdField = EventFields.StringValidatedByCustomRule((String)"lesson_id", IdeFeaturesTrainerRuleValidator.class);
        languageField = EventFields.StringValidatedByCustomRule((String)"language", SupportedLanguageRuleValidator.class);
        completedCountField = EventFields.Int((String)"completed_count");
        courseSizeField = EventFields.Int((String)"course_size");
        taskIdField = EventFields.Int((String)"task_id");
        actionIdField = EventFields.StringValidatedByCustomRule((String)"action_id", ActionIdRuleValidator.class);
        keymapSchemeField = EventFields.StringValidatedByCustomRule((String)"keymap_scheme", KeymapSchemeRuleValidator.class);
        versionField = EventFields.Version;
        inputEventField = EventFields.InputEvent;
        EventFields $i$f$logger22 = EventFields.INSTANCE;
        String name$iv = "learn_opening_way";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        learnProjectOpeningWayField = new EnumEventField(name$iv, LearnProjectOpeningWay.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "reason";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        reasonField = new EnumEventField(name$iv, LessonStopReason.class, null, transform$iv);
        newLessonsCount = EventFields.Int((String)"new_lessons_count");
        showNewLessonsState = EventFields.Boolean((String)"show_it");
        tipIdField = EventFields.StringValidatedByCustomRule((String)"tip_id", TipsOfTheDayUsagesCollector.TipInfoValidationRule.class);
        $this$iv = EventFields.INSTANCE;
        name$iv = "starting_way";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        lessonStartingWayField = new EnumEventField(name$iv, LessonStartingWay.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "feedback_entry_place";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        feedbackEntryPlace = new EnumEventField(name$iv, FeedbackEntryPlace.class, null, transform$iv);
        feedbackHasBeenSent = EventFields.Boolean((String)"feedback_has_been_sent");
        feedbackOpenedViaNotification = EventFields.Boolean((String)"feedback_opened_via_notification");
        $this$iv = EventFields.INSTANCE;
        name$iv = "feedback_likeness_answer";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        feedbackLikenessAnswer = new EnumEventField(name$iv, FeedbackLikenessAnswer.class, null, transform$iv);
        feedbackExperiencedUser = EventFields.Boolean((String)"feedback_experienced_user");
        $this$iv = EventFields.INSTANCE;
        name$iv = "problem";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        internalProblemField = new EnumEventField(name$iv, LearningInternalProblems.class, null, transform$iv);
        lastBuildLearningOpened = new PrimitiveEventField<String>(){
            @NotNull
            private final String name;
            {
                this.name = "last_build_learning_opened";
            }

            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public List<String> getValidationRule() {
                return CollectionsKt.listOf((Object)"{regexp#version}");
            }

            public void addData(@NotNull FeatureUsageData fuData, @Nullable String value) {
                Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
                if (value != null) {
                    fuData.addData(this.getName(), value);
                }
            }
        };
        lessonStartedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"start", (EventField)((EventField)lessonIdField), (EventField)((EventField)languageField), (EventField)((EventField)lessonStartingWayField), null, (int)16, null);
        lessonPassedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"passed", (EventField)((EventField)lessonIdField), (EventField)((EventField)languageField), (EventField)((EventField)EventFields.Long$default((String)"duration", null, (int)2, null)), null, (int)16, null);
        EventField[] eventFieldArray = new EventField[]{lessonIdField, taskIdField, languageField, reasonField};
        lessonStoppedEvent = GROUP.registerVarargEvent("stopped", eventFieldArray);
        eventFieldArray = new EventField[]{lessonIdField, completedCountField, courseSizeField, languageField};
        progressUpdatedEvent = GROUP.registerVarargEvent("progress", eventFieldArray);
        eventFieldArray = new EventField[]{inputEventField, keymapSchemeField, lessonIdField, taskIdField, actionIdField, versionField};
        shortcutClickedEvent = GROUP.registerVarargEvent("shortcut_clicked", eventFieldArray);
        eventFieldArray = new EventField[]{lessonIdField, taskIdField, versionField};
        restorePerformedEvent = GROUP.registerVarargEvent("restore", eventFieldArray);
        learnProjectOpenedFirstTimeEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"learn_project_opened_first_time", (EventField)((EventField)learnProjectOpeningWayField), (EventField)((EventField)languageField), null, (int)8, null);
        nonLearningProjectOpened = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"non_learning_project_opened", (EventField)((EventField)learnProjectOpeningWayField), null, (int)4, null);
        newLessonsNotificationShown = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"new_lessons_notification_shown", (EventField)((EventField)newLessonsCount), (EventField)((EventField)lastBuildLearningOpened), null, (int)8, null);
        showNewLessonsEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"show_new_lessons", (EventField)((EventField)newLessonsCount), (EventField)((EventField)lastBuildLearningOpened), null, (int)8, null);
        needShowNewLessonsNotifications = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"need_show_new_lessons_notifications", (EventField)((EventField)newLessonsCount), (EventField)((EventField)lastBuildLearningOpened), (EventField)((EventField)showNewLessonsState), null, (int)16, null);
        internalProblem = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"internal_problem", (EventField)((EventField)internalProblemField), (EventField)((EventField)lessonIdField), (EventField)((EventField)languageField), null, (int)16, null);
        lessonLinkClickedFromTip = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"lesson_link_clicked_from_tip", (EventField)((EventField)lessonIdField), (EventField)((EventField)languageField), (EventField)((EventField)tipIdField), null, (int)16, null);
        helpLinkClicked = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"help_link_clicked", (EventField)((EventField)lessonIdField), (EventField)((EventField)languageField), null, (int)8, null);
        onboardingFeedbackNotificationShown = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"onboarding_feedback_notification_shown", (EventField)((EventField)feedbackEntryPlace), null, (int)4, null);
        eventFieldArray = new EventField[]{feedbackEntryPlace, feedbackHasBeenSent, feedbackOpenedViaNotification, feedbackLikenessAnswer, feedbackExperiencedUser};
        onboardingFeedbackDialogResult = GROUP.registerVarargEvent("onboarding_feedback_dialog_result", eventFieldArray);
        onboardingBannerShown = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"onboarding.banner.shown", (EventField)((EventField)lessonIdField), (EventField)((EventField)languageField), null, (int)8, null);
        onboardingBannerSwitcherExpanded = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"onboarding.banner.switcher.expanded", (EventField)((EventField)lessonIdField), null, (int)4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ltraining/statistic/StatisticBase$LearnProjectOpeningWay;", "", "(Ljava/lang/String;I)V", "LEARN_IDE", "ONBOARDING_PROMOTER", "intellij.featuresTrainer"})
    public static final class LearnProjectOpeningWay
    extends Enum<LearnProjectOpeningWay> {
        public static final /* enum */ LearnProjectOpeningWay LEARN_IDE = new LearnProjectOpeningWay();
        public static final /* enum */ LearnProjectOpeningWay ONBOARDING_PROMOTER = new LearnProjectOpeningWay();
        private static final /* synthetic */ LearnProjectOpeningWay[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LearnProjectOpeningWay[] values() {
            return (LearnProjectOpeningWay[])$VALUES.clone();
        }

        public static LearnProjectOpeningWay valueOf(String value) {
            return Enum.valueOf(LearnProjectOpeningWay.class, value);
        }

        @NotNull
        public static EnumEntries<LearnProjectOpeningWay> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = learnProjectOpeningWayArray = new LearnProjectOpeningWay[]{LearnProjectOpeningWay.LEARN_IDE, LearnProjectOpeningWay.ONBOARDING_PROMOTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ltraining/statistic/StatisticBase$LessonProgress;", "", "lessonId", "", "taskId", "", "(Ljava/lang/String;I)V", "getLessonId", "()Ljava/lang/String;", "getTaskId", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.featuresTrainer"})
    private static final class LessonProgress {
        @NotNull
        private final String lessonId;
        private final int taskId;

        public LessonProgress(@NotNull String lessonId, int taskId) {
            Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
            this.lessonId = lessonId;
            this.taskId = taskId;
        }

        @NotNull
        public final String getLessonId() {
            return this.lessonId;
        }

        public final int getTaskId() {
            return this.taskId;
        }

        @NotNull
        public final String component1() {
            return this.lessonId;
        }

        public final int component2() {
            return this.taskId;
        }

        @NotNull
        public final LessonProgress copy(@NotNull String lessonId, int taskId) {
            Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
            return new LessonProgress(lessonId, taskId);
        }

        public static /* synthetic */ LessonProgress copy$default(LessonProgress lessonProgress, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = lessonProgress.lessonId;
            }
            if ((n2 & 2) != 0) {
                n = lessonProgress.taskId;
            }
            return lessonProgress.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "LessonProgress(lessonId=" + this.lessonId + ", taskId=" + this.taskId + ")";
        }

        public int hashCode() {
            int result2 = this.lessonId.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.taskId);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LessonProgress)) {
                return false;
            }
            LessonProgress lessonProgress = (LessonProgress)other;
            if (!Intrinsics.areEqual((Object)this.lessonId, (Object)lessonProgress.lessonId)) {
                return false;
            }
            return this.taskId == lessonProgress.taskId;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ltraining/statistic/StatisticBase$LessonStopReason;", "", "(Ljava/lang/String;I)V", "CLOSE_PROJECT", "RESTART", "CLOSE_FILE", "OPEN_MODULES", "OPEN_NEXT_OR_PREV_LESSON", "EXIT_LINK", "intellij.featuresTrainer"})
    public static final class LessonStopReason
    extends Enum<LessonStopReason> {
        public static final /* enum */ LessonStopReason CLOSE_PROJECT = new LessonStopReason();
        public static final /* enum */ LessonStopReason RESTART = new LessonStopReason();
        public static final /* enum */ LessonStopReason CLOSE_FILE = new LessonStopReason();
        public static final /* enum */ LessonStopReason OPEN_MODULES = new LessonStopReason();
        public static final /* enum */ LessonStopReason OPEN_NEXT_OR_PREV_LESSON = new LessonStopReason();
        public static final /* enum */ LessonStopReason EXIT_LINK = new LessonStopReason();
        private static final /* synthetic */ LessonStopReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LessonStopReason[] values() {
            return (LessonStopReason[])$VALUES.clone();
        }

        public static LessonStopReason valueOf(String value) {
            return Enum.valueOf(LessonStopReason.class, value);
        }

        @NotNull
        public static EnumEntries<LessonStopReason> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lessonStopReasonArray = new LessonStopReason[]{LessonStopReason.CLOSE_PROJECT, LessonStopReason.RESTART, LessonStopReason.CLOSE_FILE, LessonStopReason.OPEN_MODULES, LessonStopReason.OPEN_NEXT_OR_PREV_LESSON, LessonStopReason.EXIT_LINK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

