/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.format;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.format.ComponentFormatterTemplate;
import org.assertj.swing.format.IntEnum;
import org.assertj.swing.util.Arrays;

public class JTreeFormatter
extends ComponentFormatterTemplate {
    private static final String[] EMPTY = new String[0];
    private static final IntEnum SELECTION_MODES = new IntEnum();

    @Override
    @Nonnull
    protected String doFormat(@Nonnull Component c) {
        JTree tree2 = (JTree)c;
        String format = "%s[name=%s, selectionCount=%d, selectionPaths=%s, selectionMode=%s, enabled=%b, visible=%b, showing=%b";
        return String.format(format, this.getRealClassName(c), Strings.quote((String)tree2.getName()), tree2.getSelectionCount(), Arrays.format(this.selectionPaths(tree2)), this.selectionMode(tree2), tree2.isEnabled(), tree2.isVisible(), tree2.isShowing());
    }

    @Nonnull
    private String[] selectionPaths(@Nonnull JTree tree2) {
        TreePath[] paths = tree2.getSelectionPaths();
        if (paths == null) {
            return EMPTY;
        }
        int count = paths.length;
        if (count == 0) {
            return EMPTY;
        }
        String[] pathArray = new String[count];
        for (int i = 0; i < count; ++i) {
            TreePath path = paths[i];
            pathArray[i] = path != null ? path.toString() : null;
        }
        return pathArray;
    }

    @Nullable
    private String selectionMode(JTree tree2) {
        TreeSelectionModel model = tree2.getSelectionModel();
        return SELECTION_MODES.get(model.getSelectionMode());
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JTree.class;
    }

    static {
        SELECTION_MODES.put(1, "SINGLE_TREE_SELECTION").put(2, "CONTIGUOUS_TREE_SELECTION").put(4, "DISCONTIGUOUS_TREE_SELECTION");
    }
}

