/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTreeCellReader;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.MouseClickInfo;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JTreeChildrenShowUpCondition;
import org.assertj.swing.driver.JTreeClearSelectionTask;
import org.assertj.swing.driver.JTreeEditableQuery;
import org.assertj.swing.driver.JTreeExpandPathTask;
import org.assertj.swing.driver.JTreeLocation;
import org.assertj.swing.driver.JTreeMatchingPathQuery;
import org.assertj.swing.driver.JTreeNodeTextQuery;
import org.assertj.swing.driver.JTreePathFinder;
import org.assertj.swing.driver.JTreeToggleExpandStateTask;
import org.assertj.swing.driver.JTreeVerifySelectionTask;
import org.assertj.swing.driver.MultipleSelectionTemplate;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.exception.LocationUnavailableException;
import org.assertj.swing.exception.WaitTimedOutError;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.timing.Condition;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.ArrayPreconditions;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.Platform;
import org.assertj.swing.util.Triple;

@InternalApi
public class JTreeDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTION_PROPERTY = "selection";
    private final JTreeLocation location = new JTreeLocation();
    private final JTreePathFinder pathFinder = new JTreePathFinder();

    public JTreeDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void clickRow(@Nonnull JTree tree2, int row2) {
        Point p = this.scrollToRow(tree2, row2);
        this.robot.click((Component)tree2, p);
    }

    @RunsInEDT
    public void clickRow(@Nonnull JTree tree2, int row2, @Nonnull MouseButton button2) {
        Preconditions.checkNotNull((Object)((Object)button2));
        this.clickRow(tree2, row2, button2, 1);
    }

    @RunsInEDT
    public void clickRow(@Nonnull JTree tree2, int row2, @Nonnull MouseClickInfo mouseClickInfo) {
        Preconditions.checkNotNull((Object)mouseClickInfo);
        this.clickRow(tree2, row2, mouseClickInfo.button(), mouseClickInfo.times());
    }

    @RunsInEDT
    private void clickRow(@Nonnull JTree tree2, int row2, @Nonnull MouseButton button2, int times) {
        Point p = this.scrollToRow(tree2, row2);
        this.robot.click(tree2, p, button2, times);
    }

    @RunsInEDT
    public void doubleClickRow(@Nonnull JTree tree2, int row2) {
        Point p = this.scrollToRow(tree2, row2);
        this.doubleClick(tree2, p);
    }

    @RunsInEDT
    public void rightClickRow(@Nonnull JTree tree2, int row2) {
        Point p = this.scrollToRow(tree2, row2);
        this.rightClick(tree2, p);
    }

    @Nonnull
    @RunsInEDT
    private Point scrollToRow(@Nonnull JTree tree2, int row2) {
        Point p = (Point)JTreeDriver.scrollToRow((JTree)tree2, (int)row2, (JTreeLocation)this.location(), (boolean)false).second;
        this.robot.waitForIdle();
        return (Point)Preconditions.checkNotNull((Object)p);
    }

    @RunsInEDT
    public void clickPath(@Nonnull JTree tree2, @Nonnull String path) {
        Point p = this.scrollToPath(tree2, path);
        this.robot.click((Component)tree2, p);
    }

    @RunsInEDT
    public void clickPath(@Nonnull JTree tree2, @Nonnull String path, @Nonnull MouseButton button2) {
        Preconditions.checkNotNull((Object)((Object)button2));
        this.clickPath(tree2, path, button2, 1);
    }

    @RunsInEDT
    public void clickPath(@Nonnull JTree tree2, @Nonnull String path, @Nonnull MouseClickInfo mouseClickInfo) {
        Preconditions.checkNotNull((Object)mouseClickInfo);
        this.clickPath(tree2, path, mouseClickInfo.button(), mouseClickInfo.times());
    }

    private void clickPath(@Nonnull JTree tree2, @Nonnull String path, @Nonnull MouseButton button2, int times) {
        Point p = this.scrollToPath(tree2, path);
        this.robot.click(tree2, p, button2, times);
    }

    @RunsInEDT
    public void doubleClickPath(@Nonnull JTree tree2, @Nonnull String path) {
        Point p = this.scrollToPath(tree2, path);
        this.doubleClick(tree2, p);
    }

    @Nonnull
    private Point scrollToPath(@Nonnull JTree tree2, @Nonnull String path) {
        Point p = (Point)this.scrollToMatchingPath((JTree)tree2, (String)path, (boolean)false).third;
        this.robot.waitForIdle();
        return (Point)Preconditions.checkNotNull((Object)p);
    }

    private void doubleClick(@Nonnull JTree tree2, @Nonnull Point p) {
        this.robot.click(tree2, p, MouseButton.LEFT_BUTTON, 2);
    }

    @RunsInEDT
    public void rightClickPath(@Nonnull JTree tree2, @Nonnull String path) {
        Point p = this.scrollToPath(tree2, path);
        this.rightClick(tree2, p);
    }

    private void rightClick(@Nonnull JTree tree2, @Nonnull Point p) {
        this.robot.click(tree2, p, MouseButton.RIGHT_BUTTON, 1);
    }

    @RunsInEDT
    public void expandRow(@Nonnull JTree tree2, int row2) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree2, row2, this.location());
        this.robot.waitForIdle();
        if (((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree2, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @RunsInEDT
    public void collapseRow(@Nonnull JTree tree2, int row2) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree2, row2, this.location());
        this.robot.waitForIdle();
        if (!((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree2, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @RunsInEDT
    public void toggleRow(@Nonnull JTree tree2, int row2) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree2, row2, this.location());
        this.robot.waitForIdle();
        this.toggleCell(tree2, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @Nonnull
    @RunsInEDT
    private static Triple<Boolean, Point, Integer> scrollToRowAndGetToggleInfo(final @Nonnull JTree tree2, final int row2, final @Nonnull JTreeLocation location) {
        Triple<Boolean, Point, Integer> result2 = GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Point, Integer>>(){

            @Override
            protected Triple<Boolean, Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree2);
                Point p = JTreeDriver.scrollToVisible(tree2, row2, location);
                return Triple.of(tree2.isExpanded(row2), p, tree2.getToggleClickCount());
            }
        });
        return (Triple)Preconditions.checkNotNull(result2);
    }

    @RunsInEDT
    public void expandPath(@Nonnull JTree tree2, @Nonnull String path) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToMatchingPathAndGetToggleInfo(tree2, path, this.pathFinder(), this.location());
        if (((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree2, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @RunsInEDT
    public void collapsePath(@Nonnull JTree tree2, @Nonnull String path) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToMatchingPathAndGetToggleInfo(tree2, path, this.pathFinder(), this.location());
        if (!((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree2, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @Nonnull
    @RunsInEDT
    private static Triple<Boolean, Point, Integer> scrollToMatchingPathAndGetToggleInfo(final @Nonnull JTree tree2, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder, final @Nonnull JTreeLocation location) {
        Triple<Boolean, Point, Integer> result2 = GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Point, Integer>>(){

            @Override
            protected Triple<Boolean, Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree2);
                TreePath matchingPath = JTreeMatchingPathQuery.matchingPathFor(tree2, path, pathFinder);
                Point p = JTreeDriver.scrollToTreePath(tree2, matchingPath, location);
                return Triple.of(tree2.isExpanded(matchingPath), p, tree2.getToggleClickCount());
            }
        });
        return (Triple)Preconditions.checkNotNull(result2);
    }

    @RunsInEDT
    private void toggleCell(@Nonnull JTree tree2, @Nonnull Point p, int toggleClickCount) {
        if (toggleClickCount == 0) {
            JTreeDriver.toggleRowThroughTreeUI(tree2, p);
            this.robot.waitForIdle();
            return;
        }
        this.robot.click(tree2, p, MouseButton.LEFT_BUTTON, toggleClickCount);
    }

    @RunsInEDT
    private static void toggleRowThroughTreeUI(@Nonnull JTree tree2, @Nonnull Point p) {
        GuiActionRunner.execute(() -> {
            TreeUI treeUI = tree2.getUI();
            if (!(treeUI instanceof BasicTreeUI)) {
                throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Can't toggle row for ", treeUI}));
            }
            JTreeToggleExpandStateTask.toggleExpandState(tree2, p);
        });
    }

    @RunsInEDT
    public void selectRows(final @Nonnull JTree tree2, final @Nonnull int[] rows) {
        ArrayPreconditions.checkNotNullOrEmpty(rows);
        this.clearSelection(tree2);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return rows.length;
            }

            @Override
            void selectElement(int index) {
                JTreeDriver.this.selectRow(tree2, rows[index]);
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void unselectRows(final @Nonnull JTree tree2, final @Nonnull int[] rows) {
        ArrayPreconditions.checkNotNullOrEmpty(rows);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return rows.length;
            }

            @Override
            void unselectElement(int index) {
                JTreeDriver.this.unselectRow(tree2, rows[index]);
            }
        }.multiUnselect();
    }

    @RunsInEDT
    private void clearSelection(@Nonnull JTree tree2) {
        JTreeClearSelectionTask.clearSelectionOf(tree2);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectRow(@Nonnull JTree tree2, int row2) {
        this.scrollAndSelectRow(tree2, row2, true, false);
    }

    @RunsInEDT
    public void unselectRow(@Nonnull JTree tree2, int row2) {
        int key = Platform.controlOrCommandKey();
        this.robot.pressKeyWhileRunning(key, () -> this.scrollAndSelectRow(tree2, row2, false, false));
    }

    @RunsInEDT
    public void selectPaths(final @Nonnull JTree tree2, final @Nonnull String[] paths) {
        Preconditions.checkNotNullOrEmpty((Object[])paths);
        this.clearSelection(tree2);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return paths.length;
            }

            @Override
            void selectElement(int index) {
                JTreeDriver.this.selectPath(tree2, (String)Preconditions.checkNotNull((Object)paths[index]));
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void unselectPaths(final @Nonnull JTree tree2, final @Nonnull String[] paths) {
        Preconditions.checkNotNullOrEmpty((Object[])paths);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return paths.length;
            }

            @Override
            void unselectElement(int index) {
                JTreeDriver.this.unselectPath(tree2, (String)Preconditions.checkNotNull((Object)paths[index]));
            }
        }.multiUnselect();
    }

    @RunsInEDT
    public void selectPath(@Nonnull JTree tree2, @Nonnull String path) {
        this.selectMatchingPath(tree2, path, true, false);
    }

    @RunsInEDT
    public void unselectPath(@Nonnull JTree tree2, @Nonnull String path) {
        int key = Platform.controlOrCommandKey();
        this.robot.pressKeyWhileRunning(key, () -> this.selectMatchingPath(tree2, path, false, false));
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTree tree2, int row2) {
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree2, row2, this.location(), true);
        Point p = (Point)Preconditions.checkNotNull(info.second);
        return this.robot.showPopupMenu(tree2, p);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTree tree2, @Nonnull String path) {
        Triple<TreePath, Boolean, Point> info = this.scrollToMatchingPath(tree2, path, true);
        this.robot.waitForIdle();
        Point where = (Point)Preconditions.checkNotNull(info.third);
        return this.robot.showPopupMenu(tree2, where);
    }

    @RunsInEDT
    public void drag(@Nonnull JTree tree2, int row2) {
        Point p = this.scrollAndSelectRow(tree2, row2, true, true);
        this.drag((Component)tree2, p);
    }

    @Nonnull
    @RunsInEDT
    private Point scrollAndSelectRow(@Nonnull JTree tree2, int row2, boolean select2, boolean singleSelectRequired) {
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree2, row2, this.location(), singleSelectRequired);
        Point p = (Point)Preconditions.checkNotNull(info.second);
        if ((Boolean)info.first != select2) {
            this.robot.click((Component)tree2, p);
        }
        return p;
    }

    @RunsInEDT
    public void drop(@Nonnull JTree tree2, int row2) {
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree2, row2, this.location(), true);
        this.drop((Component)tree2, (Point)Preconditions.checkNotNull(info.second));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> scrollToRow(final @Nonnull JTree tree2, final int row2, final @Nonnull JTreeLocation location, final boolean singleSelectRequired) {
        Pair<Boolean, Point> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree2);
                Point p = JTreeDriver.scrollToVisible(tree2, row2, location);
                boolean selected = (!singleSelectRequired || tree2.getSelectionCount() == 1) && tree2.isRowSelected(row2);
                return Pair.of(selected, p);
            }
        });
        return (Pair)Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToVisible(@Nonnull JTree tree2, int row2, @Nonnull JTreeLocation location) {
        Pair<Rectangle, Point> boundsAndCoordinates = location.rowBoundsAndCoordinates(tree2, row2);
        tree2.scrollRectToVisible((Rectangle)boundsAndCoordinates.first);
        return (Point)Preconditions.checkNotNull(boundsAndCoordinates.second);
    }

    @RunsInEDT
    public void drag(@Nonnull JTree tree2, @Nonnull String path) {
        Point p = this.selectMatchingPath(tree2, path, true, true);
        this.drag((Component)tree2, p);
    }

    @Nonnull
    @RunsInEDT
    private Point selectMatchingPath(@Nonnull JTree tree2, @Nonnull String path, boolean select2, boolean singleSelectionRequired) {
        Triple<TreePath, Boolean, Point> info = this.scrollToMatchingPath(tree2, path, singleSelectionRequired);
        this.robot.waitForIdle();
        Point where = (Point)Preconditions.checkNotNull(info.third);
        if ((Boolean)info.second != select2) {
            this.robot.click((Component)tree2, where);
        }
        return where;
    }

    @RunsInEDT
    public void drop(@Nonnull JTree tree2, @Nonnull String path) {
        Point p = (Point)this.scrollToMatchingPath((JTree)tree2, (String)path, (boolean)true).third;
        this.drop((Component)tree2, (Point)Preconditions.checkNotNull((Object)p));
    }

    @Nonnull
    @RunsInEDT
    private Triple<TreePath, Boolean, Point> scrollToMatchingPath(@Nonnull JTree tree2, @Nonnull String path, boolean singleSelectionRequired) {
        TreePath matchingPath = JTreeMatchingPathQuery.verifyJTreeIsReadyAndFindMatchingPath(tree2, path, this.pathFinder());
        this.makeVisible(tree2, matchingPath, false);
        Pair<Boolean, Point> info = JTreeDriver.scrollToPathToSelect(tree2, matchingPath, this.location(), singleSelectionRequired);
        return Triple.of(matchingPath, info.first, info.second);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> scrollToPathToSelect(final @Nonnull JTree tree2, final @Nonnull TreePath path, final @Nonnull JTreeLocation location, final boolean singleSelectionRequired) {
        Pair<Boolean, Point> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                boolean isSelected = (!singleSelectionRequired || tree2.getSelectionCount() == 1) && tree2.isPathSelected(path);
                return Pair.of(isSelected, JTreeDriver.scrollToTreePath(tree2, path, location));
            }
        });
        return (Pair)Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToTreePath(@Nonnull JTree tree2, @Nonnull TreePath path, @Nonnull JTreeLocation location) {
        Pair<Rectangle, Point> boundsAndCoordinates = location.pathBoundsAndCoordinates(tree2, path);
        tree2.scrollRectToVisible((Rectangle)boundsAndCoordinates.first);
        return (Point)Preconditions.checkNotNull(boundsAndCoordinates.second);
    }

    @RunsInEDT
    private boolean makeParentVisible(@Nonnull JTree tree2, @Nonnull TreePath path) {
        boolean changed = this.makeVisible(tree2, (TreePath)Preconditions.checkNotNull((Object)path.getParentPath()), true);
        if (changed) {
            this.robot.waitForIdle();
        }
        return changed;
    }

    @RunsInEDT
    private boolean makeVisible(@Nonnull JTree tree2, @Nonnull TreePath path, boolean expandWhenFound) {
        boolean changed = false;
        if (path.getPathCount() > 1) {
            changed = this.makeParentVisible(tree2, path);
        }
        if (!expandWhenFound) {
            return changed;
        }
        JTreeExpandPathTask.expandTreePath(tree2, path);
        this.waitForChildrenToShowUp(tree2, path);
        return true;
    }

    @RunsInEDT
    private void waitForChildrenToShowUp(@Nonnull JTree tree2, @Nonnull TreePath path) {
        int timeout = this.robot.settings().timeoutToBeVisible();
        try {
            Pause.pause((Condition)JTreeChildrenShowUpCondition.untilChildrenShowUp(tree2, path), (long)timeout);
        }
        catch (WaitTimedOutError e) {
            throw new LocationUnavailableException(e.getMessage());
        }
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JTree tree2, @Nonnull int[] rows) {
        Preconditions.checkNotNull((Object)rows);
        JTreeVerifySelectionTask.checkHasSelection(tree2, rows, this.selectionProperty(tree2));
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JTree tree2, @Nonnull String[] paths) {
        Preconditions.checkNotNull((Object)paths);
        JTreeVerifySelectionTask.checkHasSelection(tree2, paths, this.pathFinder(), this.selectionProperty(tree2));
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JTree tree2) {
        JTreeVerifySelectionTask.checkNoSelection(tree2, this.selectionProperty(tree2));
    }

    @Nonnull
    @RunsInEDT
    private Description selectionProperty(@Nonnull JTree tree2) {
        return JTreeDriver.propertyName(tree2, SELECTION_PROPERTY);
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JTree tree2) {
        this.assertEditable(tree2, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JTree tree2) {
        this.assertEditable(tree2, false);
    }

    @RunsInEDT
    private void assertEditable(@Nonnull JTree tree2, boolean editable) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)JTreeEditableQuery.isEditable(tree2)).as(JTreeDriver.editableProperty(tree2))).isEqualTo(editable);
    }

    @Nonnull
    @RunsInEDT
    private static Description editableProperty(@Nonnull JTree tree2) {
        return JTreeDriver.propertyName(tree2, EDITABLE_PROPERTY);
    }

    @Nonnull
    public String separator() {
        return this.pathFinder.separator();
    }

    public void replaceSeparator(@Nonnull String newSeparator) {
        this.pathFinder.replaceSeparator((String)Preconditions.checkNotNull((Object)newSeparator));
    }

    public void replaceCellReader(@Nonnull JTreeCellReader newCellReader) {
        this.pathFinder.replaceCellReader((JTreeCellReader)Preconditions.checkNotNull((Object)newCellReader));
    }

    @RunsInEDT
    public void checkRowInBounds(@Nonnull JTree tree2, int row2) {
        this.location.checkRowInBounds(tree2, row2);
    }

    @RunsInEDT
    public void checkPathExists(@Nonnull JTree tree2, @Nonnull String path) {
        JTreeMatchingPathQuery.matchingPathFor(tree2, path, this.pathFinder());
    }

    @Nullable
    @RunsInEDT
    public String nodeValue(@Nonnull JTree tree2, @Nonnull String path) {
        return JTreeNodeTextQuery.nodeText(tree2, path, this.pathFinder());
    }

    @Nullable
    public String nodeValue(@Nonnull JTree tree2, int row2) {
        return JTreeNodeTextQuery.nodeText(tree2, row2, this.location(), this.pathFinder());
    }

    @VisibleForTesting
    JTreeCellReader cellReader() {
        return this.pathFinder.cellReader();
    }

    @Nonnull
    private JTreeLocation location() {
        return this.location;
    }

    @Nonnull
    private JTreePathFinder pathFinder() {
        return this.pathFinder;
    }
}

