/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.AbstractJTableCellWriter;
import org.assertj.swing.driver.JTableLocation;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.util.Pair;

public class JTableCheckBoxEditorCellWriter
extends AbstractJTableCellWriter {
    public JTableCheckBoxEditorCellWriter(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void enterValue(@Nonnull JTable table, int row2, int column, @Nonnull String value) {
        boolean realValue = Boolean.parseBoolean(value);
        Pair<Boolean, Point> editingInfo = JTableCheckBoxEditorCellWriter.doStartCellEditing(table, row2, column, this.location());
        if ((Boolean)editingInfo.first == realValue) {
            return;
        }
        this.robot.click((Component)table, (Point)Preconditions.checkNotNull(editingInfo.second));
    }

    @Override
    @RunsInEDT
    public void startCellEditing(@Nonnull JTable table, int row2, int column) {
        JTableCheckBoxEditorCellWriter.doStartCellEditing(table, row2, column, this.location());
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> doStartCellEditing(final @Nonnull JTable table, final int row2, final int column, final @Nonnull JTableLocation location) {
        Pair<Boolean, Point> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                JCheckBox editor = AbstractJTableCellWriter.editor(table, row2, column, JCheckBox.class);
                AbstractJTableCellWriter.scrollToCell(table, row2, column, location);
                return Pair.of(editor.isSelected(), location.pointAt(table, row2, column));
            }
        });
        return (Pair)Preconditions.checkNotNull(result2);
    }
}

