/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JInternalFrameAction;
import org.assertj.swing.driver.JInternalFrameCloseTask;
import org.assertj.swing.driver.JInternalFrameIconQuery;
import org.assertj.swing.driver.JInternalFrameSetIconTask;
import org.assertj.swing.driver.JInternalFrameSetMaximumTask;
import org.assertj.swing.driver.JInternalFrameTitleQuery;
import org.assertj.swing.driver.WindowLikeContainers;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.exception.UnexpectedException;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.Triple;

@InternalApi
public class JInternalFrameDriver
extends JComponentDriver {
    public JInternalFrameDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void moveToFront(@Nonnull JInternalFrame internalFrame) {
        GuiActionRunner.execute(() -> internalFrame.toFront());
    }

    @RunsInEDT
    public void moveToBack(@Nonnull JInternalFrame internalFrame) {
        GuiActionRunner.execute(() -> internalFrame.moveToBack());
    }

    @RunsInEDT
    public void maximize(@Nonnull JInternalFrame internalFrame) {
        Pair<Container, Point> maximizeLocation = JInternalFrameDriver.maximizeLocationOf(internalFrame);
        this.maximizeOrNormalize(internalFrame, JInternalFrameAction.MAXIMIZE, maximizeLocation);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Container, Point> maximizeLocationOf(final @Nonnull JInternalFrame internalFrame) {
        Pair<Container, Point> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Container, Point>>(){

            @Override
            @Nullable
            protected Pair<Container, Point> executeInEDT() {
                JInternalFrameDriver.checkCanMaximize(internalFrame);
                return JInternalFrameDriver.findMaximizeLocation(internalFrame);
            }
        });
        return (Pair)Preconditions.checkNotNull(result2);
    }

    @RunsInCurrentThread
    private static void checkCanMaximize(@Nonnull JInternalFrame internalFrame) {
        JInternalFrameDriver.checkShowingOrIconified(internalFrame);
        if (!internalFrame.isMaximizable()) {
            String msg = String.format("The JInternalFrame <%s> is not maximizable", Formatting.format(internalFrame));
            throw new IllegalStateException(msg);
        }
    }

    @RunsInEDT
    public void normalize(@Nonnull JInternalFrame internalFrame) {
        Pair<Container, Point> normalizeLocation = JInternalFrameDriver.validateAndFindNormalizeLocation(internalFrame);
        this.maximizeOrNormalize(internalFrame, JInternalFrameAction.NORMALIZE, normalizeLocation);
    }

    @RunsInEDT
    private static Pair<Container, Point> validateAndFindNormalizeLocation(final @Nonnull JInternalFrame internalFrame) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Container, Point>>(){

            @Override
            protected Pair<Container, Point> executeInEDT() {
                JInternalFrameDriver.checkShowingOrIconified(internalFrame);
                return JInternalFrameDriver.findMaximizeLocation(internalFrame);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkShowingOrIconified(@Nonnull JInternalFrame internalFrame) {
        if (!internalFrame.isIcon()) {
            ComponentPreconditions.checkShowing(internalFrame);
        }
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Container, Point> findMaximizeLocation(@Nonnull JInternalFrame internalFrame) {
        JComponent clickTarget = internalFrame.isIcon() ? internalFrame.getDesktopIcon() : internalFrame;
        Point location = WindowLikeContainers.maximizeButtonLocation((Container)Preconditions.checkNotNull((Object)clickTarget));
        return Pair.of(clickTarget, location);
    }

    @RunsInEDT
    private void maximizeOrNormalize(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action2, @Nonnull Pair<Container, Point> toMoveMouseTo) {
        this.moveMouseIgnoringAnyError((Component)toMoveMouseTo.first, (Point)toMoveMouseTo.second);
        this.setMaximumProperty(internalFrame, action2);
    }

    @RunsInEDT
    private void setMaximumProperty(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action2) {
        try {
            JInternalFrameSetMaximumTask.setMaximum(internalFrame, action2);
            this.robot.waitForIdle();
        }
        catch (UnexpectedException unexpected) {
            this.failIfVetoed(internalFrame, action2, unexpected);
        }
    }

    @RunsInEDT
    public void iconify(@Nonnull JInternalFrame internalFrame) {
        Pair<Boolean, Point> iconifyInfo = JInternalFrameDriver.findIconifyInfo(internalFrame);
        if (((Boolean)iconifyInfo.first).booleanValue()) {
            return;
        }
        this.moveMouseIgnoringAnyError(internalFrame, (Point)iconifyInfo.second);
        this.setIconProperty(internalFrame, JInternalFrameAction.ICONIFY);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> findIconifyInfo(final @Nonnull JInternalFrame internalFrame) {
        Pair<Boolean, Point> result2 = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            @Nullable
            protected Pair<Boolean, Point> executeInEDT() throws Throwable {
                JInternalFrameDriver.checkShowingOrIconified(internalFrame);
                if (!internalFrame.isIconifiable()) {
                    String msg = String.format("The JInternalFrame <%s> is not iconifiable.", Formatting.format(internalFrame));
                    throw new IllegalStateException(msg);
                }
                return JInternalFrameDriver.iconifyInfo(internalFrame);
            }
        });
        return (Pair)Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Boolean, Point> iconifyInfo(@Nonnull JInternalFrame internalFrame) {
        boolean iconified = JInternalFrameIconQuery.isIconified(internalFrame);
        if (iconified) {
            return Pair.of(true, null);
        }
        return Pair.of(iconified, JInternalFrameDriver.findIconifyLocation(internalFrame));
    }

    @RunsInEDT
    public void deiconify(@Nonnull JInternalFrame internalFrame) {
        Triple<Boolean, Container, Point> deiconifyInfo = JInternalFrameDriver.validateAndfindDeiconifyInfo(internalFrame);
        if (((Boolean)deiconifyInfo.first).booleanValue()) {
            return;
        }
        this.moveMouseIgnoringAnyError((Component)deiconifyInfo.second, (Point)deiconifyInfo.third);
        this.setIconProperty(internalFrame, JInternalFrameAction.DEICONIFY);
    }

    @Nonnull
    @RunsInEDT
    private static Triple<Boolean, Container, Point> validateAndfindDeiconifyInfo(final @Nonnull JInternalFrame internalFrame) {
        Triple<Boolean, Container, Point> result2 = GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Container, Point>>(){

            @Override
            @Nullable
            protected Triple<Boolean, Container, Point> executeInEDT() throws Throwable {
                JInternalFrameDriver.checkShowingOrIconified(internalFrame);
                return JInternalFrameDriver.deiconifyInfo(internalFrame);
            }
        });
        return (Triple)Preconditions.checkNotNull(result2);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Triple<Boolean, Container, Point> deiconifyInfo(@Nonnull JInternalFrame internalFrame) {
        boolean deiconified;
        boolean bl = deiconified = !JInternalFrameIconQuery.isIconified(internalFrame);
        if (deiconified) {
            return Triple.of(true, null, null);
        }
        Container desktopIcon = (Container)Preconditions.checkNotNull((Object)internalFrame.getDesktopIcon());
        return Triple.of(deiconified, desktopIcon, WindowLikeContainers.iconifyButtonLocation(desktopIcon));
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point findIconifyLocation(JInternalFrame internalFrame) {
        JInternalFrame.JDesktopIcon desktopIcon = (JInternalFrame.JDesktopIcon)Preconditions.checkNotNull((Object)internalFrame.getDesktopIcon());
        return WindowLikeContainers.iconifyButtonLocation(desktopIcon);
    }

    @RunsInEDT
    private void setIconProperty(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action2) {
        try {
            JInternalFrameSetIconTask.setIcon(internalFrame, action2);
            this.robot.waitForIdle();
        }
        catch (UnexpectedException unexpected) {
            this.failIfVetoed(internalFrame, action2, unexpected);
        }
    }

    @VisibleForTesting
    void failIfVetoed(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action2, @Nonnull UnexpectedException unexpected) {
        PropertyVetoException vetoError = this.vetoFrom(unexpected);
        if (vetoError == null) {
            return;
        }
        String msg = String.format("%s of %s was vetoed: <%s>", action2.name, Formatting.format(internalFrame), vetoError.getMessage());
        throw ActionFailedException.actionFailure(msg);
    }

    @Nullable
    private PropertyVetoException vetoFrom(@Nonnull UnexpectedException unexpected) {
        Throwable cause = unexpected.getCause();
        if (!(cause instanceof PropertyVetoException)) {
            return null;
        }
        return (PropertyVetoException)cause;
    }

    @RunsInEDT
    public void resizeWidth(@Nonnull JInternalFrame internalFrame, int width) {
        this.doResizeWidth(internalFrame, width);
    }

    @RunsInEDT
    public void resizeHeight(@Nonnull JInternalFrame w, int height) {
        this.doResizeHeight(w, height);
    }

    @RunsInEDT
    public void resizeTo(@Nonnull JInternalFrame internalFrame, @Nonnull Dimension size) {
        this.resize(internalFrame, size.width, size.height);
    }

    @RunsInEDT
    public void move(@Nonnull JInternalFrame internalFrame, @Nonnull Point where) {
        this.move(internalFrame, where.x, where.y);
    }

    @RunsInEDT
    public void close(@Nonnull JInternalFrame internalFrame) {
        Point closeButtonLocation = JInternalFrameDriver.findCloseButtonLocation(internalFrame);
        if (closeButtonLocation == null) {
            return;
        }
        this.moveMouseIgnoringAnyError(internalFrame, closeButtonLocation);
        JInternalFrameCloseTask.close(internalFrame);
        this.robot.waitForIdle();
    }

    @Nullable
    @RunsInEDT
    private static Point findCloseButtonLocation(@Nonnull JInternalFrame internalFrame) {
        return GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkShowing(internalFrame);
            if (!internalFrame.isClosable()) {
                String msg = String.format("The JInternalFrame <%s> is not closable", Formatting.format(internalFrame));
                throw new IllegalStateException(msg);
            }
            if (internalFrame.isClosed()) {
                return null;
            }
            return WindowLikeContainers.closeButtonLocation(internalFrame);
        });
    }

    @RunsInEDT
    public void requireTitle(@Nonnull JInternalFrame frame, String expected) {
        String actual = JInternalFrameTitleQuery.titleOf(frame);
        ((AbstractStringAssert)Assertions.assertThat((String)actual).as(JInternalFrameDriver.propertyName(frame, "title"))).isEqualTo(expected);
    }
}

