/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JApplet;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentDriver;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.internal.annotation.InternalApi;

@InternalApi
public class JAppletDriver
extends ComponentDriver
implements AppletStub {
    private JApplet applet;

    public JAppletDriver(@Nonnull Robot robot) {
        super(robot);
    }

    public JAppletDriver(@Nonnull Robot robot, @Nonnull JApplet newApplet) {
        this(robot);
        this.applet = newApplet;
    }

    @RunsInEDT
    private static void doResize(@Nonnull JApplet applet, int width, int height) {
        GuiActionRunner.execute(() -> applet.resize(width, height));
    }

    @Nullable
    @RunsInEDT
    private static URL codeBase(@Nonnull JApplet applet) {
        return GuiActionRunner.execute(() -> applet.getCodeBase());
    }

    @Nullable
    @RunsInEDT
    private static URL documentBase(@Nonnull JApplet applet) {
        return GuiActionRunner.execute(() -> applet.getDocumentBase());
    }

    @Nullable
    @RunsInEDT
    private static String parameter(@Nonnull JApplet applet, @Nullable String parameterName) {
        return GuiActionRunner.execute(() -> applet.getParameter(parameterName));
    }

    @RunsInEDT
    private static boolean active(@Nonnull JApplet applet) {
        Boolean result2 = GuiActionRunner.execute(() -> applet.isActive());
        return (Boolean)Preconditions.checkNotNull((Object)result2);
    }

    @Override
    @RunsInEDT
    public void appletResize(int width, int height) {
        this.appletResize(this.applet, width, height);
    }

    @RunsInEDT
    public void appletResize(@Nonnull JApplet applet, int width, int height) {
        JAppletDriver.doResize(applet, width, height);
    }

    @Override
    @RunsInEDT
    public AppletContext getAppletContext() {
        return this.getAppletContext(this.applet);
    }

    @RunsInEDT
    public AppletContext getAppletContext(JApplet applet) {
        return JAppletDriver.appletContext(applet);
    }

    @Nullable
    @RunsInEDT
    private static AppletContext appletContext(@Nonnull JApplet applet) {
        return GuiActionRunner.execute(() -> applet.getAppletContext());
    }

    @Override
    @Nullable
    @RunsInEDT
    public URL getCodeBase() {
        return this.getCodeBase(this.applet);
    }

    @Nullable
    @RunsInEDT
    public URL getCodeBase(@Nonnull JApplet applet) {
        return JAppletDriver.codeBase(applet);
    }

    @Override
    @Nullable
    @RunsInEDT
    public URL getDocumentBase() {
        return this.getDocumentBase(this.applet);
    }

    @Nullable
    @RunsInEDT
    public URL getDocumentBase(@Nonnull JApplet applet) {
        return JAppletDriver.documentBase(applet);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String getParameter(@Nullable String name) {
        return this.getParameter(this.applet, name);
    }

    @RunsInEDT
    public String getParameter(@Nonnull JApplet applet, @Nullable String name) {
        return JAppletDriver.parameter(applet, name);
    }

    @Override
    @RunsInEDT
    public boolean isActive() {
        return this.isActive(this.applet);
    }

    @RunsInEDT
    public boolean isActive(@Nonnull JApplet applet) {
        return JAppletDriver.active(applet);
    }

    @RunsInEDT
    public Applet getApplet(@Nonnull String name) {
        return this.applet.getAppletContext().getApplet(name);
    }

    @Nonnull
    @RunsInEDT
    public Enumeration<Applet> getApplets() {
        Enumeration<Applet> applets = this.applet.getAppletContext().getApplets();
        return applets != null ? applets : Collections.enumeration(Collections.emptyList());
    }
}

