/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_reflect.method;

import org.assertj.swing.dependency.fest_reflect.method.Invoker;
import org.assertj.swing.dependency.fest_reflect.method.StaticMethodParameterTypes;
import org.assertj.swing.dependency.fest_reflect.method.StaticMethodReturnType;
import org.assertj.swing.dependency.fest_reflect.method.StaticMethodReturnTypeRef;
import org.assertj.swing.dependency.fest_reflect.reference.TypeRef;
import org.assertj.swing.dependency.fest_util.Strings;

public final class StaticMethodName {
    private final String name;

    public static StaticMethodName startStaticMethodAccess(String name) {
        StaticMethodName.validateIsNotNullOrEmpty(name);
        return new StaticMethodName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the static method to access should not be null");
        }
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("The name of the static method to access should not be empty");
        }
    }

    private StaticMethodName(String name) {
        this.name = name;
    }

    public <T> StaticMethodReturnType<T> withReturnType(Class<T> type2) {
        return StaticMethodReturnType.newReturnType(this.name, type2);
    }

    public <T> StaticMethodReturnTypeRef<T> withReturnType(TypeRef<T> type2) {
        return StaticMethodReturnTypeRef.newReturnTypeRef(this.name, type2);
    }

    public StaticMethodParameterTypes<Void> withParameterTypes(Class<?> ... parameterTypes) {
        return StaticMethodParameterTypes.newParameterTypes(this.name, parameterTypes);
    }

    public Invoker<Void> in(Class<?> target) {
        return Invoker.newInvoker(this.name, target, new Class[0]);
    }
}

