/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.AbstractComponentMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public final class TypeMatcher
extends AbstractComponentMatcher {
    private final Class<? extends Component> type;

    public TypeMatcher(@Nonnull Class<? extends Component> type2) {
        this(type2, false);
    }

    public TypeMatcher(@Nonnull Class<? extends Component> type2, boolean requireShowing) {
        super(requireShowing);
        this.type = (Class)Preconditions.checkNotNull(type2);
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        return this.type.isAssignableFrom(c.getClass()) && this.requireShowingMatches(c);
    }

    public String toString() {
        return String.format("%s[type=%s, requireShowing=%b]", this.getClass().getName(), this.type.getName(), this.requireShowing());
    }
}

