/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.details.commit;

import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanelKt;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\r\u001a\u00020\u000e2\u0013\u0010\u0003\u001a\u000f\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0018\u00010\u0004J\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\u000eH\u0002R\u001b\u0010\u0003\u001a\u000f\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/ui/details/commit/ContainingBranchesPanel;", "Ljavax/swing/JPanel;", "()V", "branches", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "branchesTextArea", "Lcom/intellij/ui/components/JBTextArea;", "expanded", "", "shortLinkPanel", "Lcom/intellij/vcs/log/ui/details/commit/ContainingBranchesPanel$ShortBranchesLinkHtmlPanel;", "setBranches", "", "update", "updateBranches", "ShortBranchesLinkHtmlPanel", "intellij.platform.vcs.log.impl"})
final class ContainingBranchesPanel
extends JPanel {
    @Nullable
    private List<String> branches;
    private boolean expanded;
    @NotNull
    private final ShortBranchesLinkHtmlPanel shortLinkPanel = new ShortBranchesLinkHtmlPanel();
    @NotNull
    private final JBTextArea branchesTextArea = new JBTextArea();

    public ContainingBranchesPanel() {
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)14, (int)14, (int)0));
        this.setVisible(false);
        this.setOpaque(false);
        this.branchesTextArea.setEditable(false);
        this.branchesTextArea.setFont(FontUtil.getCommitMetadataFont());
        this.branchesTextArea.setBackground(CommitDetailsPanelKt.getCommitDetailsBackground());
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)((Object)this.shortLinkPanel));
        this.add((Component)this.branchesTextArea);
    }

    public final void setBranches(@Nullable List<String> branches) {
        this.branches = branches;
        this.expanded = false;
        this.setVisible(true);
        this.updateBranches();
    }

    public final void update() {
        this.updateBranches();
    }

    private final void updateBranches() {
        this.shortLinkPanel.update();
        List<String> branches = this.branches;
        if (this.expanded && branches != null) {
            String newText;
            String oldText = this.branchesTextArea.getText();
            if (!Intrinsics.areEqual((Object)oldText, (Object)(newText = CollectionsKt.joinToString$default((Iterable)branches, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)))) {
                this.branchesTextArea.setText(newText);
                this.branchesTextArea.setCaretPosition(0);
            }
            this.branchesTextArea.setVisible(true);
        } else {
            this.branchesTextArea.setText("");
            this.branchesTextArea.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/ui/details/commit/ContainingBranchesPanel$ShortBranchesLinkHtmlPanel;", "Lcom/intellij/util/ui/HtmlPanel;", "(Lcom/intellij/vcs/log/ui/details/commit/ContainingBranchesPanel;)V", "getBackground", "Ljava/awt/Color;", "getBody", "", "getBodyFont", "Ljava/awt/Font;", "hyperlinkUpdate", "", "e", "Ljavax/swing/event/HyperlinkEvent;", "setBounds", "x", "", "y", "w", "h", "intellij.platform.vcs.log.impl"})
    private final class ShortBranchesLinkHtmlPanel
    extends HtmlPanel {
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && CommitPresentationUtil.isShowHideBranches(e)) {
                ContainingBranchesPanel.this.expanded = !ContainingBranchesPanel.this.expanded;
                ContainingBranchesPanel.this.updateBranches();
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            int oldWidth = this.getWidth();
            super.setBounds(x, y, w, h);
            if (w != oldWidth) {
                this.update();
            }
        }

        @NotNull
        protected String getBody() {
            String string;
            Insets insets = this.getInsets();
            int availableWidth = this.getWidth() - insets.left - insets.right;
            String string2 = CommitPresentationUtil.getBranchesLinkText(ContainingBranchesPanel.this.branches, ContainingBranchesPanel.this.expanded, availableWidth, this.getFontMetrics(this.getBodyFont()));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBranchesLinkText(...)");
            String text = string2;
            if (ContainingBranchesPanel.this.expanded) {
                string = text;
            } else {
                String string3 = HtmlChunk.raw((String)text).wrapWith("nobr").toString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            }
            return string;
        }

        @NotNull
        public Color getBackground() {
            return CommitDetailsPanelKt.getCommitDetailsBackground();
        }

        @NotNull
        protected Font getBodyFont() {
            Font font = FontUtil.getCommitMetadataFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getCommitMetadataFont(...)");
            return font;
        }
    }
}

