/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.ChangeKind;
import com.intellij.vcs.log.data.index.PhmVcsLogStorageBackendKt;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.VcsDirectoryRenamesProvider;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.util.IntCollectionUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexDataGetter {
    private static final Logger LOG = Logger.getInstance(IndexDataGetter.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsLogStorageBackend myIndexStorageBackend;
    @NotNull
    private final VcsLogStorage myLogStorage;
    @NotNull
    private final VcsLogErrorHandler myErrorHandler;
    @NotNull
    private final VcsDirectoryRenamesProvider myDirectoryRenamesProvider;
    private final boolean myIsProjectLog;

    public IndexDataGetter(@NotNull Project project, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogStorageBackend indexStorageBackend, @NotNull VcsLogStorage logStorage, @NotNull VcsLogErrorHandler errorHandler) {
        if (project == null) {
            IndexDataGetter.$$$reportNull$$$0(0);
        }
        if (providers == null) {
            IndexDataGetter.$$$reportNull$$$0(1);
        }
        if (indexStorageBackend == null) {
            IndexDataGetter.$$$reportNull$$$0(2);
        }
        if (logStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(3);
        }
        if (errorHandler == null) {
            IndexDataGetter.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myProviders = providers;
        this.myIndexStorageBackend = indexStorageBackend;
        this.myLogStorage = logStorage;
        this.myErrorHandler = errorHandler;
        this.myDirectoryRenamesProvider = VcsDirectoryRenamesProvider.getInstance(this.myProject);
        this.myIsProjectLog = VcsLogUtil.isProjectLog(this.myProject, this.myProviders);
    }

    void iterateIndexedCommits(int limit, @NotNull IntFunction<Boolean> processor) {
        if (processor == null) {
            IndexDataGetter.$$$reportNull$$$0(5);
        }
        this.executeAndCatch(() -> this.myIndexStorageBackend.iterateIndexedCommits(limit, processor));
    }

    @Nullable
    public VcsUser getAuthor(int commit) {
        return (VcsUser)this.executeAndCatch(() -> this.myIndexStorageBackend.getAuthorForCommit(commit));
    }

    @Nullable
    public Map<Integer, VcsUser> getAuthor(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(6);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getAuthorForCommits(commitIds));
    }

    @Nullable
    public VcsUser getCommitter(int commit) {
        return (VcsUser)this.executeAndCatch(() -> this.myIndexStorageBackend.getCommitterForCommit(commit));
    }

    @NotNull
    public Map<Integer, VcsUser> getCommitter(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(7);
        }
        Map<Integer, VcsUser> map = this.executeAndCatch(() -> this.myIndexStorageBackend.getCommitterForCommits(commitIds), Collections.emptyMap());
        if (map == null) {
            IndexDataGetter.$$$reportNull$$$0(8);
        }
        return map;
    }

    @Nullable
    public Long getAuthorTime(int commit) {
        return (Long)this.executeAndCatch(() -> {
            long[] time = this.myIndexStorageBackend.getTimestamp(commit);
            return time == null ? null : Long.valueOf(time[0]);
        });
    }

    @Nullable
    public Map<Integer, Long> getAuthorTime(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(9);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getAuthorTime(commitIds));
    }

    @Nullable
    public Long getCommitTime(int commit) {
        return (Long)this.executeAndCatch(() -> {
            long[] time = this.myIndexStorageBackend.getTimestamp(commit);
            return time == null ? null : Long.valueOf(time[1]);
        });
    }

    @Nullable
    public Map<Integer, Long> getCommitTime(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(10);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getCommitTime(commitIds));
    }

    @Nullable
    public String getFullMessage(int index) {
        return (String)this.executeAndCatch(() -> this.myIndexStorageBackend.getMessage(index));
    }

    @Nullable
    public Map<Integer, String> getFullMessage(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(11);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getMessages(commitIds));
    }

    @Nullable
    public List<Hash> getParents(int index) {
        return (List)this.executeAndCatch(() -> {
            int[] parentsIndexes = this.myIndexStorageBackend.getParents(index);
            if (parentsIndexes == null) {
                return null;
            }
            return PhmVcsLogStorageBackendKt.getHashes(this.myLogStorage, parentsIndexes);
        });
    }

    @Nullable
    public Map<Integer, List<Hash>> getParents(@NotNull Collection<Integer> commitIds) {
        if (commitIds == null) {
            IndexDataGetter.$$$reportNull$$$0(12);
        }
        return (Map)this.executeAndCatch(() -> this.myIndexStorageBackend.getParents(commitIds));
    }

    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            IndexDataGetter.$$$reportNull$$$0(13);
        }
        if (filters.isEmpty()) {
            return false;
        }
        return ContainerUtil.all(filters, filter -> {
            if (filter instanceof VcsLogTextFilter || filter instanceof VcsLogUserFilter) {
                return true;
            }
            if (filter instanceof VcsLogStructureFilter) {
                Collection files = ((VcsLogStructureFilter)filter).getFiles();
                return ContainerUtil.find((Iterable)files, file -> file.isDirectory() && this.myProviders.containsKey(file.getVirtualFile())) == null;
            }
            return false;
        });
    }

    @NotNull
    public IntSet filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            IndexDataGetter.$$$reportNull$$$0(14);
        }
        IntSet intSet = this.filter(detailsFilters, null);
        if (intSet == null) {
            IndexDataGetter.$$$reportNull$$$0(15);
        }
        return intSet;
    }

    @NotNull
    public IntSet filter(@NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable IntSet candidates) {
        if (detailsFilters == null) {
            IndexDataGetter.$$$reportNull$$$0(16);
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        IntSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = new HashSet();
            for (VirtualFile root : this.myProviders.keySet()) {
                users.addAll(userFilter.getUsers(root));
            }
            filteredByUser = this.filterUsers(users);
        }
        IntSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        IntSet filteredByUserAndPath = IntCollectionUtil.intersect(filteredByUser, filteredByPath, candidates);
        if (textFilter == null) {
            Object object = filteredByUserAndPath == null ? IntSets.EMPTY_SET : filteredByUserAndPath;
            if (object == null) {
                IndexDataGetter.$$$reportNull$$$0(17);
            }
            return object;
        }
        return this.filterMessages(textFilter, filteredByUserAndPath);
    }

    @NotNull
    private IntSet filterUsers(@NotNull Set<? extends VcsUser> users) {
        if (users == null) {
            IndexDataGetter.$$$reportNull$$$0(18);
        }
        IntSet intSet = (IntSet)this.executeAndCatch(() -> this.myIndexStorageBackend.getCommitsForUsers(users), new IntOpenHashSet());
        if (intSet == null) {
            IndexDataGetter.$$$reportNull$$$0(19);
        }
        return intSet;
    }

    @NotNull
    private IntSet filterPaths(@NotNull Collection<? extends FilePath> paths) {
        if (paths == null) {
            IndexDataGetter.$$$reportNull$$$0(20);
        }
        IntSet intSet = (IntSet)this.executeAndCatch(() -> {
            IntOpenHashSet result2 = new IntOpenHashSet();
            for (FilePath path : paths) {
                result2.addAll((IntCollection)this.createFileHistoryData(path).build().getCommits());
                ProgressManager.checkCanceled();
            }
            return result2;
        }, new IntOpenHashSet());
        if (intSet == null) {
            IndexDataGetter.$$$reportNull$$$0(21);
        }
        return intSet;
    }

    @NotNull
    private IntSet filterMessages(@NotNull VcsLogTextFilter filter, @Nullable IntSet candidates) {
        if (filter == null) {
            IndexDataGetter.$$$reportNull$$$0(22);
        }
        IntOpenHashSet result2 = new IntOpenHashSet();
        this.filterMessages(filter, candidates, arg_0 -> ((IntSet)result2).add(arg_0));
        IntOpenHashSet intOpenHashSet = result2;
        if (intOpenHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(23);
        }
        return intOpenHashSet;
    }

    public void filterMessages(@NotNull VcsLogTextFilter filter, @NotNull IntConsumer consumer) {
        if (filter == null) {
            IndexDataGetter.$$$reportNull$$$0(24);
        }
        if (consumer == null) {
            IndexDataGetter.$$$reportNull$$$0(25);
        }
        this.filterMessages(filter, null, consumer);
    }

    private void filterMessages(@NotNull VcsLogTextFilter filter, @Nullable IntSet candidates, @NotNull IntConsumer consumer) {
        if (filter == null) {
            IndexDataGetter.$$$reportNull$$$0(26);
        }
        if (consumer == null) {
            IndexDataGetter.$$$reportNull$$$0(27);
        }
        if (!filter.isRegex() || filter instanceof VcsLogMultiplePatternsTextFilter) {
            this.executeAndCatch(() -> {
                List<String> trigramSources = filter instanceof VcsLogMultiplePatternsTextFilter ? ((VcsLogMultiplePatternsTextFilter)filter).getPatterns() : Collections.singletonList(filter.getText());
                ArrayList<String> noTrigramSources = new ArrayList<String>();
                for (String string : trigramSources) {
                    this.myIndexStorageBackend.getCommitsForSubstring(string, candidates, noTrigramSources, consumer, filter);
                }
                if (!noTrigramSources.isEmpty()) {
                    VcsLogTextFilter noTrigramFilter = VcsLogFilterObject.fromPatternsList(noTrigramSources, filter.matchesCase());
                    this.filter((IntIterable)candidates, arg_0 -> ((VcsLogTextFilter)noTrigramFilter).matches(arg_0), consumer);
                }
            });
        } else {
            this.executeAndCatch(() -> this.filter((IntIterable)candidates, arg_0 -> ((VcsLogTextFilter)filter).matches(arg_0), consumer));
        }
    }

    private void filter(@Nullable IntIterable candidates, @NotNull Predicate<String> condition, @NotNull IntConsumer consumer) throws IOException {
        if (condition == null) {
            IndexDataGetter.$$$reportNull$$$0(28);
        }
        if (consumer == null) {
            IndexDataGetter.$$$reportNull$$$0(29);
        }
        if (candidates == null) {
            this.myIndexStorageBackend.processMessages((Function2<? super Integer, ? super String, Boolean>)((Function2)(commit, message) -> {
                if (message != null && condition.test((String)message)) {
                    consumer.accept((int)commit);
                }
                return true;
            }));
        } else {
            IntIterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                int commit2 = iterator.nextInt();
                String value = this.myIndexStorageBackend.getMessage(commit2);
                if (value == null || !condition.test(value)) continue;
                consumer.accept(commit2);
            }
        }
    }

    @NotNull
    private Int2ObjectMap<Int2ObjectMap<ChangeKind>> getAffectedCommits(@NotNull FilePath path) {
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(30);
        }
        Int2ObjectOpenHashMap affectedCommits = new Int2ObjectOpenHashMap();
        VirtualFile root = this.getRoot(path);
        if (this.myProviders.containsKey(root) && root != null) {
            this.executeAndCatch(() -> this.lambda$getAffectedCommits$22(root, path, (Int2ObjectMap)affectedCommits));
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = affectedCommits;
        if (int2ObjectOpenHashMap == null) {
            IndexDataGetter.$$$reportNull$$$0(31);
        }
        return int2ObjectOpenHashMap;
    }

    @NotNull
    public FileHistoryData createFileHistoryData(@NotNull FilePath path) {
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(32);
        }
        FileHistoryData fileHistoryData = this.createFileHistoryData(Collections.singletonList(path));
        if (fileHistoryData == null) {
            IndexDataGetter.$$$reportNull$$$0(33);
        }
        return fileHistoryData;
    }

    @NotNull
    public FileHistoryData createFileHistoryData(@NotNull Collection<? extends FilePath> paths) {
        if (paths == null) {
            IndexDataGetter.$$$reportNull$$$0(34);
        }
        if (paths.size() == 1 && ((FilePath)ContainerUtil.getFirstItem(paths)).isDirectory()) {
            return new DirectoryHistoryData((FilePath)ContainerUtil.getFirstItem(paths));
        }
        return new FileHistoryDataImpl(paths);
    }

    @NotNull
    public VcsLogStorage getLogStorage() {
        VcsLogStorage vcsLogStorage = this.myLogStorage;
        if (vcsLogStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(35);
        }
        return vcsLogStorage;
    }

    @NotNull
    VcsLogStorageBackend getIndexStorageBackend() {
        VcsLogStorageBackend vcsLogStorageBackend = this.myIndexStorageBackend;
        if (vcsLogStorageBackend == null) {
            IndexDataGetter.$$$reportNull$$$0(36);
        }
        return vcsLogStorageBackend;
    }

    @Nullable
    VirtualFile getRoot(@NotNull FilePath path) {
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(37);
        }
        if (this.myIsProjectLog) {
            return VcsLogUtil.getActualRoot(this.myProject, path);
        }
        return VcsLogUtil.getActualRoot(this.myProject, this.myProviders, path);
    }

    private void executeAndCatch(@NotNull Throwable2Runnable<IOException, StorageException> runnable) {
        if (runnable == null) {
            IndexDataGetter.$$$reportNull$$$0(38);
        }
        this.executeAndCatch(() -> {
            runnable.run();
            return null;
        }, null);
    }

    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(39);
        }
        return this.executeAndCatch(computable, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<? extends T, IOException, StorageException> computable, @Nullable T defaultValue) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(40);
        }
        try {
            return (T)computable.compute();
        }
        catch (StorageException | CorruptedDataException | IOException | UncheckedIOException e) {
            this.myIndexStorageBackend.markCorrupted();
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        return defaultValue;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e == null) {
            IndexDataGetter.$$$reportNull$$$0(41);
        }
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            LOG.error("Unknown exception in Vcs Log index processing", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.myIndexStorageBackend.markCorrupted();
        this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
    }

    private /* synthetic */ Object lambda$getAffectedCommits$22(VirtualFile root, FilePath path, Int2ObjectMap affectedCommits) throws IOException, StorageException {
        this.myIndexStorageBackend.iterateChangesInCommits(root, path, (changes, commit) -> this.executeAndCatch(() -> {
            int[] parents = this.myIndexStorageBackend.getParents(commit);
            if (parents == null) {
                throw new CorruptedDataException("No parents for commit " + commit);
            }
            Int2ObjectOpenHashMap changeMap = new Int2ObjectOpenHashMap(parents.length);
            if (parents.length == 0 && !changes.isEmpty()) {
                changeMap.put(commit, (Object)((ChangeKind)((Object)((Object)((Object)ContainerUtil.getFirstItem((List)changes))))));
            } else {
                if (parents.length != changes.size()) {
                    throw new CorruptedDataException("Commit " + commit + " has " + parents.length + " parents, but " + changes.size() + " changes.");
                }
                int length = parents.length;
                for (int i = 0; i < length; ++i) {
                    changeMap.put(parents[i], (Object)((ChangeKind)((Object)((Object)((Object)changes.get(i))))));
                }
            }
            affectedCommits.put(commit, (Object)changeMap);
            return null;
        }));
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 15, 17, 19, 21, 23, 31, 33, 35, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorageBackend";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitIds";
                break;
            }
            case 8: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 31: 
            case 33: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 30: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitter";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUsers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPaths";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMessages";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedCommits";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileHistoryData";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogStorage";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexStorageBackend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexedCommits";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAuthor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommitter";
                break;
            }
            case 8: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 31: 
            case 33: 
            case 35: 
            case 36: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorTime";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommitTime";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFullMessage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canFilter";
                break;
            }
            case 14: 
            case 16: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterUsers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterPaths";
                break;
            }
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterMessages";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedCommits";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createFileHistoryData";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "executeAndCatch";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processRuntimeException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 15, 17, 19, 21, 23, 31, 33, 35, 36 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    private static interface Throwable2Runnable<E1 extends Throwable, E2 extends Throwable> {
        public void run() throws E1, E2;
    }

    private final class DirectoryHistoryData
    extends FileHistoryDataImpl {
        private final Map<EdgeData<Integer>, EdgeData<FilePath>> renamesMap;

        private DirectoryHistoryData(FilePath startPath) {
            if (startPath == null) {
                DirectoryHistoryData.$$$reportNull$$$0(0);
            }
            super(startPath);
            this.renamesMap = new HashMap<EdgeData<Integer>, EdgeData<FilePath>>();
            for (Map.Entry entry : IndexDataGetter.this.myDirectoryRenamesProvider.getRenamesMap().entrySet()) {
                EdgeData commits2 = (EdgeData)entry.getKey();
                for (EdgeData rename : (Collection)entry.getValue()) {
                    if (!VcsFileUtil.isAncestor((FilePath)((FilePath)rename.child), (FilePath)startPath, (boolean)false)) continue;
                    FilePath renamedPath = VcsUtil.getFilePath((String)(((FilePath)rename.parent).getPath() + "/" + VcsFileUtil.relativePath((FilePath)((FilePath)rename.child), (FilePath)startPath)), (boolean)true);
                    this.renamesMap.put(new EdgeData<Integer>(IndexDataGetter.this.myLogStorage.getCommitIndex(((CommitId)commits2.parent).getHash(), ((CommitId)commits2.parent).getRoot()), IndexDataGetter.this.myLogStorage.getCommitIndex(((CommitId)commits2.child).getHash(), ((CommitId)commits2.child).getRoot())), new EdgeData<FilePath>(renamedPath, startPath));
                }
            }
        }

        @Override
        @NotNull
        public Int2ObjectMap<Int2ObjectMap<ChangeKind>> getAffectedCommits(@NotNull FilePath path) {
            if (path == null) {
                DirectoryHistoryData.$$$reportNull$$$0(1);
            }
            Int2ObjectMap<Int2ObjectMap<ChangeKind>> affectedCommits = super.getAffectedCommits(path);
            if (!path.isDirectory()) {
                Int2ObjectMap<Int2ObjectMap<ChangeKind>> int2ObjectMap = affectedCommits;
                if (int2ObjectMap == null) {
                    DirectoryHistoryData.$$$reportNull$$$0(2);
                }
                return int2ObjectMap;
            }
            this.hackAffectedCommits(path, affectedCommits);
            Int2ObjectMap<Int2ObjectMap<ChangeKind>> int2ObjectMap = affectedCommits;
            if (int2ObjectMap == null) {
                DirectoryHistoryData.$$$reportNull$$$0(3);
            }
            return int2ObjectMap;
        }

        private void hackAffectedCommits(@NotNull FilePath path, @NotNull Int2ObjectMap<Int2ObjectMap<ChangeKind>> affectedCommits) {
            if (path == null) {
                DirectoryHistoryData.$$$reportNull$$$0(4);
            }
            if (affectedCommits == null) {
                DirectoryHistoryData.$$$reportNull$$$0(5);
            }
            for (Map.Entry<EdgeData<Integer>, EdgeData<FilePath>> entry : this.renamesMap.entrySet()) {
                ChangeKind newKind;
                int childCommit = (Integer)entry.getKey().child;
                if (!affectedCommits.containsKey(childCommit)) continue;
                EdgeData<FilePath> rename = entry.getValue();
                if (FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)((FilePath)rename.child), (Object)path)) {
                    newKind = ChangeKind.ADDED;
                } else {
                    if (!FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)((FilePath)rename.parent), (Object)path)) continue;
                    newKind = ChangeKind.REMOVED;
                }
                Int2ObjectMap changesMap = (Int2ObjectMap)affectedCommits.get(childCommit);
                changesMap.keySet().forEach(key -> changesMap.put(key, (Object)newKind));
            }
        }

        @Override
        @Nullable
        public EdgeData<FilePath> findRename(int parent, int child, @NotNull FilePath path, boolean isChildPath) {
            if (path == null) {
                DirectoryHistoryData.$$$reportNull$$$0(6);
            }
            if (path.isDirectory()) {
                return this.findFolderRename(parent, child, path, isChildPath);
            }
            return super.findRename(parent, child, path, isChildPath);
        }

        @Nullable
        private EdgeData<FilePath> findFolderRename(int parent, int child, @NotNull FilePath path, boolean isChildPath) {
            EdgeData<FilePath> rename;
            if (path == null) {
                DirectoryHistoryData.$$$reportNull$$$0(7);
            }
            if ((rename = this.renamesMap.get(new EdgeData<Integer>(parent, child))) == null) {
                return null;
            }
            return FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)(isChildPath ? (FilePath)rename.child : (FilePath)rename.parent), (Object)path) ? rename : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPath";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter$DirectoryHistoryData";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "affectedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter$DirectoryHistoryData";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getAffectedCommits";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hackAffectedCommits";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findRename";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findFolderRename";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private class FileHistoryDataImpl
    extends FileHistoryData {
        private FileHistoryDataImpl(FilePath startPath) {
            if (startPath == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(0);
            }
            super(startPath);
        }

        private FileHistoryDataImpl(Collection<? extends FilePath> startPaths) {
            if (startPaths == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(1);
            }
            super(startPaths);
        }

        @Override
        @NotNull
        public Int2ObjectMap<Int2ObjectMap<ChangeKind>> getAffectedCommits(@NotNull FilePath path) {
            if (path == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(2);
            }
            Int2ObjectMap<Int2ObjectMap<ChangeKind>> int2ObjectMap = IndexDataGetter.this.getAffectedCommits(path);
            if (int2ObjectMap == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(3);
            }
            return int2ObjectMap;
        }

        @Override
        @Nullable
        public EdgeData<FilePath> findRename(int parent, int child, @NotNull FilePath path, boolean isChildPath) {
            if (path == null) {
                FileHistoryDataImpl.$$$reportNull$$$0(4);
            }
            VirtualFile root = Objects.requireNonNull(IndexDataGetter.this.getRoot(path));
            return (EdgeData)IndexDataGetter.this.executeAndCatch(() -> IndexDataGetter.this.myIndexStorageBackend.findRename(parent, child, root, path, isChildPath));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPaths";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileHistoryDataImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter$FileHistoryDataImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAffectedCommits";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findRename";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CorruptedDataException
    extends RuntimeException {
        CorruptedDataException(@NotNull String message) {
            if (message == null) {
                CorruptedDataException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/data/index/IndexDataGetter$CorruptedDataException", "<init>"));
        }
    }
}

