/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.linkerscript.lang.core.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.linkerscript.lang.core.lexer.LSLexer;
import com.jetbrains.linkerscript.lang.core.parser.LSParser;
import com.jetbrains.linkerscript.lang.core.psi.LSElementTypes;
import com.jetbrains.linkerscript.lang.core.psi.LSFile;
import com.jetbrains.linkerscript.lang.core.stubs.LSFileStub;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/linkerscript/lang/core/parser/LSParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "()V", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getStringLiteralElements", "getWhitespaceTokens", "intellij.cidr.linkerscript"})
public final class LSParserDefinition
implements ParserDefinition {
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return (PsiFile)new LSFile(viewProvider);
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return (IFileElementType)LSFileStub.Type.INSTANCE;
    }

    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new LSLexer();
    }

    @NotNull
    public PsiParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new LSParser();
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        IElementType[] iElementTypeArray = new IElementType[]{TokenType.WHITE_SPACE};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        IElementType[] iElementTypeArray = new IElementType[]{LSElementTypes.BLOCK_COMMENT};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = LSElementTypes.Factory.createElement(node);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createElement(...)");
        return psiElement;
    }
}

